/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2022-12-16 20:29:41 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_fsmpt_email_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(10) unsigned DEFAULT NULL,
  `to` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `from` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `body` longtext COLLATE utf8mb4_unicode_520_ci,
  `headers` longtext COLLATE utf8mb4_unicode_520_ci,
  `attachments` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT 'pending',
  `response` text COLLATE utf8mb4_unicode_520_ci,
  `extra` text COLLATE utf8mb4_unicode_520_ci,
  `retries` int(10) unsigned DEFAULT '0',
  `resent_count` int(10) unsigned DEFAULT '0',
  `source` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_content_status` (
  `rid` bigint(20) NOT NULL,
  `nid` bigint(20) NOT NULL,
  `timestamp` datetime NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`rid`),
  KEY `nid` (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_core_status` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `module` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `origin` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `target` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  `tp_revision` int(11) NOT NULL DEFAULT '1',
  `ts_status` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `rid` (`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_code` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `flag` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `from_template` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang_code` (`lang_code`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `english_name` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `major` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL,
  `default_locale` varchar(35) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tag` varchar(35) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `encode_url` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `english_name` (`english_name`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_languages_translations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `display_language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `language_code` (`language_code`,`display_language_code`)
) ENGINE=MyISAM AUTO_INCREMENT=4097 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_locale_map` (
  `code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(35) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `code` (`code`,`locale`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_message_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `from_language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `to_language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_type` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rid` (`rid`),
  KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_node` (
  `nid` bigint(20) NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `links_fixed` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_reminders` (
  `id` bigint(20) NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `can_delete` tinyint(4) NOT NULL,
  `show` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_string_positions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) NOT NULL,
  `kind` tinyint(4) DEFAULT NULL,
  `position_in_page` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_id` (`string_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_string_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `string_translation_id` bigint(20) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_translation_id` (`string_translation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_string_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) unsigned NOT NULL,
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `mo_string` longtext COLLATE utf8mb4_unicode_520_ci,
  `translator_id` bigint(20) unsigned DEFAULT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `batch_id` int(11) NOT NULL DEFAULT '0',
  `translation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `string_language` (`string_id`,`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_strings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `string_package_id` bigint(20) unsigned DEFAULT NULL,
  `location` bigint(20) unsigned DEFAULT NULL,
  `wrap_tag` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'LINE',
  `title` varchar(160) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `gettext_context` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain_name_context_md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translation_priority` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `word_count` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_domain_name_context_md5` (`domain_name_context_md5`),
  KEY `language_context` (`language`,`context`),
  KEY `icl_strings_name` (`name`),
  KEY `icl_strings_translation_priority` (`translation_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translate` (
  `tid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) unsigned NOT NULL,
  `content_id` bigint(20) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `field_type` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_wrap_tag` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_format` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_translate` tinyint(4) NOT NULL,
  `field_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_data_translated` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_finished` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `job_id` (`job_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translate_job` (
  `job_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `translator_id` int(10) unsigned NOT NULL,
  `translated` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `manager_id` int(10) unsigned NOT NULL,
  `revision` int(10) unsigned DEFAULT NULL,
  `title` varchar(160) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `deadline_date` datetime DEFAULT NULL,
  `completed_date` datetime DEFAULT NULL,
  `editor` varchar(16) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`job_id`),
  KEY `rid` (`rid`,`translator_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translation_batches` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `batch_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `ts_url` text COLLATE utf8mb4_unicode_520_ci,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translation_status` (
  `rid` bigint(20) NOT NULL AUTO_INCREMENT,
  `translation_id` bigint(20) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `translator_id` bigint(20) NOT NULL,
  `needs_update` tinyint(4) NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `batch_id` int(11) NOT NULL DEFAULT '0',
  `translation_package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `links_fixed` tinyint(4) NOT NULL DEFAULT '0',
  `_prevstate` longtext COLLATE utf8mb4_unicode_520_ci,
  `uuid` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `tp_revision` int(11) NOT NULL DEFAULT '1',
  `ts_status` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`rid`),
  UNIQUE KEY `translation_id` (`translation_id`)
) ENGINE=MyISAM AUTO_INCREMENT=146 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_icl_translations` (
  `translation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `element_type` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post_post',
  `element_id` bigint(20) DEFAULT NULL,
  `trid` bigint(20) NOT NULL,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source_language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`translation_id`),
  UNIQUE KEY `trid_lang` (`trid`,`language_code`),
  UNIQUE KEY `el_type_id` (`element_type`,`element_id`),
  KEY `trid` (`trid`),
  KEY `id_type_language` (`element_id`,`element_type`,`language_code`)
) ENGINE=MyISAM AUTO_INCREMENT=698 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=45487 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=10475 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1821 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_sib_model_lang` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `frmID` int(20) NOT NULL DEFAULT '-1',
  `pID` int(20) NOT NULL DEFAULT '-1',
  `lang` varchar(120) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=509 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpmm_subscribers` (
  `id_subscriber` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(50) NOT NULL,
  `insert_date` datetime NOT NULL,
  PRIMARY KEY (`id_subscriber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`)
) ENGINE=MyISAM AUTO_INCREMENT=517 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("3", "20210728_bnbtakim", "f4baba08ab58bca28286_20221216202930", "20", "2022-12-16 20:29:41", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-12-16 20:29:30\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:17:\"20210728_bnbtakim\";s:4:\"Hash\";s:35:\"f4baba08ab58bca28286_20221216202930\";s:8:\"NameHash\";s:53:\"20210728_bnbtakim_f4baba08ab58bca28286_20221216202930\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:63:\"20210728_bnbtakim_f4baba08ab58bca28286_20221216202930_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.4\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:65:\"20210728_bnbtakim_f4baba08ab58bca28286_20221216202930_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:39:\"/home/ankarau1/public_html/bnbtakim.com\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-12-16 20:29:30\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:17:\"20210728_bnbtakim\";s:4:\"Hash\";s:35:\"f4baba08ab58bca28286_20221216202930\";s:8:\"NameHash\";s:53:\"20210728_bnbtakim_f4baba08ab58bca28286_20221216202930\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:67:\"20210728_bnbtakim_f4baba08ab58bca28286_20221216202930_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:66:\"20210728_bnbtakim_f4baba08ab58bca28286_20221216202930_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:30:\"MySQL Community Server - (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:1:{s:14:\"wp_commentmeta\";s:1:\"0\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:138:\"/home/ankarau1/public_html/bnbtakim.com/wp-content/backups-dup-lite/tmp/20210728_bnbtakim_f4baba08ab58bca28286_20221216202930_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:48:\"/home/ankarau1/public_html/bnbtakim.com/wp-admin\";i:1;s:58:\"/home/ankarau1/public_html/bnbtakim.com/wp-content/uploads\";i:2;s:60:\"/home/ankarau1/public_html/bnbtakim.com/wp-content/languages\";i:3;s:57:\"/home/ankarau1/public_html/bnbtakim.com/wp-content/themes\";i:4;s:51:\"/home/ankarau1/public_html/bnbtakim.com/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:39:\"/home/ankarau1/public_html/bnbtakim.com\";i:1;s:50:\"/home/ankarau1/public_html/bnbtakim.com/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:131;}");

/* INSERT TABLE DATA: wp_icl_flags */
INSERT INTO `wp_icl_flags` VALUES("1", "ar", "ar.png", "0");
INSERT INTO `wp_icl_flags` VALUES("2", "bg", "bg.png", "0");
INSERT INTO `wp_icl_flags` VALUES("3", "bn", "bn.png", "0");
INSERT INTO `wp_icl_flags` VALUES("4", "bs", "bs.png", "0");
INSERT INTO `wp_icl_flags` VALUES("5", "ca", "ca.png", "0");
INSERT INTO `wp_icl_flags` VALUES("6", "cs", "cs.png", "0");
INSERT INTO `wp_icl_flags` VALUES("7", "cy", "cy.png", "0");
INSERT INTO `wp_icl_flags` VALUES("8", "da", "da.png", "0");
INSERT INTO `wp_icl_flags` VALUES("9", "de", "de.png", "0");
INSERT INTO `wp_icl_flags` VALUES("10", "el", "el.png", "0");
INSERT INTO `wp_icl_flags` VALUES("11", "en", "en.png", "0");
INSERT INTO `wp_icl_flags` VALUES("12", "eo", "eo.png", "0");
INSERT INTO `wp_icl_flags` VALUES("13", "es", "es.png", "0");
INSERT INTO `wp_icl_flags` VALUES("14", "et", "et.png", "0");
INSERT INTO `wp_icl_flags` VALUES("15", "eu", "eu.png", "0");
INSERT INTO `wp_icl_flags` VALUES("16", "fa", "fa.png", "0");
INSERT INTO `wp_icl_flags` VALUES("17", "fi", "fi.png", "0");
INSERT INTO `wp_icl_flags` VALUES("18", "fr", "fr.png", "0");
INSERT INTO `wp_icl_flags` VALUES("19", "ga", "ga.png", "0");
INSERT INTO `wp_icl_flags` VALUES("20", "gl", "gl.png", "0");
INSERT INTO `wp_icl_flags` VALUES("21", "he", "he.png", "0");
INSERT INTO `wp_icl_flags` VALUES("22", "hi", "hi.png", "0");
INSERT INTO `wp_icl_flags` VALUES("23", "hr", "hr.png", "0");
INSERT INTO `wp_icl_flags` VALUES("24", "hu", "hu.png", "0");
INSERT INTO `wp_icl_flags` VALUES("25", "hy", "hy.png", "0");
INSERT INTO `wp_icl_flags` VALUES("26", "id", "id.png", "0");
INSERT INTO `wp_icl_flags` VALUES("27", "is", "is.png", "0");
INSERT INTO `wp_icl_flags` VALUES("28", "it", "it.png", "0");
INSERT INTO `wp_icl_flags` VALUES("29", "ja", "ja.png", "0");
INSERT INTO `wp_icl_flags` VALUES("30", "ko", "ko.png", "0");
INSERT INTO `wp_icl_flags` VALUES("31", "ku", "ku.png", "0");
INSERT INTO `wp_icl_flags` VALUES("32", "lt", "lt.png", "0");
INSERT INTO `wp_icl_flags` VALUES("33", "lv", "lv.png", "0");
INSERT INTO `wp_icl_flags` VALUES("34", "mk", "mk.png", "0");
INSERT INTO `wp_icl_flags` VALUES("35", "mn", "mn.png", "0");
INSERT INTO `wp_icl_flags` VALUES("36", "ms", "ms.png", "0");
INSERT INTO `wp_icl_flags` VALUES("37", "mt", "mt.png", "0");
INSERT INTO `wp_icl_flags` VALUES("38", "ne", "ne.png", "0");
INSERT INTO `wp_icl_flags` VALUES("39", "nl", "nl.png", "0");
INSERT INTO `wp_icl_flags` VALUES("40", "no", "no.png", "0");
INSERT INTO `wp_icl_flags` VALUES("41", "pa", "pa.png", "0");
INSERT INTO `wp_icl_flags` VALUES("42", "pl", "pl.png", "0");
INSERT INTO `wp_icl_flags` VALUES("43", "pt-br", "pt-br.png", "0");
INSERT INTO `wp_icl_flags` VALUES("44", "pt-pt", "pt-pt.png", "0");
INSERT INTO `wp_icl_flags` VALUES("45", "qu", "qu.png", "0");
INSERT INTO `wp_icl_flags` VALUES("46", "ro", "ro.png", "0");
INSERT INTO `wp_icl_flags` VALUES("47", "ru", "ru.png", "0");
INSERT INTO `wp_icl_flags` VALUES("48", "sk", "sk.png", "0");
INSERT INTO `wp_icl_flags` VALUES("49", "sl", "sl.png", "0");
INSERT INTO `wp_icl_flags` VALUES("50", "so", "so.png", "0");
INSERT INTO `wp_icl_flags` VALUES("51", "sq", "sq.png", "0");
INSERT INTO `wp_icl_flags` VALUES("52", "sr", "sr.png", "0");
INSERT INTO `wp_icl_flags` VALUES("53", "sv", "sv.png", "0");
INSERT INTO `wp_icl_flags` VALUES("54", "ta", "ta.png", "0");
INSERT INTO `wp_icl_flags` VALUES("55", "th", "th.png", "0");
INSERT INTO `wp_icl_flags` VALUES("56", "tr", "tr.png", "0");
INSERT INTO `wp_icl_flags` VALUES("57", "uk", "uk.png", "0");
INSERT INTO `wp_icl_flags` VALUES("58", "ur", "ur.png", "0");
INSERT INTO `wp_icl_flags` VALUES("59", "uz", "uz.png", "0");
INSERT INTO `wp_icl_flags` VALUES("60", "vi", "vi.png", "0");
INSERT INTO `wp_icl_flags` VALUES("61", "yi", "yi.png", "0");
INSERT INTO `wp_icl_flags` VALUES("62", "zh-hans", "zh.png", "0");
INSERT INTO `wp_icl_flags` VALUES("63", "zh-hant", "zh.png", "0");
INSERT INTO `wp_icl_flags` VALUES("64", "zu", "zu.png", "0");

/* INSERT TABLE DATA: wp_icl_languages */
INSERT INTO `wp_icl_languages` VALUES("1", "en", "English", "1", "1", "en_US", "en", "0");
INSERT INTO `wp_icl_languages` VALUES("2", "es", "Spanish", "1", "0", "es_ES", "es", "0");
INSERT INTO `wp_icl_languages` VALUES("3", "de", "German", "1", "0", "de_DE", "de", "0");
INSERT INTO `wp_icl_languages` VALUES("4", "fr", "French", "1", "0", "fr_FR", "fr", "0");
INSERT INTO `wp_icl_languages` VALUES("5", "ar", "Arabic", "0", "0", "ar", "ar", "0");
INSERT INTO `wp_icl_languages` VALUES("6", "bs", "Bosnian", "0", "0", "bs_BA", "bs", "0");
INSERT INTO `wp_icl_languages` VALUES("7", "bg", "Bulgarian", "0", "0", "bg_BG", "bg", "0");
INSERT INTO `wp_icl_languages` VALUES("8", "ca", "Catalan", "0", "0", "ca", "ca", "0");
INSERT INTO `wp_icl_languages` VALUES("9", "cs", "Czech", "0", "0", "cs_CZ", "cs", "0");
INSERT INTO `wp_icl_languages` VALUES("10", "sk", "Slovak", "0", "0", "sk_SK", "sk", "0");
INSERT INTO `wp_icl_languages` VALUES("11", "cy", "Welsh", "0", "0", "cy_GB", "cy", "0");
INSERT INTO `wp_icl_languages` VALUES("12", "da", "Danish", "1", "0", "da_DK", "da", "0");
INSERT INTO `wp_icl_languages` VALUES("13", "el", "Greek", "0", "0", "el", "el", "0");
INSERT INTO `wp_icl_languages` VALUES("14", "eo", "Esperanto", "0", "0", "eo_UY", "eo", "0");
INSERT INTO `wp_icl_languages` VALUES("15", "et", "Estonian", "0", "0", "et", "et", "0");
INSERT INTO `wp_icl_languages` VALUES("16", "eu", "Basque", "0", "0", "eu_ES", "eu", "0");
INSERT INTO `wp_icl_languages` VALUES("17", "fa", "Persian", "0", "0", "fa_IR", "fa", "0");
INSERT INTO `wp_icl_languages` VALUES("18", "fi", "Finnish", "0", "0", "fi", "fi", "0");
INSERT INTO `wp_icl_languages` VALUES("19", "ga", "Irish", "0", "0", "ga_IE", "ga", "0");
INSERT INTO `wp_icl_languages` VALUES("20", "he", "Hebrew", "0", "0", "he_IL", "he", "0");
INSERT INTO `wp_icl_languages` VALUES("21", "hi", "Hindi", "0", "0", "hi_IN", "hi", "0");
INSERT INTO `wp_icl_languages` VALUES("22", "hr", "Croatian", "0", "0", "hr", "hr", "0");
INSERT INTO `wp_icl_languages` VALUES("23", "hu", "Hungarian", "0", "0", "hu_HU", "hu", "0");
INSERT INTO `wp_icl_languages` VALUES("24", "hy", "Armenian", "0", "0", "hy_AM", "hy", "0");
INSERT INTO `wp_icl_languages` VALUES("25", "id", "Indonesian", "0", "0", "id_ID", "id", "0");
INSERT INTO `wp_icl_languages` VALUES("26", "is", "Icelandic", "0", "0", "is_IS", "is", "0");
INSERT INTO `wp_icl_languages` VALUES("27", "it", "Italian", "1", "0", "it_IT", "it", "0");
INSERT INTO `wp_icl_languages` VALUES("28", "ja", "Japanese", "1", "0", "ja", "ja", "0");
INSERT INTO `wp_icl_languages` VALUES("29", "ko", "Korean", "0", "0", "ko_KR", "ko", "0");
INSERT INTO `wp_icl_languages` VALUES("30", "ku", "Kurdish", "0", "0", "ckb", "ku", "0");
INSERT INTO `wp_icl_languages` VALUES("31", "lv", "Latvian", "0", "0", "lv_LV", "lv", "0");
INSERT INTO `wp_icl_languages` VALUES("32", "lt", "Lithuanian", "0", "0", "lt_LT", "lt", "0");
INSERT INTO `wp_icl_languages` VALUES("33", "mk", "Macedonian", "0", "0", "mk_MK", "mk", "0");
INSERT INTO `wp_icl_languages` VALUES("34", "mt", "Maltese", "0", "0", "mt_MT", "mt", "0");
INSERT INTO `wp_icl_languages` VALUES("35", "mn", "Mongolian", "0", "0", "mn_MN", "mn", "0");
INSERT INTO `wp_icl_languages` VALUES("36", "ne", "Nepali", "0", "0", "ne", "ne", "0");
INSERT INTO `wp_icl_languages` VALUES("37", "nl", "Dutch", "1", "0", "nl_NL", "nl", "0");
INSERT INTO `wp_icl_languages` VALUES("38", "no", "Norwegian Bokmål", "0", "0", "nb_NO", "no", "0");
INSERT INTO `wp_icl_languages` VALUES("39", "pa", "Punjabi", "0", "0", "", "pa", "0");
INSERT INTO `wp_icl_languages` VALUES("40", "pl", "Polish", "0", "0", "pl_PL", "pl", "0");
INSERT INTO `wp_icl_languages` VALUES("41", "pt-pt", "Portuguese, Portugal", "0", "0", "pt_PT", "pt-pt", "0");
INSERT INTO `wp_icl_languages` VALUES("42", "pt-br", "Portuguese, Brazil", "0", "0", "pt_BR", "pt-br", "0");
INSERT INTO `wp_icl_languages` VALUES("43", "qu", "Quechua", "0", "0", "quz_PE", "qu", "0");
INSERT INTO `wp_icl_languages` VALUES("44", "ro", "Romanian", "0", "0", "ro_RO", "ro", "0");
INSERT INTO `wp_icl_languages` VALUES("45", "ru", "Russian", "1", "0", "ru_RU", "ru", "0");
INSERT INTO `wp_icl_languages` VALUES("46", "sl", "Slovenian", "0", "0", "sl_SI", "sl", "0");
INSERT INTO `wp_icl_languages` VALUES("47", "so", "Somali", "0", "0", "so_SO", "so", "0");
INSERT INTO `wp_icl_languages` VALUES("48", "sq", "Albanian", "0", "0", "sq_AL", "sq", "0");
INSERT INTO `wp_icl_languages` VALUES("49", "sr", "Serbian", "0", "0", "sr_RS", "sr", "0");
INSERT INTO `wp_icl_languages` VALUES("50", "sv", "Swedish", "0", "0", "sv_SE", "sv", "0");
INSERT INTO `wp_icl_languages` VALUES("51", "ta", "Tamil", "0", "0", "ta_IN", "ta", "0");
INSERT INTO `wp_icl_languages` VALUES("52", "th", "Thai", "0", "0", "th", "th", "0");
INSERT INTO `wp_icl_languages` VALUES("53", "tr", "Turkish", "0", "1", "tr_TR", "tr", "0");
INSERT INTO `wp_icl_languages` VALUES("54", "uk", "Ukrainian", "0", "0", "uk", "uk", "0");
INSERT INTO `wp_icl_languages` VALUES("55", "ur", "Urdu", "0", "0", "uz_UZ", "ur", "0");
INSERT INTO `wp_icl_languages` VALUES("56", "uz", "Uzbek", "0", "0", "uz_UZ", "uz", "0");
INSERT INTO `wp_icl_languages` VALUES("57", "vi", "Vietnamese", "0", "0", "vi_VN", "vi", "0");
INSERT INTO `wp_icl_languages` VALUES("58", "yi", "Yiddish", "0", "0", "", "yi", "0");
INSERT INTO `wp_icl_languages` VALUES("59", "zh-hans", "Chinese (Simplified)", "1", "0", "zh_CN", "zh-hans", "0");
INSERT INTO `wp_icl_languages` VALUES("60", "zu", "Zulu", "0", "0", "", "zu", "0");
INSERT INTO `wp_icl_languages` VALUES("61", "zh-hant", "Chinese (Traditional)", "1", "0", "zh_TW", "zh-hant", "0");
INSERT INTO `wp_icl_languages` VALUES("62", "ms", "Malay", "0", "0", "ms_MY", "ms", "0");
INSERT INTO `wp_icl_languages` VALUES("63", "gl", "Galician", "0", "0", "gl_ES", "gl", "0");
INSERT INTO `wp_icl_languages` VALUES("64", "bn", "Bengali", "0", "0", "bn_BD", "bn", "0");

/* INSERT TABLE DATA: wp_icl_languages_translations */
INSERT INTO `wp_icl_languages_translations` VALUES("1", "en", "en", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("2", "en", "es", "Inglés");
INSERT INTO `wp_icl_languages_translations` VALUES("3", "en", "de", "Englisch");
INSERT INTO `wp_icl_languages_translations` VALUES("4", "en", "fr", "Anglais");
INSERT INTO `wp_icl_languages_translations` VALUES("5", "en", "ar", "الإنجليزية");
INSERT INTO `wp_icl_languages_translations` VALUES("6", "en", "bs", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("7", "en", "bg", "Английски");
INSERT INTO `wp_icl_languages_translations` VALUES("8", "en", "ca", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("9", "en", "cs", "Angličtina");
INSERT INTO `wp_icl_languages_translations` VALUES("10", "en", "sk", "Angličtina");
INSERT INTO `wp_icl_languages_translations` VALUES("11", "en", "cy", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("12", "en", "da", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("13", "en", "el", "Αγγλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("14", "en", "eo", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("15", "en", "et", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("16", "en", "eu", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("17", "en", "fa", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("18", "en", "fi", "englanti");
INSERT INTO `wp_icl_languages_translations` VALUES("19", "en", "ga", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("20", "en", "he", "אנגלית");
INSERT INTO `wp_icl_languages_translations` VALUES("21", "en", "hi", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("22", "en", "hr", "Engleski");
INSERT INTO `wp_icl_languages_translations` VALUES("23", "en", "hu", "angol");
INSERT INTO `wp_icl_languages_translations` VALUES("24", "en", "hy", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("25", "en", "id", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("26", "en", "is", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("27", "en", "it", "Inglese");
INSERT INTO `wp_icl_languages_translations` VALUES("28", "en", "ja", "英語");
INSERT INTO `wp_icl_languages_translations` VALUES("29", "en", "ko", "영어");
INSERT INTO `wp_icl_languages_translations` VALUES("30", "en", "ku", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("31", "en", "lv", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("32", "en", "lt", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("33", "en", "mk", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("34", "en", "mt", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("35", "en", "mn", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("36", "en", "ne", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("37", "en", "nl", "Engels");
INSERT INTO `wp_icl_languages_translations` VALUES("38", "en", "no", "Engelsk");
INSERT INTO `wp_icl_languages_translations` VALUES("39", "en", "pa", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("40", "en", "pl", "angielski");
INSERT INTO `wp_icl_languages_translations` VALUES("41", "en", "pt-pt", "Inglês");
INSERT INTO `wp_icl_languages_translations` VALUES("42", "en", "pt-br", "Inglês");
INSERT INTO `wp_icl_languages_translations` VALUES("43", "en", "qu", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("44", "en", "ro", "Engleză");
INSERT INTO `wp_icl_languages_translations` VALUES("45", "en", "ru", "Английский");
INSERT INTO `wp_icl_languages_translations` VALUES("46", "en", "sl", "Angleščina");
INSERT INTO `wp_icl_languages_translations` VALUES("47", "en", "so", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("48", "en", "sq", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("49", "en", "sr", "енглески");
INSERT INTO `wp_icl_languages_translations` VALUES("50", "en", "sv", "Engelska");
INSERT INTO `wp_icl_languages_translations` VALUES("51", "en", "ta", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("52", "en", "th", "อังกฤษ");
INSERT INTO `wp_icl_languages_translations` VALUES("53", "en", "tr", "İngilizce");
INSERT INTO `wp_icl_languages_translations` VALUES("54", "en", "uk", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("55", "en", "ur", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("56", "en", "uz", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("57", "en", "vi", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("58", "en", "yi", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("59", "en", "zh-hans", "英语");
INSERT INTO `wp_icl_languages_translations` VALUES("60", "en", "zu", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("61", "en", "zh-hant", "英語");
INSERT INTO `wp_icl_languages_translations` VALUES("62", "en", "ms", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("63", "en", "gl", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("64", "en", "bn", "English");
INSERT INTO `wp_icl_languages_translations` VALUES("65", "es", "en", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("66", "es", "es", "Español");
INSERT INTO `wp_icl_languages_translations` VALUES("67", "es", "de", "Spanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("68", "es", "fr", "Espagnol");
INSERT INTO `wp_icl_languages_translations` VALUES("69", "es", "ar", "الأسبانية");
INSERT INTO `wp_icl_languages_translations` VALUES("70", "es", "bs", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("71", "es", "bg", "Испански");
INSERT INTO `wp_icl_languages_translations` VALUES("72", "es", "ca", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("73", "es", "cs", "Španělský");
INSERT INTO `wp_icl_languages_translations` VALUES("74", "es", "sk", "Španielčina");
INSERT INTO `wp_icl_languages_translations` VALUES("75", "es", "cy", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("76", "es", "da", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("77", "es", "el", "Ισπανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("78", "es", "eo", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("79", "es", "et", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("80", "es", "eu", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("81", "es", "fa", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("82", "es", "fi", "espanja");
INSERT INTO `wp_icl_languages_translations` VALUES("83", "es", "ga", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("84", "es", "he", "ספרדית");
INSERT INTO `wp_icl_languages_translations` VALUES("85", "es", "hi", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("86", "es", "hr", "španjolski");
INSERT INTO `wp_icl_languages_translations` VALUES("87", "es", "hu", "spanyol");
INSERT INTO `wp_icl_languages_translations` VALUES("88", "es", "hy", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("89", "es", "id", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("90", "es", "is", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("91", "es", "it", "Spagnolo");
INSERT INTO `wp_icl_languages_translations` VALUES("92", "es", "ja", "スペイン語");
INSERT INTO `wp_icl_languages_translations` VALUES("93", "es", "ko", "스페인어");
INSERT INTO `wp_icl_languages_translations` VALUES("94", "es", "ku", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("95", "es", "lv", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("96", "es", "lt", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("97", "es", "mk", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("98", "es", "mt", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("99", "es", "mn", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("100", "es", "ne", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("101", "es", "nl", "Spaans");
INSERT INTO `wp_icl_languages_translations` VALUES("102", "es", "no", "Spansk");
INSERT INTO `wp_icl_languages_translations` VALUES("103", "es", "pa", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("104", "es", "pl", "hiszpański");
INSERT INTO `wp_icl_languages_translations` VALUES("105", "es", "pt-pt", "Espanhol");
INSERT INTO `wp_icl_languages_translations` VALUES("106", "es", "pt-br", "Espanhol");
INSERT INTO `wp_icl_languages_translations` VALUES("107", "es", "qu", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("108", "es", "ro", "Spaniolă");
INSERT INTO `wp_icl_languages_translations` VALUES("109", "es", "ru", "Испанский");
INSERT INTO `wp_icl_languages_translations` VALUES("110", "es", "sl", "Španščina");
INSERT INTO `wp_icl_languages_translations` VALUES("111", "es", "so", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("112", "es", "sq", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("113", "es", "sr", "шпански");
INSERT INTO `wp_icl_languages_translations` VALUES("114", "es", "sv", "Spanska");
INSERT INTO `wp_icl_languages_translations` VALUES("115", "es", "ta", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("116", "es", "th", "สเปน");
INSERT INTO `wp_icl_languages_translations` VALUES("117", "es", "tr", "İspanyolca");
INSERT INTO `wp_icl_languages_translations` VALUES("118", "es", "uk", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("119", "es", "ur", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("120", "es", "uz", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("121", "es", "vi", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("122", "es", "yi", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("123", "es", "zh-hans", "西班牙语");
INSERT INTO `wp_icl_languages_translations` VALUES("124", "es", "zu", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("125", "es", "zh-hant", "西班牙語");
INSERT INTO `wp_icl_languages_translations` VALUES("126", "es", "ms", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("127", "es", "gl", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("128", "es", "bn", "Spanish");
INSERT INTO `wp_icl_languages_translations` VALUES("129", "de", "en", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("130", "de", "es", "Alemán");
INSERT INTO `wp_icl_languages_translations` VALUES("131", "de", "de", "Deutsch");
INSERT INTO `wp_icl_languages_translations` VALUES("132", "de", "fr", "Allemand");
INSERT INTO `wp_icl_languages_translations` VALUES("133", "de", "ar", "الألمانية");
INSERT INTO `wp_icl_languages_translations` VALUES("134", "de", "bs", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("135", "de", "bg", "Немски");
INSERT INTO `wp_icl_languages_translations` VALUES("136", "de", "ca", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("137", "de", "cs", "Němec");
INSERT INTO `wp_icl_languages_translations` VALUES("138", "de", "sk", "Nemčina");
INSERT INTO `wp_icl_languages_translations` VALUES("139", "de", "cy", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("140", "de", "da", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("141", "de", "el", "Γερμανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("142", "de", "eo", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("143", "de", "et", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("144", "de", "eu", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("145", "de", "fa", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("146", "de", "fi", "saksa");
INSERT INTO `wp_icl_languages_translations` VALUES("147", "de", "ga", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("148", "de", "he", "גרמנית");
INSERT INTO `wp_icl_languages_translations` VALUES("149", "de", "hi", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("150", "de", "hr", "Njemački");
INSERT INTO `wp_icl_languages_translations` VALUES("151", "de", "hu", "német");
INSERT INTO `wp_icl_languages_translations` VALUES("152", "de", "hy", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("153", "de", "id", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("154", "de", "is", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("155", "de", "it", "Tedesco");
INSERT INTO `wp_icl_languages_translations` VALUES("156", "de", "ja", "ドイツ語");
INSERT INTO `wp_icl_languages_translations` VALUES("157", "de", "ko", "독어");
INSERT INTO `wp_icl_languages_translations` VALUES("158", "de", "ku", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("159", "de", "lv", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("160", "de", "lt", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("161", "de", "mk", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("162", "de", "mt", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("163", "de", "mn", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("164", "de", "ne", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("165", "de", "nl", "Duits");
INSERT INTO `wp_icl_languages_translations` VALUES("166", "de", "no", "Tysk");
INSERT INTO `wp_icl_languages_translations` VALUES("167", "de", "pa", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("168", "de", "pl", "niemiecki");
INSERT INTO `wp_icl_languages_translations` VALUES("169", "de", "pt-pt", "Alemão");
INSERT INTO `wp_icl_languages_translations` VALUES("170", "de", "pt-br", "Alemão");
INSERT INTO `wp_icl_languages_translations` VALUES("171", "de", "qu", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("172", "de", "ro", "Germană");
INSERT INTO `wp_icl_languages_translations` VALUES("173", "de", "ru", "Немецкий");
INSERT INTO `wp_icl_languages_translations` VALUES("174", "de", "sl", "Nemščina");
INSERT INTO `wp_icl_languages_translations` VALUES("175", "de", "so", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("176", "de", "sq", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("177", "de", "sr", "немачки");
INSERT INTO `wp_icl_languages_translations` VALUES("178", "de", "sv", "Tyska");
INSERT INTO `wp_icl_languages_translations` VALUES("179", "de", "ta", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("180", "de", "th", "เยอรมัน");
INSERT INTO `wp_icl_languages_translations` VALUES("181", "de", "tr", "Almanca");
INSERT INTO `wp_icl_languages_translations` VALUES("182", "de", "uk", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("183", "de", "ur", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("184", "de", "uz", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("185", "de", "vi", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("186", "de", "yi", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("187", "de", "zh-hans", "德语");
INSERT INTO `wp_icl_languages_translations` VALUES("188", "de", "zu", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("189", "de", "zh-hant", "德語");
INSERT INTO `wp_icl_languages_translations` VALUES("190", "de", "ms", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("191", "de", "gl", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("192", "de", "bn", "German");
INSERT INTO `wp_icl_languages_translations` VALUES("193", "fr", "en", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("194", "fr", "es", "Francés");
INSERT INTO `wp_icl_languages_translations` VALUES("195", "fr", "de", "Französisch");
INSERT INTO `wp_icl_languages_translations` VALUES("196", "fr", "fr", "Français");
INSERT INTO `wp_icl_languages_translations` VALUES("197", "fr", "ar", "الفرنسية");
INSERT INTO `wp_icl_languages_translations` VALUES("198", "fr", "bs", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("199", "fr", "bg", "Френски");
INSERT INTO `wp_icl_languages_translations` VALUES("200", "fr", "ca", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("201", "fr", "cs", "Francouzština");
INSERT INTO `wp_icl_languages_translations` VALUES("202", "fr", "sk", "Francúzština");
INSERT INTO `wp_icl_languages_translations` VALUES("203", "fr", "cy", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("204", "fr", "da", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("205", "fr", "el", "Γαλλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("206", "fr", "eo", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("207", "fr", "et", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("208", "fr", "eu", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("209", "fr", "fa", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("210", "fr", "fi", "ranska");
INSERT INTO `wp_icl_languages_translations` VALUES("211", "fr", "ga", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("212", "fr", "he", "צרפתית");
INSERT INTO `wp_icl_languages_translations` VALUES("213", "fr", "hi", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("214", "fr", "hr", "Francuzi");
INSERT INTO `wp_icl_languages_translations` VALUES("215", "fr", "hu", "francia");
INSERT INTO `wp_icl_languages_translations` VALUES("216", "fr", "hy", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("217", "fr", "id", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("218", "fr", "is", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("219", "fr", "it", "Francese");
INSERT INTO `wp_icl_languages_translations` VALUES("220", "fr", "ja", "フランス語");
INSERT INTO `wp_icl_languages_translations` VALUES("221", "fr", "ko", "불어");
INSERT INTO `wp_icl_languages_translations` VALUES("222", "fr", "ku", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("223", "fr", "lv", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("224", "fr", "lt", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("225", "fr", "mk", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("226", "fr", "mt", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("227", "fr", "mn", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("228", "fr", "ne", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("229", "fr", "nl", "Frans");
INSERT INTO `wp_icl_languages_translations` VALUES("230", "fr", "no", "Fransk");
INSERT INTO `wp_icl_languages_translations` VALUES("231", "fr", "pa", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("232", "fr", "pl", "francuski");
INSERT INTO `wp_icl_languages_translations` VALUES("233", "fr", "pt-pt", "Francês");
INSERT INTO `wp_icl_languages_translations` VALUES("234", "fr", "pt-br", "Francês");
INSERT INTO `wp_icl_languages_translations` VALUES("235", "fr", "qu", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("236", "fr", "ro", "Franceză");
INSERT INTO `wp_icl_languages_translations` VALUES("237", "fr", "ru", "Французский");
INSERT INTO `wp_icl_languages_translations` VALUES("238", "fr", "sl", "Francoščina");
INSERT INTO `wp_icl_languages_translations` VALUES("239", "fr", "so", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("240", "fr", "sq", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("241", "fr", "sr", "француски");
INSERT INTO `wp_icl_languages_translations` VALUES("242", "fr", "sv", "Franska");
INSERT INTO `wp_icl_languages_translations` VALUES("243", "fr", "ta", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("244", "fr", "th", "ฝรั่งเศส");
INSERT INTO `wp_icl_languages_translations` VALUES("245", "fr", "tr", "Fransızca");
INSERT INTO `wp_icl_languages_translations` VALUES("246", "fr", "uk", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("247", "fr", "ur", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("248", "fr", "uz", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("249", "fr", "vi", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("250", "fr", "yi", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("251", "fr", "zh-hans", "法语");
INSERT INTO `wp_icl_languages_translations` VALUES("252", "fr", "zu", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("253", "fr", "zh-hant", "法語");
INSERT INTO `wp_icl_languages_translations` VALUES("254", "fr", "ms", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("255", "fr", "gl", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("256", "fr", "bn", "French");
INSERT INTO `wp_icl_languages_translations` VALUES("257", "ar", "en", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("258", "ar", "es", "Árabe");
INSERT INTO `wp_icl_languages_translations` VALUES("259", "ar", "de", "Arabisch");
INSERT INTO `wp_icl_languages_translations` VALUES("260", "ar", "fr", "Arabe");
INSERT INTO `wp_icl_languages_translations` VALUES("261", "ar", "ar", "العربية");
INSERT INTO `wp_icl_languages_translations` VALUES("262", "ar", "bs", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("263", "ar", "bg", "Арабски");
INSERT INTO `wp_icl_languages_translations` VALUES("264", "ar", "ca", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("265", "ar", "cs", "Arabština");
INSERT INTO `wp_icl_languages_translations` VALUES("266", "ar", "sk", "Arabčina");
INSERT INTO `wp_icl_languages_translations` VALUES("267", "ar", "cy", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("268", "ar", "da", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("269", "ar", "el", "Αραβικα");
INSERT INTO `wp_icl_languages_translations` VALUES("270", "ar", "eo", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("271", "ar", "et", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("272", "ar", "eu", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("273", "ar", "fa", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("274", "ar", "fi", "arabia");
INSERT INTO `wp_icl_languages_translations` VALUES("275", "ar", "ga", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("276", "ar", "he", "ערבית");
INSERT INTO `wp_icl_languages_translations` VALUES("277", "ar", "hi", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("278", "ar", "hr", "Arapski");
INSERT INTO `wp_icl_languages_translations` VALUES("279", "ar", "hu", "arab");
INSERT INTO `wp_icl_languages_translations` VALUES("280", "ar", "hy", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("281", "ar", "id", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("282", "ar", "is", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("283", "ar", "it", "Arabo");
INSERT INTO `wp_icl_languages_translations` VALUES("284", "ar", "ja", "アラビア語");
INSERT INTO `wp_icl_languages_translations` VALUES("285", "ar", "ko", "아랍어");
INSERT INTO `wp_icl_languages_translations` VALUES("286", "ar", "ku", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("287", "ar", "lv", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("288", "ar", "lt", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("289", "ar", "mk", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("290", "ar", "mt", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("291", "ar", "mn", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("292", "ar", "ne", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("293", "ar", "nl", "Arabisch");
INSERT INTO `wp_icl_languages_translations` VALUES("294", "ar", "no", "Arabisk");
INSERT INTO `wp_icl_languages_translations` VALUES("295", "ar", "pa", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("296", "ar", "pl", "arabski");
INSERT INTO `wp_icl_languages_translations` VALUES("297", "ar", "pt-pt", "Árabe");
INSERT INTO `wp_icl_languages_translations` VALUES("298", "ar", "pt-br", "Árabe");
INSERT INTO `wp_icl_languages_translations` VALUES("299", "ar", "qu", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("300", "ar", "ro", "Arabică");
INSERT INTO `wp_icl_languages_translations` VALUES("301", "ar", "ru", "Арабский");
INSERT INTO `wp_icl_languages_translations` VALUES("302", "ar", "sl", "Arabščina");
INSERT INTO `wp_icl_languages_translations` VALUES("303", "ar", "so", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("304", "ar", "sq", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("305", "ar", "sr", "арапски");
INSERT INTO `wp_icl_languages_translations` VALUES("306", "ar", "sv", "Arabiska");
INSERT INTO `wp_icl_languages_translations` VALUES("307", "ar", "ta", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("308", "ar", "th", "อารบิก");
INSERT INTO `wp_icl_languages_translations` VALUES("309", "ar", "tr", "Arapça");
INSERT INTO `wp_icl_languages_translations` VALUES("310", "ar", "uk", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("311", "ar", "ur", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("312", "ar", "uz", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("313", "ar", "vi", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("314", "ar", "yi", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("315", "ar", "zh-hans", "阿拉伯语");
INSERT INTO `wp_icl_languages_translations` VALUES("316", "ar", "zu", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("317", "ar", "zh-hant", "阿拉伯語");
INSERT INTO `wp_icl_languages_translations` VALUES("318", "ar", "ms", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("319", "ar", "gl", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("320", "ar", "bn", "Arabic");
INSERT INTO `wp_icl_languages_translations` VALUES("321", "bs", "en", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("322", "bs", "es", "Bosnio");
INSERT INTO `wp_icl_languages_translations` VALUES("323", "bs", "de", "Bosnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("324", "bs", "fr", "Bosnien");
INSERT INTO `wp_icl_languages_translations` VALUES("325", "bs", "ar", "البوسنية");
INSERT INTO `wp_icl_languages_translations` VALUES("326", "bs", "bs", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("327", "bs", "bg", "Босненски");
INSERT INTO `wp_icl_languages_translations` VALUES("328", "bs", "ca", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("329", "bs", "cs", "Bosenština");
INSERT INTO `wp_icl_languages_translations` VALUES("330", "bs", "sk", "Bosniačtina");
INSERT INTO `wp_icl_languages_translations` VALUES("331", "bs", "cy", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("332", "bs", "da", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("333", "bs", "el", "Βοσνιακα");
INSERT INTO `wp_icl_languages_translations` VALUES("334", "bs", "eo", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("335", "bs", "et", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("336", "bs", "eu", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("337", "bs", "fa", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("338", "bs", "fi", "bosnia");
INSERT INTO `wp_icl_languages_translations` VALUES("339", "bs", "ga", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("340", "bs", "he", "בוסנית");
INSERT INTO `wp_icl_languages_translations` VALUES("341", "bs", "hi", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("342", "bs", "hr", "Bosanski");
INSERT INTO `wp_icl_languages_translations` VALUES("343", "bs", "hu", "bosnyák");
INSERT INTO `wp_icl_languages_translations` VALUES("344", "bs", "hy", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("345", "bs", "id", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("346", "bs", "is", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("347", "bs", "it", "Bosniaco");
INSERT INTO `wp_icl_languages_translations` VALUES("348", "bs", "ja", "ボスニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("349", "bs", "ko", "보즈니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("350", "bs", "ku", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("351", "bs", "lv", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("352", "bs", "lt", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("353", "bs", "mk", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("354", "bs", "mt", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("355", "bs", "mn", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("356", "bs", "ne", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("357", "bs", "nl", "Bosnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("358", "bs", "no", "Bosnisk");
INSERT INTO `wp_icl_languages_translations` VALUES("359", "bs", "pa", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("360", "bs", "pl", "bośniacki");
INSERT INTO `wp_icl_languages_translations` VALUES("361", "bs", "pt-pt", "Bósnio");
INSERT INTO `wp_icl_languages_translations` VALUES("362", "bs", "pt-br", "Bósnio");
INSERT INTO `wp_icl_languages_translations` VALUES("363", "bs", "qu", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("364", "bs", "ro", "Bosniacă");
INSERT INTO `wp_icl_languages_translations` VALUES("365", "bs", "ru", "Боснийский");
INSERT INTO `wp_icl_languages_translations` VALUES("366", "bs", "sl", "Bosanski");
INSERT INTO `wp_icl_languages_translations` VALUES("367", "bs", "so", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("368", "bs", "sq", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("369", "bs", "sr", "босански");
INSERT INTO `wp_icl_languages_translations` VALUES("370", "bs", "sv", "Bosniska");
INSERT INTO `wp_icl_languages_translations` VALUES("371", "bs", "ta", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("372", "bs", "th", "บอสเนียน");
INSERT INTO `wp_icl_languages_translations` VALUES("373", "bs", "tr", "Boşnakça");
INSERT INTO `wp_icl_languages_translations` VALUES("374", "bs", "uk", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("375", "bs", "ur", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("376", "bs", "uz", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("377", "bs", "vi", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("378", "bs", "yi", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("379", "bs", "zh-hans", "波斯尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("380", "bs", "zu", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("381", "bs", "zh-hant", "波士尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("382", "bs", "ms", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("383", "bs", "gl", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("384", "bs", "bn", "Bosnian");
INSERT INTO `wp_icl_languages_translations` VALUES("385", "bg", "en", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("386", "bg", "es", "Búlgaro");
INSERT INTO `wp_icl_languages_translations` VALUES("387", "bg", "de", "Bulgarisch");
INSERT INTO `wp_icl_languages_translations` VALUES("388", "bg", "fr", "Bulgare");
INSERT INTO `wp_icl_languages_translations` VALUES("389", "bg", "ar", "البلغارية");
INSERT INTO `wp_icl_languages_translations` VALUES("390", "bg", "bs", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("391", "bg", "bg", "Български");
INSERT INTO `wp_icl_languages_translations` VALUES("392", "bg", "ca", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("393", "bg", "cs", "Bulharština");
INSERT INTO `wp_icl_languages_translations` VALUES("394", "bg", "sk", "Bulharčina");
INSERT INTO `wp_icl_languages_translations` VALUES("395", "bg", "cy", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("396", "bg", "da", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("397", "bg", "el", "Βουλγαρικα");
INSERT INTO `wp_icl_languages_translations` VALUES("398", "bg", "eo", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("399", "bg", "et", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("400", "bg", "eu", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("401", "bg", "fa", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("402", "bg", "fi", "bulgaria");
INSERT INTO `wp_icl_languages_translations` VALUES("403", "bg", "ga", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("404", "bg", "he", "בולגרית");
INSERT INTO `wp_icl_languages_translations` VALUES("405", "bg", "hi", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("406", "bg", "hr", "Bugarski");
INSERT INTO `wp_icl_languages_translations` VALUES("407", "bg", "hu", "bolgár");
INSERT INTO `wp_icl_languages_translations` VALUES("408", "bg", "hy", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("409", "bg", "id", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("410", "bg", "is", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("411", "bg", "it", "Bulgaro");
INSERT INTO `wp_icl_languages_translations` VALUES("412", "bg", "ja", "ブルガリア語");
INSERT INTO `wp_icl_languages_translations` VALUES("413", "bg", "ko", "불가리아어");
INSERT INTO `wp_icl_languages_translations` VALUES("414", "bg", "ku", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("415", "bg", "lv", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("416", "bg", "lt", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("417", "bg", "mk", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("418", "bg", "mt", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("419", "bg", "mn", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("420", "bg", "ne", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("421", "bg", "nl", "Bulgaars");
INSERT INTO `wp_icl_languages_translations` VALUES("422", "bg", "no", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("423", "bg", "pa", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("424", "bg", "pl", "bułgarski");
INSERT INTO `wp_icl_languages_translations` VALUES("425", "bg", "pt-pt", "Búlgaro");
INSERT INTO `wp_icl_languages_translations` VALUES("426", "bg", "pt-br", "Búlgaro");
INSERT INTO `wp_icl_languages_translations` VALUES("427", "bg", "qu", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("428", "bg", "ro", "Bulgară");
INSERT INTO `wp_icl_languages_translations` VALUES("429", "bg", "ru", "Болгарский");
INSERT INTO `wp_icl_languages_translations` VALUES("430", "bg", "sl", "Bolgarščina");
INSERT INTO `wp_icl_languages_translations` VALUES("431", "bg", "so", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("432", "bg", "sq", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("433", "bg", "sr", "бугарски");
INSERT INTO `wp_icl_languages_translations` VALUES("434", "bg", "sv", "Bulgariska");
INSERT INTO `wp_icl_languages_translations` VALUES("435", "bg", "ta", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("436", "bg", "th", "บัลแกเรียน");
INSERT INTO `wp_icl_languages_translations` VALUES("437", "bg", "tr", "Bulgarca");
INSERT INTO `wp_icl_languages_translations` VALUES("438", "bg", "uk", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("439", "bg", "ur", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("440", "bg", "uz", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("441", "bg", "vi", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("442", "bg", "yi", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("443", "bg", "zh-hans", "保加利亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("444", "bg", "zu", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("445", "bg", "zh-hant", "保加利亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("446", "bg", "ms", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("447", "bg", "gl", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("448", "bg", "bn", "Bulgarian");
INSERT INTO `wp_icl_languages_translations` VALUES("449", "ca", "en", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("450", "ca", "es", "Catalán");
INSERT INTO `wp_icl_languages_translations` VALUES("451", "ca", "de", "Katalanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("452", "ca", "fr", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("453", "ca", "ar", "الكاتالوينية");
INSERT INTO `wp_icl_languages_translations` VALUES("454", "ca", "bs", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("455", "ca", "bg", "Каталонски");
INSERT INTO `wp_icl_languages_translations` VALUES("456", "ca", "ca", "Català");
INSERT INTO `wp_icl_languages_translations` VALUES("457", "ca", "cs", "Katalánština");
INSERT INTO `wp_icl_languages_translations` VALUES("458", "ca", "sk", "Katalánčina");
INSERT INTO `wp_icl_languages_translations` VALUES("459", "ca", "cy", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("460", "ca", "da", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("461", "ca", "el", "Καταλανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("462", "ca", "eo", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("463", "ca", "et", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("464", "ca", "eu", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("465", "ca", "fa", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("466", "ca", "fi", "katalaani");
INSERT INTO `wp_icl_languages_translations` VALUES("467", "ca", "ga", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("468", "ca", "he", "קטלאנית");
INSERT INTO `wp_icl_languages_translations` VALUES("469", "ca", "hi", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("470", "ca", "hr", "Katalonski");
INSERT INTO `wp_icl_languages_translations` VALUES("471", "ca", "hu", "katalán");
INSERT INTO `wp_icl_languages_translations` VALUES("472", "ca", "hy", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("473", "ca", "id", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("474", "ca", "is", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("475", "ca", "it", "Catalano");
INSERT INTO `wp_icl_languages_translations` VALUES("476", "ca", "ja", "カタルーニャ語");
INSERT INTO `wp_icl_languages_translations` VALUES("477", "ca", "ko", "카탈로니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("478", "ca", "ku", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("479", "ca", "lv", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("480", "ca", "lt", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("481", "ca", "mk", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("482", "ca", "mt", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("483", "ca", "mn", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("484", "ca", "ne", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("485", "ca", "nl", "Catalaans");
INSERT INTO `wp_icl_languages_translations` VALUES("486", "ca", "no", "catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("487", "ca", "pa", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("488", "ca", "pl", "kataloński");
INSERT INTO `wp_icl_languages_translations` VALUES("489", "ca", "pt-pt", "Catalão");
INSERT INTO `wp_icl_languages_translations` VALUES("490", "ca", "pt-br", "Catalão");
INSERT INTO `wp_icl_languages_translations` VALUES("491", "ca", "qu", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("492", "ca", "ro", "Catalană");
INSERT INTO `wp_icl_languages_translations` VALUES("493", "ca", "ru", "Каталанский");
INSERT INTO `wp_icl_languages_translations` VALUES("494", "ca", "sl", "Katalonščina");
INSERT INTO `wp_icl_languages_translations` VALUES("495", "ca", "so", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("496", "ca", "sq", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("497", "ca", "sr", "каталонски");
INSERT INTO `wp_icl_languages_translations` VALUES("498", "ca", "sv", "Katalanska");
INSERT INTO `wp_icl_languages_translations` VALUES("499", "ca", "ta", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("500", "ca", "th", "คะตะลาน");
INSERT INTO `wp_icl_languages_translations` VALUES("501", "ca", "tr", "Katalan dili");
INSERT INTO `wp_icl_languages_translations` VALUES("502", "ca", "uk", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("503", "ca", "ur", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("504", "ca", "uz", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("505", "ca", "vi", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("506", "ca", "yi", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("507", "ca", "zh-hans", "加泰罗尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("508", "ca", "zu", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("509", "ca", "zh-hant", "加泰羅尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("510", "ca", "ms", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("511", "ca", "gl", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("512", "ca", "bn", "Catalan");
INSERT INTO `wp_icl_languages_translations` VALUES("513", "cs", "en", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("514", "cs", "es", "Checo");
INSERT INTO `wp_icl_languages_translations` VALUES("515", "cs", "de", "Tschechisch");
INSERT INTO `wp_icl_languages_translations` VALUES("516", "cs", "fr", "Tchèque");
INSERT INTO `wp_icl_languages_translations` VALUES("517", "cs", "ar", "التشيكية");
INSERT INTO `wp_icl_languages_translations` VALUES("518", "cs", "bs", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("519", "cs", "bg", "Чешки");
INSERT INTO `wp_icl_languages_translations` VALUES("520", "cs", "ca", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("521", "cs", "cs", "Čeština");
INSERT INTO `wp_icl_languages_translations` VALUES("522", "cs", "sk", "Čeština");
INSERT INTO `wp_icl_languages_translations` VALUES("523", "cs", "cy", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("524", "cs", "da", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("525", "cs", "el", "Τσεχικη");
INSERT INTO `wp_icl_languages_translations` VALUES("526", "cs", "eo", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("527", "cs", "et", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("528", "cs", "eu", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("529", "cs", "fa", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("530", "cs", "fi", "tsekki");
INSERT INTO `wp_icl_languages_translations` VALUES("531", "cs", "ga", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("532", "cs", "he", "צ\'כית");
INSERT INTO `wp_icl_languages_translations` VALUES("533", "cs", "hi", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("534", "cs", "hr", "češki");
INSERT INTO `wp_icl_languages_translations` VALUES("535", "cs", "hu", "cseh");
INSERT INTO `wp_icl_languages_translations` VALUES("536", "cs", "hy", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("537", "cs", "id", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("538", "cs", "is", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("539", "cs", "it", "Ceco");
INSERT INTO `wp_icl_languages_translations` VALUES("540", "cs", "ja", "チェコ語");
INSERT INTO `wp_icl_languages_translations` VALUES("541", "cs", "ko", "체코슬로바키아어");
INSERT INTO `wp_icl_languages_translations` VALUES("542", "cs", "ku", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("543", "cs", "lv", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("544", "cs", "lt", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("545", "cs", "mk", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("546", "cs", "mt", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("547", "cs", "mn", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("548", "cs", "ne", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("549", "cs", "nl", "Tsjechisch");
INSERT INTO `wp_icl_languages_translations` VALUES("550", "cs", "no", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("551", "cs", "pa", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("552", "cs", "pl", "czeski");
INSERT INTO `wp_icl_languages_translations` VALUES("553", "cs", "pt-pt", "Tcheco");
INSERT INTO `wp_icl_languages_translations` VALUES("554", "cs", "pt-br", "Tcheco");
INSERT INTO `wp_icl_languages_translations` VALUES("555", "cs", "qu", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("556", "cs", "ro", "Cehă");
INSERT INTO `wp_icl_languages_translations` VALUES("557", "cs", "ru", "Чешский");
INSERT INTO `wp_icl_languages_translations` VALUES("558", "cs", "sl", "Češčina");
INSERT INTO `wp_icl_languages_translations` VALUES("559", "cs", "so", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("560", "cs", "sq", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("561", "cs", "sr", "чешки");
INSERT INTO `wp_icl_languages_translations` VALUES("562", "cs", "sv", "Tjeckiska");
INSERT INTO `wp_icl_languages_translations` VALUES("563", "cs", "ta", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("564", "cs", "th", "เช็ก");
INSERT INTO `wp_icl_languages_translations` VALUES("565", "cs", "tr", "Çekçe");
INSERT INTO `wp_icl_languages_translations` VALUES("566", "cs", "uk", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("567", "cs", "ur", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("568", "cs", "uz", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("569", "cs", "vi", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("570", "cs", "yi", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("571", "cs", "zh-hans", "捷克语");
INSERT INTO `wp_icl_languages_translations` VALUES("572", "cs", "zu", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("573", "cs", "zh-hant", "捷克語");
INSERT INTO `wp_icl_languages_translations` VALUES("574", "cs", "ms", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("575", "cs", "gl", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("576", "cs", "bn", "Czech");
INSERT INTO `wp_icl_languages_translations` VALUES("577", "sk", "en", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("578", "sk", "es", "Eslavo");
INSERT INTO `wp_icl_languages_translations` VALUES("579", "sk", "de", "Slowakisch");
INSERT INTO `wp_icl_languages_translations` VALUES("580", "sk", "fr", "Slave");
INSERT INTO `wp_icl_languages_translations` VALUES("581", "sk", "ar", "السلافية");
INSERT INTO `wp_icl_languages_translations` VALUES("582", "sk", "bs", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("583", "sk", "bg", "Словашки");
INSERT INTO `wp_icl_languages_translations` VALUES("584", "sk", "ca", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("585", "sk", "cs", "Slovenština");
INSERT INTO `wp_icl_languages_translations` VALUES("586", "sk", "sk", "Slovenčina");
INSERT INTO `wp_icl_languages_translations` VALUES("587", "sk", "cy", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("588", "sk", "da", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("589", "sk", "el", "Σλαβικη");
INSERT INTO `wp_icl_languages_translations` VALUES("590", "sk", "eo", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("591", "sk", "et", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("592", "sk", "eu", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("593", "sk", "fa", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("594", "sk", "fi", "slaavi");
INSERT INTO `wp_icl_languages_translations` VALUES("595", "sk", "ga", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("596", "sk", "he", "סלאבית");
INSERT INTO `wp_icl_languages_translations` VALUES("597", "sk", "hi", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("598", "sk", "hr", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("599", "sk", "hu", "szláv");
INSERT INTO `wp_icl_languages_translations` VALUES("600", "sk", "hy", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("601", "sk", "id", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("602", "sk", "is", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("603", "sk", "it", "Slavo");
INSERT INTO `wp_icl_languages_translations` VALUES("604", "sk", "ja", "スラヴ語派");
INSERT INTO `wp_icl_languages_translations` VALUES("605", "sk", "ko", "슬라브어");
INSERT INTO `wp_icl_languages_translations` VALUES("606", "sk", "ku", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("607", "sk", "lv", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("608", "sk", "lt", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("609", "sk", "mk", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("610", "sk", "mt", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("611", "sk", "mn", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("612", "sk", "ne", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("613", "sk", "nl", "Slavisch");
INSERT INTO `wp_icl_languages_translations` VALUES("614", "sk", "no", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("615", "sk", "pa", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("616", "sk", "pl", "słowacki");
INSERT INTO `wp_icl_languages_translations` VALUES("617", "sk", "pt-pt", "Eslavo");
INSERT INTO `wp_icl_languages_translations` VALUES("618", "sk", "pt-br", "Eslavo");
INSERT INTO `wp_icl_languages_translations` VALUES("619", "sk", "qu", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("620", "sk", "ro", "Slavă");
INSERT INTO `wp_icl_languages_translations` VALUES("621", "sk", "ru", "Славянский");
INSERT INTO `wp_icl_languages_translations` VALUES("622", "sk", "sl", "Slovaščina");
INSERT INTO `wp_icl_languages_translations` VALUES("623", "sk", "so", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("624", "sk", "sq", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("625", "sk", "sr", "словачки");
INSERT INTO `wp_icl_languages_translations` VALUES("626", "sk", "sv", "Slavisk");
INSERT INTO `wp_icl_languages_translations` VALUES("627", "sk", "ta", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("628", "sk", "th", "สลาวิก");
INSERT INTO `wp_icl_languages_translations` VALUES("629", "sk", "tr", "Slav dili");
INSERT INTO `wp_icl_languages_translations` VALUES("630", "sk", "uk", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("631", "sk", "ur", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("632", "sk", "uz", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("633", "sk", "vi", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("634", "sk", "yi", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("635", "sk", "zh-hans", "斯拉夫语");
INSERT INTO `wp_icl_languages_translations` VALUES("636", "sk", "zu", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("637", "sk", "zh-hant", "斯拉夫語");
INSERT INTO `wp_icl_languages_translations` VALUES("638", "sk", "ms", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("639", "sk", "gl", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("640", "sk", "bn", "Slovak");
INSERT INTO `wp_icl_languages_translations` VALUES("641", "cy", "en", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("642", "cy", "es", "Galés");
INSERT INTO `wp_icl_languages_translations` VALUES("643", "cy", "de", "Walisisch");
INSERT INTO `wp_icl_languages_translations` VALUES("644", "cy", "fr", "Gallois");
INSERT INTO `wp_icl_languages_translations` VALUES("645", "cy", "ar", "الولزية");
INSERT INTO `wp_icl_languages_translations` VALUES("646", "cy", "bs", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("647", "cy", "bg", "Уелски");
INSERT INTO `wp_icl_languages_translations` VALUES("648", "cy", "ca", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("649", "cy", "cs", "Velšský");
INSERT INTO `wp_icl_languages_translations` VALUES("650", "cy", "sk", "Welština");
INSERT INTO `wp_icl_languages_translations` VALUES("651", "cy", "cy", "Cymraeg");
INSERT INTO `wp_icl_languages_translations` VALUES("652", "cy", "da", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("653", "cy", "el", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("654", "cy", "eo", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("655", "cy", "et", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("656", "cy", "eu", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("657", "cy", "fa", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("658", "cy", "fi", "kymri");
INSERT INTO `wp_icl_languages_translations` VALUES("659", "cy", "ga", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("660", "cy", "he", "וולשית");
INSERT INTO `wp_icl_languages_translations` VALUES("661", "cy", "hi", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("662", "cy", "hr", "Velški");
INSERT INTO `wp_icl_languages_translations` VALUES("663", "cy", "hu", "vels");
INSERT INTO `wp_icl_languages_translations` VALUES("664", "cy", "hy", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("665", "cy", "id", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("666", "cy", "is", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("667", "cy", "it", "Gallese");
INSERT INTO `wp_icl_languages_translations` VALUES("668", "cy", "ja", "ウェールズ語");
INSERT INTO `wp_icl_languages_translations` VALUES("669", "cy", "ko", "웨일즈어");
INSERT INTO `wp_icl_languages_translations` VALUES("670", "cy", "ku", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("671", "cy", "lv", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("672", "cy", "lt", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("673", "cy", "mk", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("674", "cy", "mt", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("675", "cy", "mn", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("676", "cy", "ne", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("677", "cy", "nl", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("678", "cy", "no", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("679", "cy", "pa", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("680", "cy", "pl", "walijski");
INSERT INTO `wp_icl_languages_translations` VALUES("681", "cy", "pt-pt", "Galês");
INSERT INTO `wp_icl_languages_translations` VALUES("682", "cy", "pt-br", "Galês");
INSERT INTO `wp_icl_languages_translations` VALUES("683", "cy", "qu", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("684", "cy", "ro", "Galeză");
INSERT INTO `wp_icl_languages_translations` VALUES("685", "cy", "ru", "Валлийский");
INSERT INTO `wp_icl_languages_translations` VALUES("686", "cy", "sl", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("687", "cy", "so", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("688", "cy", "sq", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("689", "cy", "sr", "велшки");
INSERT INTO `wp_icl_languages_translations` VALUES("690", "cy", "sv", "Walesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("691", "cy", "ta", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("692", "cy", "th", "เวลช์");
INSERT INTO `wp_icl_languages_translations` VALUES("693", "cy", "tr", "Galce");
INSERT INTO `wp_icl_languages_translations` VALUES("694", "cy", "uk", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("695", "cy", "ur", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("696", "cy", "uz", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("697", "cy", "vi", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("698", "cy", "yi", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("699", "cy", "zh-hans", "威尔士语");
INSERT INTO `wp_icl_languages_translations` VALUES("700", "cy", "zu", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("701", "cy", "zh-hant", "威爾士語");
INSERT INTO `wp_icl_languages_translations` VALUES("702", "cy", "ms", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("703", "cy", "gl", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("704", "cy", "bn", "Welsh");
INSERT INTO `wp_icl_languages_translations` VALUES("705", "da", "en", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("706", "da", "es", "Danés");
INSERT INTO `wp_icl_languages_translations` VALUES("707", "da", "de", "Dänisch");
INSERT INTO `wp_icl_languages_translations` VALUES("708", "da", "fr", "Danois");
INSERT INTO `wp_icl_languages_translations` VALUES("709", "da", "ar", "الدانماركية");
INSERT INTO `wp_icl_languages_translations` VALUES("710", "da", "bs", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("711", "da", "bg", "Датски");
INSERT INTO `wp_icl_languages_translations` VALUES("712", "da", "ca", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("713", "da", "cs", "Dánský");
INSERT INTO `wp_icl_languages_translations` VALUES("714", "da", "sk", "Dánčina");
INSERT INTO `wp_icl_languages_translations` VALUES("715", "da", "cy", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("716", "da", "da", "Dansk");
INSERT INTO `wp_icl_languages_translations` VALUES("717", "da", "el", "Δανεζικα");
INSERT INTO `wp_icl_languages_translations` VALUES("718", "da", "eo", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("719", "da", "et", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("720", "da", "eu", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("721", "da", "fa", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("722", "da", "fi", "tanska");
INSERT INTO `wp_icl_languages_translations` VALUES("723", "da", "ga", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("724", "da", "he", "דנית");
INSERT INTO `wp_icl_languages_translations` VALUES("725", "da", "hi", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("726", "da", "hr", "Danski");
INSERT INTO `wp_icl_languages_translations` VALUES("727", "da", "hu", "dán");
INSERT INTO `wp_icl_languages_translations` VALUES("728", "da", "hy", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("729", "da", "id", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("730", "da", "is", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("731", "da", "it", "Danese");
INSERT INTO `wp_icl_languages_translations` VALUES("732", "da", "ja", "デンマーク語");
INSERT INTO `wp_icl_languages_translations` VALUES("733", "da", "ko", "덴마크어");
INSERT INTO `wp_icl_languages_translations` VALUES("734", "da", "ku", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("735", "da", "lv", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("736", "da", "lt", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("737", "da", "mk", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("738", "da", "mt", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("739", "da", "mn", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("740", "da", "ne", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("741", "da", "nl", "Deens");
INSERT INTO `wp_icl_languages_translations` VALUES("742", "da", "no", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("743", "da", "pa", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("744", "da", "pl", "duński");
INSERT INTO `wp_icl_languages_translations` VALUES("745", "da", "pt-pt", "Dinamarquês");
INSERT INTO `wp_icl_languages_translations` VALUES("746", "da", "pt-br", "Dinamarquês");
INSERT INTO `wp_icl_languages_translations` VALUES("747", "da", "qu", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("748", "da", "ro", "Daneză");
INSERT INTO `wp_icl_languages_translations` VALUES("749", "da", "ru", "Датский");
INSERT INTO `wp_icl_languages_translations` VALUES("750", "da", "sl", "Danščina");
INSERT INTO `wp_icl_languages_translations` VALUES("751", "da", "so", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("752", "da", "sq", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("753", "da", "sr", "дански");
INSERT INTO `wp_icl_languages_translations` VALUES("754", "da", "sv", "Danska");
INSERT INTO `wp_icl_languages_translations` VALUES("755", "da", "ta", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("756", "da", "th", "เดนมาร์ก");
INSERT INTO `wp_icl_languages_translations` VALUES("757", "da", "tr", "Danca");
INSERT INTO `wp_icl_languages_translations` VALUES("758", "da", "uk", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("759", "da", "ur", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("760", "da", "uz", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("761", "da", "vi", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("762", "da", "yi", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("763", "da", "zh-hans", "丹麦语");
INSERT INTO `wp_icl_languages_translations` VALUES("764", "da", "zu", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("765", "da", "zh-hant", "丹麥語");
INSERT INTO `wp_icl_languages_translations` VALUES("766", "da", "ms", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("767", "da", "gl", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("768", "da", "bn", "Danish");
INSERT INTO `wp_icl_languages_translations` VALUES("769", "el", "en", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("770", "el", "es", "Griego");
INSERT INTO `wp_icl_languages_translations` VALUES("771", "el", "de", "Griechisch");
INSERT INTO `wp_icl_languages_translations` VALUES("772", "el", "fr", "Grec moderne");
INSERT INTO `wp_icl_languages_translations` VALUES("773", "el", "ar", "اليونانية");
INSERT INTO `wp_icl_languages_translations` VALUES("774", "el", "bs", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("775", "el", "bg", "Гръцки");
INSERT INTO `wp_icl_languages_translations` VALUES("776", "el", "ca", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("777", "el", "cs", "Řečtina");
INSERT INTO `wp_icl_languages_translations` VALUES("778", "el", "sk", "Gréčtina");
INSERT INTO `wp_icl_languages_translations` VALUES("779", "el", "cy", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("780", "el", "da", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("781", "el", "el", "Ελληνικα");
INSERT INTO `wp_icl_languages_translations` VALUES("782", "el", "eo", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("783", "el", "et", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("784", "el", "eu", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("785", "el", "fa", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("786", "el", "fi", "kreikka");
INSERT INTO `wp_icl_languages_translations` VALUES("787", "el", "ga", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("788", "el", "he", "יוונית");
INSERT INTO `wp_icl_languages_translations` VALUES("789", "el", "hi", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("790", "el", "hr", "Grčki");
INSERT INTO `wp_icl_languages_translations` VALUES("791", "el", "hu", "görög");
INSERT INTO `wp_icl_languages_translations` VALUES("792", "el", "hy", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("793", "el", "id", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("794", "el", "is", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("795", "el", "it", "Greco");
INSERT INTO `wp_icl_languages_translations` VALUES("796", "el", "ja", "ギリシア語");
INSERT INTO `wp_icl_languages_translations` VALUES("797", "el", "ko", "그리스어");
INSERT INTO `wp_icl_languages_translations` VALUES("798", "el", "ku", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("799", "el", "lv", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("800", "el", "lt", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("801", "el", "mk", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("802", "el", "mt", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("803", "el", "mn", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("804", "el", "ne", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("805", "el", "nl", "Grieks");
INSERT INTO `wp_icl_languages_translations` VALUES("806", "el", "no", "Gresk");
INSERT INTO `wp_icl_languages_translations` VALUES("807", "el", "pa", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("808", "el", "pl", "grecki");
INSERT INTO `wp_icl_languages_translations` VALUES("809", "el", "pt-pt", "Grego");
INSERT INTO `wp_icl_languages_translations` VALUES("810", "el", "pt-br", "Grego");
INSERT INTO `wp_icl_languages_translations` VALUES("811", "el", "qu", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("812", "el", "ro", "Greacă");
INSERT INTO `wp_icl_languages_translations` VALUES("813", "el", "ru", "Греческий");
INSERT INTO `wp_icl_languages_translations` VALUES("814", "el", "sl", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("815", "el", "so", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("816", "el", "sq", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("817", "el", "sr", "грчки");
INSERT INTO `wp_icl_languages_translations` VALUES("818", "el", "sv", "Grekiska");
INSERT INTO `wp_icl_languages_translations` VALUES("819", "el", "ta", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("820", "el", "th", "กรีก");
INSERT INTO `wp_icl_languages_translations` VALUES("821", "el", "tr", "Yunanca");
INSERT INTO `wp_icl_languages_translations` VALUES("822", "el", "uk", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("823", "el", "ur", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("824", "el", "uz", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("825", "el", "vi", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("826", "el", "yi", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("827", "el", "zh-hans", "希腊语");
INSERT INTO `wp_icl_languages_translations` VALUES("828", "el", "zu", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("829", "el", "zh-hant", "希臘語");
INSERT INTO `wp_icl_languages_translations` VALUES("830", "el", "ms", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("831", "el", "gl", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("832", "el", "bn", "Greek");
INSERT INTO `wp_icl_languages_translations` VALUES("833", "eo", "en", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("834", "eo", "es", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("835", "eo", "de", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("836", "eo", "fr", "Espéranto");
INSERT INTO `wp_icl_languages_translations` VALUES("837", "eo", "ar", "الاسبرانتو");
INSERT INTO `wp_icl_languages_translations` VALUES("838", "eo", "bs", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("839", "eo", "bg", "Есперанто");
INSERT INTO `wp_icl_languages_translations` VALUES("840", "eo", "ca", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("841", "eo", "cs", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("842", "eo", "sk", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("843", "eo", "cy", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("844", "eo", "da", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("845", "eo", "el", "Εσπεραντο");
INSERT INTO `wp_icl_languages_translations` VALUES("846", "eo", "eo", "Esperanta");
INSERT INTO `wp_icl_languages_translations` VALUES("847", "eo", "et", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("848", "eo", "eu", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("849", "eo", "fa", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("850", "eo", "fi", "esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("851", "eo", "ga", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("852", "eo", "he", "אספרנטו");
INSERT INTO `wp_icl_languages_translations` VALUES("853", "eo", "hi", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("854", "eo", "hr", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("855", "eo", "hu", "eszperantó");
INSERT INTO `wp_icl_languages_translations` VALUES("856", "eo", "hy", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("857", "eo", "id", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("858", "eo", "is", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("859", "eo", "it", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("860", "eo", "ja", "エスペラント語");
INSERT INTO `wp_icl_languages_translations` VALUES("861", "eo", "ko", "에스페란토어");
INSERT INTO `wp_icl_languages_translations` VALUES("862", "eo", "ku", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("863", "eo", "lv", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("864", "eo", "lt", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("865", "eo", "mk", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("866", "eo", "mt", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("867", "eo", "mn", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("868", "eo", "ne", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("869", "eo", "nl", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("870", "eo", "no", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("871", "eo", "pa", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("872", "eo", "pl", "esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("873", "eo", "pt-pt", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("874", "eo", "pt-br", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("875", "eo", "qu", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("876", "eo", "ro", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("877", "eo", "ru", "Эсперанто");
INSERT INTO `wp_icl_languages_translations` VALUES("878", "eo", "sl", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("879", "eo", "so", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("880", "eo", "sq", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("881", "eo", "sr", "есперанто");
INSERT INTO `wp_icl_languages_translations` VALUES("882", "eo", "sv", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("883", "eo", "ta", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("884", "eo", "th", "เอสเปอรันโต");
INSERT INTO `wp_icl_languages_translations` VALUES("885", "eo", "tr", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("886", "eo", "uk", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("887", "eo", "ur", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("888", "eo", "uz", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("889", "eo", "vi", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("890", "eo", "yi", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("891", "eo", "zh-hans", "世界语");
INSERT INTO `wp_icl_languages_translations` VALUES("892", "eo", "zu", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("893", "eo", "zh-hant", "世界語");
INSERT INTO `wp_icl_languages_translations` VALUES("894", "eo", "ms", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("895", "eo", "gl", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("896", "eo", "bn", "Esperanto");
INSERT INTO `wp_icl_languages_translations` VALUES("897", "et", "en", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("898", "et", "es", "Estonio");
INSERT INTO `wp_icl_languages_translations` VALUES("899", "et", "de", "Estnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("900", "et", "fr", "Estonien");
INSERT INTO `wp_icl_languages_translations` VALUES("901", "et", "ar", "الأستونية");
INSERT INTO `wp_icl_languages_translations` VALUES("902", "et", "bs", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("903", "et", "bg", "Естонски");
INSERT INTO `wp_icl_languages_translations` VALUES("904", "et", "ca", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("905", "et", "cs", "Estonština");
INSERT INTO `wp_icl_languages_translations` VALUES("906", "et", "sk", "Estónčina");
INSERT INTO `wp_icl_languages_translations` VALUES("907", "et", "cy", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("908", "et", "da", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("909", "et", "el", "Εσθονικα");
INSERT INTO `wp_icl_languages_translations` VALUES("910", "et", "eo", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("911", "et", "et", "Eesti");
INSERT INTO `wp_icl_languages_translations` VALUES("912", "et", "eu", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("913", "et", "fa", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("914", "et", "fi", "eesti");
INSERT INTO `wp_icl_languages_translations` VALUES("915", "et", "ga", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("916", "et", "he", "אסטונית");
INSERT INTO `wp_icl_languages_translations` VALUES("917", "et", "hi", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("918", "et", "hr", "Estonski");
INSERT INTO `wp_icl_languages_translations` VALUES("919", "et", "hu", "észt");
INSERT INTO `wp_icl_languages_translations` VALUES("920", "et", "hy", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("921", "et", "id", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("922", "et", "is", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("923", "et", "it", "Estone");
INSERT INTO `wp_icl_languages_translations` VALUES("924", "et", "ja", "エストニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("925", "et", "ko", "에스토니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("926", "et", "ku", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("927", "et", "lv", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("928", "et", "lt", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("929", "et", "mk", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("930", "et", "mt", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("931", "et", "mn", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("932", "et", "ne", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("933", "et", "nl", "Ests");
INSERT INTO `wp_icl_languages_translations` VALUES("934", "et", "no", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("935", "et", "pa", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("936", "et", "pl", "estoński");
INSERT INTO `wp_icl_languages_translations` VALUES("937", "et", "pt-pt", "Estoniano");
INSERT INTO `wp_icl_languages_translations` VALUES("938", "et", "pt-br", "Estoniano");
INSERT INTO `wp_icl_languages_translations` VALUES("939", "et", "qu", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("940", "et", "ro", "Estoniană");
INSERT INTO `wp_icl_languages_translations` VALUES("941", "et", "ru", "Эстонский");
INSERT INTO `wp_icl_languages_translations` VALUES("942", "et", "sl", "Estonščina");
INSERT INTO `wp_icl_languages_translations` VALUES("943", "et", "so", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("944", "et", "sq", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("945", "et", "sr", "естонски");
INSERT INTO `wp_icl_languages_translations` VALUES("946", "et", "sv", "Estniska");
INSERT INTO `wp_icl_languages_translations` VALUES("947", "et", "ta", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("948", "et", "th", "เอสโตเนียน");
INSERT INTO `wp_icl_languages_translations` VALUES("949", "et", "tr", "Estonya dili");
INSERT INTO `wp_icl_languages_translations` VALUES("950", "et", "uk", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("951", "et", "ur", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("952", "et", "uz", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("953", "et", "vi", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("954", "et", "yi", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("955", "et", "zh-hans", "爱沙尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("956", "et", "zu", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("957", "et", "zh-hant", "愛沙尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("958", "et", "ms", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("959", "et", "gl", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("960", "et", "bn", "Estonian");
INSERT INTO `wp_icl_languages_translations` VALUES("961", "eu", "en", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("962", "eu", "es", "Euskera");
INSERT INTO `wp_icl_languages_translations` VALUES("963", "eu", "de", "Baskisch");
INSERT INTO `wp_icl_languages_translations` VALUES("964", "eu", "fr", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("965", "eu", "ar", "لغة الباسك");
INSERT INTO `wp_icl_languages_translations` VALUES("966", "eu", "bs", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("967", "eu", "bg", "Баски");
INSERT INTO `wp_icl_languages_translations` VALUES("968", "eu", "ca", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("969", "eu", "cs", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("970", "eu", "sk", "Baskičtina");
INSERT INTO `wp_icl_languages_translations` VALUES("971", "eu", "cy", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("972", "eu", "da", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("973", "eu", "el", "Βασκικα");
INSERT INTO `wp_icl_languages_translations` VALUES("974", "eu", "eo", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("975", "eu", "et", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("976", "eu", "eu", "Euskara");
INSERT INTO `wp_icl_languages_translations` VALUES("977", "eu", "fa", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("978", "eu", "fi", "baski");
INSERT INTO `wp_icl_languages_translations` VALUES("979", "eu", "ga", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("980", "eu", "he", "בסקית");
INSERT INTO `wp_icl_languages_translations` VALUES("981", "eu", "hi", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("982", "eu", "hr", "Baskijski");
INSERT INTO `wp_icl_languages_translations` VALUES("983", "eu", "hu", "baszk");
INSERT INTO `wp_icl_languages_translations` VALUES("984", "eu", "hy", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("985", "eu", "id", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("986", "eu", "is", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("987", "eu", "it", "Basco");
INSERT INTO `wp_icl_languages_translations` VALUES("988", "eu", "ja", "バスク語");
INSERT INTO `wp_icl_languages_translations` VALUES("989", "eu", "ko", "바스크어");
INSERT INTO `wp_icl_languages_translations` VALUES("990", "eu", "ku", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("991", "eu", "lv", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("992", "eu", "lt", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("993", "eu", "mk", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("994", "eu", "mt", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("995", "eu", "mn", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("996", "eu", "ne", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("997", "eu", "nl", "Baskisch");
INSERT INTO `wp_icl_languages_translations` VALUES("998", "eu", "no", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("999", "eu", "pa", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1000", "eu", "pl", "baskijski");
INSERT INTO `wp_icl_languages_translations` VALUES("1001", "eu", "pt-pt", "Basco");
INSERT INTO `wp_icl_languages_translations` VALUES("1002", "eu", "pt-br", "Basco");
INSERT INTO `wp_icl_languages_translations` VALUES("1003", "eu", "qu", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1004", "eu", "ro", "Bască");
INSERT INTO `wp_icl_languages_translations` VALUES("1005", "eu", "ru", "Баскский");
INSERT INTO `wp_icl_languages_translations` VALUES("1006", "eu", "sl", "Baskovščina");
INSERT INTO `wp_icl_languages_translations` VALUES("1007", "eu", "so", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1008", "eu", "sq", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1009", "eu", "sr", "баскијски");
INSERT INTO `wp_icl_languages_translations` VALUES("1010", "eu", "sv", "Baskiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1011", "eu", "ta", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1012", "eu", "th", "บาสค์");
INSERT INTO `wp_icl_languages_translations` VALUES("1013", "eu", "tr", "Bask dili");
INSERT INTO `wp_icl_languages_translations` VALUES("1014", "eu", "uk", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1015", "eu", "ur", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1016", "eu", "uz", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1017", "eu", "vi", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1018", "eu", "yi", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1019", "eu", "zh-hans", "巴斯克语");
INSERT INTO `wp_icl_languages_translations` VALUES("1020", "eu", "zu", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1021", "eu", "zh-hant", "巴斯克語");
INSERT INTO `wp_icl_languages_translations` VALUES("1022", "eu", "ms", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1023", "eu", "gl", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1024", "eu", "bn", "Basque");
INSERT INTO `wp_icl_languages_translations` VALUES("1025", "fa", "en", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1026", "fa", "es", "Persa");
INSERT INTO `wp_icl_languages_translations` VALUES("1027", "fa", "de", "Persisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1028", "fa", "fr", "Perse");
INSERT INTO `wp_icl_languages_translations` VALUES("1029", "fa", "ar", "الفارسية");
INSERT INTO `wp_icl_languages_translations` VALUES("1030", "fa", "bs", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1031", "fa", "bg", "Персийски");
INSERT INTO `wp_icl_languages_translations` VALUES("1032", "fa", "ca", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1033", "fa", "cs", "Perský");
INSERT INTO `wp_icl_languages_translations` VALUES("1034", "fa", "sk", "Perzština");
INSERT INTO `wp_icl_languages_translations` VALUES("1035", "fa", "cy", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1036", "fa", "da", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1037", "fa", "el", "Περσικος");
INSERT INTO `wp_icl_languages_translations` VALUES("1038", "fa", "eo", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1039", "fa", "et", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1040", "fa", "eu", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1041", "fa", "fa", "فارسی");
INSERT INTO `wp_icl_languages_translations` VALUES("1042", "fa", "fi", "persia");
INSERT INTO `wp_icl_languages_translations` VALUES("1043", "fa", "ga", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1044", "fa", "he", "פרסית");
INSERT INTO `wp_icl_languages_translations` VALUES("1045", "fa", "hi", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1046", "fa", "hr", "Perzijski");
INSERT INTO `wp_icl_languages_translations` VALUES("1047", "fa", "hu", "perzsa");
INSERT INTO `wp_icl_languages_translations` VALUES("1048", "fa", "hy", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1049", "fa", "id", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1050", "fa", "is", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1051", "fa", "it", "Persiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1052", "fa", "ja", "ペルシア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1053", "fa", "ko", "페르시아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1054", "fa", "ku", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1055", "fa", "lv", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1056", "fa", "lt", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1057", "fa", "mk", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1058", "fa", "mt", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1059", "fa", "mn", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1060", "fa", "ne", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1061", "fa", "nl", "Perzisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1062", "fa", "no", "Persisk");
INSERT INTO `wp_icl_languages_translations` VALUES("1063", "fa", "pa", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1064", "fa", "pl", "perski");
INSERT INTO `wp_icl_languages_translations` VALUES("1065", "fa", "pt-pt", "Persa");
INSERT INTO `wp_icl_languages_translations` VALUES("1066", "fa", "pt-br", "Persa");
INSERT INTO `wp_icl_languages_translations` VALUES("1067", "fa", "qu", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1068", "fa", "ro", "Persană");
INSERT INTO `wp_icl_languages_translations` VALUES("1069", "fa", "ru", "Персидский");
INSERT INTO `wp_icl_languages_translations` VALUES("1070", "fa", "sl", "Perzijski");
INSERT INTO `wp_icl_languages_translations` VALUES("1071", "fa", "so", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1072", "fa", "sq", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1073", "fa", "sr", "персијски");
INSERT INTO `wp_icl_languages_translations` VALUES("1074", "fa", "sv", "Persiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1075", "fa", "ta", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1076", "fa", "th", "เปอร์เซียน");
INSERT INTO `wp_icl_languages_translations` VALUES("1077", "fa", "tr", "Farsça");
INSERT INTO `wp_icl_languages_translations` VALUES("1078", "fa", "uk", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1079", "fa", "ur", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1080", "fa", "uz", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1081", "fa", "vi", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1082", "fa", "yi", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1083", "fa", "zh-hans", "波斯语");
INSERT INTO `wp_icl_languages_translations` VALUES("1084", "fa", "zu", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1085", "fa", "zh-hant", "波斯語");
INSERT INTO `wp_icl_languages_translations` VALUES("1086", "fa", "ms", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1087", "fa", "gl", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1088", "fa", "bn", "Persian");
INSERT INTO `wp_icl_languages_translations` VALUES("1089", "fi", "en", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1090", "fi", "es", "Finlandés");
INSERT INTO `wp_icl_languages_translations` VALUES("1091", "fi", "de", "Finnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1092", "fi", "fr", "Finnois");
INSERT INTO `wp_icl_languages_translations` VALUES("1093", "fi", "ar", "الفنلندية");
INSERT INTO `wp_icl_languages_translations` VALUES("1094", "fi", "bs", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1095", "fi", "bg", "Фински");
INSERT INTO `wp_icl_languages_translations` VALUES("1096", "fi", "ca", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1097", "fi", "cs", "Finský");
INSERT INTO `wp_icl_languages_translations` VALUES("1098", "fi", "sk", "Fínština");
INSERT INTO `wp_icl_languages_translations` VALUES("1099", "fi", "cy", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1100", "fi", "da", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1101", "fi", "el", "Φινλανδικη");
INSERT INTO `wp_icl_languages_translations` VALUES("1102", "fi", "eo", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1103", "fi", "et", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1104", "fi", "eu", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1105", "fi", "fa", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1106", "fi", "fi", "Suomi");
INSERT INTO `wp_icl_languages_translations` VALUES("1107", "fi", "ga", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1108", "fi", "he", "פינית");
INSERT INTO `wp_icl_languages_translations` VALUES("1109", "fi", "hi", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1110", "fi", "hr", "Finski");
INSERT INTO `wp_icl_languages_translations` VALUES("1111", "fi", "hu", "finn");
INSERT INTO `wp_icl_languages_translations` VALUES("1112", "fi", "hy", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1113", "fi", "id", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1114", "fi", "is", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1115", "fi", "it", "Finlandese");
INSERT INTO `wp_icl_languages_translations` VALUES("1116", "fi", "ja", "フィンランド語");
INSERT INTO `wp_icl_languages_translations` VALUES("1117", "fi", "ko", "핀란드어");
INSERT INTO `wp_icl_languages_translations` VALUES("1118", "fi", "ku", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1119", "fi", "lv", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1120", "fi", "lt", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1121", "fi", "mk", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1122", "fi", "mt", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1123", "fi", "mn", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1124", "fi", "ne", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1125", "fi", "nl", "Fins");
INSERT INTO `wp_icl_languages_translations` VALUES("1126", "fi", "no", "Finsk");
INSERT INTO `wp_icl_languages_translations` VALUES("1127", "fi", "pa", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1128", "fi", "pl", "fiński");
INSERT INTO `wp_icl_languages_translations` VALUES("1129", "fi", "pt-pt", "Finlandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1130", "fi", "pt-br", "Finlandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1131", "fi", "qu", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1132", "fi", "ro", "Finlandeză");
INSERT INTO `wp_icl_languages_translations` VALUES("1133", "fi", "ru", "Финский");
INSERT INTO `wp_icl_languages_translations` VALUES("1134", "fi", "sl", "Finski");
INSERT INTO `wp_icl_languages_translations` VALUES("1135", "fi", "so", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1136", "fi", "sq", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1137", "fi", "sr", "фински");
INSERT INTO `wp_icl_languages_translations` VALUES("1138", "fi", "sv", "Finska");
INSERT INTO `wp_icl_languages_translations` VALUES("1139", "fi", "ta", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1140", "fi", "th", "ฟินนิช");
INSERT INTO `wp_icl_languages_translations` VALUES("1141", "fi", "tr", "Fince");
INSERT INTO `wp_icl_languages_translations` VALUES("1142", "fi", "uk", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1143", "fi", "ur", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1144", "fi", "uz", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1145", "fi", "vi", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1146", "fi", "yi", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1147", "fi", "zh-hans", "芬兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("1148", "fi", "zu", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1149", "fi", "zh-hant", "芬蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("1150", "fi", "ms", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1151", "fi", "gl", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1152", "fi", "bn", "Finnish");
INSERT INTO `wp_icl_languages_translations` VALUES("1153", "ga", "en", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1154", "ga", "es", "Irlandés");
INSERT INTO `wp_icl_languages_translations` VALUES("1155", "ga", "de", "Irisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1156", "ga", "fr", "Irlandais");
INSERT INTO `wp_icl_languages_translations` VALUES("1157", "ga", "ar", "الأيرلندية");
INSERT INTO `wp_icl_languages_translations` VALUES("1158", "ga", "bs", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1159", "ga", "bg", "Ирландски");
INSERT INTO `wp_icl_languages_translations` VALUES("1160", "ga", "ca", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1161", "ga", "cs", "Irský");
INSERT INTO `wp_icl_languages_translations` VALUES("1162", "ga", "sk", "Írština");
INSERT INTO `wp_icl_languages_translations` VALUES("1163", "ga", "cy", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1164", "ga", "da", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1165", "ga", "el", "Ιρλανδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1166", "ga", "eo", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1167", "ga", "et", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1168", "ga", "eu", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1169", "ga", "fa", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1170", "ga", "fi", "iiri");
INSERT INTO `wp_icl_languages_translations` VALUES("1171", "ga", "ga", "Gaeilge");
INSERT INTO `wp_icl_languages_translations` VALUES("1172", "ga", "he", "אירית");
INSERT INTO `wp_icl_languages_translations` VALUES("1173", "ga", "hi", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1174", "ga", "hr", "Irci");
INSERT INTO `wp_icl_languages_translations` VALUES("1175", "ga", "hu", "ír");
INSERT INTO `wp_icl_languages_translations` VALUES("1176", "ga", "hy", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1177", "ga", "id", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1178", "ga", "is", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1179", "ga", "it", "Irlandese");
INSERT INTO `wp_icl_languages_translations` VALUES("1180", "ga", "ja", "アイルランド語");
INSERT INTO `wp_icl_languages_translations` VALUES("1181", "ga", "ko", "아일랜드어");
INSERT INTO `wp_icl_languages_translations` VALUES("1182", "ga", "ku", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1183", "ga", "lv", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1184", "ga", "lt", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1185", "ga", "mk", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1186", "ga", "mt", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1187", "ga", "mn", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1188", "ga", "ne", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1189", "ga", "nl", "Iers");
INSERT INTO `wp_icl_languages_translations` VALUES("1190", "ga", "no", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1191", "ga", "pa", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1192", "ga", "pl", "irlandzki");
INSERT INTO `wp_icl_languages_translations` VALUES("1193", "ga", "pt-pt", "Irlandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1194", "ga", "pt-br", "Irlandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1195", "ga", "qu", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1196", "ga", "ro", "Irlandeză");
INSERT INTO `wp_icl_languages_translations` VALUES("1197", "ga", "ru", "Ирландский");
INSERT INTO `wp_icl_languages_translations` VALUES("1198", "ga", "sl", "Irski");
INSERT INTO `wp_icl_languages_translations` VALUES("1199", "ga", "so", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1200", "ga", "sq", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1201", "ga", "sr", "ирски");
INSERT INTO `wp_icl_languages_translations` VALUES("1202", "ga", "sv", "Irländska");
INSERT INTO `wp_icl_languages_translations` VALUES("1203", "ga", "ta", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1204", "ga", "th", "ไอริช");
INSERT INTO `wp_icl_languages_translations` VALUES("1205", "ga", "tr", "İrlanda dili");
INSERT INTO `wp_icl_languages_translations` VALUES("1206", "ga", "uk", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1207", "ga", "ur", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1208", "ga", "uz", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1209", "ga", "vi", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1210", "ga", "yi", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1211", "ga", "zh-hans", "爱尔兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("1212", "ga", "zu", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1213", "ga", "zh-hant", "愛爾蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("1214", "ga", "ms", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1215", "ga", "gl", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1216", "ga", "bn", "Irish");
INSERT INTO `wp_icl_languages_translations` VALUES("1217", "he", "en", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1218", "he", "es", "Hebreo");
INSERT INTO `wp_icl_languages_translations` VALUES("1219", "he", "de", "Hebräisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1220", "he", "fr", "Hébreu");
INSERT INTO `wp_icl_languages_translations` VALUES("1221", "he", "ar", "العبرية");
INSERT INTO `wp_icl_languages_translations` VALUES("1222", "he", "bs", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1223", "he", "bg", "Иврит");
INSERT INTO `wp_icl_languages_translations` VALUES("1224", "he", "ca", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1225", "he", "cs", "Hebrejština");
INSERT INTO `wp_icl_languages_translations` VALUES("1226", "he", "sk", "Hebrejčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1227", "he", "cy", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1228", "he", "da", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1229", "he", "el", "Εβραικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1230", "he", "eo", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1231", "he", "et", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1232", "he", "eu", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1233", "he", "fa", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1234", "he", "fi", "heprea");
INSERT INTO `wp_icl_languages_translations` VALUES("1235", "he", "ga", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1236", "he", "he", "עברית");
INSERT INTO `wp_icl_languages_translations` VALUES("1237", "he", "hi", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1238", "he", "hr", "Hebrejski");
INSERT INTO `wp_icl_languages_translations` VALUES("1239", "he", "hu", "héber");
INSERT INTO `wp_icl_languages_translations` VALUES("1240", "he", "hy", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1241", "he", "id", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1242", "he", "is", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1243", "he", "it", "Ebraico");
INSERT INTO `wp_icl_languages_translations` VALUES("1244", "he", "ja", "ヘブライ語");
INSERT INTO `wp_icl_languages_translations` VALUES("1245", "he", "ko", "히브리어");
INSERT INTO `wp_icl_languages_translations` VALUES("1246", "he", "ku", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1247", "he", "lv", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1248", "he", "lt", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1249", "he", "mk", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1250", "he", "mt", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1251", "he", "mn", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1252", "he", "ne", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1253", "he", "nl", "Hebreeuws");
INSERT INTO `wp_icl_languages_translations` VALUES("1254", "he", "no", "Hebraisk");
INSERT INTO `wp_icl_languages_translations` VALUES("1255", "he", "pa", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1256", "he", "pl", "hebrajski");
INSERT INTO `wp_icl_languages_translations` VALUES("1257", "he", "pt-pt", "Hebraico");
INSERT INTO `wp_icl_languages_translations` VALUES("1258", "he", "pt-br", "Hebraico");
INSERT INTO `wp_icl_languages_translations` VALUES("1259", "he", "qu", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1260", "he", "ro", "Ebraică");
INSERT INTO `wp_icl_languages_translations` VALUES("1261", "he", "ru", "Иврит");
INSERT INTO `wp_icl_languages_translations` VALUES("1262", "he", "sl", "Hebrejščina");
INSERT INTO `wp_icl_languages_translations` VALUES("1263", "he", "so", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1264", "he", "sq", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1265", "he", "sr", "Хебрејски");
INSERT INTO `wp_icl_languages_translations` VALUES("1266", "he", "sv", "Hebreiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1267", "he", "ta", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1268", "he", "th", "ฮิบรู");
INSERT INTO `wp_icl_languages_translations` VALUES("1269", "he", "tr", "İbranice");
INSERT INTO `wp_icl_languages_translations` VALUES("1270", "he", "uk", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1271", "he", "ur", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1272", "he", "uz", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1273", "he", "vi", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1274", "he", "yi", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1275", "he", "zh-hans", "希伯来语");
INSERT INTO `wp_icl_languages_translations` VALUES("1276", "he", "zu", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1277", "he", "zh-hant", "希伯來語");
INSERT INTO `wp_icl_languages_translations` VALUES("1278", "he", "ms", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1279", "he", "gl", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1280", "he", "bn", "Hebrew");
INSERT INTO `wp_icl_languages_translations` VALUES("1281", "hi", "en", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1282", "hi", "es", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1283", "hi", "de", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1284", "hi", "fr", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1285", "hi", "ar", "الهندية");
INSERT INTO `wp_icl_languages_translations` VALUES("1286", "hi", "bs", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1287", "hi", "bg", "Хинди");
INSERT INTO `wp_icl_languages_translations` VALUES("1288", "hi", "ca", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1289", "hi", "cs", "Hindština");
INSERT INTO `wp_icl_languages_translations` VALUES("1290", "hi", "sk", "Hindčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1291", "hi", "cy", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1292", "hi", "da", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1293", "hi", "el", "Ινδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1294", "hi", "eo", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1295", "hi", "et", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1296", "hi", "eu", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1297", "hi", "fa", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1298", "hi", "fi", "hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1299", "hi", "ga", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1300", "hi", "he", "הודית");
INSERT INTO `wp_icl_languages_translations` VALUES("1301", "hi", "hi", "हिन्दी");
INSERT INTO `wp_icl_languages_translations` VALUES("1302", "hi", "hr", "Hindski");
INSERT INTO `wp_icl_languages_translations` VALUES("1303", "hi", "hu", "hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1304", "hi", "hy", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1305", "hi", "id", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1306", "hi", "is", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1307", "hi", "it", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1308", "hi", "ja", "ヒンディー語");
INSERT INTO `wp_icl_languages_translations` VALUES("1309", "hi", "ko", "힌두어");
INSERT INTO `wp_icl_languages_translations` VALUES("1310", "hi", "ku", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1311", "hi", "lv", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1312", "hi", "lt", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1313", "hi", "mk", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1314", "hi", "mt", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1315", "hi", "mn", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1316", "hi", "ne", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1317", "hi", "nl", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1318", "hi", "no", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1319", "hi", "pa", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1320", "hi", "pl", "hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1321", "hi", "pt-pt", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1322", "hi", "pt-br", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1323", "hi", "qu", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1324", "hi", "ro", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1325", "hi", "ru", "Хинди");
INSERT INTO `wp_icl_languages_translations` VALUES("1326", "hi", "sl", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1327", "hi", "so", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1328", "hi", "sq", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1329", "hi", "sr", "хинди");
INSERT INTO `wp_icl_languages_translations` VALUES("1330", "hi", "sv", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1331", "hi", "ta", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1332", "hi", "th", "ฮินดิ");
INSERT INTO `wp_icl_languages_translations` VALUES("1333", "hi", "tr", "Hintçe");
INSERT INTO `wp_icl_languages_translations` VALUES("1334", "hi", "uk", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1335", "hi", "ur", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1336", "hi", "uz", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1337", "hi", "vi", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1338", "hi", "yi", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1339", "hi", "zh-hans", "印地语");
INSERT INTO `wp_icl_languages_translations` VALUES("1340", "hi", "zu", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1341", "hi", "zh-hant", "印地語");
INSERT INTO `wp_icl_languages_translations` VALUES("1342", "hi", "ms", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1343", "hi", "gl", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1344", "hi", "bn", "Hindi");
INSERT INTO `wp_icl_languages_translations` VALUES("1345", "hr", "en", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1346", "hr", "es", "Croata");
INSERT INTO `wp_icl_languages_translations` VALUES("1347", "hr", "de", "Kroatisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1348", "hr", "fr", "Croate");
INSERT INTO `wp_icl_languages_translations` VALUES("1349", "hr", "ar", "الكرواتية");
INSERT INTO `wp_icl_languages_translations` VALUES("1350", "hr", "bs", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1351", "hr", "bg", "Хърватски");
INSERT INTO `wp_icl_languages_translations` VALUES("1352", "hr", "ca", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1353", "hr", "cs", "Chorvatský");
INSERT INTO `wp_icl_languages_translations` VALUES("1354", "hr", "sk", "Chorvátština");
INSERT INTO `wp_icl_languages_translations` VALUES("1355", "hr", "cy", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1356", "hr", "da", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1357", "hr", "el", "Κροατικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1358", "hr", "eo", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1359", "hr", "et", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1360", "hr", "eu", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1361", "hr", "fa", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1362", "hr", "fi", "kroatia");
INSERT INTO `wp_icl_languages_translations` VALUES("1363", "hr", "ga", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1364", "hr", "he", "קרוטאית");
INSERT INTO `wp_icl_languages_translations` VALUES("1365", "hr", "hi", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1366", "hr", "hr", "Hrvatski");
INSERT INTO `wp_icl_languages_translations` VALUES("1367", "hr", "hu", "horvát");
INSERT INTO `wp_icl_languages_translations` VALUES("1368", "hr", "hy", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1369", "hr", "id", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1370", "hr", "is", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1371", "hr", "it", "Croato");
INSERT INTO `wp_icl_languages_translations` VALUES("1372", "hr", "ja", "クロアチア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1373", "hr", "ko", "크로아시아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1374", "hr", "ku", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1375", "hr", "lv", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1376", "hr", "lt", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1377", "hr", "mk", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1378", "hr", "mt", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1379", "hr", "mn", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1380", "hr", "ne", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1381", "hr", "nl", "Kroatisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1382", "hr", "no", "Kroatisk");
INSERT INTO `wp_icl_languages_translations` VALUES("1383", "hr", "pa", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1384", "hr", "pl", "chorwacki");
INSERT INTO `wp_icl_languages_translations` VALUES("1385", "hr", "pt-pt", "Croata");
INSERT INTO `wp_icl_languages_translations` VALUES("1386", "hr", "pt-br", "Croata");
INSERT INTO `wp_icl_languages_translations` VALUES("1387", "hr", "qu", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1388", "hr", "ro", "Croată");
INSERT INTO `wp_icl_languages_translations` VALUES("1389", "hr", "ru", "Хорватский");
INSERT INTO `wp_icl_languages_translations` VALUES("1390", "hr", "sl", "Hrvaški");
INSERT INTO `wp_icl_languages_translations` VALUES("1391", "hr", "so", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1392", "hr", "sq", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1393", "hr", "sr", "хрватски");
INSERT INTO `wp_icl_languages_translations` VALUES("1394", "hr", "sv", "Kroatiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1395", "hr", "ta", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1396", "hr", "th", "โครเอเชีย");
INSERT INTO `wp_icl_languages_translations` VALUES("1397", "hr", "tr", "Hırvatça");
INSERT INTO `wp_icl_languages_translations` VALUES("1398", "hr", "uk", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1399", "hr", "ur", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1400", "hr", "uz", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1401", "hr", "vi", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1402", "hr", "yi", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1403", "hr", "zh-hans", "克罗地亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("1404", "hr", "zu", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1405", "hr", "zh-hant", "克羅地亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("1406", "hr", "ms", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1407", "hr", "gl", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1408", "hr", "bn", "Croatian");
INSERT INTO `wp_icl_languages_translations` VALUES("1409", "hu", "en", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1410", "hu", "es", "Húngaro");
INSERT INTO `wp_icl_languages_translations` VALUES("1411", "hu", "de", "Ungarisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1412", "hu", "fr", "Hongrois");
INSERT INTO `wp_icl_languages_translations` VALUES("1413", "hu", "ar", "الهنغارية");
INSERT INTO `wp_icl_languages_translations` VALUES("1414", "hu", "bs", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1415", "hu", "bg", "Унгарски");
INSERT INTO `wp_icl_languages_translations` VALUES("1416", "hu", "ca", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1417", "hu", "cs", "Maďarština");
INSERT INTO `wp_icl_languages_translations` VALUES("1418", "hu", "sk", "Maďarčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1419", "hu", "cy", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1420", "hu", "da", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1421", "hu", "el", "Ουγγρικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1422", "hu", "eo", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1423", "hu", "et", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1424", "hu", "eu", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1425", "hu", "fa", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1426", "hu", "fi", "unkari");
INSERT INTO `wp_icl_languages_translations` VALUES("1427", "hu", "ga", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1428", "hu", "he", "הונגרית");
INSERT INTO `wp_icl_languages_translations` VALUES("1429", "hu", "hi", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1430", "hu", "hr", "Mađarski");
INSERT INTO `wp_icl_languages_translations` VALUES("1431", "hu", "hu", "Magyar");
INSERT INTO `wp_icl_languages_translations` VALUES("1432", "hu", "hy", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1433", "hu", "id", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1434", "hu", "is", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1435", "hu", "it", "Ungherese");
INSERT INTO `wp_icl_languages_translations` VALUES("1436", "hu", "ja", "ハンガリー語");
INSERT INTO `wp_icl_languages_translations` VALUES("1437", "hu", "ko", "헝가리어");
INSERT INTO `wp_icl_languages_translations` VALUES("1438", "hu", "ku", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1439", "hu", "lv", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1440", "hu", "lt", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1441", "hu", "mk", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1442", "hu", "mt", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1443", "hu", "mn", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1444", "hu", "ne", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1445", "hu", "nl", "Hongaars");
INSERT INTO `wp_icl_languages_translations` VALUES("1446", "hu", "no", "Ungarsk");
INSERT INTO `wp_icl_languages_translations` VALUES("1447", "hu", "pa", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1448", "hu", "pl", "węgierski");
INSERT INTO `wp_icl_languages_translations` VALUES("1449", "hu", "pt-pt", "Húngaro");
INSERT INTO `wp_icl_languages_translations` VALUES("1450", "hu", "pt-br", "Húngaro");
INSERT INTO `wp_icl_languages_translations` VALUES("1451", "hu", "qu", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1452", "hu", "ro", "Ungară");
INSERT INTO `wp_icl_languages_translations` VALUES("1453", "hu", "ru", "Венгерский");
INSERT INTO `wp_icl_languages_translations` VALUES("1454", "hu", "sl", "Madžarski");
INSERT INTO `wp_icl_languages_translations` VALUES("1455", "hu", "so", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1456", "hu", "sq", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1457", "hu", "sr", "мађарски");
INSERT INTO `wp_icl_languages_translations` VALUES("1458", "hu", "sv", "Ungerska");
INSERT INTO `wp_icl_languages_translations` VALUES("1459", "hu", "ta", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1460", "hu", "th", "ฮังการี");
INSERT INTO `wp_icl_languages_translations` VALUES("1461", "hu", "tr", "Macarca");
INSERT INTO `wp_icl_languages_translations` VALUES("1462", "hu", "uk", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1463", "hu", "ur", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1464", "hu", "uz", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1465", "hu", "vi", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1466", "hu", "yi", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1467", "hu", "zh-hans", "匈牙利语");
INSERT INTO `wp_icl_languages_translations` VALUES("1468", "hu", "zu", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1469", "hu", "zh-hant", "匈牙利語");
INSERT INTO `wp_icl_languages_translations` VALUES("1470", "hu", "ms", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1471", "hu", "gl", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1472", "hu", "bn", "Hungarian");
INSERT INTO `wp_icl_languages_translations` VALUES("1473", "hy", "en", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1474", "hy", "es", "Armenio");
INSERT INTO `wp_icl_languages_translations` VALUES("1475", "hy", "de", "Armenisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1476", "hy", "fr", "Arménien");
INSERT INTO `wp_icl_languages_translations` VALUES("1477", "hy", "ar", "الأرمينية");
INSERT INTO `wp_icl_languages_translations` VALUES("1478", "hy", "bs", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1479", "hy", "bg", "Арменски");
INSERT INTO `wp_icl_languages_translations` VALUES("1480", "hy", "ca", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1481", "hy", "cs", "Arménský");
INSERT INTO `wp_icl_languages_translations` VALUES("1482", "hy", "sk", "Arménčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1483", "hy", "cy", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1484", "hy", "da", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1485", "hy", "el", "Αρμενικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1486", "hy", "eo", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1487", "hy", "et", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1488", "hy", "eu", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1489", "hy", "fa", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1490", "hy", "fi", "armenia");
INSERT INTO `wp_icl_languages_translations` VALUES("1491", "hy", "ga", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1492", "hy", "he", "ארמנית");
INSERT INTO `wp_icl_languages_translations` VALUES("1493", "hy", "hi", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1494", "hy", "hr", "Armenac");
INSERT INTO `wp_icl_languages_translations` VALUES("1495", "hy", "hu", "örmény");
INSERT INTO `wp_icl_languages_translations` VALUES("1496", "hy", "hy", "Հայերեն");
INSERT INTO `wp_icl_languages_translations` VALUES("1497", "hy", "id", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1498", "hy", "is", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1499", "hy", "it", "Armeno");
INSERT INTO `wp_icl_languages_translations` VALUES("1500", "hy", "ja", "アルメニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1501", "hy", "ko", "아르메니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1502", "hy", "ku", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1503", "hy", "lv", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1504", "hy", "lt", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1505", "hy", "mk", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1506", "hy", "mt", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1507", "hy", "mn", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1508", "hy", "ne", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1509", "hy", "nl", "Armeens");
INSERT INTO `wp_icl_languages_translations` VALUES("1510", "hy", "no", "Armensk");
INSERT INTO `wp_icl_languages_translations` VALUES("1511", "hy", "pa", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1512", "hy", "pl", "ormiański");
INSERT INTO `wp_icl_languages_translations` VALUES("1513", "hy", "pt-pt", "Arménio");
INSERT INTO `wp_icl_languages_translations` VALUES("1514", "hy", "pt-br", "Arménio");
INSERT INTO `wp_icl_languages_translations` VALUES("1515", "hy", "qu", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1516", "hy", "ro", "Armeană");
INSERT INTO `wp_icl_languages_translations` VALUES("1517", "hy", "ru", "Армянский");
INSERT INTO `wp_icl_languages_translations` VALUES("1518", "hy", "sl", "Armenski");
INSERT INTO `wp_icl_languages_translations` VALUES("1519", "hy", "so", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1520", "hy", "sq", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1521", "hy", "sr", "јерменски");
INSERT INTO `wp_icl_languages_translations` VALUES("1522", "hy", "sv", "Armeniska");
INSERT INTO `wp_icl_languages_translations` VALUES("1523", "hy", "ta", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1524", "hy", "th", "อาร์เมเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("1525", "hy", "tr", "Ermenice");
INSERT INTO `wp_icl_languages_translations` VALUES("1526", "hy", "uk", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1527", "hy", "ur", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1528", "hy", "uz", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1529", "hy", "vi", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1530", "hy", "yi", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1531", "hy", "zh-hans", "亚美尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("1532", "hy", "zu", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1533", "hy", "zh-hant", "亞美尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("1534", "hy", "ms", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1535", "hy", "gl", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1536", "hy", "bn", "Armenian");
INSERT INTO `wp_icl_languages_translations` VALUES("1537", "id", "en", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1538", "id", "es", "Indonesio");
INSERT INTO `wp_icl_languages_translations` VALUES("1539", "id", "de", "Indonesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1540", "id", "fr", "Indonésien");
INSERT INTO `wp_icl_languages_translations` VALUES("1541", "id", "ar", "الأندونيسية");
INSERT INTO `wp_icl_languages_translations` VALUES("1542", "id", "bs", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1543", "id", "bg", "Индонезийски");
INSERT INTO `wp_icl_languages_translations` VALUES("1544", "id", "ca", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1545", "id", "cs", "Indonéský");
INSERT INTO `wp_icl_languages_translations` VALUES("1546", "id", "sk", "Indonézčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1547", "id", "cy", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1548", "id", "da", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1549", "id", "el", "Ινδονησιακα");
INSERT INTO `wp_icl_languages_translations` VALUES("1550", "id", "eo", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1551", "id", "et", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1552", "id", "eu", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1553", "id", "fa", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1554", "id", "fi", "indonesia");
INSERT INTO `wp_icl_languages_translations` VALUES("1555", "id", "ga", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1556", "id", "he", "אינדונזית");
INSERT INTO `wp_icl_languages_translations` VALUES("1557", "id", "hi", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1558", "id", "hr", "Indonezijski");
INSERT INTO `wp_icl_languages_translations` VALUES("1559", "id", "hu", "indonéz");
INSERT INTO `wp_icl_languages_translations` VALUES("1560", "id", "hy", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1561", "id", "id", "Indonesia");
INSERT INTO `wp_icl_languages_translations` VALUES("1562", "id", "is", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1563", "id", "it", "Indonesiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1564", "id", "ja", "インドネシア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1565", "id", "ko", "인도네시아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1566", "id", "ku", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1567", "id", "lv", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1568", "id", "lt", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1569", "id", "mk", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1570", "id", "mt", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1571", "id", "mn", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1572", "id", "ne", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1573", "id", "nl", "Indonesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1574", "id", "no", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1575", "id", "pa", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1576", "id", "pl", "indonezyjski");
INSERT INTO `wp_icl_languages_translations` VALUES("1577", "id", "pt-pt", "Indonésio");
INSERT INTO `wp_icl_languages_translations` VALUES("1578", "id", "pt-br", "Indonésio");
INSERT INTO `wp_icl_languages_translations` VALUES("1579", "id", "qu", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1580", "id", "ro", "Indoneziană");
INSERT INTO `wp_icl_languages_translations` VALUES("1581", "id", "ru", "Индонезийский");
INSERT INTO `wp_icl_languages_translations` VALUES("1582", "id", "sl", "Indonezijski");
INSERT INTO `wp_icl_languages_translations` VALUES("1583", "id", "so", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1584", "id", "sq", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1585", "id", "sr", "индонезијски");
INSERT INTO `wp_icl_languages_translations` VALUES("1586", "id", "sv", "Indonesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1587", "id", "ta", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1588", "id", "th", "อินโดนีเซีย");
INSERT INTO `wp_icl_languages_translations` VALUES("1589", "id", "tr", "Endonezya dili");
INSERT INTO `wp_icl_languages_translations` VALUES("1590", "id", "uk", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1591", "id", "ur", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1592", "id", "uz", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1593", "id", "vi", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1594", "id", "yi", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1595", "id", "zh-hans", "印度尼西亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("1596", "id", "zu", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1597", "id", "zh-hant", "印尼語");
INSERT INTO `wp_icl_languages_translations` VALUES("1598", "id", "ms", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1599", "id", "gl", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1600", "id", "bn", "Indonesian");
INSERT INTO `wp_icl_languages_translations` VALUES("1601", "is", "en", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1602", "is", "es", "Islandés");
INSERT INTO `wp_icl_languages_translations` VALUES("1603", "is", "de", "Isländisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1604", "is", "fr", "Islandais");
INSERT INTO `wp_icl_languages_translations` VALUES("1605", "is", "ar", "الأيسلاندية");
INSERT INTO `wp_icl_languages_translations` VALUES("1606", "is", "bs", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1607", "is", "bg", "Исландски");
INSERT INTO `wp_icl_languages_translations` VALUES("1608", "is", "ca", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1609", "is", "cs", "Islandský");
INSERT INTO `wp_icl_languages_translations` VALUES("1610", "is", "sk", "Islančina");
INSERT INTO `wp_icl_languages_translations` VALUES("1611", "is", "cy", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1612", "is", "da", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1613", "is", "el", "Ισλανδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1614", "is", "eo", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1615", "is", "et", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1616", "is", "eu", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1617", "is", "fa", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1618", "is", "fi", "islanti");
INSERT INTO `wp_icl_languages_translations` VALUES("1619", "is", "ga", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1620", "is", "he", "איסלנדית");
INSERT INTO `wp_icl_languages_translations` VALUES("1621", "is", "hi", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1622", "is", "hr", "Islandski");
INSERT INTO `wp_icl_languages_translations` VALUES("1623", "is", "hu", "izlandi");
INSERT INTO `wp_icl_languages_translations` VALUES("1624", "is", "hy", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1625", "is", "id", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1626", "is", "is", "Íslenska");
INSERT INTO `wp_icl_languages_translations` VALUES("1627", "is", "it", "Islandese");
INSERT INTO `wp_icl_languages_translations` VALUES("1628", "is", "ja", "アイスランド語");
INSERT INTO `wp_icl_languages_translations` VALUES("1629", "is", "ko", "아이슬랜드어");
INSERT INTO `wp_icl_languages_translations` VALUES("1630", "is", "ku", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1631", "is", "lv", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1632", "is", "lt", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1633", "is", "mk", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1634", "is", "mt", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1635", "is", "mn", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1636", "is", "ne", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1637", "is", "nl", "Ijslands");
INSERT INTO `wp_icl_languages_translations` VALUES("1638", "is", "no", "Islandsk");
INSERT INTO `wp_icl_languages_translations` VALUES("1639", "is", "pa", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1640", "is", "pl", "islandzki");
INSERT INTO `wp_icl_languages_translations` VALUES("1641", "is", "pt-pt", "Islandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1642", "is", "pt-br", "Islandês");
INSERT INTO `wp_icl_languages_translations` VALUES("1643", "is", "qu", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1644", "is", "ro", "Islandeză");
INSERT INTO `wp_icl_languages_translations` VALUES("1645", "is", "ru", "Исландский");
INSERT INTO `wp_icl_languages_translations` VALUES("1646", "is", "sl", "Islandski");
INSERT INTO `wp_icl_languages_translations` VALUES("1647", "is", "so", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1648", "is", "sq", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1649", "is", "sr", "исландски");
INSERT INTO `wp_icl_languages_translations` VALUES("1650", "is", "sv", "Isländska");
INSERT INTO `wp_icl_languages_translations` VALUES("1651", "is", "ta", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1652", "is", "th", "ไอซ์แลนด์");
INSERT INTO `wp_icl_languages_translations` VALUES("1653", "is", "tr", "İzlandaca");
INSERT INTO `wp_icl_languages_translations` VALUES("1654", "is", "uk", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1655", "is", "ur", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1656", "is", "uz", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1657", "is", "vi", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1658", "is", "yi", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1659", "is", "zh-hans", "冰岛语");
INSERT INTO `wp_icl_languages_translations` VALUES("1660", "is", "zu", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1661", "is", "zh-hant", "冰島語");
INSERT INTO `wp_icl_languages_translations` VALUES("1662", "is", "ms", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1663", "is", "gl", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1664", "is", "bn", "Icelandic");
INSERT INTO `wp_icl_languages_translations` VALUES("1665", "it", "en", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1666", "it", "es", "Italiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1667", "it", "de", "Italienisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1668", "it", "fr", "Italien");
INSERT INTO `wp_icl_languages_translations` VALUES("1669", "it", "ar", "الإيطالية");
INSERT INTO `wp_icl_languages_translations` VALUES("1670", "it", "bs", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1671", "it", "bg", "Италиански");
INSERT INTO `wp_icl_languages_translations` VALUES("1672", "it", "ca", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1673", "it", "cs", "Ital");
INSERT INTO `wp_icl_languages_translations` VALUES("1674", "it", "sk", "Taliančina");
INSERT INTO `wp_icl_languages_translations` VALUES("1675", "it", "cy", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1676", "it", "da", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1677", "it", "el", "Ιταλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1678", "it", "eo", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1679", "it", "et", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1680", "it", "eu", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1681", "it", "fa", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1682", "it", "fi", "italia");
INSERT INTO `wp_icl_languages_translations` VALUES("1683", "it", "ga", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1684", "it", "he", "איטלקית");
INSERT INTO `wp_icl_languages_translations` VALUES("1685", "it", "hi", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1686", "it", "hr", "Talijanski");
INSERT INTO `wp_icl_languages_translations` VALUES("1687", "it", "hu", "olasz");
INSERT INTO `wp_icl_languages_translations` VALUES("1688", "it", "hy", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1689", "it", "id", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1690", "it", "is", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1691", "it", "it", "Italiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1692", "it", "ja", "イタリア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1693", "it", "ko", "이태리어");
INSERT INTO `wp_icl_languages_translations` VALUES("1694", "it", "ku", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1695", "it", "lv", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1696", "it", "lt", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1697", "it", "mk", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1698", "it", "mt", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1699", "it", "mn", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1700", "it", "ne", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1701", "it", "nl", "Italiaans");
INSERT INTO `wp_icl_languages_translations` VALUES("1702", "it", "no", "Italiensk");
INSERT INTO `wp_icl_languages_translations` VALUES("1703", "it", "pa", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1704", "it", "pl", "włoski");
INSERT INTO `wp_icl_languages_translations` VALUES("1705", "it", "pt-pt", "Italiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1706", "it", "pt-br", "Italiano");
INSERT INTO `wp_icl_languages_translations` VALUES("1707", "it", "qu", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1708", "it", "ro", "Italiană");
INSERT INTO `wp_icl_languages_translations` VALUES("1709", "it", "ru", "Итальянский");
INSERT INTO `wp_icl_languages_translations` VALUES("1710", "it", "sl", "Italijanski");
INSERT INTO `wp_icl_languages_translations` VALUES("1711", "it", "so", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1712", "it", "sq", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1713", "it", "sr", "италијански");
INSERT INTO `wp_icl_languages_translations` VALUES("1714", "it", "sv", "Italienska");
INSERT INTO `wp_icl_languages_translations` VALUES("1715", "it", "ta", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1716", "it", "th", "อิตาลี");
INSERT INTO `wp_icl_languages_translations` VALUES("1717", "it", "tr", "İtalyanca");
INSERT INTO `wp_icl_languages_translations` VALUES("1718", "it", "uk", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1719", "it", "ur", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1720", "it", "uz", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1721", "it", "vi", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1722", "it", "yi", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1723", "it", "zh-hans", "意大利语");
INSERT INTO `wp_icl_languages_translations` VALUES("1724", "it", "zu", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1725", "it", "zh-hant", "義大利語");
INSERT INTO `wp_icl_languages_translations` VALUES("1726", "it", "ms", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1727", "it", "gl", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1728", "it", "bn", "Italian");
INSERT INTO `wp_icl_languages_translations` VALUES("1729", "ja", "en", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1730", "ja", "es", "Japonés");
INSERT INTO `wp_icl_languages_translations` VALUES("1731", "ja", "de", "Japanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1732", "ja", "fr", "Japonais");
INSERT INTO `wp_icl_languages_translations` VALUES("1733", "ja", "ar", "اليابانية");
INSERT INTO `wp_icl_languages_translations` VALUES("1734", "ja", "bs", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1735", "ja", "bg", "Японски");
INSERT INTO `wp_icl_languages_translations` VALUES("1736", "ja", "ca", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1737", "ja", "cs", "Japonský");
INSERT INTO `wp_icl_languages_translations` VALUES("1738", "ja", "sk", "Japonština");
INSERT INTO `wp_icl_languages_translations` VALUES("1739", "ja", "cy", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1740", "ja", "da", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1741", "ja", "el", "Ιαπωνικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1742", "ja", "eo", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1743", "ja", "et", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1744", "ja", "eu", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1745", "ja", "fa", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1746", "ja", "fi", "japani");
INSERT INTO `wp_icl_languages_translations` VALUES("1747", "ja", "ga", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1748", "ja", "he", "יפנית");
INSERT INTO `wp_icl_languages_translations` VALUES("1749", "ja", "hi", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1750", "ja", "hr", "Japanski");
INSERT INTO `wp_icl_languages_translations` VALUES("1751", "ja", "hu", "japán");
INSERT INTO `wp_icl_languages_translations` VALUES("1752", "ja", "hy", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1753", "ja", "id", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1754", "ja", "is", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1755", "ja", "it", "Giapponese");
INSERT INTO `wp_icl_languages_translations` VALUES("1756", "ja", "ja", "日本語");
INSERT INTO `wp_icl_languages_translations` VALUES("1757", "ja", "ko", "일어");
INSERT INTO `wp_icl_languages_translations` VALUES("1758", "ja", "ku", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1759", "ja", "lv", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1760", "ja", "lt", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1761", "ja", "mk", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1762", "ja", "mt", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1763", "ja", "mn", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1764", "ja", "ne", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1765", "ja", "nl", "Japans");
INSERT INTO `wp_icl_languages_translations` VALUES("1766", "ja", "no", "Japansk");
INSERT INTO `wp_icl_languages_translations` VALUES("1767", "ja", "pa", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1768", "ja", "pl", "japoński");
INSERT INTO `wp_icl_languages_translations` VALUES("1769", "ja", "pt-pt", "Japonês");
INSERT INTO `wp_icl_languages_translations` VALUES("1770", "ja", "pt-br", "Japonês");
INSERT INTO `wp_icl_languages_translations` VALUES("1771", "ja", "qu", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1772", "ja", "ro", "Japoneză");
INSERT INTO `wp_icl_languages_translations` VALUES("1773", "ja", "ru", "Японский");
INSERT INTO `wp_icl_languages_translations` VALUES("1774", "ja", "sl", "Japonski");
INSERT INTO `wp_icl_languages_translations` VALUES("1775", "ja", "so", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1776", "ja", "sq", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1777", "ja", "sr", "јапански");
INSERT INTO `wp_icl_languages_translations` VALUES("1778", "ja", "sv", "Japanska");
INSERT INTO `wp_icl_languages_translations` VALUES("1779", "ja", "ta", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1780", "ja", "th", "ญี่ปุ่น");
INSERT INTO `wp_icl_languages_translations` VALUES("1781", "ja", "tr", "Japonca");
INSERT INTO `wp_icl_languages_translations` VALUES("1782", "ja", "uk", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1783", "ja", "ur", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1784", "ja", "uz", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1785", "ja", "vi", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1786", "ja", "yi", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1787", "ja", "zh-hans", "日语");
INSERT INTO `wp_icl_languages_translations` VALUES("1788", "ja", "zu", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1789", "ja", "zh-hant", "日語");
INSERT INTO `wp_icl_languages_translations` VALUES("1790", "ja", "ms", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1791", "ja", "gl", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1792", "ja", "bn", "Japanese");
INSERT INTO `wp_icl_languages_translations` VALUES("1793", "ko", "en", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1794", "ko", "es", "Coreano");
INSERT INTO `wp_icl_languages_translations` VALUES("1795", "ko", "de", "Koreanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1796", "ko", "fr", "Coréen");
INSERT INTO `wp_icl_languages_translations` VALUES("1797", "ko", "ar", "الكورية");
INSERT INTO `wp_icl_languages_translations` VALUES("1798", "ko", "bs", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1799", "ko", "bg", "Корейски");
INSERT INTO `wp_icl_languages_translations` VALUES("1800", "ko", "ca", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1801", "ko", "cs", "Korejský");
INSERT INTO `wp_icl_languages_translations` VALUES("1802", "ko", "sk", "Kórejčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1803", "ko", "cy", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1804", "ko", "da", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1805", "ko", "el", "Κορεατικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1806", "ko", "eo", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1807", "ko", "et", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1808", "ko", "eu", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1809", "ko", "fa", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1810", "ko", "fi", "korea");
INSERT INTO `wp_icl_languages_translations` VALUES("1811", "ko", "ga", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1812", "ko", "he", "קוראנית");
INSERT INTO `wp_icl_languages_translations` VALUES("1813", "ko", "hi", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1814", "ko", "hr", "Korejski");
INSERT INTO `wp_icl_languages_translations` VALUES("1815", "ko", "hu", "koreai");
INSERT INTO `wp_icl_languages_translations` VALUES("1816", "ko", "hy", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1817", "ko", "id", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1818", "ko", "is", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1819", "ko", "it", "Coreano");
INSERT INTO `wp_icl_languages_translations` VALUES("1820", "ko", "ja", "韓国語");
INSERT INTO `wp_icl_languages_translations` VALUES("1821", "ko", "ko", "한국어");
INSERT INTO `wp_icl_languages_translations` VALUES("1822", "ko", "ku", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1823", "ko", "lv", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1824", "ko", "lt", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1825", "ko", "mk", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1826", "ko", "mt", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1827", "ko", "mn", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1828", "ko", "ne", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1829", "ko", "nl", "Koreaans");
INSERT INTO `wp_icl_languages_translations` VALUES("1830", "ko", "no", "Koreanske");
INSERT INTO `wp_icl_languages_translations` VALUES("1831", "ko", "pa", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1832", "ko", "pl", "koreański");
INSERT INTO `wp_icl_languages_translations` VALUES("1833", "ko", "pt-pt", "Coreano");
INSERT INTO `wp_icl_languages_translations` VALUES("1834", "ko", "pt-br", "Coreano");
INSERT INTO `wp_icl_languages_translations` VALUES("1835", "ko", "qu", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1836", "ko", "ro", "Coreană");
INSERT INTO `wp_icl_languages_translations` VALUES("1837", "ko", "ru", "Корейский");
INSERT INTO `wp_icl_languages_translations` VALUES("1838", "ko", "sl", "Korejski");
INSERT INTO `wp_icl_languages_translations` VALUES("1839", "ko", "so", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1840", "ko", "sq", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1841", "ko", "sr", "корејски");
INSERT INTO `wp_icl_languages_translations` VALUES("1842", "ko", "sv", "Koreanska");
INSERT INTO `wp_icl_languages_translations` VALUES("1843", "ko", "ta", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1844", "ko", "th", "เกาหลี");
INSERT INTO `wp_icl_languages_translations` VALUES("1845", "ko", "tr", "Kore dili");
INSERT INTO `wp_icl_languages_translations` VALUES("1846", "ko", "uk", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1847", "ko", "ur", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1848", "ko", "uz", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1849", "ko", "vi", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1850", "ko", "yi", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1851", "ko", "zh-hans", "韩语");
INSERT INTO `wp_icl_languages_translations` VALUES("1852", "ko", "zu", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1853", "ko", "zh-hant", "韓語");
INSERT INTO `wp_icl_languages_translations` VALUES("1854", "ko", "ms", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1855", "ko", "gl", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1856", "ko", "bn", "Korean");
INSERT INTO `wp_icl_languages_translations` VALUES("1857", "ku", "en", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1858", "ku", "es", "Kurdo");
INSERT INTO `wp_icl_languages_translations` VALUES("1859", "ku", "de", "Kurdisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1860", "ku", "fr", "Kurde");
INSERT INTO `wp_icl_languages_translations` VALUES("1861", "ku", "ar", "الكردية");
INSERT INTO `wp_icl_languages_translations` VALUES("1862", "ku", "bs", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1863", "ku", "bg", "Кюрдски");
INSERT INTO `wp_icl_languages_translations` VALUES("1864", "ku", "ca", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1865", "ku", "cs", "Kurdský");
INSERT INTO `wp_icl_languages_translations` VALUES("1866", "ku", "sk", "Kurdština");
INSERT INTO `wp_icl_languages_translations` VALUES("1867", "ku", "cy", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1868", "ku", "da", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1869", "ku", "el", "Κουρδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1870", "ku", "eo", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1871", "ku", "et", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1872", "ku", "eu", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1873", "ku", "fa", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1874", "ku", "fi", "kurdi");
INSERT INTO `wp_icl_languages_translations` VALUES("1875", "ku", "ga", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1876", "ku", "he", "כורדית");
INSERT INTO `wp_icl_languages_translations` VALUES("1877", "ku", "hi", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1878", "ku", "hr", "Kurdski");
INSERT INTO `wp_icl_languages_translations` VALUES("1879", "ku", "hu", "kurd");
INSERT INTO `wp_icl_languages_translations` VALUES("1880", "ku", "hy", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1881", "ku", "id", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1882", "ku", "is", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1883", "ku", "it", "Curdo");
INSERT INTO `wp_icl_languages_translations` VALUES("1884", "ku", "ja", "クルド語");
INSERT INTO `wp_icl_languages_translations` VALUES("1885", "ku", "ko", "쿠르드어");
INSERT INTO `wp_icl_languages_translations` VALUES("1886", "ku", "ku", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1887", "ku", "lv", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1888", "ku", "lt", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1889", "ku", "mk", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1890", "ku", "mt", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1891", "ku", "mn", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1892", "ku", "ne", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1893", "ku", "nl", "Koerdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1894", "ku", "no", "Kurdisk");
INSERT INTO `wp_icl_languages_translations` VALUES("1895", "ku", "pa", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1896", "ku", "pl", "kurdyjski");
INSERT INTO `wp_icl_languages_translations` VALUES("1897", "ku", "pt-pt", "Curdo");
INSERT INTO `wp_icl_languages_translations` VALUES("1898", "ku", "pt-br", "Curdo");
INSERT INTO `wp_icl_languages_translations` VALUES("1899", "ku", "qu", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1900", "ku", "ro", "Kurdă");
INSERT INTO `wp_icl_languages_translations` VALUES("1901", "ku", "ru", "Курдский");
INSERT INTO `wp_icl_languages_translations` VALUES("1902", "ku", "sl", "Kurdščina");
INSERT INTO `wp_icl_languages_translations` VALUES("1903", "ku", "so", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1904", "ku", "sq", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1905", "ku", "sr", "курдски");
INSERT INTO `wp_icl_languages_translations` VALUES("1906", "ku", "sv", "Kurdiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1907", "ku", "ta", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1908", "ku", "th", "เคอร์ดิช");
INSERT INTO `wp_icl_languages_translations` VALUES("1909", "ku", "tr", "Kürtçe");
INSERT INTO `wp_icl_languages_translations` VALUES("1910", "ku", "uk", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1911", "ku", "ur", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1912", "ku", "uz", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1913", "ku", "vi", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1914", "ku", "yi", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1915", "ku", "zh-hans", "库尔德语");
INSERT INTO `wp_icl_languages_translations` VALUES("1916", "ku", "zu", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1917", "ku", "zh-hant", "庫爾德語");
INSERT INTO `wp_icl_languages_translations` VALUES("1918", "ku", "ms", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1919", "ku", "gl", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1920", "ku", "bn", "Kurdish");
INSERT INTO `wp_icl_languages_translations` VALUES("1921", "lv", "en", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1922", "lv", "es", "Letón");
INSERT INTO `wp_icl_languages_translations` VALUES("1923", "lv", "de", "Lettisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1924", "lv", "fr", "Letton");
INSERT INTO `wp_icl_languages_translations` VALUES("1925", "lv", "ar", "اللاتفية");
INSERT INTO `wp_icl_languages_translations` VALUES("1926", "lv", "bs", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1927", "lv", "bg", "Латвийски");
INSERT INTO `wp_icl_languages_translations` VALUES("1928", "lv", "ca", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1929", "lv", "cs", "Lotyština");
INSERT INTO `wp_icl_languages_translations` VALUES("1930", "lv", "sk", "Lotyština");
INSERT INTO `wp_icl_languages_translations` VALUES("1931", "lv", "cy", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1932", "lv", "da", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1933", "lv", "el", "Λετονικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1934", "lv", "eo", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1935", "lv", "et", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1936", "lv", "eu", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1937", "lv", "fa", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1938", "lv", "fi", "latvia");
INSERT INTO `wp_icl_languages_translations` VALUES("1939", "lv", "ga", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1940", "lv", "he", "לטבית");
INSERT INTO `wp_icl_languages_translations` VALUES("1941", "lv", "hi", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1942", "lv", "hr", "Letonski");
INSERT INTO `wp_icl_languages_translations` VALUES("1943", "lv", "hu", "lett");
INSERT INTO `wp_icl_languages_translations` VALUES("1944", "lv", "hy", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1945", "lv", "id", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1946", "lv", "is", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1947", "lv", "it", "Lettone");
INSERT INTO `wp_icl_languages_translations` VALUES("1948", "lv", "ja", "ラトビア語");
INSERT INTO `wp_icl_languages_translations` VALUES("1949", "lv", "ko", "라트비아어");
INSERT INTO `wp_icl_languages_translations` VALUES("1950", "lv", "ku", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1951", "lv", "lv", "Latviešu");
INSERT INTO `wp_icl_languages_translations` VALUES("1952", "lv", "lt", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1953", "lv", "mk", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1954", "lv", "mt", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1955", "lv", "mn", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1956", "lv", "ne", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1957", "lv", "nl", "Lets");
INSERT INTO `wp_icl_languages_translations` VALUES("1958", "lv", "no", "Latvisk");
INSERT INTO `wp_icl_languages_translations` VALUES("1959", "lv", "pa", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1960", "lv", "pl", "łotewski");
INSERT INTO `wp_icl_languages_translations` VALUES("1961", "lv", "pt-pt", "Letão");
INSERT INTO `wp_icl_languages_translations` VALUES("1962", "lv", "pt-br", "Letão");
INSERT INTO `wp_icl_languages_translations` VALUES("1963", "lv", "qu", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1964", "lv", "ro", "Letoniană");
INSERT INTO `wp_icl_languages_translations` VALUES("1965", "lv", "ru", "латышский");
INSERT INTO `wp_icl_languages_translations` VALUES("1966", "lv", "sl", "Latvijščina");
INSERT INTO `wp_icl_languages_translations` VALUES("1967", "lv", "so", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1968", "lv", "sq", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1969", "lv", "sr", "летонски");
INSERT INTO `wp_icl_languages_translations` VALUES("1970", "lv", "sv", "Lettiska");
INSERT INTO `wp_icl_languages_translations` VALUES("1971", "lv", "ta", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1972", "lv", "th", "ลัตเวีย");
INSERT INTO `wp_icl_languages_translations` VALUES("1973", "lv", "tr", "Letonca");
INSERT INTO `wp_icl_languages_translations` VALUES("1974", "lv", "uk", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1975", "lv", "ur", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1976", "lv", "uz", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1977", "lv", "vi", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1978", "lv", "yi", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1979", "lv", "zh-hans", "拉脱维亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("1980", "lv", "zu", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1981", "lv", "zh-hant", "拉脫維亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("1982", "lv", "ms", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1983", "lv", "gl", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1984", "lv", "bn", "Latvian");
INSERT INTO `wp_icl_languages_translations` VALUES("1985", "lt", "en", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("1986", "lt", "es", "Lituano");
INSERT INTO `wp_icl_languages_translations` VALUES("1987", "lt", "de", "Litauisch");
INSERT INTO `wp_icl_languages_translations` VALUES("1988", "lt", "fr", "Lituanien");
INSERT INTO `wp_icl_languages_translations` VALUES("1989", "lt", "ar", "اللتوانية");
INSERT INTO `wp_icl_languages_translations` VALUES("1990", "lt", "bs", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("1991", "lt", "bg", "Литовски");
INSERT INTO `wp_icl_languages_translations` VALUES("1992", "lt", "ca", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("1993", "lt", "cs", "litevský");
INSERT INTO `wp_icl_languages_translations` VALUES("1994", "lt", "sk", "Litovčina");
INSERT INTO `wp_icl_languages_translations` VALUES("1995", "lt", "cy", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("1996", "lt", "da", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("1997", "lt", "el", "Λιθουανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("1998", "lt", "eo", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("1999", "lt", "et", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2000", "lt", "eu", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2001", "lt", "fa", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2002", "lt", "fi", "liettua");
INSERT INTO `wp_icl_languages_translations` VALUES("2003", "lt", "ga", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2004", "lt", "he", "ליטאית");
INSERT INTO `wp_icl_languages_translations` VALUES("2005", "lt", "hi", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2006", "lt", "hr", "Litvanski");
INSERT INTO `wp_icl_languages_translations` VALUES("2007", "lt", "hu", "litván");
INSERT INTO `wp_icl_languages_translations` VALUES("2008", "lt", "hy", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2009", "lt", "id", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2010", "lt", "is", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2011", "lt", "it", "Lituano");
INSERT INTO `wp_icl_languages_translations` VALUES("2012", "lt", "ja", "リトアニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2013", "lt", "ko", "리투아니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2014", "lt", "ku", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2015", "lt", "lv", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2016", "lt", "lt", "Lietuvos");
INSERT INTO `wp_icl_languages_translations` VALUES("2017", "lt", "mk", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2018", "lt", "mt", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2019", "lt", "mn", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2020", "lt", "ne", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2021", "lt", "nl", "Litouws");
INSERT INTO `wp_icl_languages_translations` VALUES("2022", "lt", "no", "Litauisk");
INSERT INTO `wp_icl_languages_translations` VALUES("2023", "lt", "pa", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2024", "lt", "pl", "litewski");
INSERT INTO `wp_icl_languages_translations` VALUES("2025", "lt", "pt-pt", "Lituano");
INSERT INTO `wp_icl_languages_translations` VALUES("2026", "lt", "pt-br", "Lituano");
INSERT INTO `wp_icl_languages_translations` VALUES("2027", "lt", "qu", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2028", "lt", "ro", "Lituaniană");
INSERT INTO `wp_icl_languages_translations` VALUES("2029", "lt", "ru", "Литовский");
INSERT INTO `wp_icl_languages_translations` VALUES("2030", "lt", "sl", "Litovščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2031", "lt", "so", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2032", "lt", "sq", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2033", "lt", "sr", "литвански");
INSERT INTO `wp_icl_languages_translations` VALUES("2034", "lt", "sv", "Litauiska");
INSERT INTO `wp_icl_languages_translations` VALUES("2035", "lt", "ta", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2036", "lt", "th", "ลิธัวเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2037", "lt", "tr", "Litvanyaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2038", "lt", "uk", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2039", "lt", "ur", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2040", "lt", "uz", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2041", "lt", "vi", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2042", "lt", "yi", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2043", "lt", "zh-hans", "立陶宛语");
INSERT INTO `wp_icl_languages_translations` VALUES("2044", "lt", "zu", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2045", "lt", "zh-hant", "立陶宛語");
INSERT INTO `wp_icl_languages_translations` VALUES("2046", "lt", "ms", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2047", "lt", "gl", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2048", "lt", "bn", "Lithuanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2049", "mk", "en", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2050", "mk", "es", "Macedonio");
INSERT INTO `wp_icl_languages_translations` VALUES("2051", "mk", "de", "Mazedonisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2052", "mk", "fr", "Macédonien");
INSERT INTO `wp_icl_languages_translations` VALUES("2053", "mk", "ar", "المقدونية");
INSERT INTO `wp_icl_languages_translations` VALUES("2054", "mk", "bs", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2055", "mk", "bg", "Македонски");
INSERT INTO `wp_icl_languages_translations` VALUES("2056", "mk", "ca", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2057", "mk", "cs", "Makedonský");
INSERT INTO `wp_icl_languages_translations` VALUES("2058", "mk", "sk", "Macedónština");
INSERT INTO `wp_icl_languages_translations` VALUES("2059", "mk", "cy", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2060", "mk", "da", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2061", "mk", "el", "Μακεδονικο");
INSERT INTO `wp_icl_languages_translations` VALUES("2062", "mk", "eo", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2063", "mk", "et", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2064", "mk", "eu", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2065", "mk", "fa", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2066", "mk", "fi", "makedonia");
INSERT INTO `wp_icl_languages_translations` VALUES("2067", "mk", "ga", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2068", "mk", "he", "מקדונית");
INSERT INTO `wp_icl_languages_translations` VALUES("2069", "mk", "hi", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2070", "mk", "hr", "Makedonski");
INSERT INTO `wp_icl_languages_translations` VALUES("2071", "mk", "hu", "macedón");
INSERT INTO `wp_icl_languages_translations` VALUES("2072", "mk", "hy", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2073", "mk", "id", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2074", "mk", "is", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2075", "mk", "it", "Macedone");
INSERT INTO `wp_icl_languages_translations` VALUES("2076", "mk", "ja", "マケドニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2077", "mk", "ko", "마케도니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2078", "mk", "ku", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2079", "mk", "lv", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2080", "mk", "lt", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2081", "mk", "mk", "македонски");
INSERT INTO `wp_icl_languages_translations` VALUES("2082", "mk", "mt", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2083", "mk", "mn", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2084", "mk", "ne", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2085", "mk", "nl", "Macedonisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2086", "mk", "no", "Makedonsk");
INSERT INTO `wp_icl_languages_translations` VALUES("2087", "mk", "pa", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2088", "mk", "pl", "macedoński");
INSERT INTO `wp_icl_languages_translations` VALUES("2089", "mk", "pt-pt", "Macedônio");
INSERT INTO `wp_icl_languages_translations` VALUES("2090", "mk", "pt-br", "Macedônio");
INSERT INTO `wp_icl_languages_translations` VALUES("2091", "mk", "qu", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2092", "mk", "ro", "Macedoniană");
INSERT INTO `wp_icl_languages_translations` VALUES("2093", "mk", "ru", "Македонский");
INSERT INTO `wp_icl_languages_translations` VALUES("2094", "mk", "sl", "Makedonski");
INSERT INTO `wp_icl_languages_translations` VALUES("2095", "mk", "so", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2096", "mk", "sq", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2097", "mk", "sr", "македонски");
INSERT INTO `wp_icl_languages_translations` VALUES("2098", "mk", "sv", "Makedonska");
INSERT INTO `wp_icl_languages_translations` VALUES("2099", "mk", "ta", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2100", "mk", "th", "มาซิโดเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2101", "mk", "tr", "Makedonyaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2102", "mk", "uk", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2103", "mk", "ur", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2104", "mk", "uz", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2105", "mk", "vi", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2106", "mk", "yi", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2107", "mk", "zh-hans", "马其顿语");
INSERT INTO `wp_icl_languages_translations` VALUES("2108", "mk", "zu", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2109", "mk", "zh-hant", "馬其頓語");
INSERT INTO `wp_icl_languages_translations` VALUES("2110", "mk", "ms", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2111", "mk", "gl", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2112", "mk", "bn", "Macedonian");
INSERT INTO `wp_icl_languages_translations` VALUES("2113", "mt", "en", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2114", "mt", "es", "Maltés");
INSERT INTO `wp_icl_languages_translations` VALUES("2115", "mt", "de", "Maltesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2116", "mt", "fr", "Maltais");
INSERT INTO `wp_icl_languages_translations` VALUES("2117", "mt", "ar", "المالطية");
INSERT INTO `wp_icl_languages_translations` VALUES("2118", "mt", "bs", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2119", "mt", "bg", "Малтийски");
INSERT INTO `wp_icl_languages_translations` VALUES("2120", "mt", "ca", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2121", "mt", "cs", "Maltština");
INSERT INTO `wp_icl_languages_translations` VALUES("2122", "mt", "sk", "Maltézština");
INSERT INTO `wp_icl_languages_translations` VALUES("2123", "mt", "cy", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2124", "mt", "da", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2125", "mt", "el", "Μαλτεζικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2126", "mt", "eo", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2127", "mt", "et", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2128", "mt", "eu", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2129", "mt", "fa", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2130", "mt", "fi", "malta");
INSERT INTO `wp_icl_languages_translations` VALUES("2131", "mt", "ga", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2132", "mt", "he", "מלטזית");
INSERT INTO `wp_icl_languages_translations` VALUES("2133", "mt", "hi", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2134", "mt", "hr", "Malteški");
INSERT INTO `wp_icl_languages_translations` VALUES("2135", "mt", "hu", "máltai");
INSERT INTO `wp_icl_languages_translations` VALUES("2136", "mt", "hy", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2137", "mt", "id", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2138", "mt", "is", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2139", "mt", "it", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2140", "mt", "ja", "マルタ語");
INSERT INTO `wp_icl_languages_translations` VALUES("2141", "mt", "ko", "몰타어");
INSERT INTO `wp_icl_languages_translations` VALUES("2142", "mt", "ku", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2143", "mt", "lv", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2144", "mt", "lt", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2145", "mt", "mk", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2146", "mt", "mt", "Malti");
INSERT INTO `wp_icl_languages_translations` VALUES("2147", "mt", "mn", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2148", "mt", "ne", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2149", "mt", "nl", "Maltees");
INSERT INTO `wp_icl_languages_translations` VALUES("2150", "mt", "no", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2151", "mt", "pa", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2152", "mt", "pl", "maltański");
INSERT INTO `wp_icl_languages_translations` VALUES("2153", "mt", "pt-pt", "Maltês");
INSERT INTO `wp_icl_languages_translations` VALUES("2154", "mt", "pt-br", "Maltês");
INSERT INTO `wp_icl_languages_translations` VALUES("2155", "mt", "qu", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2156", "mt", "ro", "Malteză");
INSERT INTO `wp_icl_languages_translations` VALUES("2157", "mt", "ru", "Мальтийский");
INSERT INTO `wp_icl_languages_translations` VALUES("2158", "mt", "sl", "Malteški");
INSERT INTO `wp_icl_languages_translations` VALUES("2159", "mt", "so", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2160", "mt", "sq", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2161", "mt", "sr", "малтешки");
INSERT INTO `wp_icl_languages_translations` VALUES("2162", "mt", "sv", "Maltesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("2163", "mt", "ta", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2164", "mt", "th", "มอลทีส");
INSERT INTO `wp_icl_languages_translations` VALUES("2165", "mt", "tr", "Malta dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2166", "mt", "uk", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2167", "mt", "ur", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2168", "mt", "uz", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2169", "mt", "vi", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2170", "mt", "yi", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2171", "mt", "zh-hans", "马耳他语");
INSERT INTO `wp_icl_languages_translations` VALUES("2172", "mt", "zu", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2173", "mt", "zh-hant", "馬爾他語");
INSERT INTO `wp_icl_languages_translations` VALUES("2174", "mt", "ms", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2175", "mt", "gl", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2176", "mt", "bn", "Maltese");
INSERT INTO `wp_icl_languages_translations` VALUES("2177", "mn", "en", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2178", "mn", "es", "Mongol");
INSERT INTO `wp_icl_languages_translations` VALUES("2179", "mn", "de", "Mongolisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2180", "mn", "fr", "Mongol");
INSERT INTO `wp_icl_languages_translations` VALUES("2181", "mn", "ar", "المنغولية");
INSERT INTO `wp_icl_languages_translations` VALUES("2182", "mn", "bs", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2183", "mn", "bg", "Монголски");
INSERT INTO `wp_icl_languages_translations` VALUES("2184", "mn", "ca", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2185", "mn", "cs", "Mongolský");
INSERT INTO `wp_icl_languages_translations` VALUES("2186", "mn", "sk", "Mongolština");
INSERT INTO `wp_icl_languages_translations` VALUES("2187", "mn", "cy", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2188", "mn", "da", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2189", "mn", "el", "Μογγολικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2190", "mn", "eo", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2191", "mn", "et", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2192", "mn", "eu", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2193", "mn", "fa", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2194", "mn", "fi", "mongoli");
INSERT INTO `wp_icl_languages_translations` VALUES("2195", "mn", "ga", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2196", "mn", "he", "מונגולית");
INSERT INTO `wp_icl_languages_translations` VALUES("2197", "mn", "hi", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2198", "mn", "hr", "Mongolski");
INSERT INTO `wp_icl_languages_translations` VALUES("2199", "mn", "hu", "mongol");
INSERT INTO `wp_icl_languages_translations` VALUES("2200", "mn", "hy", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2201", "mn", "id", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2202", "mn", "is", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2203", "mn", "it", "Mongolo");
INSERT INTO `wp_icl_languages_translations` VALUES("2204", "mn", "ja", "モンゴル語");
INSERT INTO `wp_icl_languages_translations` VALUES("2205", "mn", "ko", "몽골어");
INSERT INTO `wp_icl_languages_translations` VALUES("2206", "mn", "ku", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2207", "mn", "lv", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2208", "mn", "lt", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2209", "mn", "mk", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2210", "mn", "mt", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2211", "mn", "mn", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2212", "mn", "ne", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2213", "mn", "nl", "Mongools");
INSERT INTO `wp_icl_languages_translations` VALUES("2214", "mn", "no", "Mongolsk");
INSERT INTO `wp_icl_languages_translations` VALUES("2215", "mn", "pa", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2216", "mn", "pl", "mongolski");
INSERT INTO `wp_icl_languages_translations` VALUES("2217", "mn", "pt-pt", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2218", "mn", "pt-br", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2219", "mn", "qu", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2220", "mn", "ro", "Mongoleză");
INSERT INTO `wp_icl_languages_translations` VALUES("2221", "mn", "ru", "Монгольский");
INSERT INTO `wp_icl_languages_translations` VALUES("2222", "mn", "sl", "Mongolski");
INSERT INTO `wp_icl_languages_translations` VALUES("2223", "mn", "so", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2224", "mn", "sq", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2225", "mn", "sr", "монголски");
INSERT INTO `wp_icl_languages_translations` VALUES("2226", "mn", "sv", "Mongoliska");
INSERT INTO `wp_icl_languages_translations` VALUES("2227", "mn", "ta", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2228", "mn", "th", "มองโกเลีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2229", "mn", "tr", "Mongolca");
INSERT INTO `wp_icl_languages_translations` VALUES("2230", "mn", "uk", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2231", "mn", "ur", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2232", "mn", "uz", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2233", "mn", "vi", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2234", "mn", "yi", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2235", "mn", "zh-hans", "蒙古语");
INSERT INTO `wp_icl_languages_translations` VALUES("2236", "mn", "zu", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2237", "mn", "zh-hant", "蒙古語");
INSERT INTO `wp_icl_languages_translations` VALUES("2238", "mn", "ms", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2239", "mn", "gl", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2240", "mn", "bn", "Mongolian");
INSERT INTO `wp_icl_languages_translations` VALUES("2241", "ne", "en", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2242", "ne", "es", "Nepalí");
INSERT INTO `wp_icl_languages_translations` VALUES("2243", "ne", "de", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2244", "ne", "fr", "Népalais");
INSERT INTO `wp_icl_languages_translations` VALUES("2245", "ne", "ar", "النيبالية");
INSERT INTO `wp_icl_languages_translations` VALUES("2246", "ne", "bs", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2247", "ne", "bg", "Непалски");
INSERT INTO `wp_icl_languages_translations` VALUES("2248", "ne", "ca", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2249", "ne", "cs", "Nepálský");
INSERT INTO `wp_icl_languages_translations` VALUES("2250", "ne", "sk", "Nepálčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2251", "ne", "cy", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2252", "ne", "da", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2253", "ne", "el", "Νεπαλι");
INSERT INTO `wp_icl_languages_translations` VALUES("2254", "ne", "eo", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2255", "ne", "et", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2256", "ne", "eu", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2257", "ne", "fa", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2258", "ne", "fi", "nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2259", "ne", "ga", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2260", "ne", "he", "נפאלית");
INSERT INTO `wp_icl_languages_translations` VALUES("2261", "ne", "hi", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2262", "ne", "hr", "Nepalski");
INSERT INTO `wp_icl_languages_translations` VALUES("2263", "ne", "hu", "nepáli");
INSERT INTO `wp_icl_languages_translations` VALUES("2264", "ne", "hy", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2265", "ne", "id", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2266", "ne", "is", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2267", "ne", "it", "Nepalese");
INSERT INTO `wp_icl_languages_translations` VALUES("2268", "ne", "ja", "ネパール語");
INSERT INTO `wp_icl_languages_translations` VALUES("2269", "ne", "ko", "네팔어");
INSERT INTO `wp_icl_languages_translations` VALUES("2270", "ne", "ku", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2271", "ne", "lv", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2272", "ne", "lt", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2273", "ne", "mk", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2274", "ne", "mt", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2275", "ne", "mn", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2276", "ne", "ne", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2277", "ne", "nl", "Nepalees");
INSERT INTO `wp_icl_languages_translations` VALUES("2278", "ne", "no", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2279", "ne", "pa", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2280", "ne", "pl", "nepalski");
INSERT INTO `wp_icl_languages_translations` VALUES("2281", "ne", "pt-pt", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2282", "ne", "pt-br", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2283", "ne", "qu", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2284", "ne", "ro", "Nepaleză");
INSERT INTO `wp_icl_languages_translations` VALUES("2285", "ne", "ru", "Непальский");
INSERT INTO `wp_icl_languages_translations` VALUES("2286", "ne", "sl", "Nepalščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2287", "ne", "so", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2288", "ne", "sq", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2289", "ne", "sr", "непалски");
INSERT INTO `wp_icl_languages_translations` VALUES("2290", "ne", "sv", "Nepalesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("2291", "ne", "ta", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2292", "ne", "th", "เนปาล");
INSERT INTO `wp_icl_languages_translations` VALUES("2293", "ne", "tr", "Nepal dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2294", "ne", "uk", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2295", "ne", "ur", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2296", "ne", "uz", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2297", "ne", "vi", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2298", "ne", "yi", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2299", "ne", "zh-hans", "尼泊尔语");
INSERT INTO `wp_icl_languages_translations` VALUES("2300", "ne", "zu", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2301", "ne", "zh-hant", "尼泊爾語");
INSERT INTO `wp_icl_languages_translations` VALUES("2302", "ne", "ms", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2303", "ne", "gl", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2304", "ne", "bn", "Nepali");
INSERT INTO `wp_icl_languages_translations` VALUES("2305", "nl", "en", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2306", "nl", "es", "Holandés");
INSERT INTO `wp_icl_languages_translations` VALUES("2307", "nl", "de", "Niederländisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2308", "nl", "fr", "Néerlandais");
INSERT INTO `wp_icl_languages_translations` VALUES("2309", "nl", "ar", "الهولندية");
INSERT INTO `wp_icl_languages_translations` VALUES("2310", "nl", "bs", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2311", "nl", "bg", "Холандски");
INSERT INTO `wp_icl_languages_translations` VALUES("2312", "nl", "ca", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2313", "nl", "cs", "Holandský");
INSERT INTO `wp_icl_languages_translations` VALUES("2314", "nl", "sk", "Holandčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2315", "nl", "cy", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2316", "nl", "da", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2317", "nl", "el", "Ολλανδικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2318", "nl", "eo", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2319", "nl", "et", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2320", "nl", "eu", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2321", "nl", "fa", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2322", "nl", "fi", "hollanti");
INSERT INTO `wp_icl_languages_translations` VALUES("2323", "nl", "ga", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2324", "nl", "he", "הולנדית");
INSERT INTO `wp_icl_languages_translations` VALUES("2325", "nl", "hi", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2326", "nl", "hr", "Holandski");
INSERT INTO `wp_icl_languages_translations` VALUES("2327", "nl", "hu", "holland");
INSERT INTO `wp_icl_languages_translations` VALUES("2328", "nl", "hy", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2329", "nl", "id", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2330", "nl", "is", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2331", "nl", "it", "Olandese");
INSERT INTO `wp_icl_languages_translations` VALUES("2332", "nl", "ja", "オランダ語");
INSERT INTO `wp_icl_languages_translations` VALUES("2333", "nl", "ko", "화란어");
INSERT INTO `wp_icl_languages_translations` VALUES("2334", "nl", "ku", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2335", "nl", "lv", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2336", "nl", "lt", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2337", "nl", "mk", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2338", "nl", "mt", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2339", "nl", "mn", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2340", "nl", "ne", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2341", "nl", "nl", "Nederlands");
INSERT INTO `wp_icl_languages_translations` VALUES("2342", "nl", "no", "Nederlandsk");
INSERT INTO `wp_icl_languages_translations` VALUES("2343", "nl", "pa", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2344", "nl", "pl", "holenderski");
INSERT INTO `wp_icl_languages_translations` VALUES("2345", "nl", "pt-pt", "Holandês");
INSERT INTO `wp_icl_languages_translations` VALUES("2346", "nl", "pt-br", "Holandês");
INSERT INTO `wp_icl_languages_translations` VALUES("2347", "nl", "qu", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2348", "nl", "ro", "Olaneză");
INSERT INTO `wp_icl_languages_translations` VALUES("2349", "nl", "ru", "Голландский");
INSERT INTO `wp_icl_languages_translations` VALUES("2350", "nl", "sl", "Nizozemščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2351", "nl", "so", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2352", "nl", "sq", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2353", "nl", "sr", "холандски");
INSERT INTO `wp_icl_languages_translations` VALUES("2354", "nl", "sv", "Nederländska");
INSERT INTO `wp_icl_languages_translations` VALUES("2355", "nl", "ta", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2356", "nl", "th", "ดัตช์");
INSERT INTO `wp_icl_languages_translations` VALUES("2357", "nl", "tr", "Hollandaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2358", "nl", "uk", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2359", "nl", "ur", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2360", "nl", "uz", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2361", "nl", "vi", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2362", "nl", "yi", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2363", "nl", "zh-hans", "荷兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("2364", "nl", "zu", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2365", "nl", "zh-hant", "荷蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("2366", "nl", "ms", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2367", "nl", "gl", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2368", "nl", "bn", "Dutch");
INSERT INTO `wp_icl_languages_translations` VALUES("2369", "no", "en", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2370", "no", "es", "Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2371", "no", "de", "Norwegisch (Buchsprache)");
INSERT INTO `wp_icl_languages_translations` VALUES("2372", "no", "fr", "Norvégien Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2373", "no", "ar", "البوكمالية النرويجية");
INSERT INTO `wp_icl_languages_translations` VALUES("2374", "no", "bs", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2375", "no", "bg", "Норвежки книжовен");
INSERT INTO `wp_icl_languages_translations` VALUES("2376", "no", "ca", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2377", "no", "cs", "Norwegian bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2378", "no", "sk", "Nórsky jazyk Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2379", "no", "cy", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2380", "no", "da", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2381", "no", "el", "Νορβηγικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2382", "no", "eo", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2383", "no", "et", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2384", "no", "eu", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2385", "no", "fa", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2386", "no", "fi", "kirjanorja");
INSERT INTO `wp_icl_languages_translations` VALUES("2387", "no", "ga", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2388", "no", "he", "נורווגית");
INSERT INTO `wp_icl_languages_translations` VALUES("2389", "no", "hi", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2390", "no", "hr", "Književni norveški");
INSERT INTO `wp_icl_languages_translations` VALUES("2391", "no", "hu", "norvég bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2392", "no", "hy", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2393", "no", "id", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2394", "no", "is", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2395", "no", "it", "Norvegese Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2396", "no", "ja", "ノルウェー・ブークモール");
INSERT INTO `wp_icl_languages_translations` VALUES("2397", "no", "ko", "노르웨이 보크말어");
INSERT INTO `wp_icl_languages_translations` VALUES("2398", "no", "ku", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2399", "no", "lv", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2400", "no", "lt", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2401", "no", "mk", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2402", "no", "mt", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2403", "no", "mn", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2404", "no", "ne", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2405", "no", "nl", "Noors Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2406", "no", "no", "Norsk bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2407", "no", "pa", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2408", "no", "pl", "norweski bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2409", "no", "pt-pt", "Norueguês");
INSERT INTO `wp_icl_languages_translations` VALUES("2410", "no", "pt-br", "Norueguês");
INSERT INTO `wp_icl_languages_translations` VALUES("2411", "no", "qu", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2412", "no", "ro", "Bokmål (norvegiană)");
INSERT INTO `wp_icl_languages_translations` VALUES("2413", "no", "ru", "Норвежский букмол");
INSERT INTO `wp_icl_languages_translations` VALUES("2414", "no", "sl", "Knjižna norveščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2415", "no", "so", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2416", "no", "sq", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2417", "no", "sr", "Норвешки бокмал");
INSERT INTO `wp_icl_languages_translations` VALUES("2418", "no", "sv", "Norskt Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2419", "no", "ta", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2420", "no", "th", "นอร์วิเจียนบอกมาล");
INSERT INTO `wp_icl_languages_translations` VALUES("2421", "no", "tr", "Bokmal Norveç dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2422", "no", "uk", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2423", "no", "ur", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2424", "no", "uz", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2425", "no", "vi", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2426", "no", "yi", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2427", "no", "zh-hans", "挪威布克莫尔语");
INSERT INTO `wp_icl_languages_translations` VALUES("2428", "no", "zu", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2429", "no", "zh-hant", "挪威布克莫爾語");
INSERT INTO `wp_icl_languages_translations` VALUES("2430", "no", "ms", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2431", "no", "gl", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2432", "no", "bn", "Norwegian Bokmål");
INSERT INTO `wp_icl_languages_translations` VALUES("2433", "pa", "en", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2434", "pa", "es", "Panyabí");
INSERT INTO `wp_icl_languages_translations` VALUES("2435", "pa", "de", "Pandschabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2436", "pa", "fr", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2437", "pa", "ar", "البنجابية");
INSERT INTO `wp_icl_languages_translations` VALUES("2438", "pa", "bs", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2439", "pa", "bg", "Панджабски");
INSERT INTO `wp_icl_languages_translations` VALUES("2440", "pa", "ca", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2441", "pa", "cs", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2442", "pa", "sk", "Pandžábčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2443", "pa", "cy", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2444", "pa", "da", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2445", "pa", "el", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2446", "pa", "eo", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2447", "pa", "et", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2448", "pa", "eu", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2449", "pa", "fa", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2450", "pa", "fi", "pandzabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2451", "pa", "ga", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2452", "pa", "he", "פנג\'אבית");
INSERT INTO `wp_icl_languages_translations` VALUES("2453", "pa", "hi", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2454", "pa", "hr", "Pendžabljanin");
INSERT INTO `wp_icl_languages_translations` VALUES("2455", "pa", "hu", "pandzsábi");
INSERT INTO `wp_icl_languages_translations` VALUES("2456", "pa", "hy", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2457", "pa", "id", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2458", "pa", "is", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2459", "pa", "it", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2460", "pa", "ja", "パンジャーブ語");
INSERT INTO `wp_icl_languages_translations` VALUES("2461", "pa", "ko", "펀자브어");
INSERT INTO `wp_icl_languages_translations` VALUES("2462", "pa", "ku", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2463", "pa", "lv", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2464", "pa", "lt", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2465", "pa", "mk", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2466", "pa", "mt", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2467", "pa", "mn", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2468", "pa", "ne", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2469", "pa", "nl", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2470", "pa", "no", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2471", "pa", "pa", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2472", "pa", "pl", "pendżabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2473", "pa", "pt-pt", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2474", "pa", "pt-br", "Panjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2475", "pa", "qu", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2476", "pa", "ro", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2477", "pa", "ru", "Панджаби");
INSERT INTO `wp_icl_languages_translations` VALUES("2478", "pa", "sl", "Pandžabščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2479", "pa", "so", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2480", "pa", "sq", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2481", "pa", "sr", "панџаби");
INSERT INTO `wp_icl_languages_translations` VALUES("2482", "pa", "sv", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2483", "pa", "ta", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2484", "pa", "th", "ปัญจาบ");
INSERT INTO `wp_icl_languages_translations` VALUES("2485", "pa", "tr", "Pencapça");
INSERT INTO `wp_icl_languages_translations` VALUES("2486", "pa", "uk", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2487", "pa", "ur", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2488", "pa", "uz", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2489", "pa", "vi", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2490", "pa", "yi", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2491", "pa", "zh-hans", "旁遮普语");
INSERT INTO `wp_icl_languages_translations` VALUES("2492", "pa", "zu", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2493", "pa", "zh-hant", "旁遮普語");
INSERT INTO `wp_icl_languages_translations` VALUES("2494", "pa", "ms", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2495", "pa", "gl", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2496", "pa", "bn", "Punjabi");
INSERT INTO `wp_icl_languages_translations` VALUES("2497", "pl", "en", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2498", "pl", "es", "Polaco");
INSERT INTO `wp_icl_languages_translations` VALUES("2499", "pl", "de", "Polnisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2500", "pl", "fr", "Polonais");
INSERT INTO `wp_icl_languages_translations` VALUES("2501", "pl", "ar", "البولندية");
INSERT INTO `wp_icl_languages_translations` VALUES("2502", "pl", "bs", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2503", "pl", "bg", "Полски");
INSERT INTO `wp_icl_languages_translations` VALUES("2504", "pl", "ca", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2505", "pl", "cs", "Polský");
INSERT INTO `wp_icl_languages_translations` VALUES("2506", "pl", "sk", "Polština");
INSERT INTO `wp_icl_languages_translations` VALUES("2507", "pl", "cy", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2508", "pl", "da", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2509", "pl", "el", "Πολωνικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2510", "pl", "eo", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2511", "pl", "et", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2512", "pl", "eu", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2513", "pl", "fa", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2514", "pl", "fi", "puola");
INSERT INTO `wp_icl_languages_translations` VALUES("2515", "pl", "ga", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2516", "pl", "he", "פולנית");
INSERT INTO `wp_icl_languages_translations` VALUES("2517", "pl", "hi", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2518", "pl", "hr", "Poljski");
INSERT INTO `wp_icl_languages_translations` VALUES("2519", "pl", "hu", "lengyel");
INSERT INTO `wp_icl_languages_translations` VALUES("2520", "pl", "hy", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2521", "pl", "id", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2522", "pl", "is", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2523", "pl", "it", "Polacco");
INSERT INTO `wp_icl_languages_translations` VALUES("2524", "pl", "ja", "ポーランド語");
INSERT INTO `wp_icl_languages_translations` VALUES("2525", "pl", "ko", "폴란드어");
INSERT INTO `wp_icl_languages_translations` VALUES("2526", "pl", "ku", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2527", "pl", "lv", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2528", "pl", "lt", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2529", "pl", "mk", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2530", "pl", "mt", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2531", "pl", "mn", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2532", "pl", "ne", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2533", "pl", "nl", "Pools");
INSERT INTO `wp_icl_languages_translations` VALUES("2534", "pl", "no", "Polsk");
INSERT INTO `wp_icl_languages_translations` VALUES("2535", "pl", "pa", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2536", "pl", "pl", "polski");
INSERT INTO `wp_icl_languages_translations` VALUES("2537", "pl", "pt-pt", "Polonês");
INSERT INTO `wp_icl_languages_translations` VALUES("2538", "pl", "pt-br", "Polonês");
INSERT INTO `wp_icl_languages_translations` VALUES("2539", "pl", "qu", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2540", "pl", "ro", "Poloneză");
INSERT INTO `wp_icl_languages_translations` VALUES("2541", "pl", "ru", "Польский");
INSERT INTO `wp_icl_languages_translations` VALUES("2542", "pl", "sl", "Poljski");
INSERT INTO `wp_icl_languages_translations` VALUES("2543", "pl", "so", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2544", "pl", "sq", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2545", "pl", "sr", "пољски");
INSERT INTO `wp_icl_languages_translations` VALUES("2546", "pl", "sv", "Polska");
INSERT INTO `wp_icl_languages_translations` VALUES("2547", "pl", "ta", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2548", "pl", "th", "โปแลนด์");
INSERT INTO `wp_icl_languages_translations` VALUES("2549", "pl", "tr", "Polonyaca");
INSERT INTO `wp_icl_languages_translations` VALUES("2550", "pl", "uk", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2551", "pl", "ur", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2552", "pl", "uz", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2553", "pl", "vi", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2554", "pl", "yi", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2555", "pl", "zh-hans", "波兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("2556", "pl", "zu", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2557", "pl", "zh-hant", "波蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("2558", "pl", "ms", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2559", "pl", "gl", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2560", "pl", "bn", "Polish");
INSERT INTO `wp_icl_languages_translations` VALUES("2561", "pt-pt", "en", "Portuguese (Portugal)");
INSERT INTO `wp_icl_languages_translations` VALUES("2562", "pt-pt", "es", "Portugués, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2563", "pt-pt", "de", "Portugiesisch, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2564", "pt-pt", "fr", "Portugais - du Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2565", "pt-pt", "ar", "البرتغالية ، البرتغال");
INSERT INTO `wp_icl_languages_translations` VALUES("2566", "pt-pt", "bs", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2567", "pt-pt", "bg", "Португалски (Португалия)");
INSERT INTO `wp_icl_languages_translations` VALUES("2568", "pt-pt", "ca", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2569", "pt-pt", "cs", "Portugalština ( Portugalsko)");
INSERT INTO `wp_icl_languages_translations` VALUES("2570", "pt-pt", "sk", "Portugalština");
INSERT INTO `wp_icl_languages_translations` VALUES("2571", "pt-pt", "cy", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2572", "pt-pt", "da", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2573", "pt-pt", "el", "Πορτογαλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2574", "pt-pt", "eo", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2575", "pt-pt", "et", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2576", "pt-pt", "eu", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2577", "pt-pt", "fa", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2578", "pt-pt", "fi", "portugali");
INSERT INTO `wp_icl_languages_translations` VALUES("2579", "pt-pt", "ga", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2580", "pt-pt", "he", "פורטוגזית");
INSERT INTO `wp_icl_languages_translations` VALUES("2581", "pt-pt", "hi", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2582", "pt-pt", "hr", "Portugalski (Portugal)");
INSERT INTO `wp_icl_languages_translations` VALUES("2583", "pt-pt", "hu", "portugál");
INSERT INTO `wp_icl_languages_translations` VALUES("2584", "pt-pt", "hy", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2585", "pt-pt", "id", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2586", "pt-pt", "is", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2587", "pt-pt", "it", "Portoghese, Portogallo");
INSERT INTO `wp_icl_languages_translations` VALUES("2588", "pt-pt", "ja", "ポルトガル語");
INSERT INTO `wp_icl_languages_translations` VALUES("2589", "pt-pt", "ko", "포르투갈 포르투갈어");
INSERT INTO `wp_icl_languages_translations` VALUES("2590", "pt-pt", "ku", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2591", "pt-pt", "lv", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2592", "pt-pt", "lt", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2593", "pt-pt", "mk", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2594", "pt-pt", "mt", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2595", "pt-pt", "mn", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2596", "pt-pt", "ne", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2597", "pt-pt", "nl", "Portugees, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2598", "pt-pt", "no", "Portugisisk (Portugal)");
INSERT INTO `wp_icl_languages_translations` VALUES("2599", "pt-pt", "pa", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2600", "pt-pt", "pl", "portugalski, Portugalia");
INSERT INTO `wp_icl_languages_translations` VALUES("2601", "pt-pt", "pt-pt", "Português");
INSERT INTO `wp_icl_languages_translations` VALUES("2602", "pt-pt", "pt-br", "Português");
INSERT INTO `wp_icl_languages_translations` VALUES("2603", "pt-pt", "qu", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2604", "pt-pt", "ro", "Portugheză (Portugalia)");
INSERT INTO `wp_icl_languages_translations` VALUES("2605", "pt-pt", "ru", "Португальский, Португалия");
INSERT INTO `wp_icl_languages_translations` VALUES("2606", "pt-pt", "sl", "Portugalščina ( Portugalska )");
INSERT INTO `wp_icl_languages_translations` VALUES("2607", "pt-pt", "so", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2608", "pt-pt", "sq", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2609", "pt-pt", "sr", "Португалски (Португалија)");
INSERT INTO `wp_icl_languages_translations` VALUES("2610", "pt-pt", "sv", "Portugisiska, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2611", "pt-pt", "ta", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2612", "pt-pt", "th", "โปรตุเกส");
INSERT INTO `wp_icl_languages_translations` VALUES("2613", "pt-pt", "tr", "Portekizce, Portekiz");
INSERT INTO `wp_icl_languages_translations` VALUES("2614", "pt-pt", "uk", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2615", "pt-pt", "ur", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2616", "pt-pt", "uz", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2617", "pt-pt", "vi", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2618", "pt-pt", "yi", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2619", "pt-pt", "zh-hans", "葡萄牙语（葡萄牙）");
INSERT INTO `wp_icl_languages_translations` VALUES("2620", "pt-pt", "zu", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2621", "pt-pt", "zh-hant", "葡萄牙語（葡萄牙）");
INSERT INTO `wp_icl_languages_translations` VALUES("2622", "pt-pt", "ms", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2623", "pt-pt", "gl", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2624", "pt-pt", "bn", "Portuguese, Portugal");
INSERT INTO `wp_icl_languages_translations` VALUES("2625", "pt-br", "en", "Portuguese (Brazil)");
INSERT INTO `wp_icl_languages_translations` VALUES("2626", "pt-br", "es", "Portugués, Brasil");
INSERT INTO `wp_icl_languages_translations` VALUES("2627", "pt-br", "de", "Portugiesisch, Brasilien");
INSERT INTO `wp_icl_languages_translations` VALUES("2628", "pt-br", "fr", "Portugais - du Brésil");
INSERT INTO `wp_icl_languages_translations` VALUES("2629", "pt-br", "ar", "البرتغالية ،البرازيل");
INSERT INTO `wp_icl_languages_translations` VALUES("2630", "pt-br", "bs", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2631", "pt-br", "bg", "Португалски (Бразилия)");
INSERT INTO `wp_icl_languages_translations` VALUES("2632", "pt-br", "ca", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2633", "pt-br", "cs", "Portugalština ( Brazílie)");
INSERT INTO `wp_icl_languages_translations` VALUES("2634", "pt-br", "sk", "Brazílska Portugalština");
INSERT INTO `wp_icl_languages_translations` VALUES("2635", "pt-br", "cy", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2636", "pt-br", "da", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2637", "pt-br", "el", "Πορτογαλικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2638", "pt-br", "eo", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2639", "pt-br", "et", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2640", "pt-br", "eu", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2641", "pt-br", "fa", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2642", "pt-br", "fi", "Brasilian portugali");
INSERT INTO `wp_icl_languages_translations` VALUES("2643", "pt-br", "ga", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2644", "pt-br", "he", "פורטוגזית - ברזיל");
INSERT INTO `wp_icl_languages_translations` VALUES("2645", "pt-br", "hi", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2646", "pt-br", "hr", "Portugalski (Brazil)");
INSERT INTO `wp_icl_languages_translations` VALUES("2647", "pt-br", "hu", "brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2648", "pt-br", "hy", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2649", "pt-br", "id", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2650", "pt-br", "is", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2651", "pt-br", "it", "Portoghese, Brasile");
INSERT INTO `wp_icl_languages_translations` VALUES("2652", "pt-br", "ja", "ポルトガル語（ブラジル）");
INSERT INTO `wp_icl_languages_translations` VALUES("2653", "pt-br", "ko", "브라질 포르투갈어");
INSERT INTO `wp_icl_languages_translations` VALUES("2654", "pt-br", "ku", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2655", "pt-br", "lv", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2656", "pt-br", "lt", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2657", "pt-br", "mk", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2658", "pt-br", "mt", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2659", "pt-br", "mn", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2660", "pt-br", "ne", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2661", "pt-br", "nl", "Portugees, Brazilië");
INSERT INTO `wp_icl_languages_translations` VALUES("2662", "pt-br", "no", "Portugisisk (Brasil)");
INSERT INTO `wp_icl_languages_translations` VALUES("2663", "pt-br", "pa", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2664", "pt-br", "pl", "portugalski, Brazylia");
INSERT INTO `wp_icl_languages_translations` VALUES("2665", "pt-br", "pt-pt", "Português");
INSERT INTO `wp_icl_languages_translations` VALUES("2666", "pt-br", "pt-br", "Português");
INSERT INTO `wp_icl_languages_translations` VALUES("2667", "pt-br", "qu", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2668", "pt-br", "ro", "Portugheză (Brazilia)");
INSERT INTO `wp_icl_languages_translations` VALUES("2669", "pt-br", "ru", "Португальский, Бразилия");
INSERT INTO `wp_icl_languages_translations` VALUES("2670", "pt-br", "sl", "Portugalščina ( Brazilija )");
INSERT INTO `wp_icl_languages_translations` VALUES("2671", "pt-br", "so", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2672", "pt-br", "sq", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2673", "pt-br", "sr", "Португалски (Бразил)");
INSERT INTO `wp_icl_languages_translations` VALUES("2674", "pt-br", "sv", "Portugisiska, Brasilien");
INSERT INTO `wp_icl_languages_translations` VALUES("2675", "pt-br", "ta", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2676", "pt-br", "th", "โปรตุเกสบราซิล");
INSERT INTO `wp_icl_languages_translations` VALUES("2677", "pt-br", "tr", "Portekizce, Brezilya");
INSERT INTO `wp_icl_languages_translations` VALUES("2678", "pt-br", "uk", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2679", "pt-br", "ur", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2680", "pt-br", "uz", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2681", "pt-br", "vi", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2682", "pt-br", "yi", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2683", "pt-br", "zh-hans", "葡萄牙语（巴西）");
INSERT INTO `wp_icl_languages_translations` VALUES("2684", "pt-br", "zu", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2685", "pt-br", "zh-hant", "葡萄牙語（巴西）");
INSERT INTO `wp_icl_languages_translations` VALUES("2686", "pt-br", "ms", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2687", "pt-br", "gl", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2688", "pt-br", "bn", "Portuguese, Brazil");
INSERT INTO `wp_icl_languages_translations` VALUES("2689", "qu", "en", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2690", "qu", "es", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2691", "qu", "de", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2692", "qu", "fr", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2693", "qu", "ar", "الكويتشوا");
INSERT INTO `wp_icl_languages_translations` VALUES("2694", "qu", "bs", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2695", "qu", "bg", "Кечуа");
INSERT INTO `wp_icl_languages_translations` VALUES("2696", "qu", "ca", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2697", "qu", "cs", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2698", "qu", "sk", "Jazyk Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2699", "qu", "cy", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2700", "qu", "da", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2701", "qu", "el", "Κετσουα");
INSERT INTO `wp_icl_languages_translations` VALUES("2702", "qu", "eo", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2703", "qu", "et", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2704", "qu", "eu", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2705", "qu", "fa", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2706", "qu", "fi", "ketsua");
INSERT INTO `wp_icl_languages_translations` VALUES("2707", "qu", "ga", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2708", "qu", "he", "קצ\'ואה");
INSERT INTO `wp_icl_languages_translations` VALUES("2709", "qu", "hi", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2710", "qu", "hr", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2711", "qu", "hu", "quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2712", "qu", "hy", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2713", "qu", "id", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2714", "qu", "is", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2715", "qu", "it", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2716", "qu", "ja", "ケチュア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2717", "qu", "ko", "케추아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2718", "qu", "ku", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2719", "qu", "lv", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2720", "qu", "lt", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2721", "qu", "mk", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2722", "qu", "mt", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2723", "qu", "mn", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2724", "qu", "ne", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2725", "qu", "nl", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2726", "qu", "no", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2727", "qu", "pa", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2728", "qu", "pl", "keczua");
INSERT INTO `wp_icl_languages_translations` VALUES("2729", "qu", "pt-pt", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2730", "qu", "pt-br", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2731", "qu", "qu", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2732", "qu", "ro", "Quechuană");
INSERT INTO `wp_icl_languages_translations` VALUES("2733", "qu", "ru", "Кечуа");
INSERT INTO `wp_icl_languages_translations` VALUES("2734", "qu", "sl", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2735", "qu", "so", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2736", "qu", "sq", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2737", "qu", "sr", "Кечуа");
INSERT INTO `wp_icl_languages_translations` VALUES("2738", "qu", "sv", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2739", "qu", "ta", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2740", "qu", "th", "คิวชัว");
INSERT INTO `wp_icl_languages_translations` VALUES("2741", "qu", "tr", "Quechua dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2742", "qu", "uk", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2743", "qu", "ur", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2744", "qu", "uz", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2745", "qu", "vi", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2746", "qu", "yi", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2747", "qu", "zh-hans", "盖丘亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("2748", "qu", "zu", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2749", "qu", "zh-hant", "蓋丘亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("2750", "qu", "ms", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2751", "qu", "gl", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2752", "qu", "bn", "Quechua");
INSERT INTO `wp_icl_languages_translations` VALUES("2753", "ro", "en", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2754", "ro", "es", "Rumano");
INSERT INTO `wp_icl_languages_translations` VALUES("2755", "ro", "de", "Rumänisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2756", "ro", "fr", "Roumain");
INSERT INTO `wp_icl_languages_translations` VALUES("2757", "ro", "ar", "الرومانية");
INSERT INTO `wp_icl_languages_translations` VALUES("2758", "ro", "bs", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2759", "ro", "bg", "Румънски");
INSERT INTO `wp_icl_languages_translations` VALUES("2760", "ro", "ca", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2761", "ro", "cs", "Rumunština");
INSERT INTO `wp_icl_languages_translations` VALUES("2762", "ro", "sk", "Rumunčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2763", "ro", "cy", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2764", "ro", "da", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2765", "ro", "el", "Ρουμανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2766", "ro", "eo", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2767", "ro", "et", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2768", "ro", "eu", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2769", "ro", "fa", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2770", "ro", "fi", "romania");
INSERT INTO `wp_icl_languages_translations` VALUES("2771", "ro", "ga", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2772", "ro", "he", "רומנית");
INSERT INTO `wp_icl_languages_translations` VALUES("2773", "ro", "hi", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2774", "ro", "hr", "Rumunjski");
INSERT INTO `wp_icl_languages_translations` VALUES("2775", "ro", "hu", "román");
INSERT INTO `wp_icl_languages_translations` VALUES("2776", "ro", "hy", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2777", "ro", "id", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2778", "ro", "is", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2779", "ro", "it", "Rumeno");
INSERT INTO `wp_icl_languages_translations` VALUES("2780", "ro", "ja", "ルーマニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2781", "ro", "ko", "로마니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2782", "ro", "ku", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2783", "ro", "lv", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2784", "ro", "lt", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2785", "ro", "mk", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2786", "ro", "mt", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2787", "ro", "mn", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2788", "ro", "ne", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2789", "ro", "nl", "Roemeens");
INSERT INTO `wp_icl_languages_translations` VALUES("2790", "ro", "no", "Rumensk");
INSERT INTO `wp_icl_languages_translations` VALUES("2791", "ro", "pa", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2792", "ro", "pl", "rumuński");
INSERT INTO `wp_icl_languages_translations` VALUES("2793", "ro", "pt-pt", "Romeno");
INSERT INTO `wp_icl_languages_translations` VALUES("2794", "ro", "pt-br", "Romeno");
INSERT INTO `wp_icl_languages_translations` VALUES("2795", "ro", "qu", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2796", "ro", "ro", "Română");
INSERT INTO `wp_icl_languages_translations` VALUES("2797", "ro", "ru", "Румынский");
INSERT INTO `wp_icl_languages_translations` VALUES("2798", "ro", "sl", "Romunščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2799", "ro", "so", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2800", "ro", "sq", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2801", "ro", "sr", "румунски");
INSERT INTO `wp_icl_languages_translations` VALUES("2802", "ro", "sv", "Rumänska");
INSERT INTO `wp_icl_languages_translations` VALUES("2803", "ro", "ta", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2804", "ro", "th", "โรมาเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2805", "ro", "tr", "Rumence");
INSERT INTO `wp_icl_languages_translations` VALUES("2806", "ro", "uk", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2807", "ro", "ur", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2808", "ro", "uz", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2809", "ro", "vi", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2810", "ro", "yi", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2811", "ro", "zh-hans", "罗马尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("2812", "ro", "zu", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2813", "ro", "zh-hant", "羅馬尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("2814", "ro", "ms", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2815", "ro", "gl", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2816", "ro", "bn", "Romanian");
INSERT INTO `wp_icl_languages_translations` VALUES("2817", "ru", "en", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2818", "ru", "es", "Ruso");
INSERT INTO `wp_icl_languages_translations` VALUES("2819", "ru", "de", "Russisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2820", "ru", "fr", "Russe");
INSERT INTO `wp_icl_languages_translations` VALUES("2821", "ru", "ar", "الروسية");
INSERT INTO `wp_icl_languages_translations` VALUES("2822", "ru", "bs", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2823", "ru", "bg", "Руски");
INSERT INTO `wp_icl_languages_translations` VALUES("2824", "ru", "ca", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2825", "ru", "cs", "Ruský");
INSERT INTO `wp_icl_languages_translations` VALUES("2826", "ru", "sk", "Ruština");
INSERT INTO `wp_icl_languages_translations` VALUES("2827", "ru", "cy", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2828", "ru", "da", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2829", "ru", "el", "Ρωσικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2830", "ru", "eo", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2831", "ru", "et", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2832", "ru", "eu", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2833", "ru", "fa", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2834", "ru", "fi", "venäjä");
INSERT INTO `wp_icl_languages_translations` VALUES("2835", "ru", "ga", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2836", "ru", "he", "רוסית");
INSERT INTO `wp_icl_languages_translations` VALUES("2837", "ru", "hi", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2838", "ru", "hr", "Ruski");
INSERT INTO `wp_icl_languages_translations` VALUES("2839", "ru", "hu", "orosz");
INSERT INTO `wp_icl_languages_translations` VALUES("2840", "ru", "hy", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2841", "ru", "id", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2842", "ru", "is", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2843", "ru", "it", "Russo");
INSERT INTO `wp_icl_languages_translations` VALUES("2844", "ru", "ja", "ロシア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2845", "ru", "ko", "러시아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2846", "ru", "ku", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2847", "ru", "lv", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2848", "ru", "lt", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2849", "ru", "mk", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2850", "ru", "mt", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2851", "ru", "mn", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2852", "ru", "ne", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2853", "ru", "nl", "Russisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2854", "ru", "no", "Russisk");
INSERT INTO `wp_icl_languages_translations` VALUES("2855", "ru", "pa", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2856", "ru", "pl", "rosyjski");
INSERT INTO `wp_icl_languages_translations` VALUES("2857", "ru", "pt-pt", "Russo");
INSERT INTO `wp_icl_languages_translations` VALUES("2858", "ru", "pt-br", "Russo");
INSERT INTO `wp_icl_languages_translations` VALUES("2859", "ru", "qu", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2860", "ru", "ro", "Rusă");
INSERT INTO `wp_icl_languages_translations` VALUES("2861", "ru", "ru", "Русский");
INSERT INTO `wp_icl_languages_translations` VALUES("2862", "ru", "sl", "Ruščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2863", "ru", "so", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2864", "ru", "sq", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2865", "ru", "sr", "руски");
INSERT INTO `wp_icl_languages_translations` VALUES("2866", "ru", "sv", "Ryska");
INSERT INTO `wp_icl_languages_translations` VALUES("2867", "ru", "ta", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2868", "ru", "th", "รัสเซีย");
INSERT INTO `wp_icl_languages_translations` VALUES("2869", "ru", "tr", "Rusça");
INSERT INTO `wp_icl_languages_translations` VALUES("2870", "ru", "uk", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2871", "ru", "ur", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2872", "ru", "uz", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2873", "ru", "vi", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2874", "ru", "yi", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2875", "ru", "zh-hans", "俄语");
INSERT INTO `wp_icl_languages_translations` VALUES("2876", "ru", "zu", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2877", "ru", "zh-hant", "俄語");
INSERT INTO `wp_icl_languages_translations` VALUES("2878", "ru", "ms", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2879", "ru", "gl", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2880", "ru", "bn", "Russian");
INSERT INTO `wp_icl_languages_translations` VALUES("2881", "sl", "en", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2882", "sl", "es", "Esloveno");
INSERT INTO `wp_icl_languages_translations` VALUES("2883", "sl", "de", "Slowenisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2884", "sl", "fr", "Slovène");
INSERT INTO `wp_icl_languages_translations` VALUES("2885", "sl", "ar", "السلوفانية");
INSERT INTO `wp_icl_languages_translations` VALUES("2886", "sl", "bs", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2887", "sl", "bg", "Словенски");
INSERT INTO `wp_icl_languages_translations` VALUES("2888", "sl", "ca", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2889", "sl", "cs", "Slovinština");
INSERT INTO `wp_icl_languages_translations` VALUES("2890", "sl", "sk", "Slovinčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2891", "sl", "cy", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2892", "sl", "da", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2893", "sl", "el", "Σλοβενικα");
INSERT INTO `wp_icl_languages_translations` VALUES("2894", "sl", "eo", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2895", "sl", "et", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2896", "sl", "eu", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2897", "sl", "fa", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2898", "sl", "fi", "sloveeni");
INSERT INTO `wp_icl_languages_translations` VALUES("2899", "sl", "ga", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2900", "sl", "he", "סלובנית");
INSERT INTO `wp_icl_languages_translations` VALUES("2901", "sl", "hi", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2902", "sl", "hr", "Slovenac");
INSERT INTO `wp_icl_languages_translations` VALUES("2903", "sl", "hu", "szlovén");
INSERT INTO `wp_icl_languages_translations` VALUES("2904", "sl", "hy", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2905", "sl", "id", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2906", "sl", "is", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2907", "sl", "it", "Sloveno");
INSERT INTO `wp_icl_languages_translations` VALUES("2908", "sl", "ja", "スロベニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("2909", "sl", "ko", "슬로베니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2910", "sl", "ku", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2911", "sl", "lv", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2912", "sl", "lt", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2913", "sl", "mk", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2914", "sl", "mt", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2915", "sl", "mn", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2916", "sl", "ne", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2917", "sl", "nl", "Sloveens");
INSERT INTO `wp_icl_languages_translations` VALUES("2918", "sl", "no", "Slovensk");
INSERT INTO `wp_icl_languages_translations` VALUES("2919", "sl", "pa", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2920", "sl", "pl", "słoweński");
INSERT INTO `wp_icl_languages_translations` VALUES("2921", "sl", "pt-pt", "Esloveno");
INSERT INTO `wp_icl_languages_translations` VALUES("2922", "sl", "pt-br", "Esloveno");
INSERT INTO `wp_icl_languages_translations` VALUES("2923", "sl", "qu", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2924", "sl", "ro", "Slovenă");
INSERT INTO `wp_icl_languages_translations` VALUES("2925", "sl", "ru", "Словенский");
INSERT INTO `wp_icl_languages_translations` VALUES("2926", "sl", "sl", "Slovenščina");
INSERT INTO `wp_icl_languages_translations` VALUES("2927", "sl", "so", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2928", "sl", "sq", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2929", "sl", "sr", "словеначки");
INSERT INTO `wp_icl_languages_translations` VALUES("2930", "sl", "sv", "Slovenska");
INSERT INTO `wp_icl_languages_translations` VALUES("2931", "sl", "ta", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2932", "sl", "th", "สโลวีเนียน");
INSERT INTO `wp_icl_languages_translations` VALUES("2933", "sl", "tr", "Sloven dili");
INSERT INTO `wp_icl_languages_translations` VALUES("2934", "sl", "uk", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2935", "sl", "ur", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2936", "sl", "uz", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2937", "sl", "vi", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2938", "sl", "yi", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2939", "sl", "zh-hans", "斯洛文尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("2940", "sl", "zu", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2941", "sl", "zh-hant", "斯洛文尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("2942", "sl", "ms", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2943", "sl", "gl", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2944", "sl", "bn", "Slovenian");
INSERT INTO `wp_icl_languages_translations` VALUES("2945", "so", "en", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2946", "so", "es", "Somalí");
INSERT INTO `wp_icl_languages_translations` VALUES("2947", "so", "de", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2948", "so", "fr", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2949", "so", "ar", "الصومالية");
INSERT INTO `wp_icl_languages_translations` VALUES("2950", "so", "bs", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2951", "so", "bg", "Сомалийски");
INSERT INTO `wp_icl_languages_translations` VALUES("2952", "so", "ca", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2953", "so", "cs", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2954", "so", "sk", "Somálčina");
INSERT INTO `wp_icl_languages_translations` VALUES("2955", "so", "cy", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2956", "so", "da", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2957", "so", "el", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2958", "so", "eo", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2959", "so", "et", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2960", "so", "eu", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2961", "so", "fa", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2962", "so", "fi", "somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2963", "so", "ga", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2964", "so", "he", "סומלית");
INSERT INTO `wp_icl_languages_translations` VALUES("2965", "so", "hi", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2966", "so", "hr", "Somalijski");
INSERT INTO `wp_icl_languages_translations` VALUES("2967", "so", "hu", "szomáli");
INSERT INTO `wp_icl_languages_translations` VALUES("2968", "so", "hy", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2969", "so", "id", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2970", "so", "is", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2971", "so", "it", "Somalo");
INSERT INTO `wp_icl_languages_translations` VALUES("2972", "so", "ja", "ソマリ語");
INSERT INTO `wp_icl_languages_translations` VALUES("2973", "so", "ko", "소말리아어");
INSERT INTO `wp_icl_languages_translations` VALUES("2974", "so", "ku", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2975", "so", "lv", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2976", "so", "lt", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2977", "so", "mk", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2978", "so", "mt", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2979", "so", "mn", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2980", "so", "ne", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2981", "so", "nl", "Somalisch");
INSERT INTO `wp_icl_languages_translations` VALUES("2982", "so", "no", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2983", "so", "pa", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2984", "so", "pl", "somalijski");
INSERT INTO `wp_icl_languages_translations` VALUES("2985", "so", "pt-pt", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2986", "so", "pt-br", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2987", "so", "qu", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2988", "so", "ro", "Somaleză");
INSERT INTO `wp_icl_languages_translations` VALUES("2989", "so", "ru", "Сомалийский");
INSERT INTO `wp_icl_languages_translations` VALUES("2990", "so", "sl", "Somalski");
INSERT INTO `wp_icl_languages_translations` VALUES("2991", "so", "so", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2992", "so", "sq", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2993", "so", "sr", "Сомалијски");
INSERT INTO `wp_icl_languages_translations` VALUES("2994", "so", "sv", "Somaliska");
INSERT INTO `wp_icl_languages_translations` VALUES("2995", "so", "ta", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2996", "so", "th", "โซมาลี");
INSERT INTO `wp_icl_languages_translations` VALUES("2997", "so", "tr", "Somalice");
INSERT INTO `wp_icl_languages_translations` VALUES("2998", "so", "uk", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("2999", "so", "ur", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3000", "so", "uz", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3001", "so", "vi", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3002", "so", "yi", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3003", "so", "zh-hans", "索马里语");
INSERT INTO `wp_icl_languages_translations` VALUES("3004", "so", "zu", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3005", "so", "zh-hant", "索馬里語");
INSERT INTO `wp_icl_languages_translations` VALUES("3006", "so", "ms", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3007", "so", "gl", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3008", "so", "bn", "Somali");
INSERT INTO `wp_icl_languages_translations` VALUES("3009", "sq", "en", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3010", "sq", "es", "Albanés");
INSERT INTO `wp_icl_languages_translations` VALUES("3011", "sq", "de", "Albanisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3012", "sq", "fr", "Albanais");
INSERT INTO `wp_icl_languages_translations` VALUES("3013", "sq", "ar", "الألبانية");
INSERT INTO `wp_icl_languages_translations` VALUES("3014", "sq", "bs", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3015", "sq", "bg", "Албански");
INSERT INTO `wp_icl_languages_translations` VALUES("3016", "sq", "ca", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3017", "sq", "cs", "Albánský");
INSERT INTO `wp_icl_languages_translations` VALUES("3018", "sq", "sk", "Albánčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3019", "sq", "cy", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3020", "sq", "da", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3021", "sq", "el", "Αλβανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3022", "sq", "eo", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3023", "sq", "et", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3024", "sq", "eu", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3025", "sq", "fa", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3026", "sq", "fi", "albania");
INSERT INTO `wp_icl_languages_translations` VALUES("3027", "sq", "ga", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3028", "sq", "he", "אלבנית");
INSERT INTO `wp_icl_languages_translations` VALUES("3029", "sq", "hi", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3030", "sq", "hr", "Albanac");
INSERT INTO `wp_icl_languages_translations` VALUES("3031", "sq", "hu", "albán");
INSERT INTO `wp_icl_languages_translations` VALUES("3032", "sq", "hy", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3033", "sq", "id", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3034", "sq", "is", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3035", "sq", "it", "Albanese");
INSERT INTO `wp_icl_languages_translations` VALUES("3036", "sq", "ja", "アルバニア語");
INSERT INTO `wp_icl_languages_translations` VALUES("3037", "sq", "ko", "알바니아어");
INSERT INTO `wp_icl_languages_translations` VALUES("3038", "sq", "ku", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3039", "sq", "lv", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3040", "sq", "lt", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3041", "sq", "mk", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3042", "sq", "mt", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3043", "sq", "mn", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3044", "sq", "ne", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3045", "sq", "nl", "Albaans");
INSERT INTO `wp_icl_languages_translations` VALUES("3046", "sq", "no", "Albansk");
INSERT INTO `wp_icl_languages_translations` VALUES("3047", "sq", "pa", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3048", "sq", "pl", "albański");
INSERT INTO `wp_icl_languages_translations` VALUES("3049", "sq", "pt-pt", "Albanês");
INSERT INTO `wp_icl_languages_translations` VALUES("3050", "sq", "pt-br", "Albanês");
INSERT INTO `wp_icl_languages_translations` VALUES("3051", "sq", "qu", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3052", "sq", "ro", "Albaneză");
INSERT INTO `wp_icl_languages_translations` VALUES("3053", "sq", "ru", "Албанский");
INSERT INTO `wp_icl_languages_translations` VALUES("3054", "sq", "sl", "Albanski");
INSERT INTO `wp_icl_languages_translations` VALUES("3055", "sq", "so", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3056", "sq", "sq", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3057", "sq", "sr", "албански");
INSERT INTO `wp_icl_languages_translations` VALUES("3058", "sq", "sv", "Albanska");
INSERT INTO `wp_icl_languages_translations` VALUES("3059", "sq", "ta", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3060", "sq", "th", "อัลเบเนีย");
INSERT INTO `wp_icl_languages_translations` VALUES("3061", "sq", "tr", "Arnavutça");
INSERT INTO `wp_icl_languages_translations` VALUES("3062", "sq", "uk", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3063", "sq", "ur", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3064", "sq", "uz", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3065", "sq", "vi", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3066", "sq", "yi", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3067", "sq", "zh-hans", "阿尔巴尼亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("3068", "sq", "zu", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3069", "sq", "zh-hant", "阿爾巴尼亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("3070", "sq", "ms", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3071", "sq", "gl", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3072", "sq", "bn", "Albanian");
INSERT INTO `wp_icl_languages_translations` VALUES("3073", "sr", "en", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3074", "sr", "es", "Serbio");
INSERT INTO `wp_icl_languages_translations` VALUES("3075", "sr", "de", "Serbisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3076", "sr", "fr", "Serbe");
INSERT INTO `wp_icl_languages_translations` VALUES("3077", "sr", "ar", "الصربية");
INSERT INTO `wp_icl_languages_translations` VALUES("3078", "sr", "bs", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3079", "sr", "bg", "Сръбски");
INSERT INTO `wp_icl_languages_translations` VALUES("3080", "sr", "ca", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3081", "sr", "cs", "Srbský");
INSERT INTO `wp_icl_languages_translations` VALUES("3082", "sr", "sk", "Srbština");
INSERT INTO `wp_icl_languages_translations` VALUES("3083", "sr", "cy", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3084", "sr", "da", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3085", "sr", "el", "Σερβικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3086", "sr", "eo", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3087", "sr", "et", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3088", "sr", "eu", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3089", "sr", "fa", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3090", "sr", "fi", "serbia");
INSERT INTO `wp_icl_languages_translations` VALUES("3091", "sr", "ga", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3092", "sr", "he", "סרבית");
INSERT INTO `wp_icl_languages_translations` VALUES("3093", "sr", "hi", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3094", "sr", "hr", "Srpski");
INSERT INTO `wp_icl_languages_translations` VALUES("3095", "sr", "hu", "szerb");
INSERT INTO `wp_icl_languages_translations` VALUES("3096", "sr", "hy", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3097", "sr", "id", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3098", "sr", "is", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3099", "sr", "it", "Serbo");
INSERT INTO `wp_icl_languages_translations` VALUES("3100", "sr", "ja", "セルビア語");
INSERT INTO `wp_icl_languages_translations` VALUES("3101", "sr", "ko", "세르비아어");
INSERT INTO `wp_icl_languages_translations` VALUES("3102", "sr", "ku", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3103", "sr", "lv", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3104", "sr", "lt", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3105", "sr", "mk", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3106", "sr", "mt", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3107", "sr", "mn", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3108", "sr", "ne", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3109", "sr", "nl", "Servisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3110", "sr", "no", "Serbisk");
INSERT INTO `wp_icl_languages_translations` VALUES("3111", "sr", "pa", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3112", "sr", "pl", "serbski");
INSERT INTO `wp_icl_languages_translations` VALUES("3113", "sr", "pt-pt", "Sérvio");
INSERT INTO `wp_icl_languages_translations` VALUES("3114", "sr", "pt-br", "Sérvio");
INSERT INTO `wp_icl_languages_translations` VALUES("3115", "sr", "qu", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3116", "sr", "ro", "Sârbă");
INSERT INTO `wp_icl_languages_translations` VALUES("3117", "sr", "ru", "Сербский");
INSERT INTO `wp_icl_languages_translations` VALUES("3118", "sr", "sl", "Srbski");
INSERT INTO `wp_icl_languages_translations` VALUES("3119", "sr", "so", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3120", "sr", "sq", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3121", "sr", "sr", "српски");
INSERT INTO `wp_icl_languages_translations` VALUES("3122", "sr", "sv", "Serbiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3123", "sr", "ta", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3124", "sr", "th", "เซอร์เบีย");
INSERT INTO `wp_icl_languages_translations` VALUES("3125", "sr", "tr", "Sırpça");
INSERT INTO `wp_icl_languages_translations` VALUES("3126", "sr", "uk", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3127", "sr", "ur", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3128", "sr", "uz", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3129", "sr", "vi", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3130", "sr", "yi", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3131", "sr", "zh-hans", "赛尔维亚语");
INSERT INTO `wp_icl_languages_translations` VALUES("3132", "sr", "zu", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3133", "sr", "zh-hant", "賽爾維亞語");
INSERT INTO `wp_icl_languages_translations` VALUES("3134", "sr", "ms", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3135", "sr", "gl", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3136", "sr", "bn", "Serbian");
INSERT INTO `wp_icl_languages_translations` VALUES("3137", "sv", "en", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3138", "sv", "es", "Sueco");
INSERT INTO `wp_icl_languages_translations` VALUES("3139", "sv", "de", "Schwedisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3140", "sv", "fr", "Suédois");
INSERT INTO `wp_icl_languages_translations` VALUES("3141", "sv", "ar", "السويدية");
INSERT INTO `wp_icl_languages_translations` VALUES("3142", "sv", "bs", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3143", "sv", "bg", "Шведски");
INSERT INTO `wp_icl_languages_translations` VALUES("3144", "sv", "ca", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3145", "sv", "cs", "Švédský");
INSERT INTO `wp_icl_languages_translations` VALUES("3146", "sv", "sk", "Švédština");
INSERT INTO `wp_icl_languages_translations` VALUES("3147", "sv", "cy", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3148", "sv", "da", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3149", "sv", "el", "Σουηδικη");
INSERT INTO `wp_icl_languages_translations` VALUES("3150", "sv", "eo", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3151", "sv", "et", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3152", "sv", "eu", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3153", "sv", "fa", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3154", "sv", "fi", "ruotsi");
INSERT INTO `wp_icl_languages_translations` VALUES("3155", "sv", "ga", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3156", "sv", "he", "שוודית");
INSERT INTO `wp_icl_languages_translations` VALUES("3157", "sv", "hi", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3158", "sv", "hr", "švedski");
INSERT INTO `wp_icl_languages_translations` VALUES("3159", "sv", "hu", "svéd");
INSERT INTO `wp_icl_languages_translations` VALUES("3160", "sv", "hy", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3161", "sv", "id", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3162", "sv", "is", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3163", "sv", "it", "Svedese");
INSERT INTO `wp_icl_languages_translations` VALUES("3164", "sv", "ja", "スウェーデン語");
INSERT INTO `wp_icl_languages_translations` VALUES("3165", "sv", "ko", "스웨덴어");
INSERT INTO `wp_icl_languages_translations` VALUES("3166", "sv", "ku", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3167", "sv", "lv", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3168", "sv", "lt", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3169", "sv", "mk", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3170", "sv", "mt", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3171", "sv", "mn", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3172", "sv", "ne", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3173", "sv", "nl", "Zweeds");
INSERT INTO `wp_icl_languages_translations` VALUES("3174", "sv", "no", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3175", "sv", "pa", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3176", "sv", "pl", "szwedzki");
INSERT INTO `wp_icl_languages_translations` VALUES("3177", "sv", "pt-pt", "Sueco");
INSERT INTO `wp_icl_languages_translations` VALUES("3178", "sv", "pt-br", "Sueco");
INSERT INTO `wp_icl_languages_translations` VALUES("3179", "sv", "qu", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3180", "sv", "ro", "Suedeză");
INSERT INTO `wp_icl_languages_translations` VALUES("3181", "sv", "ru", "Шведский");
INSERT INTO `wp_icl_languages_translations` VALUES("3182", "sv", "sl", "Švedščina");
INSERT INTO `wp_icl_languages_translations` VALUES("3183", "sv", "so", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3184", "sv", "sq", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3185", "sv", "sr", "шведски");
INSERT INTO `wp_icl_languages_translations` VALUES("3186", "sv", "sv", "Svenska");
INSERT INTO `wp_icl_languages_translations` VALUES("3187", "sv", "ta", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3188", "sv", "th", "สวีเดน");
INSERT INTO `wp_icl_languages_translations` VALUES("3189", "sv", "tr", "İsveççe");
INSERT INTO `wp_icl_languages_translations` VALUES("3190", "sv", "uk", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3191", "sv", "ur", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3192", "sv", "uz", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3193", "sv", "vi", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3194", "sv", "yi", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3195", "sv", "zh-hans", "瑞典语");
INSERT INTO `wp_icl_languages_translations` VALUES("3196", "sv", "zu", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3197", "sv", "zh-hant", "瑞典語");
INSERT INTO `wp_icl_languages_translations` VALUES("3198", "sv", "ms", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3199", "sv", "gl", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3200", "sv", "bn", "Swedish");
INSERT INTO `wp_icl_languages_translations` VALUES("3201", "ta", "en", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3202", "ta", "es", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3203", "ta", "de", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3204", "ta", "fr", "Tamoul");
INSERT INTO `wp_icl_languages_translations` VALUES("3205", "ta", "ar", "التاميلية");
INSERT INTO `wp_icl_languages_translations` VALUES("3206", "ta", "bs", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3207", "ta", "bg", "Тамилски");
INSERT INTO `wp_icl_languages_translations` VALUES("3208", "ta", "ca", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3209", "ta", "cs", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3210", "ta", "sk", "Tamilčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3211", "ta", "cy", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3212", "ta", "da", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3213", "ta", "el", "Ταμιλ");
INSERT INTO `wp_icl_languages_translations` VALUES("3214", "ta", "eo", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3215", "ta", "et", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3216", "ta", "eu", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3217", "ta", "fa", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3218", "ta", "fi", "tamili");
INSERT INTO `wp_icl_languages_translations` VALUES("3219", "ta", "ga", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3220", "ta", "he", "טמילית");
INSERT INTO `wp_icl_languages_translations` VALUES("3221", "ta", "hi", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3222", "ta", "hr", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3223", "ta", "hu", "tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3224", "ta", "hy", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3225", "ta", "id", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3226", "ta", "is", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3227", "ta", "it", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3228", "ta", "ja", "タミル語");
INSERT INTO `wp_icl_languages_translations` VALUES("3229", "ta", "ko", "타밀어");
INSERT INTO `wp_icl_languages_translations` VALUES("3230", "ta", "ku", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3231", "ta", "lv", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3232", "ta", "lt", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3233", "ta", "mk", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3234", "ta", "mt", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3235", "ta", "mn", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3236", "ta", "ne", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3237", "ta", "nl", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3238", "ta", "no", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3239", "ta", "pa", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3240", "ta", "pl", "tamilski");
INSERT INTO `wp_icl_languages_translations` VALUES("3241", "ta", "pt-pt", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3242", "ta", "pt-br", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3243", "ta", "qu", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3244", "ta", "ro", "Tamilă");
INSERT INTO `wp_icl_languages_translations` VALUES("3245", "ta", "ru", "Тамильский");
INSERT INTO `wp_icl_languages_translations` VALUES("3246", "ta", "sl", "Tamilščina");
INSERT INTO `wp_icl_languages_translations` VALUES("3247", "ta", "so", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3248", "ta", "sq", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3249", "ta", "sr", "тамилски");
INSERT INTO `wp_icl_languages_translations` VALUES("3250", "ta", "sv", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3251", "ta", "ta", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3252", "ta", "th", "ทมิฬ");
INSERT INTO `wp_icl_languages_translations` VALUES("3253", "ta", "tr", "Tamil dili");
INSERT INTO `wp_icl_languages_translations` VALUES("3254", "ta", "uk", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3255", "ta", "ur", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3256", "ta", "uz", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3257", "ta", "vi", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3258", "ta", "yi", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3259", "ta", "zh-hans", "泰米尔语");
INSERT INTO `wp_icl_languages_translations` VALUES("3260", "ta", "zu", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3261", "ta", "zh-hant", "泰米爾語");
INSERT INTO `wp_icl_languages_translations` VALUES("3262", "ta", "ms", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3263", "ta", "gl", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3264", "ta", "bn", "Tamil");
INSERT INTO `wp_icl_languages_translations` VALUES("3265", "th", "en", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3266", "th", "es", "Tailandés");
INSERT INTO `wp_icl_languages_translations` VALUES("3267", "th", "de", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3268", "th", "fr", "Thaï");
INSERT INTO `wp_icl_languages_translations` VALUES("3269", "th", "ar", "التايلندية");
INSERT INTO `wp_icl_languages_translations` VALUES("3270", "th", "bs", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3271", "th", "bg", "Тайски");
INSERT INTO `wp_icl_languages_translations` VALUES("3272", "th", "ca", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3273", "th", "cs", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3274", "th", "sk", "Thajština");
INSERT INTO `wp_icl_languages_translations` VALUES("3275", "th", "cy", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3276", "th", "da", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3277", "th", "el", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3278", "th", "eo", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3279", "th", "et", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3280", "th", "eu", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3281", "th", "fa", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3282", "th", "fi", "thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3283", "th", "ga", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3284", "th", "he", "תאילנדית");
INSERT INTO `wp_icl_languages_translations` VALUES("3285", "th", "hi", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3286", "th", "hr", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3287", "th", "hu", "tájföldi");
INSERT INTO `wp_icl_languages_translations` VALUES("3288", "th", "hy", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3289", "th", "id", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3290", "th", "is", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3291", "th", "it", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3292", "th", "ja", "タイ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3293", "th", "ko", "태국어");
INSERT INTO `wp_icl_languages_translations` VALUES("3294", "th", "ku", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3295", "th", "lv", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3296", "th", "lt", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3297", "th", "mk", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3298", "th", "mt", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3299", "th", "mn", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3300", "th", "ne", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3301", "th", "nl", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3302", "th", "no", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3303", "th", "pa", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3304", "th", "pl", "tajski");
INSERT INTO `wp_icl_languages_translations` VALUES("3305", "th", "pt-pt", "Tailandês");
INSERT INTO `wp_icl_languages_translations` VALUES("3306", "th", "pt-br", "Tailandês");
INSERT INTO `wp_icl_languages_translations` VALUES("3307", "th", "qu", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3308", "th", "ro", "Tailandeză");
INSERT INTO `wp_icl_languages_translations` VALUES("3309", "th", "ru", "Тайский");
INSERT INTO `wp_icl_languages_translations` VALUES("3310", "th", "sl", "Tajski");
INSERT INTO `wp_icl_languages_translations` VALUES("3311", "th", "so", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3312", "th", "sq", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3313", "th", "sr", "Тајландски");
INSERT INTO `wp_icl_languages_translations` VALUES("3314", "th", "sv", "Thailändska");
INSERT INTO `wp_icl_languages_translations` VALUES("3315", "th", "ta", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3316", "th", "th", "ไทย");
INSERT INTO `wp_icl_languages_translations` VALUES("3317", "th", "tr", "Tayca");
INSERT INTO `wp_icl_languages_translations` VALUES("3318", "th", "uk", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3319", "th", "ur", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3320", "th", "uz", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3321", "th", "vi", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3322", "th", "yi", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3323", "th", "zh-hans", "泰语");
INSERT INTO `wp_icl_languages_translations` VALUES("3324", "th", "zu", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3325", "th", "zh-hant", "泰語");
INSERT INTO `wp_icl_languages_translations` VALUES("3326", "th", "ms", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3327", "th", "gl", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3328", "th", "bn", "Thai");
INSERT INTO `wp_icl_languages_translations` VALUES("3329", "tr", "en", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3330", "tr", "es", "Turco");
INSERT INTO `wp_icl_languages_translations` VALUES("3331", "tr", "de", "Türkisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3332", "tr", "fr", "Turc");
INSERT INTO `wp_icl_languages_translations` VALUES("3333", "tr", "ar", "التركية");
INSERT INTO `wp_icl_languages_translations` VALUES("3334", "tr", "bs", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3335", "tr", "bg", "Турски");
INSERT INTO `wp_icl_languages_translations` VALUES("3336", "tr", "ca", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3337", "tr", "cs", "Turečtina");
INSERT INTO `wp_icl_languages_translations` VALUES("3338", "tr", "sk", "Turečtina");
INSERT INTO `wp_icl_languages_translations` VALUES("3339", "tr", "cy", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3340", "tr", "da", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3341", "tr", "el", "Τουρκικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3342", "tr", "eo", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3343", "tr", "et", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3344", "tr", "eu", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3345", "tr", "fa", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3346", "tr", "fi", "turkki");
INSERT INTO `wp_icl_languages_translations` VALUES("3347", "tr", "ga", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3348", "tr", "he", "תורכית");
INSERT INTO `wp_icl_languages_translations` VALUES("3349", "tr", "hi", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3350", "tr", "hr", "Turski");
INSERT INTO `wp_icl_languages_translations` VALUES("3351", "tr", "hu", "török");
INSERT INTO `wp_icl_languages_translations` VALUES("3352", "tr", "hy", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3353", "tr", "id", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3354", "tr", "is", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3355", "tr", "it", "Turco");
INSERT INTO `wp_icl_languages_translations` VALUES("3356", "tr", "ja", "トルコ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3357", "tr", "ko", "터어키어");
INSERT INTO `wp_icl_languages_translations` VALUES("3358", "tr", "ku", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3359", "tr", "lv", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3360", "tr", "lt", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3361", "tr", "mk", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3362", "tr", "mt", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3363", "tr", "mn", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3364", "tr", "ne", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3365", "tr", "nl", "Turks");
INSERT INTO `wp_icl_languages_translations` VALUES("3366", "tr", "no", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3367", "tr", "pa", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3368", "tr", "pl", "turecki");
INSERT INTO `wp_icl_languages_translations` VALUES("3369", "tr", "pt-pt", "Turco");
INSERT INTO `wp_icl_languages_translations` VALUES("3370", "tr", "pt-br", "Turco");
INSERT INTO `wp_icl_languages_translations` VALUES("3371", "tr", "qu", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3372", "tr", "ro", "Turcă");
INSERT INTO `wp_icl_languages_translations` VALUES("3373", "tr", "ru", "Турецкий");
INSERT INTO `wp_icl_languages_translations` VALUES("3374", "tr", "sl", "Turščina");
INSERT INTO `wp_icl_languages_translations` VALUES("3375", "tr", "so", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3376", "tr", "sq", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3377", "tr", "sr", "турски");
INSERT INTO `wp_icl_languages_translations` VALUES("3378", "tr", "sv", "Turkiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3379", "tr", "ta", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3380", "tr", "th", "ตุรกี");
INSERT INTO `wp_icl_languages_translations` VALUES("3381", "tr", "tr", "Türkçe");
INSERT INTO `wp_icl_languages_translations` VALUES("3382", "tr", "uk", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3383", "tr", "ur", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3384", "tr", "uz", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3385", "tr", "vi", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3386", "tr", "yi", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3387", "tr", "zh-hans", "土耳其语");
INSERT INTO `wp_icl_languages_translations` VALUES("3388", "tr", "zu", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3389", "tr", "zh-hant", "土耳其語");
INSERT INTO `wp_icl_languages_translations` VALUES("3390", "tr", "ms", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3391", "tr", "gl", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3392", "tr", "bn", "Turkish");
INSERT INTO `wp_icl_languages_translations` VALUES("3393", "uk", "en", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3394", "uk", "es", "Ucraniano");
INSERT INTO `wp_icl_languages_translations` VALUES("3395", "uk", "de", "Ukrainisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3396", "uk", "fr", "Ukrainien");
INSERT INTO `wp_icl_languages_translations` VALUES("3397", "uk", "ar", "الأوكرانية");
INSERT INTO `wp_icl_languages_translations` VALUES("3398", "uk", "bs", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3399", "uk", "bg", "Украински");
INSERT INTO `wp_icl_languages_translations` VALUES("3400", "uk", "ca", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3401", "uk", "cs", "Ukrajinský");
INSERT INTO `wp_icl_languages_translations` VALUES("3402", "uk", "sk", "Ukrajinčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3403", "uk", "cy", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3404", "uk", "da", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3405", "uk", "el", "Ουκρανικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3406", "uk", "eo", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3407", "uk", "et", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3408", "uk", "eu", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3409", "uk", "fa", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3410", "uk", "fi", "ukraina");
INSERT INTO `wp_icl_languages_translations` VALUES("3411", "uk", "ga", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3412", "uk", "he", "אוקראינית");
INSERT INTO `wp_icl_languages_translations` VALUES("3413", "uk", "hi", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3414", "uk", "hr", "Ukrajinski");
INSERT INTO `wp_icl_languages_translations` VALUES("3415", "uk", "hu", "ukrán");
INSERT INTO `wp_icl_languages_translations` VALUES("3416", "uk", "hy", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3417", "uk", "id", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3418", "uk", "is", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3419", "uk", "it", "Ucraino");
INSERT INTO `wp_icl_languages_translations` VALUES("3420", "uk", "ja", "ウクライナ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3421", "uk", "ko", "우크라이나어");
INSERT INTO `wp_icl_languages_translations` VALUES("3422", "uk", "ku", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3423", "uk", "lv", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3424", "uk", "lt", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3425", "uk", "mk", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3426", "uk", "mt", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3427", "uk", "mn", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3428", "uk", "ne", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3429", "uk", "nl", "Oekraïens");
INSERT INTO `wp_icl_languages_translations` VALUES("3430", "uk", "no", "Ukrainsk");
INSERT INTO `wp_icl_languages_translations` VALUES("3431", "uk", "pa", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3432", "uk", "pl", "ukraiński");
INSERT INTO `wp_icl_languages_translations` VALUES("3433", "uk", "pt-pt", "Ucraniano");
INSERT INTO `wp_icl_languages_translations` VALUES("3434", "uk", "pt-br", "Ucraniano");
INSERT INTO `wp_icl_languages_translations` VALUES("3435", "uk", "qu", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3436", "uk", "ro", "Ucrainiană");
INSERT INTO `wp_icl_languages_translations` VALUES("3437", "uk", "ru", "Украинский");
INSERT INTO `wp_icl_languages_translations` VALUES("3438", "uk", "sl", "Ukrajinski");
INSERT INTO `wp_icl_languages_translations` VALUES("3439", "uk", "so", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3440", "uk", "sq", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3441", "uk", "sr", "украјински");
INSERT INTO `wp_icl_languages_translations` VALUES("3442", "uk", "sv", "Ukrainska");
INSERT INTO `wp_icl_languages_translations` VALUES("3443", "uk", "ta", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3444", "uk", "th", "ยูเครน");
INSERT INTO `wp_icl_languages_translations` VALUES("3445", "uk", "tr", "Ukraynaca");
INSERT INTO `wp_icl_languages_translations` VALUES("3446", "uk", "uk", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3447", "uk", "ur", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3448", "uk", "uz", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3449", "uk", "vi", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3450", "uk", "yi", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3451", "uk", "zh-hans", "乌克兰语");
INSERT INTO `wp_icl_languages_translations` VALUES("3452", "uk", "zu", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3453", "uk", "zh-hant", "烏克蘭語");
INSERT INTO `wp_icl_languages_translations` VALUES("3454", "uk", "ms", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3455", "uk", "gl", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3456", "uk", "bn", "Ukrainian");
INSERT INTO `wp_icl_languages_translations` VALUES("3457", "ur", "en", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3458", "ur", "es", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3459", "ur", "de", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3460", "ur", "fr", "Ourdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3461", "ur", "ar", "الأردية");
INSERT INTO `wp_icl_languages_translations` VALUES("3462", "ur", "bs", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3463", "ur", "bg", "Урду");
INSERT INTO `wp_icl_languages_translations` VALUES("3464", "ur", "ca", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3465", "ur", "cs", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3466", "ur", "sk", "Urdština");
INSERT INTO `wp_icl_languages_translations` VALUES("3467", "ur", "cy", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3468", "ur", "da", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3469", "ur", "el", "Ουρντου");
INSERT INTO `wp_icl_languages_translations` VALUES("3470", "ur", "eo", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3471", "ur", "et", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3472", "ur", "eu", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3473", "ur", "fa", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3474", "ur", "fi", "urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3475", "ur", "ga", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3476", "ur", "he", "אורדו");
INSERT INTO `wp_icl_languages_translations` VALUES("3477", "ur", "hi", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3478", "ur", "hr", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3479", "ur", "hu", "urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3480", "ur", "hy", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3481", "ur", "id", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3482", "ur", "is", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3483", "ur", "it", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3484", "ur", "ja", "ウルドゥー語");
INSERT INTO `wp_icl_languages_translations` VALUES("3485", "ur", "ko", "우르두어");
INSERT INTO `wp_icl_languages_translations` VALUES("3486", "ur", "ku", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3487", "ur", "lv", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3488", "ur", "lt", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3489", "ur", "mk", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3490", "ur", "mt", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3491", "ur", "mn", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3492", "ur", "ne", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3493", "ur", "nl", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3494", "ur", "no", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3495", "ur", "pa", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3496", "ur", "pl", "urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3497", "ur", "pt-pt", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3498", "ur", "pt-br", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3499", "ur", "qu", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3500", "ur", "ro", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3501", "ur", "ru", "Урду");
INSERT INTO `wp_icl_languages_translations` VALUES("3502", "ur", "sl", "Urdujščina");
INSERT INTO `wp_icl_languages_translations` VALUES("3503", "ur", "so", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3504", "ur", "sq", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3505", "ur", "sr", "урду");
INSERT INTO `wp_icl_languages_translations` VALUES("3506", "ur", "sv", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3507", "ur", "ta", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3508", "ur", "th", "อุรดู");
INSERT INTO `wp_icl_languages_translations` VALUES("3509", "ur", "tr", "Urduca");
INSERT INTO `wp_icl_languages_translations` VALUES("3510", "ur", "uk", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3511", "ur", "ur", "اردو ");
INSERT INTO `wp_icl_languages_translations` VALUES("3512", "ur", "uz", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3513", "ur", "vi", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3514", "ur", "yi", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3515", "ur", "zh-hans", "乌尔都语");
INSERT INTO `wp_icl_languages_translations` VALUES("3516", "ur", "zu", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3517", "ur", "zh-hant", "烏爾都語");
INSERT INTO `wp_icl_languages_translations` VALUES("3518", "ur", "ms", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3519", "ur", "gl", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3520", "ur", "bn", "Urdu");
INSERT INTO `wp_icl_languages_translations` VALUES("3521", "uz", "en", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3522", "uz", "es", "Uzbeko");
INSERT INTO `wp_icl_languages_translations` VALUES("3523", "uz", "de", "Usbekisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3524", "uz", "fr", "Ouzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3525", "uz", "ar", "الاوزباكية");
INSERT INTO `wp_icl_languages_translations` VALUES("3526", "uz", "bs", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3527", "uz", "bg", "Узбекски");
INSERT INTO `wp_icl_languages_translations` VALUES("3528", "uz", "ca", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3529", "uz", "cs", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3530", "uz", "sk", "Uzbekčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3531", "uz", "cy", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3532", "uz", "da", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3533", "uz", "el", "Ουζμπεκικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3534", "uz", "eo", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3535", "uz", "et", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3536", "uz", "eu", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3537", "uz", "fa", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3538", "uz", "fi", "uzbekki");
INSERT INTO `wp_icl_languages_translations` VALUES("3539", "uz", "ga", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3540", "uz", "he", "אוזבקית");
INSERT INTO `wp_icl_languages_translations` VALUES("3541", "uz", "hi", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3542", "uz", "hr", "Uzbečki");
INSERT INTO `wp_icl_languages_translations` VALUES("3543", "uz", "hu", "üzbég");
INSERT INTO `wp_icl_languages_translations` VALUES("3544", "uz", "hy", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3545", "uz", "id", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3546", "uz", "is", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3547", "uz", "it", "Uzbeco");
INSERT INTO `wp_icl_languages_translations` VALUES("3548", "uz", "ja", "ウズベク語");
INSERT INTO `wp_icl_languages_translations` VALUES("3549", "uz", "ko", "우즈베크어");
INSERT INTO `wp_icl_languages_translations` VALUES("3550", "uz", "ku", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3551", "uz", "lv", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3552", "uz", "lt", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3553", "uz", "mk", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3554", "uz", "mt", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3555", "uz", "mn", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3556", "uz", "ne", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3557", "uz", "nl", "Oezbeeks");
INSERT INTO `wp_icl_languages_translations` VALUES("3558", "uz", "no", "Usbekisk");
INSERT INTO `wp_icl_languages_translations` VALUES("3559", "uz", "pa", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3560", "uz", "pl", "uzbecki");
INSERT INTO `wp_icl_languages_translations` VALUES("3561", "uz", "pt-pt", "Uzbeque");
INSERT INTO `wp_icl_languages_translations` VALUES("3562", "uz", "pt-br", "Uzbeque");
INSERT INTO `wp_icl_languages_translations` VALUES("3563", "uz", "qu", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3564", "uz", "ro", "Uzbecă");
INSERT INTO `wp_icl_languages_translations` VALUES("3565", "uz", "ru", "Узбекский");
INSERT INTO `wp_icl_languages_translations` VALUES("3566", "uz", "sl", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3567", "uz", "so", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3568", "uz", "sq", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3569", "uz", "sr", "Узбек");
INSERT INTO `wp_icl_languages_translations` VALUES("3570", "uz", "sv", "Uzbekiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3571", "uz", "ta", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3572", "uz", "th", "อุซเบก");
INSERT INTO `wp_icl_languages_translations` VALUES("3573", "uz", "tr", "Özbekçe");
INSERT INTO `wp_icl_languages_translations` VALUES("3574", "uz", "uk", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3575", "uz", "ur", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3576", "uz", "uz", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3577", "uz", "vi", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3578", "uz", "yi", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3579", "uz", "zh-hans", "乌兹别克语");
INSERT INTO `wp_icl_languages_translations` VALUES("3580", "uz", "zu", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3581", "uz", "zh-hant", "烏茲別克語");
INSERT INTO `wp_icl_languages_translations` VALUES("3582", "uz", "ms", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3583", "uz", "gl", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3584", "uz", "bn", "Uzbek");
INSERT INTO `wp_icl_languages_translations` VALUES("3585", "vi", "en", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3586", "vi", "es", "Vietnamita");
INSERT INTO `wp_icl_languages_translations` VALUES("3587", "vi", "de", "Vietnamesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3588", "vi", "fr", "Vietnamien");
INSERT INTO `wp_icl_languages_translations` VALUES("3589", "vi", "ar", "الفيتنامية");
INSERT INTO `wp_icl_languages_translations` VALUES("3590", "vi", "bs", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3591", "vi", "bg", "Виетнамски");
INSERT INTO `wp_icl_languages_translations` VALUES("3592", "vi", "ca", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3593", "vi", "cs", "Vietnamský");
INSERT INTO `wp_icl_languages_translations` VALUES("3594", "vi", "sk", "Vietnamčina");
INSERT INTO `wp_icl_languages_translations` VALUES("3595", "vi", "cy", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3596", "vi", "da", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3597", "vi", "el", "Βιετναμεζικα");
INSERT INTO `wp_icl_languages_translations` VALUES("3598", "vi", "eo", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3599", "vi", "et", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3600", "vi", "eu", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3601", "vi", "fa", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3602", "vi", "fi", "vietnam");
INSERT INTO `wp_icl_languages_translations` VALUES("3603", "vi", "ga", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3604", "vi", "he", "וייטנאמית");
INSERT INTO `wp_icl_languages_translations` VALUES("3605", "vi", "hi", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3606", "vi", "hr", "Vijetnamski");
INSERT INTO `wp_icl_languages_translations` VALUES("3607", "vi", "hu", "vietnámi");
INSERT INTO `wp_icl_languages_translations` VALUES("3608", "vi", "hy", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3609", "vi", "id", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3610", "vi", "is", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3611", "vi", "it", "Vietnamita");
INSERT INTO `wp_icl_languages_translations` VALUES("3612", "vi", "ja", "ベトナム語");
INSERT INTO `wp_icl_languages_translations` VALUES("3613", "vi", "ko", "베트남어");
INSERT INTO `wp_icl_languages_translations` VALUES("3614", "vi", "ku", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3615", "vi", "lv", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3616", "vi", "lt", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3617", "vi", "mk", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3618", "vi", "mt", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3619", "vi", "mn", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3620", "vi", "ne", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3621", "vi", "nl", "Vietnamees");
INSERT INTO `wp_icl_languages_translations` VALUES("3622", "vi", "no", "Vietnamesisk");
INSERT INTO `wp_icl_languages_translations` VALUES("3623", "vi", "pa", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3624", "vi", "pl", "wietnamski");
INSERT INTO `wp_icl_languages_translations` VALUES("3625", "vi", "pt-pt", "Vietnamita");
INSERT INTO `wp_icl_languages_translations` VALUES("3626", "vi", "pt-br", "Vietnamita");
INSERT INTO `wp_icl_languages_translations` VALUES("3627", "vi", "qu", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3628", "vi", "ro", "Vietnameză");
INSERT INTO `wp_icl_languages_translations` VALUES("3629", "vi", "ru", "Вьетнамский");
INSERT INTO `wp_icl_languages_translations` VALUES("3630", "vi", "sl", "Vietnamščina");
INSERT INTO `wp_icl_languages_translations` VALUES("3631", "vi", "so", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3632", "vi", "sq", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3633", "vi", "sr", "вијетнамски");
INSERT INTO `wp_icl_languages_translations` VALUES("3634", "vi", "sv", "Vietnamesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3635", "vi", "ta", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3636", "vi", "th", "เวียดนาม");
INSERT INTO `wp_icl_languages_translations` VALUES("3637", "vi", "tr", "Vietnamca");
INSERT INTO `wp_icl_languages_translations` VALUES("3638", "vi", "uk", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3639", "vi", "ur", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3640", "vi", "uz", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3641", "vi", "vi", "Tiếng Việt");
INSERT INTO `wp_icl_languages_translations` VALUES("3642", "vi", "yi", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3643", "vi", "zh-hans", "越南语");
INSERT INTO `wp_icl_languages_translations` VALUES("3644", "vi", "zu", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3645", "vi", "zh-hant", "越南語");
INSERT INTO `wp_icl_languages_translations` VALUES("3646", "vi", "ms", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3647", "vi", "gl", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3648", "vi", "bn", "Vietnamese");
INSERT INTO `wp_icl_languages_translations` VALUES("3649", "yi", "en", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3650", "yi", "es", "Yidis");
INSERT INTO `wp_icl_languages_translations` VALUES("3651", "yi", "de", "Jiddisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3652", "yi", "fr", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3653", "yi", "ar", "اليديشية");
INSERT INTO `wp_icl_languages_translations` VALUES("3654", "yi", "bs", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3655", "yi", "bg", "Идиш");
INSERT INTO `wp_icl_languages_translations` VALUES("3656", "yi", "ca", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3657", "yi", "cs", "Jidiš");
INSERT INTO `wp_icl_languages_translations` VALUES("3658", "yi", "sk", "Jidiš");
INSERT INTO `wp_icl_languages_translations` VALUES("3659", "yi", "cy", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3660", "yi", "da", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3661", "yi", "el", "Γιντις");
INSERT INTO `wp_icl_languages_translations` VALUES("3662", "yi", "eo", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3663", "yi", "et", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3664", "yi", "eu", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3665", "yi", "fa", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3666", "yi", "fi", "jiddi");
INSERT INTO `wp_icl_languages_translations` VALUES("3667", "yi", "ga", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3668", "yi", "he", "יידיש");
INSERT INTO `wp_icl_languages_translations` VALUES("3669", "yi", "hi", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3670", "yi", "hr", "Jidiš");
INSERT INTO `wp_icl_languages_translations` VALUES("3671", "yi", "hu", "jiddis");
INSERT INTO `wp_icl_languages_translations` VALUES("3672", "yi", "hy", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3673", "yi", "id", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3674", "yi", "is", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3675", "yi", "it", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3676", "yi", "ja", "イディッシュ語");
INSERT INTO `wp_icl_languages_translations` VALUES("3677", "yi", "ko", "이디시어");
INSERT INTO `wp_icl_languages_translations` VALUES("3678", "yi", "ku", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3679", "yi", "lv", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3680", "yi", "lt", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3681", "yi", "mk", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3682", "yi", "mt", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3683", "yi", "mn", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3684", "yi", "ne", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3685", "yi", "nl", "Jiddisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3686", "yi", "no", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3687", "yi", "pa", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3688", "yi", "pl", "jidysz");
INSERT INTO `wp_icl_languages_translations` VALUES("3689", "yi", "pt-pt", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3690", "yi", "pt-br", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3691", "yi", "qu", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3692", "yi", "ro", "Idiş");
INSERT INTO `wp_icl_languages_translations` VALUES("3693", "yi", "ru", "Идиш");
INSERT INTO `wp_icl_languages_translations` VALUES("3694", "yi", "sl", "Jidiš");
INSERT INTO `wp_icl_languages_translations` VALUES("3695", "yi", "so", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3696", "yi", "sq", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3697", "yi", "sr", "јидиш");
INSERT INTO `wp_icl_languages_translations` VALUES("3698", "yi", "sv", "Jiddisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3699", "yi", "ta", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3700", "yi", "th", "ยิชดิช");
INSERT INTO `wp_icl_languages_translations` VALUES("3701", "yi", "tr", "Eski İbranice");
INSERT INTO `wp_icl_languages_translations` VALUES("3702", "yi", "uk", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3703", "yi", "ur", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3704", "yi", "uz", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3705", "yi", "vi", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3706", "yi", "yi", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3707", "yi", "zh-hans", "依地语");
INSERT INTO `wp_icl_languages_translations` VALUES("3708", "yi", "zu", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3709", "yi", "zh-hant", "依地語");
INSERT INTO `wp_icl_languages_translations` VALUES("3710", "yi", "ms", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3711", "yi", "gl", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3712", "yi", "bn", "Yiddish");
INSERT INTO `wp_icl_languages_translations` VALUES("3713", "zh-hans", "en", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3714", "zh-hans", "es", "Chino simplificado");
INSERT INTO `wp_icl_languages_translations` VALUES("3715", "zh-hans", "de", "Vereinfachtes Chinesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3716", "zh-hans", "fr", "Chinois simplifié");
INSERT INTO `wp_icl_languages_translations` VALUES("3717", "zh-hans", "ar", "الصينية المبسطة");
INSERT INTO `wp_icl_languages_translations` VALUES("3718", "zh-hans", "bs", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3719", "zh-hans", "bg", "Китайски  (опростен)");
INSERT INTO `wp_icl_languages_translations` VALUES("3720", "zh-hans", "ca", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3721", "zh-hans", "cs", "Čínština ( Zjednodušený )");
INSERT INTO `wp_icl_languages_translations` VALUES("3722", "zh-hans", "sk", "Zjednodušená Čínština");
INSERT INTO `wp_icl_languages_translations` VALUES("3723", "zh-hans", "cy", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3724", "zh-hans", "da", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3725", "zh-hans", "el", "Κινεζικα (Απλοποιημένα)");
INSERT INTO `wp_icl_languages_translations` VALUES("3726", "zh-hans", "eo", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3727", "zh-hans", "et", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3728", "zh-hans", "eu", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3729", "zh-hans", "fa", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3730", "zh-hans", "fi", "kiina");
INSERT INTO `wp_icl_languages_translations` VALUES("3731", "zh-hans", "ga", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3732", "zh-hans", "he", "סינית");
INSERT INTO `wp_icl_languages_translations` VALUES("3733", "zh-hans", "hi", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3734", "zh-hans", "hr", "Kineski (pojednostavljeni)");
INSERT INTO `wp_icl_languages_translations` VALUES("3735", "zh-hans", "hu", "egyszerűsített kínai");
INSERT INTO `wp_icl_languages_translations` VALUES("3736", "zh-hans", "hy", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3737", "zh-hans", "id", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3738", "zh-hans", "is", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3739", "zh-hans", "it", "Cinese semplificato");
INSERT INTO `wp_icl_languages_translations` VALUES("3740", "zh-hans", "ja", "簡体中国語");
INSERT INTO `wp_icl_languages_translations` VALUES("3741", "zh-hans", "ko", "중국어 간체");
INSERT INTO `wp_icl_languages_translations` VALUES("3742", "zh-hans", "ku", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3743", "zh-hans", "lv", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3744", "zh-hans", "lt", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3745", "zh-hans", "mk", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3746", "zh-hans", "mt", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3747", "zh-hans", "mn", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3748", "zh-hans", "ne", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3749", "zh-hans", "nl", "Vereenvoudigd Chinees");
INSERT INTO `wp_icl_languages_translations` VALUES("3750", "zh-hans", "no", "Kinesisk (forenklet)");
INSERT INTO `wp_icl_languages_translations` VALUES("3751", "zh-hans", "pa", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3752", "zh-hans", "pl", "chiński uproszczony");
INSERT INTO `wp_icl_languages_translations` VALUES("3753", "zh-hans", "pt-pt", "Chinês (Simplificado)");
INSERT INTO `wp_icl_languages_translations` VALUES("3754", "zh-hans", "pt-br", "Chinês (Simplificado)");
INSERT INTO `wp_icl_languages_translations` VALUES("3755", "zh-hans", "qu", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3756", "zh-hans", "ro", "Chineza simplificată");
INSERT INTO `wp_icl_languages_translations` VALUES("3757", "zh-hans", "ru", "Китайский (упрощенный)");
INSERT INTO `wp_icl_languages_translations` VALUES("3758", "zh-hans", "sl", "Kitajščina (poenostavljena )");
INSERT INTO `wp_icl_languages_translations` VALUES("3759", "zh-hans", "so", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3760", "zh-hans", "sq", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3761", "zh-hans", "sr", "Кинески (поједностављени)");
INSERT INTO `wp_icl_languages_translations` VALUES("3762", "zh-hans", "sv", "Förenklad kinesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3763", "zh-hans", "ta", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3764", "zh-hans", "th", "จีนประยุกต์");
INSERT INTO `wp_icl_languages_translations` VALUES("3765", "zh-hans", "tr", "Modern Çince");
INSERT INTO `wp_icl_languages_translations` VALUES("3766", "zh-hans", "uk", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3767", "zh-hans", "ur", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3768", "zh-hans", "uz", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3769", "zh-hans", "vi", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3770", "zh-hans", "yi", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3771", "zh-hans", "zh-hans", "简体中文");
INSERT INTO `wp_icl_languages_translations` VALUES("3772", "zh-hans", "zu", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3773", "zh-hans", "zh-hant", "簡體中文");
INSERT INTO `wp_icl_languages_translations` VALUES("3774", "zh-hans", "ms", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3775", "zh-hans", "gl", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3776", "zh-hans", "bn", "Chinese (Simplified)");
INSERT INTO `wp_icl_languages_translations` VALUES("3777", "zu", "en", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3778", "zu", "es", "Zulú");
INSERT INTO `wp_icl_languages_translations` VALUES("3779", "zu", "de", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3780", "zu", "fr", "Zoulou");
INSERT INTO `wp_icl_languages_translations` VALUES("3781", "zu", "ar", "الزولو");
INSERT INTO `wp_icl_languages_translations` VALUES("3782", "zu", "bs", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3783", "zu", "bg", "Зулу");
INSERT INTO `wp_icl_languages_translations` VALUES("3784", "zu", "ca", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3785", "zu", "cs", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3786", "zu", "sk", "Jazyk Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3787", "zu", "cy", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3788", "zu", "da", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3789", "zu", "el", "Ζουλου");
INSERT INTO `wp_icl_languages_translations` VALUES("3790", "zu", "eo", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3791", "zu", "et", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3792", "zu", "eu", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3793", "zu", "fa", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3794", "zu", "fi", "zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3795", "zu", "ga", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3796", "zu", "he", "זולו ");
INSERT INTO `wp_icl_languages_translations` VALUES("3797", "zu", "hi", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3798", "zu", "hr", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3799", "zu", "hu", "zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3800", "zu", "hy", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3801", "zu", "id", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3802", "zu", "is", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3803", "zu", "it", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3804", "zu", "ja", "ズールー語");
INSERT INTO `wp_icl_languages_translations` VALUES("3805", "zu", "ko", "줄루어");
INSERT INTO `wp_icl_languages_translations` VALUES("3806", "zu", "ku", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3807", "zu", "lv", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3808", "zu", "lt", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3809", "zu", "mk", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3810", "zu", "mt", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3811", "zu", "mn", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3812", "zu", "ne", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3813", "zu", "nl", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3814", "zu", "no", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3815", "zu", "pa", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3816", "zu", "pl", "zuluski");
INSERT INTO `wp_icl_languages_translations` VALUES("3817", "zu", "pt-pt", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3818", "zu", "pt-br", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3819", "zu", "qu", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3820", "zu", "ro", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3821", "zu", "ru", "Зулу");
INSERT INTO `wp_icl_languages_translations` VALUES("3822", "zu", "sl", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3823", "zu", "so", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3824", "zu", "sq", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3825", "zu", "sr", "зулу");
INSERT INTO `wp_icl_languages_translations` VALUES("3826", "zu", "sv", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3827", "zu", "ta", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3828", "zu", "th", "ซูลู");
INSERT INTO `wp_icl_languages_translations` VALUES("3829", "zu", "tr", "Zulu dili");
INSERT INTO `wp_icl_languages_translations` VALUES("3830", "zu", "uk", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3831", "zu", "ur", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3832", "zu", "uz", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3833", "zu", "vi", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3834", "zu", "yi", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3835", "zu", "zh-hans", "祖鲁语");
INSERT INTO `wp_icl_languages_translations` VALUES("3836", "zu", "zu", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3837", "zu", "zh-hant", "祖魯語");
INSERT INTO `wp_icl_languages_translations` VALUES("3838", "zu", "ms", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3839", "zu", "gl", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3840", "zu", "bn", "Zulu");
INSERT INTO `wp_icl_languages_translations` VALUES("3841", "zh-hant", "en", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3842", "zh-hant", "es", "Chino tradicional");
INSERT INTO `wp_icl_languages_translations` VALUES("3843", "zh-hant", "de", "Traditionelles Chinesisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3844", "zh-hant", "fr", "Chinois traditionnel");
INSERT INTO `wp_icl_languages_translations` VALUES("3845", "zh-hant", "ar", "الصينية التقليدية");
INSERT INTO `wp_icl_languages_translations` VALUES("3846", "zh-hant", "bs", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3847", "zh-hant", "bg", "Китайски (традиционен)");
INSERT INTO `wp_icl_languages_translations` VALUES("3848", "zh-hant", "ca", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3849", "zh-hant", "cs", "Čínština (tradiční )");
INSERT INTO `wp_icl_languages_translations` VALUES("3850", "zh-hant", "sk", "Tradičná Čínština");
INSERT INTO `wp_icl_languages_translations` VALUES("3851", "zh-hant", "cy", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3852", "zh-hant", "da", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3853", "zh-hant", "el", "Κινεζικα (Παραδοσιακά)");
INSERT INTO `wp_icl_languages_translations` VALUES("3854", "zh-hant", "eo", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3855", "zh-hant", "et", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3856", "zh-hant", "eu", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3857", "zh-hant", "fa", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3858", "zh-hant", "fi", "perinteinen kiina");
INSERT INTO `wp_icl_languages_translations` VALUES("3859", "zh-hant", "ga", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3860", "zh-hant", "he", "סינית מסורתית");
INSERT INTO `wp_icl_languages_translations` VALUES("3861", "zh-hant", "hi", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3862", "zh-hant", "hr", "Kineski (tradicionalni)");
INSERT INTO `wp_icl_languages_translations` VALUES("3863", "zh-hant", "hu", "hagyományos kínai");
INSERT INTO `wp_icl_languages_translations` VALUES("3864", "zh-hant", "hy", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3865", "zh-hant", "id", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3866", "zh-hant", "is", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3867", "zh-hant", "it", "Cinese tradizionale");
INSERT INTO `wp_icl_languages_translations` VALUES("3868", "zh-hant", "ja", "繁体中国語");
INSERT INTO `wp_icl_languages_translations` VALUES("3869", "zh-hant", "ko", "중국어 번체");
INSERT INTO `wp_icl_languages_translations` VALUES("3870", "zh-hant", "ku", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3871", "zh-hant", "lv", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3872", "zh-hant", "lt", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3873", "zh-hant", "mk", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3874", "zh-hant", "mt", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3875", "zh-hant", "mn", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3876", "zh-hant", "ne", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3877", "zh-hant", "nl", "Traditioneel Chinees");
INSERT INTO `wp_icl_languages_translations` VALUES("3878", "zh-hant", "no", "Kinesisk (tradisjonell)");
INSERT INTO `wp_icl_languages_translations` VALUES("3879", "zh-hant", "pa", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3880", "zh-hant", "pl", "chiński tradycyjny");
INSERT INTO `wp_icl_languages_translations` VALUES("3881", "zh-hant", "pt-pt", "Chinês (Tradicional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3882", "zh-hant", "pt-br", "Chinês (Tradicional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3883", "zh-hant", "qu", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3884", "zh-hant", "ro", "Chineza tradiţională");
INSERT INTO `wp_icl_languages_translations` VALUES("3885", "zh-hant", "ru", "Китайский (традиционный)");
INSERT INTO `wp_icl_languages_translations` VALUES("3886", "zh-hant", "sl", "Kitajščina (tradicionalna)");
INSERT INTO `wp_icl_languages_translations` VALUES("3887", "zh-hant", "so", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3888", "zh-hant", "sq", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3889", "zh-hant", "sr", "Кинески (традиционални)");
INSERT INTO `wp_icl_languages_translations` VALUES("3890", "zh-hant", "sv", "Traditionell kinesiska");
INSERT INTO `wp_icl_languages_translations` VALUES("3891", "zh-hant", "ta", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3892", "zh-hant", "th", "จีนดั้งเดิม");
INSERT INTO `wp_icl_languages_translations` VALUES("3893", "zh-hant", "tr", "Klasik Çince");
INSERT INTO `wp_icl_languages_translations` VALUES("3894", "zh-hant", "uk", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3895", "zh-hant", "ur", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3896", "zh-hant", "uz", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3897", "zh-hant", "vi", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3898", "zh-hant", "yi", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3899", "zh-hant", "zh-hans", "繁体中文");
INSERT INTO `wp_icl_languages_translations` VALUES("3900", "zh-hant", "zu", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3901", "zh-hant", "zh-hant", "繁體中文");
INSERT INTO `wp_icl_languages_translations` VALUES("3902", "zh-hant", "ms", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3903", "zh-hant", "gl", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3904", "zh-hant", "bn", "Chinese (Traditional)");
INSERT INTO `wp_icl_languages_translations` VALUES("3905", "ms", "en", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3906", "ms", "es", "Malayo");
INSERT INTO `wp_icl_languages_translations` VALUES("3907", "ms", "de", "Malaiisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3908", "ms", "fr", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3909", "ms", "ar", "لغة الملايو");
INSERT INTO `wp_icl_languages_translations` VALUES("3910", "ms", "bs", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3911", "ms", "bg", "Малайски");
INSERT INTO `wp_icl_languages_translations` VALUES("3912", "ms", "ca", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3913", "ms", "cs", "Malajský");
INSERT INTO `wp_icl_languages_translations` VALUES("3914", "ms", "sk", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3915", "ms", "cy", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3916", "ms", "da", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3917", "ms", "el", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3918", "ms", "eo", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3919", "ms", "et", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3920", "ms", "eu", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3921", "ms", "fa", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3922", "ms", "fi", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3923", "ms", "ga", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3924", "ms", "he", "מלאית");
INSERT INTO `wp_icl_languages_translations` VALUES("3925", "ms", "hi", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3926", "ms", "hr", "Malajski");
INSERT INTO `wp_icl_languages_translations` VALUES("3927", "ms", "hu", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3928", "ms", "hy", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3929", "ms", "id", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3930", "ms", "is", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3931", "ms", "it", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3932", "ms", "ja", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3933", "ms", "ko", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3934", "ms", "ku", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3935", "ms", "lv", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3936", "ms", "lt", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3937", "ms", "mk", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3938", "ms", "mt", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3939", "ms", "mn", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3940", "ms", "ne", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3941", "ms", "nl", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3942", "ms", "no", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3943", "ms", "pa", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3944", "ms", "pl", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3945", "ms", "pt-pt", "Malaio");
INSERT INTO `wp_icl_languages_translations` VALUES("3946", "ms", "pt-br", "Malaio");
INSERT INTO `wp_icl_languages_translations` VALUES("3947", "ms", "qu", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3948", "ms", "ro", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3949", "ms", "ru", "Малайский");
INSERT INTO `wp_icl_languages_translations` VALUES("3950", "ms", "sl", "Malajščina");
INSERT INTO `wp_icl_languages_translations` VALUES("3951", "ms", "so", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3952", "ms", "sq", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3953", "ms", "sr", "малајски");
INSERT INTO `wp_icl_languages_translations` VALUES("3954", "ms", "sv", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3955", "ms", "ta", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3956", "ms", "th", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3957", "ms", "tr", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3958", "ms", "uk", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3959", "ms", "ur", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3960", "ms", "uz", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3961", "ms", "vi", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3962", "ms", "yi", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3963", "ms", "zh-hans", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3964", "ms", "zu", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3965", "ms", "zh-hant", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3966", "ms", "ms", "Melayu");
INSERT INTO `wp_icl_languages_translations` VALUES("3967", "ms", "gl", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3968", "ms", "bn", "Malay");
INSERT INTO `wp_icl_languages_translations` VALUES("3969", "gl", "en", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3970", "gl", "es", "Gallego");
INSERT INTO `wp_icl_languages_translations` VALUES("3971", "gl", "de", "Galicisch");
INSERT INTO `wp_icl_languages_translations` VALUES("3972", "gl", "fr", "Galicien");
INSERT INTO `wp_icl_languages_translations` VALUES("3973", "gl", "ar", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3974", "gl", "bs", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3975", "gl", "bg", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3976", "gl", "ca", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3977", "gl", "cs", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3978", "gl", "sk", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3979", "gl", "cy", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3980", "gl", "da", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3981", "gl", "el", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3982", "gl", "eo", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3983", "gl", "et", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3984", "gl", "eu", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3985", "gl", "fa", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3986", "gl", "fi", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3987", "gl", "ga", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3988", "gl", "he", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3989", "gl", "hi", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3990", "gl", "hr", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3991", "gl", "hu", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3992", "gl", "hy", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3993", "gl", "id", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3994", "gl", "is", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3995", "gl", "it", "Gallego");
INSERT INTO `wp_icl_languages_translations` VALUES("3996", "gl", "ja", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3997", "gl", "ko", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3998", "gl", "ku", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("3999", "gl", "lv", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4000", "gl", "lt", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4001", "gl", "mk", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4002", "gl", "mt", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4003", "gl", "mn", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4004", "gl", "ne", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4005", "gl", "nl", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4006", "gl", "no", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4007", "gl", "pa", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4008", "gl", "pl", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4009", "gl", "pt-pt", "Galego");
INSERT INTO `wp_icl_languages_translations` VALUES("4010", "gl", "pt-br", "Galego");
INSERT INTO `wp_icl_languages_translations` VALUES("4011", "gl", "qu", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4012", "gl", "ro", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4013", "gl", "ru", "Галисийский");
INSERT INTO `wp_icl_languages_translations` VALUES("4014", "gl", "sl", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4015", "gl", "so", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4016", "gl", "sq", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4017", "gl", "sr", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4018", "gl", "sv", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4019", "gl", "ta", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4020", "gl", "th", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4021", "gl", "tr", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4022", "gl", "uk", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4023", "gl", "ur", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4024", "gl", "uz", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4025", "gl", "vi", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4026", "gl", "yi", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4027", "gl", "zh-hans", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4028", "gl", "zu", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4029", "gl", "zh-hant", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4030", "gl", "ms", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4031", "gl", "gl", "Galego");
INSERT INTO `wp_icl_languages_translations` VALUES("4032", "gl", "bn", "Galician");
INSERT INTO `wp_icl_languages_translations` VALUES("4033", "bn", "en", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4034", "bn", "es", "Bengalí");
INSERT INTO `wp_icl_languages_translations` VALUES("4035", "bn", "de", "Bengalisch");
INSERT INTO `wp_icl_languages_translations` VALUES("4036", "bn", "fr", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4037", "bn", "ar", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4038", "bn", "bs", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4039", "bn", "bg", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4040", "bn", "ca", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4041", "bn", "cs", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4042", "bn", "sk", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4043", "bn", "cy", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4044", "bn", "da", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4045", "bn", "el", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4046", "bn", "eo", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4047", "bn", "et", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4048", "bn", "eu", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4049", "bn", "fa", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4050", "bn", "fi", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4051", "bn", "ga", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4052", "bn", "he", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4053", "bn", "hi", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4054", "bn", "hr", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4055", "bn", "hu", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4056", "bn", "hy", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4057", "bn", "id", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4058", "bn", "is", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4059", "bn", "it", "Bengalese");
INSERT INTO `wp_icl_languages_translations` VALUES("4060", "bn", "ja", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4061", "bn", "ko", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4062", "bn", "ku", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4063", "bn", "lv", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4064", "bn", "lt", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4065", "bn", "mk", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4066", "bn", "mt", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4067", "bn", "mn", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4068", "bn", "ne", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4069", "bn", "nl", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4070", "bn", "no", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4071", "bn", "pa", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4072", "bn", "pl", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4073", "bn", "pt-pt", "Bengalês");
INSERT INTO `wp_icl_languages_translations` VALUES("4074", "bn", "pt-br", "Bengalês");
INSERT INTO `wp_icl_languages_translations` VALUES("4075", "bn", "qu", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4076", "bn", "ro", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4077", "bn", "ru", "Бенгальский");
INSERT INTO `wp_icl_languages_translations` VALUES("4078", "bn", "sl", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4079", "bn", "so", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4080", "bn", "sq", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4081", "bn", "sr", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4082", "bn", "sv", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4083", "bn", "ta", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4084", "bn", "th", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4085", "bn", "tr", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4086", "bn", "uk", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4087", "bn", "ur", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4088", "bn", "uz", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4089", "bn", "vi", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4090", "bn", "yi", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4091", "bn", "zh-hans", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4092", "bn", "zu", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4093", "bn", "zh-hant", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4094", "bn", "ms", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4095", "bn", "gl", "Bengali");
INSERT INTO `wp_icl_languages_translations` VALUES("4096", "bn", "bn", "हिन्दी");

/* INSERT TABLE DATA: wp_icl_locale_map */
INSERT INTO `wp_icl_locale_map` VALUES("en", "en_US");
INSERT INTO `wp_icl_locale_map` VALUES("tr", "tr_TR");

/* INSERT TABLE DATA: wp_icl_translation_status */
INSERT INTO `wp_icl_translation_status` VALUES("1", "345", "9", "0", "0", "", "", "0", "", "2021-08-26 14:38:13", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("2", "346", "9", "0", "0", "", "", "0", "", "2021-08-26 14:38:19", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("3", "347", "9", "0", "0", "", "", "0", "", "2021-08-26 14:38:24", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("4", "348", "9", "0", "0", "", "", "0", "", "2021-08-26 14:38:28", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("124", "631", "9", "0", "0", "", "", "0", "", "2021-10-05 17:09:30", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("6", "350", "9", "0", "0", "", "", "0", "", "2021-08-26 14:38:35", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("131", "658", "9", "0", "0", "", "", "0", "", "2021-10-28 22:28:36", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("8", "352", "9", "0", "0", "", "", "0", "", "2021-08-26 14:38:41", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("9", "353", "9", "0", "0", "", "", "0", "", "2021-08-26 14:38:44", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("10", "354", "9", "0", "0", "", "", "0", "", "2021-08-26 14:38:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("11", "355", "9", "0", "0", "", "", "0", "", "2021-08-26 14:38:50", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("12", "356", "9", "0", "0", "", "", "0", "", "2021-08-26 14:38:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("13", "357", "9", "0", "0", "", "", "0", "", "2021-08-26 14:38:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("14", "358", "9", "0", "0", "", "", "0", "", "2021-08-26 14:39:25", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("15", "359", "9", "0", "0", "", "", "0", "", "2021-08-26 14:39:28", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("16", "360", "9", "0", "0", "", "", "0", "", "2021-08-26 14:39:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("17", "361", "9", "0", "0", "", "", "0", "", "2021-08-26 14:39:58", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("123", "629", "9", "0", "0", "", "", "0", "", "2021-10-05 17:07:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("19", "363", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:08", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("20", "364", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:11", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("21", "365", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:13", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("22", "366", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:14", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("23", "367", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:14", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("24", "368", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:14", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("25", "369", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:16", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("26", "370", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:18", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("27", "371", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:20", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("28", "372", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:21", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("29", "373", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:24", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("30", "374", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:25", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("31", "375", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:29", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("32", "376", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("33", "377", "9", "0", "0", "", "", "0", "", "2021-08-26 14:40:35", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("34", "378", "9", "0", "0", "", "", "0", "", "2021-08-26 14:41:38", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("35", "379", "9", "0", "0", "", "", "0", "", "2021-08-26 14:41:40", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("36", "380", "9", "0", "0", "", "", "0", "", "2021-08-26 14:41:43", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("37", "381", "9", "0", "0", "", "", "0", "", "2021-08-26 14:41:46", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("38", "382", "9", "0", "0", "", "", "0", "", "2021-08-26 14:41:48", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("39", "383", "9", "0", "0", "", "", "0", "", "2021-08-26 14:41:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("40", "384", "9", "0", "0", "", "", "0", "", "2021-08-26 14:41:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("41", "385", "9", "0", "0", "", "", "0", "", "2021-08-26 14:41:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("42", "386", "9", "0", "0", "", "", "0", "", "2021-08-26 14:41:59", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("43", "387", "9", "0", "0", "", "", "0", "", "2021-08-26 14:42:02", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("44", "388", "9", "0", "0", "", "", "0", "", "2021-08-26 14:42:04", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("45", "389", "9", "0", "0", "", "", "0", "", "2021-08-26 14:42:07", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("46", "390", "9", "0", "0", "", "", "0", "", "2021-08-26 14:42:10", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("47", "391", "9", "0", "0", "", "", "0", "", "2021-08-26 14:42:12", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("48", "392", "9", "0", "0", "", "", "0", "", "2021-08-26 14:42:16", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("49", "393", "9", "0", "0", "", "", "0", "", "2021-08-26 14:42:20", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("50", "394", "9", "0", "0", "", "", "0", "", "2021-08-26 14:42:22", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("51", "395", "9", "0", "0", "", "", "0", "", "2021-08-26 14:42:24", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("52", "396", "9", "0", "0", "", "", "0", "", "2021-08-26 14:42:27", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("53", "397", "9", "0", "0", "", "", "0", "", "2021-08-26 14:42:30", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("54", "399", "9", "0", "0", "", "", "0", "", "2021-08-26 14:57:02", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("55", "401", "9", "0", "0", "", "", "0", "", "2021-08-26 15:00:44", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("56", "403", "9", "0", "0", "", "", "0", "", "2021-08-26 19:55:23", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("57", "405", "9", "0", "0", "", "", "0", "", "2021-08-26 19:58:16", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("58", "407", "9", "0", "0", "", "", "0", "", "2021-08-26 21:37:17", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("59", "409", "9", "0", "0", "", "", "0", "", "2021-08-27 11:19:47", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("60", "411", "9", "0", "0", "", "", "0", "", "2021-08-27 11:22:39", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("61", "413", "9", "0", "0", "", "", "0", "", "2021-08-27 11:25:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("62", "415", "9", "0", "0", "", "", "0", "", "2021-08-27 11:31:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("63", "417", "9", "0", "0", "", "", "0", "", "2021-08-27 11:37:54", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("64", "419", "9", "0", "0", "", "", "0", "", "2021-08-27 11:38:55", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("65", "421", "9", "0", "0", "", "", "0", "", "2021-08-27 11:51:55", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("66", "423", "9", "0", "0", "", "", "0", "", "2021-08-29 11:35:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("67", "425", "9", "0", "0", "", "", "0", "", "2021-08-29 11:39:15", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("68", "427", "9", "0", "0", "", "", "0", "", "2021-08-29 11:45:41", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("69", "429", "9", "0", "0", "", "", "0", "", "2021-08-29 13:23:37", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("70", "431", "9", "0", "0", "", "", "0", "", "2021-08-29 13:33:38", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("71", "435", "9", "0", "0", "", "", "0", "", "2021-08-29 14:44:24", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("72", "437", "9", "0", "0", "", "", "0", "", "2021-08-29 14:45:33", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("73", "439", "9", "0", "0", "", "", "0", "", "2021-08-29 14:45:55", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("74", "441", "9", "0", "0", "", "", "0", "", "2021-08-29 23:36:11", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("75", "443", "9", "0", "0", "", "", "0", "", "2021-08-29 23:36:40", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("76", "445", "9", "0", "0", "", "", "0", "", "2021-08-29 23:39:20", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("77", "447", "9", "0", "0", "", "", "0", "", "2021-08-29 23:41:25", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("78", "449", "9", "0", "0", "", "", "0", "", "2021-08-29 23:51:42", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("79", "461", "9", "0", "0", "", "", "0", "", "2021-08-31 21:15:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("80", "463", "9", "0", "0", "", "", "0", "", "2021-09-03 10:52:37", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("81", "465", "9", "0", "0", "", "", "0", "", "2021-09-03 10:55:26", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("82", "467", "9", "0", "0", "", "", "0", "", "2021-09-03 10:57:01", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("83", "469", "9", "0", "0", "", "", "0", "", "2021-09-03 11:01:01", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("84", "471", "9", "0", "0", "", "", "0", "", "2021-09-03 11:04:03", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("85", "473", "9", "0", "0", "", "", "0", "", "2021-09-03 11:14:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("86", "479", "9", "0", "0", "", "", "0", "", "2021-09-03 11:35:17", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("87", "483", "9", "0", "0", "", "", "0", "", "2021-09-03 11:38:17", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("88", "487", "9", "0", "0", "", "", "0", "", "2021-09-03 11:39:21", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("89", "491", "9", "0", "0", "", "", "0", "", "2021-09-03 11:41:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("90", "497", "9", "0", "0", "", "", "0", "", "2021-09-04 23:57:08", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("91", "499", "9", "0", "0", "", "", "0", "", "2021-09-05 00:00:21", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("92", "501", "9", "0", "0", "", "", "0", "", "2021-09-05 00:09:21", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("93", "503", "9", "0", "0", "", "", "0", "", "2021-09-05 00:10:56", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("94", "505", "9", "0", "0", "", "", "0", "", "2021-09-05 00:22:55", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("95", "507", "9", "0", "0", "", "", "0", "", "2021-09-05 00:25:09", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("96", "509", "9", "0", "0", "", "", "0", "", "2021-09-05 00:28:26", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("97", "511", "9", "0", "0", "", "", "0", "", "2021-09-05 12:51:17", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("98", "515", "9", "0", "0", "", "", "0", "", "2021-09-07 11:20:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("99", "519", "9", "0", "0", "", "", "0", "", "2021-09-07 11:22:27", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("100", "523", "9", "0", "0", "", "", "0", "", "2021-09-07 11:24:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("101", "527", "9", "0", "0", "", "", "0", "", "2021-09-07 11:27:04", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("102", "531", "9", "0", "0", "", "", "0", "", "2021-09-07 11:32:16", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("103", "535", "9", "0", "0", "", "", "0", "", "2021-09-07 11:34:38", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("104", "539", "9", "0", "0", "", "", "0", "", "2021-09-07 11:38:01", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("105", "543", "9", "0", "0", "", "", "0", "", "2021-09-07 11:40:16", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("106", "547", "9", "0", "0", "", "", "0", "", "2021-09-07 11:43:01", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("107", "551", "9", "0", "0", "", "", "0", "", "2021-09-07 11:51:29", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("108", "555", "9", "0", "0", "", "", "0", "", "2021-09-07 11:55:24", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("109", "557", "9", "0", "0", "", "", "0", "", "2021-09-07 11:58:52", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("110", "563", "9", "0", "0", "", "", "0", "", "2021-09-07 12:06:14", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("111", "565", "9", "0", "0", "", "", "0", "", "2021-09-07 12:06:24", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("112", "569", "9", "0", "0", "", "", "0", "", "2021-09-07 12:08:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("113", "573", "9", "0", "0", "", "", "0", "", "2021-09-07 12:10:15", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("114", "577", "9", "0", "0", "", "", "0", "", "2021-09-07 12:14:21", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("115", "581", "9", "0", "0", "", "", "0", "", "2021-09-07 12:16:03", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("116", "583", "9", "0", "0", "", "", "0", "", "2021-09-07 12:16:20", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("117", "587", "9", "0", "0", "", "", "0", "", "2021-09-11 21:55:31", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("118", "592", "9", "0", "0", "", "", "0", "", "2021-09-12 20:56:53", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("119", "594", "9", "0", "0", "", "", "0", "", "2021-09-12 20:58:26", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("120", "623", "9", "0", "0", "", "", "0", "", "2021-09-19 20:18:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("121", "625", "9", "0", "0", "", "", "0", "", "2021-09-19 23:44:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("122", "627", "9", "0", "0", "", "", "0", "", "2021-09-19 23:46:04", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("125", "637", "9", "0", "0", "", "", "0", "", "2021-10-05 22:05:13", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("126", "641", "9", "0", "0", "", "", "0", "", "2021-10-05 22:09:15", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("127", "643", "9", "0", "0", "", "", "0", "", "2021-10-05 22:10:37", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("128", "645", "9", "0", "0", "", "", "0", "", "2021-10-05 22:11:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("129", "647", "9", "0", "0", "", "", "0", "", "2021-10-05 22:13:08", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("130", "649", "9", "0", "0", "", "", "0", "", "2021-10-05 22:13:57", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("132", "660", "9", "0", "0", "", "", "0", "", "2021-10-28 22:28:42", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("133", "662", "9", "0", "0", "", "", "0", "", "2021-10-28 22:28:45", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("134", "664", "9", "0", "0", "", "", "0", "", "2021-10-28 22:28:51", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("135", "666", "9", "0", "0", "", "", "0", "", "2021-10-28 22:55:08", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("136", "679", "9", "0", "0", "", "", "0", "", "2021-11-14 22:21:24", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("137", "681", "9", "0", "0", "", "", "0", "", "2021-11-15 23:26:29", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("138", "683", "9", "0", "0", "", "", "0", "", "2021-11-15 23:30:38", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("139", "685", "9", "0", "0", "", "", "0", "", "2021-11-15 23:31:12", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("140", "687", "9", "0", "0", "", "", "0", "", "2021-11-15 23:31:49", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("141", "689", "9", "0", "0", "", "", "0", "", "2021-11-15 23:32:59", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("142", "691", "9", "0", "0", "", "", "0", "", "2021-11-15 23:33:03", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("143", "693", "9", "0", "0", "", "", "0", "", "2021-11-15 23:33:05", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("144", "695", "9", "0", "0", "", "", "0", "", "2022-12-14 10:29:10", "0", NULL, NULL, NULL, "1", NULL);
INSERT INTO `wp_icl_translation_status` VALUES("145", "697", "9", "0", "0", "", "", "0", "", "2022-12-14 10:29:39", "0", NULL, NULL, NULL, "1", NULL);

/* INSERT TABLE DATA: wp_icl_translations */
INSERT INTO `wp_icl_translations` VALUES("627", "post_attachment", "1700", "2073", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("626", "post_attachment", "1699", "2073", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("625", "post_attachment", "1697", "2072", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("623", "post_attachment", "1679", "2071", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("622", "post_attachment", "1678", "2071", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("621", "post_nav_menu_item", "1675", "2055", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("620", "post_nav_menu_item", "1674", "2056", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("618", "post_nav_menu_item", "1672", "2067", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("617", "post_nav_menu_item", "1671", "2066", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("616", "post_nav_menu_item", "1670", "2051", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("615", "post_nav_menu_item", "1669", "2050", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("614", "post_nav_menu_item", "1662", "2049", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("613", "post_nav_menu_item", "1661", "2048", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("612", "post_nav_menu_item", "1660", "2047", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("17", "post_nav_menu_item", "272", "272", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("18", "post_nav_menu_item", "273", "273", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("19", "post_nav_menu_item", "274", "274", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("20", "post_nav_menu_item", "318", "318", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("21", "post_nav_menu_item", "364", "364", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("22", "post_nav_menu_item", "875", "875", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("23", "post_nav_menu_item", "876", "876", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("24", "post_nav_menu_item", "884", "884", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("25", "post_nav_menu_item", "890", "890", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("26", "post_nav_menu_item", "894", "894", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("27", "post_page", "3", "3", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("28", "post_page", "190", "190", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("29", "post_page", "2", "2", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("30", "post_page", "235", "235", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("31", "post_page", "248", "248", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("32", "post_page", "267", "267", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("33", "post_page", "278", "278", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("34", "post_page", "360", "360", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("35", "post_page", "362", "362", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("36", "post_page", "381", "381", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("37", "post_page", "385", "385", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("38", "post_page", "396", "396", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("39", "post_page", "444", "444", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("40", "post_page", "454", "454", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("41", "post_page", "463", "463", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("42", "post_page", "473", "473", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("43", "post_page", "480", "480", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("44", "post_page", "485", "485", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("45", "post_page", "493", "493", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("46", "post_page", "500", "500", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("47", "post_page", "506", "506", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("48", "post_page", "517", "517", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("49", "post_page", "524", "524", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("50", "post_page", "532", "532", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("51", "post_page", "538", "538", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("52", "post_page", "548", "548", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("53", "post_page", "557", "557", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("54", "post_page", "566", "566", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("55", "post_page", "570", "570", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("56", "post_page", "579", "579", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("57", "post_page", "586", "586", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("58", "post_page", "590", "590", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("59", "post_page", "597", "597", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("60", "post_page", "610", "610", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("61", "post_page", "618", "618", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("62", "post_page", "627", "627", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("63", "post_page", "636", "636", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("64", "post_page", "644", "644", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("65", "post_page", "649", "649", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("66", "post_page", "656", "656", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("67", "post_page", "659", "659", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("68", "post_page", "663", "663", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("69", "post_page", "669", "669", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("70", "post_page", "679", "679", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("71", "post_page", "687", "687", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("72", "post_page", "695", "695", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("73", "post_page", "700", "700", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("74", "post_page", "707", "707", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("75", "post_page", "714", "714", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("76", "post_page", "723", "723", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("77", "post_page", "729", "729", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("78", "post_page", "739", "739", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("79", "post_page", "747", "747", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("80", "post_page", "877", "877", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("81", "post_page", "885", "885", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("82", "post_page", "891", "891", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("83", "post_wpcf7_contact_form", "269", "269", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("84", "post_zn_pb_templates", "212", "212", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("85", "post_zn_pb_templates", "213", "213", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("86", "post_znpb_template_mngr", "188", "188", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("87", "tax_category", "1", "896", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("88", "tax_category", "3", "898", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("590", "tax_nav_menu", "4", "2042", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("624", "post_attachment", "1696", "2072", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("619", "post_nav_menu_item", "1673", "2054", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("611", "tax_nav_menu", "10", "2094", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("93", "comment", "1", "908", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("94", "tax_category", NULL, "896", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("95", "post_attachment", "5", "914", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("96", "post_attachment", "11", "920", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("97", "post_attachment", "16", "925", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("98", "post_attachment", "20", "929", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("99", "post_attachment", "21", "930", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("100", "post_attachment", "22", "931", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("101", "post_attachment", "25", "934", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("102", "post_attachment", "26", "935", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("103", "post_attachment", "40", "949", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("104", "post_attachment", "47", "956", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("105", "post_attachment", "49", "958", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("106", "post_attachment", "50", "959", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("107", "post_attachment", "53", "962", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("108", "post_attachment", "62", "971", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("109", "post_attachment", "63", "972", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("110", "post_attachment", "64", "973", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("111", "post_attachment", "65", "974", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("112", "post_attachment", "85", "994", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("113", "post_attachment", "91", "1000", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("114", "post_attachment", "92", "1001", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("115", "post_attachment", "113", "1022", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("116", "post_attachment", "116", "1025", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("117", "post_attachment", "122", "1031", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("118", "post_attachment", "123", "1032", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("119", "post_attachment", "124", "1033", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("120", "post_attachment", "125", "1034", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("121", "post_attachment", "126", "1035", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("122", "post_attachment", "127", "1036", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("123", "post_attachment", "130", "1039", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("124", "post_attachment", "144", "1053", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("125", "post_attachment", "145", "1054", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("126", "post_attachment", "146", "1055", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("127", "post_attachment", "147", "1056", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("128", "post_attachment", "166", "1075", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("129", "post_attachment", "167", "1076", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("130", "post_attachment", "187", "1096", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("131", "post_attachment", "216", "1125", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("132", "post_attachment", "217", "1126", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("133", "post_attachment", "220", "1129", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("134", "post_attachment", "221", "1130", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("135", "post_attachment", "228", "1137", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("136", "post_attachment", "229", "1138", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("137", "post_attachment", "230", "1139", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("138", "post_attachment", "231", "1140", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("139", "post_attachment", "234", "1143", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("140", "post_attachment", "237", "1146", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("141", "post_attachment", "238", "1147", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("142", "post_attachment", "239", "1148", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("143", "post_attachment", "240", "1149", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("144", "post_attachment", "241", "1150", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("145", "post_attachment", "242", "1151", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("146", "post_attachment", "255", "1164", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("147", "post_attachment", "256", "1165", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("148", "post_attachment", "257", "1166", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("149", "post_attachment", "263", "1172", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("150", "post_attachment", "277", "1186", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("151", "post_attachment", "285", "1194", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("152", "post_attachment", "292", "1201", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("153", "post_attachment", "299", "1208", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("154", "post_attachment", "300", "1209", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("155", "post_attachment", "307", "1216", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("156", "post_attachment", "331", "1240", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("157", "post_attachment", "335", "1244", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("158", "post_attachment", "337", "1246", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("159", "post_attachment", "351", "1260", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("160", "post_attachment", "355", "1264", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("161", "post_attachment", "367", "1276", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("162", "post_attachment", "394", "1303", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("163", "post_attachment", "399", "1308", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("164", "post_attachment", "400", "1309", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("165", "post_attachment", "401", "1310", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("166", "post_attachment", "402", "1311", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("167", "post_attachment", "403", "1312", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("168", "post_attachment", "404", "1313", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("169", "post_attachment", "405", "1314", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("170", "post_attachment", "406", "1315", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("171", "post_attachment", "407", "1316", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("172", "post_attachment", "408", "1317", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("173", "post_attachment", "409", "1318", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("174", "post_attachment", "410", "1319", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("175", "post_attachment", "411", "1320", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("176", "post_attachment", "412", "1321", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("177", "post_attachment", "413", "1322", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("178", "post_attachment", "414", "1323", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("179", "post_attachment", "415", "1324", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("180", "post_attachment", "418", "1327", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("181", "post_attachment", "419", "1328", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("182", "post_attachment", "420", "1329", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("183", "post_attachment", "421", "1330", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("184", "post_attachment", "427", "1336", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("185", "post_attachment", "446", "1355", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("186", "post_attachment", "447", "1356", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("187", "post_attachment", "448", "1357", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("188", "post_attachment", "449", "1358", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("189", "post_attachment", "450", "1359", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("190", "post_attachment", "451", "1360", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("191", "post_attachment", "457", "1366", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("192", "post_attachment", "458", "1367", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("193", "post_attachment", "459", "1368", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("194", "post_attachment", "460", "1369", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("195", "post_attachment", "465", "1374", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("196", "post_attachment", "466", "1375", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("197", "post_attachment", "467", "1376", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("198", "post_attachment", "468", "1377", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("199", "post_attachment", "475", "1384", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("200", "post_attachment", "476", "1385", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("201", "post_attachment", "477", "1386", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("202", "post_attachment", "482", "1391", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("203", "post_attachment", "487", "1396", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("204", "post_attachment", "488", "1397", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("205", "post_attachment", "489", "1398", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("206", "post_attachment", "495", "1404", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("207", "post_attachment", "496", "1405", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("208", "post_attachment", "497", "1406", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("209", "post_attachment", "499", "1408", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("210", "post_attachment", "502", "1411", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("211", "post_attachment", "503", "1412", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("212", "post_attachment", "504", "1413", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("213", "post_attachment", "508", "1417", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("214", "post_attachment", "509", "1418", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("215", "post_attachment", "510", "1419", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("216", "post_attachment", "511", "1420", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("217", "post_attachment", "512", "1421", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("218", "post_attachment", "513", "1422", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("219", "post_attachment", "519", "1428", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("220", "post_attachment", "520", "1429", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("221", "post_attachment", "521", "1430", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("222", "post_attachment", "522", "1431", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("223", "post_attachment", "526", "1435", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("224", "post_attachment", "527", "1436", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("225", "post_attachment", "528", "1437", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("226", "post_attachment", "529", "1438", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("227", "post_attachment", "534", "1443", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("228", "post_attachment", "535", "1444", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("229", "post_attachment", "536", "1445", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("230", "post_attachment", "540", "1449", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("231", "post_attachment", "541", "1450", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("232", "post_attachment", "542", "1451", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("233", "post_attachment", "543", "1452", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("234", "post_attachment", "544", "1453", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("235", "post_attachment", "550", "1459", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("236", "post_attachment", "551", "1460", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("237", "post_attachment", "552", "1461", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("238", "post_attachment", "554", "1463", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("239", "post_attachment", "559", "1468", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("240", "post_attachment", "560", "1469", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("241", "post_attachment", "561", "1470", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("242", "post_attachment", "562", "1471", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("243", "post_attachment", "563", "1472", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("244", "post_attachment", "568", "1477", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("245", "post_attachment", "572", "1481", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("246", "post_attachment", "573", "1482", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("247", "post_attachment", "574", "1483", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("248", "post_attachment", "576", "1485", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("249", "post_attachment", "577", "1486", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("250", "post_attachment", "578", "1487", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("251", "post_attachment", "581", "1490", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("252", "post_attachment", "582", "1491", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("253", "post_attachment", "588", "1497", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("254", "post_attachment", "592", "1501", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("255", "post_attachment", "593", "1502", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("256", "post_attachment", "594", "1503", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("257", "post_attachment", "595", "1504", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("258", "post_attachment", "599", "1508", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("259", "post_attachment", "600", "1509", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("260", "post_attachment", "601", "1510", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("261", "post_attachment", "602", "1511", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("262", "post_attachment", "603", "1512", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("263", "post_attachment", "604", "1513", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("264", "post_attachment", "605", "1514", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("265", "post_attachment", "607", "1516", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("266", "post_attachment", "612", "1521", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("267", "post_attachment", "613", "1522", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("268", "post_attachment", "614", "1523", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("269", "post_attachment", "615", "1524", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("270", "post_attachment", "616", "1525", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("271", "post_attachment", "620", "1529", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("272", "post_attachment", "621", "1530", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("273", "post_attachment", "622", "1531", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("274", "post_attachment", "623", "1532", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("275", "post_attachment", "624", "1533", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("276", "post_attachment", "629", "1538", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("277", "post_attachment", "630", "1539", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("278", "post_attachment", "631", "1540", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("279", "post_attachment", "632", "1541", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("280", "post_attachment", "638", "1547", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("281", "post_attachment", "639", "1548", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("282", "post_attachment", "640", "1549", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("283", "post_attachment", "641", "1550", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("284", "post_attachment", "642", "1551", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("285", "post_attachment", "651", "1560", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("286", "post_attachment", "652", "1561", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("287", "post_attachment", "653", "1562", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("288", "post_attachment", "665", "1574", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("289", "post_attachment", "666", "1575", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("290", "post_attachment", "667", "1576", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("291", "post_attachment", "671", "1580", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("292", "post_attachment", "672", "1581", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("293", "post_attachment", "673", "1582", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("294", "post_attachment", "674", "1583", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("295", "post_attachment", "675", "1584", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("296", "post_attachment", "681", "1590", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("297", "post_attachment", "682", "1591", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("298", "post_attachment", "683", "1592", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("299", "post_attachment", "684", "1593", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("300", "post_attachment", "690", "1599", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("301", "post_attachment", "691", "1600", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("302", "post_attachment", "692", "1601", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("303", "post_attachment", "693", "1602", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("304", "post_attachment", "697", "1606", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("305", "post_attachment", "698", "1607", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("306", "post_attachment", "702", "1611", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("307", "post_attachment", "703", "1612", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("308", "post_attachment", "704", "1613", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("309", "post_attachment", "705", "1614", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("310", "post_attachment", "709", "1618", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("311", "post_attachment", "710", "1619", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("312", "post_attachment", "711", "1620", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("313", "post_attachment", "712", "1621", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("314", "post_attachment", "716", "1625", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("315", "post_attachment", "717", "1626", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("316", "post_attachment", "718", "1627", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("317", "post_attachment", "719", "1628", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("318", "post_attachment", "720", "1629", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("319", "post_attachment", "725", "1634", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("320", "post_attachment", "726", "1635", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("321", "post_attachment", "727", "1636", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("322", "post_attachment", "731", "1640", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("323", "post_attachment", "732", "1641", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("324", "post_attachment", "733", "1642", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("325", "post_attachment", "734", "1643", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("326", "post_attachment", "741", "1650", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("327", "post_attachment", "742", "1651", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("328", "post_attachment", "743", "1652", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("329", "post_attachment", "744", "1653", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("330", "post_attachment", "745", "1654", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("331", "post_attachment", "749", "1658", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("332", "post_attachment", "753", "1662", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("333", "post_attachment", "869", "1778", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("334", "post_attachment", "879", "1788", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("335", "post_attachment", "953", "1862", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("336", "post_attachment", "954", "1863", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("337", "post_attachment", "996", "1905", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("338", "post_attachment", "1003", "1912", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("339", "post_attachment", "1011", "1920", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("340", "post_attachment", "1014", "1923", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("341", "post_attachment", "1021", "1930", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("342", "post_attachment", "1023", "1932", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("343", "post_attachment", "1027", "1936", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("344", "post_attachment", "1029", "1938", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("345", "post_page", "1079", "235", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("346", "post_page", "1080", "248", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("347", "post_page", "1081", "267", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("348", "post_page", "1082", "278", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("349", "post_page", "1083", "360", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("350", "post_page", "1084", "362", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("351", "post_page", "1085", "381", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("352", "post_page", "1086", "385", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("353", "post_page", "1087", "396", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("354", "post_page", "1088", "444", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("355", "post_page", "1089", "454", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("356", "post_page", "1090", "463", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("357", "post_page", "1091", "473", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("358", "post_page", "1092", "480", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("359", "post_page", "1093", "485", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("360", "post_page", "1094", "493", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("361", "post_page", "1095", "500", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("362", "post_page", "1096", "506", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("363", "post_page", "1097", "517", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("364", "post_page", "1098", "524", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("365", "post_page", "1099", "532", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("366", "post_page", "1100", "538", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("367", "post_page", "1101", "548", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("368", "post_page", "1102", "557", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("369", "post_page", "1103", "566", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("370", "post_page", "1104", "570", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("371", "post_page", "1105", "579", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("372", "post_page", "1106", "586", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("373", "post_page", "1107", "590", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("374", "post_page", "1108", "597", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("375", "post_page", "1109", "610", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("376", "post_page", "1110", "618", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("377", "post_page", "1111", "627", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("378", "post_page", "1112", "636", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("379", "post_page", "1113", "644", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("380", "post_page", "1114", "649", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("381", "post_page", "1115", "656", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("382", "post_page", "1116", "659", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("383", "post_page", "1117", "663", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("384", "post_page", "1118", "669", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("385", "post_page", "1119", "679", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("386", "post_page", "1120", "687", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("387", "post_page", "1121", "695", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("388", "post_page", "1122", "700", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("389", "post_page", "1123", "707", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("390", "post_page", "1124", "714", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("391", "post_page", "1125", "723", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("392", "post_page", "1126", "729", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("393", "post_page", "1127", "739", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("394", "post_page", "1128", "747", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("395", "post_page", "1129", "877", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("396", "post_page", "1130", "885", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("397", "post_page", "1131", "891", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("398", "post_attachment", "1141", "1939", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("399", "post_attachment", "1142", "1939", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("400", "post_attachment", "1148", "1940", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("401", "post_attachment", "1149", "1940", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("402", "post_attachment", "1156", "1941", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("403", "post_attachment", "1157", "1941", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("404", "post_attachment", "1159", "1942", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("405", "post_attachment", "1160", "1942", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("406", "post_attachment", "1166", "1943", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("407", "post_attachment", "1167", "1943", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("408", "post_attachment", "1171", "1944", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("409", "post_attachment", "1172", "1944", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("410", "post_attachment", "1176", "1945", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("411", "post_attachment", "1177", "1945", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("412", "post_attachment", "1179", "1946", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("413", "post_attachment", "1180", "1946", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("414", "post_attachment", "1185", "1947", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("415", "post_attachment", "1186", "1947", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("416", "post_attachment", "1191", "1948", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("417", "post_attachment", "1192", "1948", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("418", "post_attachment", "1193", "1949", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("419", "post_attachment", "1194", "1949", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("420", "post_attachment", "1202", "1950", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("421", "post_attachment", "1203", "1950", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("422", "post_attachment", "1209", "1951", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("423", "post_attachment", "1210", "1951", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("424", "post_attachment", "1212", "1952", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("425", "post_attachment", "1213", "1952", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("426", "post_attachment", "1216", "1953", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("427", "post_attachment", "1217", "1953", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("428", "post_attachment", "1227", "1954", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("429", "post_attachment", "1228", "1954", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("430", "post_attachment", "1232", "1955", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("431", "post_attachment", "1233", "1955", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("432", "post_page", "1235", "1956", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("433", "post_page", "1236", "1956", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("434", "post_attachment", "1238", "1957", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("435", "post_attachment", "1239", "1957", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("678", "post_attachment", "1770", "2110", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("437", "post_attachment", "1241", "1958", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("438", "post_attachment", "1242", "1959", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("439", "post_attachment", "1243", "1959", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("440", "post_attachment", "1252", "1960", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("441", "post_attachment", "1253", "1960", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("442", "post_attachment", "1254", "1961", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("443", "post_attachment", "1255", "1961", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("444", "post_attachment", "1258", "1962", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("445", "post_attachment", "1259", "1962", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("446", "post_attachment", "1262", "1963", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("447", "post_attachment", "1263", "1963", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("448", "post_attachment", "1271", "1964", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("449", "post_attachment", "1272", "1964", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("450", "tax_nav_menu", "8", "903", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("586", "post_attachment", "1571", "2039", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("459", "post_znpb_template_mngr", "1298", "188", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("670", "post_nav_menu_item", "1291", "2102", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("458", "post_nav_menu_item", "1297", "1972", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("460", "post_attachment", "1300", "1973", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("461", "post_attachment", "1301", "1973", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("462", "post_attachment", "1308", "1974", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("463", "post_attachment", "1309", "1974", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("464", "post_attachment", "1312", "1975", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("465", "post_attachment", "1313", "1975", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("466", "post_attachment", "1316", "1976", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("467", "post_attachment", "1317", "1976", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("468", "post_attachment", "1321", "1977", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("469", "post_attachment", "1322", "1977", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("470", "post_attachment", "1325", "1978", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("471", "post_attachment", "1326", "1978", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("472", "post_attachment", "1329", "1979", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("473", "post_attachment", "1330", "1979", "tr", "en");
INSERT INTO `wp_icl_translations` VALUES("671", "post_nav_menu_item", "1293", "2103", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("476", "post_page", "1340", "1982", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("477", "post_page", "1341", "1982", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("478", "post_attachment", "1343", "1983", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("479", "post_attachment", "1344", "1983", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("480", "post_page", "1346", "1984", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("481", "post_page", "1347", "1984", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("482", "post_attachment", "1349", "1985", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("483", "post_attachment", "1350", "1985", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("484", "post_page", "1352", "1986", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("485", "post_page", "1353", "1986", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("486", "post_attachment", "1355", "1987", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("487", "post_attachment", "1356", "1987", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("488", "post_page", "1358", "1988", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("489", "post_page", "1359", "1988", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("490", "post_attachment", "1361", "1989", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("491", "post_attachment", "1362", "1989", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("492", "post_page", "1364", "1990", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("493", "post_page", "1365", "1990", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("494", "post_page", "1368", "1991", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("495", "post_nav_menu_item", "1373", "1992", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("496", "post_attachment", "1379", "1993", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("497", "post_attachment", "1380", "1993", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("498", "post_attachment", "1382", "1994", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("499", "post_attachment", "1383", "1994", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("500", "post_attachment", "1385", "1995", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("501", "post_attachment", "1386", "1995", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("502", "post_attachment", "1389", "1996", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("503", "post_attachment", "1390", "1996", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("504", "post_attachment", "1399", "1997", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("505", "post_attachment", "1400", "1997", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("506", "post_attachment", "1403", "1998", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("507", "post_attachment", "1404", "1998", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("508", "post_attachment", "1408", "1999", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("509", "post_attachment", "1409", "1999", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("510", "post_attachment", "1426", "2000", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("511", "post_attachment", "1427", "2000", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("512", "post_page", "1442", "2001", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("513", "post_page", "1443", "2001", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("514", "post_attachment", "1445", "2002", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("515", "post_attachment", "1446", "2002", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("516", "post_page", "1448", "2003", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("517", "post_page", "1449", "2003", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("518", "post_attachment", "1451", "2004", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("519", "post_attachment", "1452", "2004", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("520", "post_page", "1455", "2005", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("521", "post_page", "1456", "2005", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("522", "post_attachment", "1458", "2006", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("523", "post_attachment", "1459", "2006", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("524", "post_page", "1461", "2007", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("525", "post_page", "1462", "2007", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("526", "post_attachment", "1464", "2008", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("527", "post_attachment", "1465", "2008", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("528", "post_page", "1469", "2009", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("529", "post_page", "1470", "2009", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("530", "post_attachment", "1472", "2010", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("531", "post_attachment", "1473", "2010", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("532", "post_page", "1475", "2011", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("533", "post_page", "1476", "2011", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("534", "post_attachment", "1478", "2012", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("535", "post_attachment", "1479", "2012", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("536", "post_page", "1481", "2013", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("537", "post_page", "1482", "2013", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("538", "post_attachment", "1484", "2014", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("539", "post_attachment", "1485", "2014", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("540", "post_page", "1488", "2015", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("541", "post_page", "1489", "2015", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("542", "post_attachment", "1491", "2016", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("543", "post_attachment", "1492", "2016", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("544", "post_page", "1494", "2017", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("545", "post_page", "1495", "2017", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("546", "post_attachment", "1497", "2018", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("547", "post_attachment", "1498", "2018", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("548", "post_page", "1501", "2019", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("549", "post_page", "1502", "2019", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("550", "post_attachment", "1504", "2020", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("551", "post_attachment", "1505", "2020", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("552", "post_page", "1507", "2021", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("553", "post_page", "1508", "2021", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("554", "post_attachment", "1510", "2022", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("555", "post_attachment", "1511", "2022", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("556", "post_attachment", "1513", "2023", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("557", "post_attachment", "1514", "2023", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("558", "post_page", "1517", "2024", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("559", "post_page", "1518", "2024", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("560", "post_page", "1522", "2025", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("561", "post_page", "1523", "2025", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("564", "post_attachment", "1528", "2027", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("563", "post_attachment", "1527", "2026", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("565", "post_attachment", "1529", "2027", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("566", "post_page", "1533", "2028", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("567", "post_page", "1534", "2028", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("568", "post_attachment", "1536", "2029", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("569", "post_attachment", "1537", "2029", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("570", "post_page", "1539", "2030", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("571", "post_page", "1540", "2030", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("572", "post_attachment", "1542", "2031", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("573", "post_attachment", "1543", "2031", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("574", "post_page", "1545", "2032", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("575", "post_page", "1546", "2032", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("576", "post_attachment", "1548", "2033", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("577", "post_attachment", "1549", "2033", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("578", "post_page", "1551", "2034", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("579", "post_page", "1552", "2034", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("582", "post_attachment", "1556", "2036", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("581", "post_attachment", "1555", "2035", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("583", "post_attachment", "1557", "2036", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("584", "post_page", "1566", "2037", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("587", "post_attachment", "1572", "2039", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("660", "post_attachment", "1743", "2096", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("589", "post_nav_menu_item", "1574", "2041", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("591", "post_attachment", "1583", "2043", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("592", "post_attachment", "1584", "2043", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("593", "post_attachment", "1585", "2044", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("594", "post_attachment", "1586", "2044", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("595", "post_nav_menu_item", "1591", "2045", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("656", "tax_nav_menu", "9", "2094", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("597", "post_nav_menu_item", "1638", "2047", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("598", "post_nav_menu_item", "1639", "2048", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("599", "post_nav_menu_item", "1640", "2049", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("600", "post_nav_menu_item", "1641", "2050", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("601", "post_nav_menu_item", "1642", "2051", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("602", "post_nav_menu_item", "1643", "2052", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("603", "post_nav_menu_item", "1644", "2053", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("604", "post_nav_menu_item", "1645", "2054", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("605", "post_nav_menu_item", "1646", "2055", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("606", "post_nav_menu_item", "1647", "2056", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("607", "post_nav_menu_item", "1648", "2057", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("608", "post_nav_menu_item", "1649", "2058", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("609", "post_nav_menu_item", "1657", "2059", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("628", "post_attachment", "1708", "2074", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("629", "post_attachment", "1709", "2074", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("630", "post_attachment", "1710", "2075", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("631", "post_attachment", "1711", "2075", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("694", "post_attachment", "1815", "2118", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("633", "post_nav_menu_item", "1713", "2077", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("634", "post_nav_menu_item", "1714", "2078", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("635", "post_nav_menu_item", "1715", "2079", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("636", "post_attachment", "1716", "2080", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("637", "post_attachment", "1717", "2080", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("659", "post_attachment", "1742", "2096", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("658", "post_attachment", "1741", "2095", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("640", "post_attachment", "1720", "2083", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("641", "post_attachment", "1721", "2083", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("642", "post_attachment", "1722", "2084", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("643", "post_attachment", "1723", "2084", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("644", "post_attachment", "1724", "2085", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("645", "post_attachment", "1725", "2085", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("646", "post_attachment", "1726", "2086", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("647", "post_attachment", "1727", "2086", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("648", "post_attachment", "1728", "2087", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("649", "post_attachment", "1729", "2087", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("657", "post_attachment", "1740", "2095", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("651", "post_nav_menu_item", "1731", "2089", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("652", "post_nav_menu_item", "1732", "2090", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("653", "post_nav_menu_item", "1733", "2091", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("654", "post_nav_menu_item", "1734", "2092", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("655", "post_nav_menu_item", "1735", "2093", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("661", "post_attachment", "1744", "2097", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("662", "post_attachment", "1745", "2097", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("663", "post_attachment", "1746", "2098", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("664", "post_attachment", "1747", "2098", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("665", "post_attachment", "1751", "2099", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("666", "post_attachment", "1752", "2099", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("667", "post_page", "1754", "2100", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("668", "post_page", "1755", "2100", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("669", "post_nav_menu_item", "1758", "2101", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("672", "post_nav_menu_item", "1294", "2104", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("673", "post_nav_menu_item", "1295", "2105", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("674", "post_nav_menu_item", "1296", "2106", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("675", "post_nav_menu_item", "1337", "2107", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("676", "post_nav_menu_item", "1338", "2108", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("677", "post_nav_menu_item", "1569", "2109", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("679", "post_attachment", "1771", "2110", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("680", "post_attachment", "1773", "2111", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("681", "post_attachment", "1774", "2111", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("682", "post_attachment", "1776", "2112", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("683", "post_attachment", "1777", "2112", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("684", "post_attachment", "1778", "2113", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("685", "post_attachment", "1779", "2113", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("686", "post_attachment", "1780", "2114", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("687", "post_attachment", "1781", "2114", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("688", "post_attachment", "1782", "2115", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("689", "post_attachment", "1783", "2115", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("690", "post_attachment", "1784", "2116", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("691", "post_attachment", "1785", "2116", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("692", "post_attachment", "1786", "2117", "tr", NULL);
INSERT INTO `wp_icl_translations` VALUES("693", "post_attachment", "1787", "2117", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("695", "post_attachment", "1816", "2118", "en", "tr");
INSERT INTO `wp_icl_translations` VALUES("696", "post_attachment", "1817", "2119", "en", NULL);
INSERT INTO `wp_icl_translations` VALUES("697", "post_attachment", "1818", "2119", "tr", "en");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://bnbtakim.com", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://bnbtakim.com", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Bnb Takım", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "web@grafenbilisim.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "j F Y H:i", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("1587", "duplicate_post_copytitle", "1", "yes");
INSERT INTO `wp_options` VALUES("1588", "duplicate_post_copydate", "0", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:11:{i:0;s:40:\"sitepress-multilingual-cms/sitepress.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:33:\"duplicate-post/duplicate-post.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:27:\"fluent-smtp/fluent-smtp.php\";i:5;s:35:\"litespeed-cache/litespeed-cache.php\";i:6;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:7;s:23:\"revslider/revslider.php\";i:8;s:24:\"wordpress-seo/wp-seo.php\";i:9;s:35:\"wp-fastest-cache/wpFastestCache.php\";i:10;s:29:\"znpb-tiltbox/znpb-tiltbox.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "3", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:3:{i:0;s:75:\"/home/ankarau1/public_html/bnbtakim.com/wp-content/themes/kallyas/style.css\";i:1;s:76:\"/home/ankarau1/public_html/bnbtakim.com/wp-content/themes/kallyas/header.php\";i:3;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "kallyas", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "kallyas", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:3:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:2:{s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";s:21:\"mailin/sendinblue.php\";a:2:{i:0;s:11:\"SIB_Manager\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "278", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "1786", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1671481732", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "initial_db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("99", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:78:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;s:10:\"copy_posts\";b:1;s:34:\"wpml_manage_translation_management\";b:1;s:21:\"wpml_manage_languages\";b:1;s:41:\"wpml_manage_theme_and_plugin_localization\";b:1;s:19:\"wpml_manage_support\";b:1;s:36:\"wpml_manage_woocommerce_multilingual\";b:1;s:37:\"wpml_operate_woocommerce_multilingual\";b:1;s:29:\"wpml_manage_media_translation\";b:1;s:22:\"wpml_manage_navigation\";b:1;s:24:\"wpml_manage_sticky_links\";b:1;s:30:\"wpml_manage_string_translation\";b:1;s:33:\"wpml_manage_translation_analytics\";b:1;s:25:\"wpml_manage_wp_menus_sync\";b:1;s:32:\"wpml_manage_taxonomy_translation\";b:1;s:27:\"wpml_manage_troubleshooting\";b:1;s:31:\"wpml_manage_translation_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;s:10:\"copy_posts\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:10:\"copy_posts\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("100", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("101", "WPLANG", "tr_TR", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_archives", "a:3:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}i:3;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_meta", "a:3:{i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:14:\"defaultsidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-3\";i:4;s:12:\"categories-3\";i:5;s:6:\"meta-3\";}s:19:\"hiddenpannelsidebar\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:8:\"znfooter\";a:0:{}s:10:\"znfooter-2\";a:0:{}s:10:\"znfooter-3\";a:0:{}s:10:\"znfooter-4\";a:0:{}s:10:\"znfooter-5\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("108", "cron", "a:13:{i:1671222623;a:3:{s:19:\"litespeed_task_lqip\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:27:\"litespeed_task_imgoptm_pull\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:19:\"litespeed_task_ccss\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1671223412;a:5:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1671239096;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1671266612;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1671266621;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1671266625;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1671276907;a:1:{s:24:\"update_wpml_config_index\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1671305834;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1671306207;a:1:{s:35:\"fluentmail_do_daily_scheduled_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1671612212;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1671824234;a:1:{s:16:\"wpseo_ryte_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1672114878;a:1:{s:25:\"otgs_send_components_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("203", "revslider_update_version", "6.4.10", "yes");
INSERT INTO `wp_options` VALUES("119", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("121", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("120", "theme_mods_twentytwentyone", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1627375437;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("178", "revslider_servers", "a:7:{i:0;s:22:\"themepunch-ext-c.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-a.tools\";i:3;s:22:\"themepunch-ext-a.tools\";i:4;s:22:\"themepunch-ext-b.tools\";i:5;s:16:\"themepunch.tools\";i:6;s:22:\"themepunch-ext-c.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("179", "revslider_server_refresh", "1671031950", "yes");
INSERT INTO `wp_options` VALUES("180", "revslider-update-check-short", "1671222317", "yes");
INSERT INTO `wp_options` VALUES("181", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("182", "revslider-update-hash", "547696f11f5702139271e24fe8a84fb9", "yes");
INSERT INTO `wp_options` VALUES("183", "revslider-latest-version", "6.6.7", "yes");
INSERT INTO `wp_options` VALUES("184", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("185", "revslider-notices", "a:3:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.0.0\";s:4:\"text\";s:545:\"<div style=\"display: block; background: #fff;text-align: center; \nheight: 300px;\"><a \nhref=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium2\"\n target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: \ncover; background-size: cover; opacity: 1; width: 920px; height: 300px; \ndisplay: inline-block;\" muted=\"\" loop=\"\" autoplay=\"\" \npreload=\"auto\"><source \nsrc=\"//updates.themepunch-ext-c.tools//banners/videobanner_premium2.mp4\" \ntype=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:12:\"TPRSV6511-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.0.0\";s:4:\"text\";s:407:\"<div style=\"display: block; background:#fff;text-align: center; \nheight: 250px;\"><a \nhref=\"https://www.sliderrevolution.com/wordpress-hosting/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getwphosting\"\n target=\"_blank\" rel=\"noopener\"><img style=\"width: 960px; \nheight: 250px; display: inline-block;\" \n src=\"//updates.themepunch-ext-c.tools//banners/rs60/wphostingadmin.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPRSV6518-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:556:\"<div style=\"display: block; background: #fff;text-align: center; height: 300px;\"><a href=\"https://www.sliderrevolution.com/slider-revolution-visual-editor-version-6-6/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=update66\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 920px; height: 300px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-c.tools//banners/rs60/update66videobanner2.mp4\" type=\"video/mp4\"></video></a></div>\n\";s:4:\"code\";s:8:\"TPRSV663\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("186", "revslider-additions", "O:8:\"stdClass\":1:{s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("187", "rs-addons-counter", "0", "yes");
INSERT INTO `wp_options` VALUES("188", "revslider-addons", "O:8:\"stdClass\":31:{s:25:\"revslider-particles-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"413\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.2.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2021-06-25\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"404\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.0.7\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2022-05-25\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2021-12-15\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"410\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_mousetrap.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"409\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.0.8\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2022-04-12\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_lottie.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2021-08-09\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"383\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_charts.png\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2021-07-08\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_charts.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"408\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2021-06-22\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2021-07-17\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:84:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"412\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2021-06-22\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"396\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2021-12-23\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2021-10-11\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2021-07-08\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:80:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:81:\"//updates.themepunch-ext-c.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2022-05-11\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2021-11-03\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2022-02-19\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_domainswitch.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2021-06-12\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2022-05-25\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2022-01-31\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2022-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2021-06-12\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2021-05-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2021-05-28\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}}", "yes");
INSERT INTO `wp_options` VALUES("547", "litespeed.gui._summary", "a:2:{s:11:\"new_version\";i:1627642426;s:5:\"score\";i:1627988026;}", "yes");
INSERT INTO `wp_options` VALUES("204", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("169", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("12609", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("271", "duplicator_settings", "a:17:{s:7:\"version\";s:5:\"1.4.2\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("272", "duplicator_version_plugin", "1.4.2", "yes");
INSERT INTO `wp_options` VALUES("273", "duplicator_ui_view_state", "a:2:{s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";}", "yes");
INSERT INTO `wp_options` VALUES("274", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-12-16 20:29:30\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:17:\"20210728_bnbtakim\";s:4:\"Hash\";s:35:\"f4baba08ab58bca28286_20221216202930\";s:8:\"NameHash\";s:53:\"20210728_bnbtakim_f4baba08ab58bca28286_20221216202930\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:63:\"20210728_bnbtakim_f4baba08ab58bca28286_20221216202930_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:39:\"/home/ankarau1/public_html/bnbtakim.com\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-12-16 20:29:30\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"5.7.40\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:17:\"20210728_bnbtakim\";s:4:\"Hash\";s:35:\"f4baba08ab58bca28286_20221216202930\";s:8:\"NameHash\";s:53:\"20210728_bnbtakim_f4baba08ab58bca28286_20221216202930\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:30:\"MySQL Community Server - (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:0:{}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:63;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:48:\"/home/ankarau1/public_html/bnbtakim.com/wp-admin\";i:1;s:58:\"/home/ankarau1/public_html/bnbtakim.com/wp-content/uploads\";i:2;s:60:\"/home/ankarau1/public_html/bnbtakim.com/wp-content/languages\";i:3;s:57:\"/home/ankarau1/public_html/bnbtakim.com/wp-content/themes\";i:4;s:51:\"/home/ankarau1/public_html/bnbtakim.com/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:39:\"/home/ankarau1/public_html/bnbtakim.com\";i:1;s:50:\"/home/ankarau1/public_html/bnbtakim.com/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:129;}", "yes");
INSERT INTO `wp_options` VALUES("45152", "_icl_cache", "a:2:{s:25:\"language_name_cache_class\";a:136:{s:21:\"language_details_sqtr\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:10:\"Arnavutça\";}s:21:\"language_details_artr\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:7:\"Arapça\";}s:21:\"language_details_hytr\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Ermenice\";}s:21:\"language_details_eutr\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:9:\"Bask dili\";}s:21:\"language_details_bntr\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:21:\"language_details_bstr\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:10:\"Boşnakça\";}s:21:\"language_details_bgtr\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:8:\"Bulgarca\";}s:21:\"language_details_catr\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:12:\"Katalan dili\";}s:26:\"language_details_zh-hanstr\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:13:\"Modern Çince\";}s:26:\"language_details_zh-hanttr\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:13:\"Klasik Çince\";}s:21:\"language_details_hrtr\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:10:\"Hırvatça\";}s:21:\"language_details_cstr\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:7:\"Çekçe\";}s:21:\"language_details_datr\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:5:\"Danca\";}s:21:\"language_details_nltr\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:10:\"Hollandaca\";}s:21:\"language_details_entr\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:10:\"İngilizce\";}s:21:\"language_details_eotr\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:21:\"language_details_ettr\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:12:\"Estonya dili\";}s:21:\"language_details_fitr\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:5:\"Fince\";}s:21:\"language_details_frtr\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:10:\"Fransızca\";}s:21:\"language_details_gltr\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:21:\"language_details_detr\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:7:\"Almanca\";}s:21:\"language_details_eltr\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικα\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:7:\"Yunanca\";}s:21:\"language_details_hetr\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:9:\"İbranice\";}s:21:\"language_details_hitr\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:7:\"Hintçe\";}s:21:\"language_details_hutr\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:7:\"Macarca\";}s:21:\"language_details_istr\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:10:\"İzlandaca\";}s:21:\"language_details_idtr\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:14:\"Endonezya dili\";}s:21:\"language_details_gatr\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:13:\"İrlanda dili\";}s:21:\"language_details_ittr\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:10:\"İtalyanca\";}s:21:\"language_details_jatr\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:7:\"Japonca\";}s:21:\"language_details_kotr\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:9:\"Kore dili\";}s:21:\"language_details_kutr\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:8:\"Kürtçe\";}s:21:\"language_details_lvtr\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Letonca\";}s:21:\"language_details_lttr\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:8:\"Lietuvos\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Litvanyaca\";}s:21:\"language_details_mktr\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:11:\"Makedonyaca\";}s:21:\"language_details_mstr\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:21:\"language_details_mttr\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:10:\"Malta dili\";}s:21:\"language_details_mntr\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:8:\"Mongolca\";}s:21:\"language_details_netr\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:10:\"Nepal dili\";}s:21:\"language_details_notr\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:19:\"Bokmal Norveç dili\";}s:21:\"language_details_fatr\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Farsça\";}s:21:\"language_details_pltr\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:9:\"Polonyaca\";}s:24:\"language_details_pt-brtr\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:20:\"Portekizce, Brezilya\";}s:24:\"language_details_pt-pttr\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:20:\"Portekizce, Portekiz\";}s:21:\"language_details_patr\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:9:\"Pencapça\";}s:21:\"language_details_qutr\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:12:\"Quechua dili\";}s:21:\"language_details_rotr\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:7:\"Rumence\";}s:21:\"language_details_rutr\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:6:\"Rusça\";}s:21:\"language_details_srtr\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:8:\"Sırpça\";}s:21:\"language_details_sktr\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:9:\"Slav dili\";}s:21:\"language_details_sltr\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:11:\"Sloven dili\";}s:21:\"language_details_sotr\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:8:\"Somalice\";}s:21:\"language_details_estr\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:11:\"İspanyolca\";}s:21:\"language_details_svtr\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:10:\"İsveççe\";}s:21:\"language_details_tatr\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:10:\"Tamil dili\";}s:21:\"language_details_thtr\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:5:\"Tayca\";}s:21:\"language_details_trtr\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:8:\"Türkçe\";}s:21:\"language_details_uktr\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:9:\"Ukrainian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukraynaca\";}s:21:\"language_details_urtr\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:6:\"Urduca\";}s:21:\"language_details_uztr\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:9:\"Özbekçe\";}s:21:\"language_details_vitr\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:9:\"Vietnamca\";}s:21:\"language_details_cytr\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Galce\";}s:21:\"language_details_yitr\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:14:\"Eski İbranice\";}s:21:\"language_details_zutr\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:9:\"Zulu dili\";}s:29:\"all_language_tr__english_name\";a:64:{s:2:\"sq\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:10:\"Arnavutça\";}s:2:\"ar\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:7:\"Arapça\";}s:2:\"hy\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Ermenice\";}s:2:\"eu\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:9:\"Bask dili\";}s:2:\"bn\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:2:\"bs\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:10:\"Boşnakça\";}s:2:\"bg\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:8:\"Bulgarca\";}s:2:\"ca\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:12:\"Katalan dili\";}s:7:\"zh-hans\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:13:\"Modern Çince\";}s:7:\"zh-hant\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:13:\"Klasik Çince\";}s:2:\"hr\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:10:\"Hırvatça\";}s:2:\"cs\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:7:\"Çekçe\";}s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:5:\"Danca\";}s:2:\"nl\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:10:\"Hollandaca\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:10:\"İngilizce\";}s:2:\"eo\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:2:\"et\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:12:\"Estonya dili\";}s:2:\"fi\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:5:\"Fince\";}s:2:\"fr\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:10:\"Fransızca\";}s:2:\"gl\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:2:\"de\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:7:\"Almanca\";}s:2:\"el\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικα\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:7:\"Yunanca\";}s:2:\"he\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:9:\"İbranice\";}s:2:\"hi\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:7:\"Hintçe\";}s:2:\"hu\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:7:\"Macarca\";}s:2:\"is\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:10:\"İzlandaca\";}s:2:\"id\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:14:\"Endonezya dili\";}s:2:\"ga\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:13:\"İrlanda dili\";}s:2:\"it\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:10:\"İtalyanca\";}s:2:\"ja\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:7:\"Japonca\";}s:2:\"ko\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:9:\"Kore dili\";}s:2:\"ku\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:8:\"Kürtçe\";}s:2:\"lv\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Letonca\";}s:2:\"lt\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:8:\"Lietuvos\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Litvanyaca\";}s:2:\"mk\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:11:\"Makedonyaca\";}s:2:\"ms\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:2:\"mt\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:10:\"Malta dili\";}s:2:\"mn\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:8:\"Mongolca\";}s:2:\"ne\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:10:\"Nepal dili\";}s:2:\"no\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:19:\"Bokmal Norveç dili\";}s:2:\"fa\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Farsça\";}s:2:\"pl\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:9:\"Polonyaca\";}s:5:\"pt-br\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:20:\"Portekizce, Brezilya\";}s:5:\"pt-pt\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:20:\"Portekizce, Portekiz\";}s:2:\"pa\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:9:\"Pencapça\";}s:2:\"qu\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:12:\"Quechua dili\";}s:2:\"ro\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:7:\"Rumence\";}s:2:\"ru\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:6:\"Rusça\";}s:2:\"sr\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:8:\"Sırpça\";}s:2:\"sk\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:9:\"Slav dili\";}s:2:\"sl\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:11:\"Sloven dili\";}s:2:\"so\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:8:\"Somalice\";}s:2:\"es\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:11:\"İspanyolca\";}s:2:\"sv\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:10:\"İsveççe\";}s:2:\"ta\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:10:\"Tamil dili\";}s:2:\"th\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:5:\"Tayca\";}s:2:\"tr\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:8:\"Türkçe\";}s:2:\"uk\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:9:\"Ukrainian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukraynaca\";}s:2:\"ur\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:6:\"Urduca\";}s:2:\"uz\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:9:\"Özbekçe\";}s:2:\"vi\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:9:\"Vietnamca\";}s:2:\"cy\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Galce\";}s:2:\"yi\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:14:\"Eski İbranice\";}s:2:\"zu\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:9:\"Zulu dili\";}}s:28:\"in_language_tr__english_name\";a:2:{s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:10:\"İngilizce\";}s:2:\"tr\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:8:\"Türkçe\";}}s:4:\"enen\";s:7:\"English\";s:4:\"entr\";s:10:\"İngilizce\";s:4:\"trtr\";s:8:\"Türkçe\";s:21:\"language_details_sqen\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:8:\"Albanian\";}s:21:\"language_details_aren\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:6:\"Arabic\";}s:21:\"language_details_hyen\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Armenian\";}s:21:\"language_details_euen\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:6:\"Basque\";}s:21:\"language_details_bnen\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:21:\"language_details_bsen\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:7:\"Bosnian\";}s:21:\"language_details_bgen\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:9:\"Bulgarian\";}s:21:\"language_details_caen\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:7:\"Catalan\";}s:26:\"language_details_zh-hansen\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:20:\"Chinese (Simplified)\";}s:26:\"language_details_zh-hanten\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:21:\"Chinese (Traditional)\";}s:21:\"language_details_hren\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:8:\"Croatian\";}s:21:\"language_details_csen\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:5:\"Czech\";}s:21:\"language_details_daen\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:21:\"language_details_nlen\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:5:\"Dutch\";}s:21:\"language_details_enen\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:21:\"language_details_eoen\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:21:\"language_details_eten\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:8:\"Estonian\";}s:21:\"language_details_fien\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:7:\"Finnish\";}s:21:\"language_details_fren\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:6:\"French\";}s:21:\"language_details_glen\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:21:\"language_details_deen\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:6:\"German\";}s:21:\"language_details_elen\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικα\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:5:\"Greek\";}s:21:\"language_details_heen\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:6:\"Hebrew\";}s:21:\"language_details_hien\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:5:\"Hindi\";}s:21:\"language_details_huen\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:9:\"Hungarian\";}s:21:\"language_details_isen\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:9:\"Icelandic\";}s:21:\"language_details_iden\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:10:\"Indonesian\";}s:21:\"language_details_gaen\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:5:\"Irish\";}s:21:\"language_details_iten\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:7:\"Italian\";}s:21:\"language_details_jaen\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:8:\"Japanese\";}s:21:\"language_details_koen\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:6:\"Korean\";}s:21:\"language_details_kuen\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:7:\"Kurdish\";}s:21:\"language_details_lven\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Latvian\";}s:21:\"language_details_lten\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:8:\"Lietuvos\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Lithuanian\";}s:21:\"language_details_mken\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:10:\"Macedonian\";}s:21:\"language_details_msen\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:21:\"language_details_mten\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:7:\"Maltese\";}s:21:\"language_details_mnen\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:9:\"Mongolian\";}s:21:\"language_details_neen\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:6:\"Nepali\";}s:21:\"language_details_noen\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:17:\"Norwegian Bokmål\";}s:21:\"language_details_faen\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Persian\";}s:21:\"language_details_plen\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:6:\"Polish\";}s:24:\"language_details_pt-bren\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:19:\"Portuguese (Brazil)\";}s:24:\"language_details_pt-pten\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:21:\"Portuguese (Portugal)\";}s:21:\"language_details_paen\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:7:\"Punjabi\";}s:21:\"language_details_quen\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:7:\"Quechua\";}s:21:\"language_details_roen\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:8:\"Romanian\";}s:21:\"language_details_ruen\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:7:\"Russian\";}s:21:\"language_details_sren\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:7:\"Serbian\";}s:21:\"language_details_sken\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:6:\"Slovak\";}s:21:\"language_details_slen\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:9:\"Slovenian\";}s:21:\"language_details_soen\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:6:\"Somali\";}s:21:\"language_details_esen\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:7:\"Spanish\";}s:21:\"language_details_sven\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:7:\"Swedish\";}s:21:\"language_details_taen\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:5:\"Tamil\";}s:21:\"language_details_then\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:4:\"Thai\";}s:21:\"language_details_tren\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:7:\"Turkish\";}s:21:\"language_details_uken\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:9:\"Ukrainian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukrainian\";}s:21:\"language_details_uren\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:4:\"Urdu\";}s:21:\"language_details_uzen\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:5:\"Uzbek\";}s:21:\"language_details_vien\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:10:\"Vietnamese\";}s:21:\"language_details_cyen\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Welsh\";}s:21:\"language_details_yien\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:7:\"Yiddish\";}s:21:\"language_details_zuen\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:4:\"Zulu\";}s:29:\"all_language_en__english_name\";a:64:{s:2:\"sq\";a:10:{s:4:\"code\";s:2:\"sq\";s:2:\"id\";s:2:\"48\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:8:\"Albanian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sq_AL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sq\";s:12:\"display_name\";s:8:\"Albanian\";}s:2:\"ar\";a:10:{s:4:\"code\";s:2:\"ar\";s:2:\"id\";s:1:\"5\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ar\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ar\";s:12:\"display_name\";s:6:\"Arabic\";}s:2:\"hy\";a:10:{s:4:\"code\";s:2:\"hy\";s:2:\"id\";s:2:\"24\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hy_AM\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hy\";s:12:\"display_name\";s:8:\"Armenian\";}s:2:\"eu\";a:10:{s:4:\"code\";s:2:\"eu\";s:2:\"id\";s:2:\"16\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eu_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eu\";s:12:\"display_name\";s:6:\"Basque\";}s:2:\"bn\";a:10:{s:4:\"code\";s:2:\"bn\";s:2:\"id\";s:2:\"64\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bn_BD\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bn\";s:12:\"display_name\";s:7:\"Bengali\";}s:2:\"bs\";a:10:{s:4:\"code\";s:2:\"bs\";s:2:\"id\";s:1:\"6\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:7:\"Bosnian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bs_BA\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bs\";s:12:\"display_name\";s:7:\"Bosnian\";}s:2:\"bg\";a:10:{s:4:\"code\";s:2:\"bg\";s:2:\"id\";s:1:\"7\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"bg_BG\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"bg\";s:12:\"display_name\";s:9:\"Bulgarian\";}s:2:\"ca\";a:10:{s:4:\"code\";s:2:\"ca\";s:2:\"id\";s:1:\"8\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ca\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ca\";s:12:\"display_name\";s:7:\"Catalan\";}s:7:\"zh-hans\";a:10:{s:4:\"code\";s:7:\"zh-hans\";s:2:\"id\";s:2:\"59\";s:12:\"english_name\";s:20:\"Chinese (Simplified)\";s:11:\"native_name\";s:12:\"简体中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_CN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hans\";s:12:\"display_name\";s:20:\"Chinese (Simplified)\";}s:7:\"zh-hant\";a:10:{s:4:\"code\";s:7:\"zh-hant\";s:2:\"id\";s:2:\"61\";s:12:\"english_name\";s:21:\"Chinese (Traditional)\";s:11:\"native_name\";s:12:\"繁體中文\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"zh_TW\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:7:\"zh-hant\";s:12:\"display_name\";s:21:\"Chinese (Traditional)\";}s:2:\"hr\";a:10:{s:4:\"code\";s:2:\"hr\";s:2:\"id\";s:2:\"22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"hr\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hr\";s:12:\"display_name\";s:8:\"Croatian\";}s:2:\"cs\";a:10:{s:4:\"code\";s:2:\"cs\";s:2:\"id\";s:1:\"9\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cs_CZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cs\";s:12:\"display_name\";s:5:\"Czech\";}s:2:\"da\";a:10:{s:4:\"code\";s:2:\"da\";s:2:\"id\";s:2:\"12\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"da_DK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"da\";s:12:\"display_name\";s:6:\"Danish\";}s:2:\"nl\";a:10:{s:4:\"code\";s:2:\"nl\";s:2:\"id\";s:2:\"37\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nl_NL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"nl\";s:12:\"display_name\";s:5:\"Dutch\";}s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:2:\"eo\";a:10:{s:4:\"code\";s:2:\"eo\";s:2:\"id\";s:2:\"14\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanta\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"eo_UY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"eo\";s:12:\"display_name\";s:9:\"Esperanto\";}s:2:\"et\";a:10:{s:4:\"code\";s:2:\"et\";s:2:\"id\";s:2:\"15\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"et\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"et\";s:12:\"display_name\";s:8:\"Estonian\";}s:2:\"fi\";a:10:{s:4:\"code\";s:2:\"fi\";s:2:\"id\";s:2:\"18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"fi\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fi\";s:12:\"display_name\";s:7:\"Finnish\";}s:2:\"fr\";a:10:{s:4:\"code\";s:2:\"fr\";s:2:\"id\";s:1:\"4\";s:12:\"english_name\";s:6:\"French\";s:11:\"native_name\";s:9:\"Français\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fr_FR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fr\";s:12:\"display_name\";s:6:\"French\";}s:2:\"gl\";a:10:{s:4:\"code\";s:2:\"gl\";s:2:\"id\";s:2:\"63\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"gl_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"gl\";s:12:\"display_name\";s:8:\"Galician\";}s:2:\"de\";a:10:{s:4:\"code\";s:2:\"de\";s:2:\"id\";s:1:\"3\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"de_DE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"de\";s:12:\"display_name\";s:6:\"German\";}s:2:\"el\";a:10:{s:4:\"code\";s:2:\"el\";s:2:\"id\";s:2:\"13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικα\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"el\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"el\";s:12:\"display_name\";s:5:\"Greek\";}s:2:\"he\";a:10:{s:4:\"code\";s:2:\"he\";s:2:\"id\";s:2:\"20\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:10:\"עברית\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"he_IL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"he\";s:12:\"display_name\";s:6:\"Hebrew\";}s:2:\"hi\";a:10:{s:4:\"code\";s:2:\"hi\";s:2:\"id\";s:2:\"21\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hi_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hi\";s:12:\"display_name\";s:5:\"Hindi\";}s:2:\"hu\";a:10:{s:4:\"code\";s:2:\"hu\";s:2:\"id\";s:2:\"23\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"hu_HU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"hu\";s:12:\"display_name\";s:9:\"Hungarian\";}s:2:\"is\";a:10:{s:4:\"code\";s:2:\"is\";s:2:\"id\";s:2:\"26\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"is_IS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"is\";s:12:\"display_name\";s:9:\"Icelandic\";}s:2:\"id\";a:10:{s:4:\"code\";s:2:\"id\";s:2:\"id\";s:2:\"25\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:9:\"Indonesia\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"id_ID\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"id\";s:12:\"display_name\";s:10:\"Indonesian\";}s:2:\"ga\";a:10:{s:4:\"code\";s:2:\"ga\";s:2:\"id\";s:2:\"19\";s:12:\"english_name\";s:5:\"Irish\";s:11:\"native_name\";s:7:\"Gaeilge\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ga_IE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ga\";s:12:\"display_name\";s:5:\"Irish\";}s:2:\"it\";a:10:{s:4:\"code\";s:2:\"it\";s:2:\"id\";s:2:\"27\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"it_IT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"it\";s:12:\"display_name\";s:7:\"Italian\";}s:2:\"ja\";a:10:{s:4:\"code\";s:2:\"ja\";s:2:\"id\";s:2:\"28\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ja\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ja\";s:12:\"display_name\";s:8:\"Japanese\";}s:2:\"ko\";a:10:{s:4:\"code\";s:2:\"ko\";s:2:\"id\";s:2:\"29\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ko_KR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ko\";s:12:\"display_name\";s:6:\"Korean\";}s:2:\"ku\";a:10:{s:4:\"code\";s:2:\"ku\";s:2:\"id\";s:2:\"30\";s:12:\"english_name\";s:7:\"Kurdish\";s:11:\"native_name\";s:7:\"Kurdish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:3:\"ckb\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ku\";s:12:\"display_name\";s:7:\"Kurdish\";}s:2:\"lv\";a:10:{s:4:\"code\";s:2:\"lv\";s:2:\"id\";s:2:\"31\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:9:\"Latviešu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lv_LV\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lv\";s:12:\"display_name\";s:7:\"Latvian\";}s:2:\"lt\";a:10:{s:4:\"code\";s:2:\"lt\";s:2:\"id\";s:2:\"32\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:8:\"Lietuvos\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"lt_LT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"lt\";s:12:\"display_name\";s:10:\"Lithuanian\";}s:2:\"mk\";a:10:{s:4:\"code\";s:2:\"mk\";s:2:\"id\";s:2:\"33\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:20:\"македонски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mk_MK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mk\";s:12:\"display_name\";s:10:\"Macedonian\";}s:2:\"ms\";a:10:{s:4:\"code\";s:2:\"ms\";s:2:\"id\";s:2:\"62\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:6:\"Melayu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ms_MY\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ms\";s:12:\"display_name\";s:5:\"Malay\";}s:2:\"mt\";a:10:{s:4:\"code\";s:2:\"mt\";s:2:\"id\";s:2:\"34\";s:12:\"english_name\";s:7:\"Maltese\";s:11:\"native_name\";s:5:\"Malti\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mt_MT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mt\";s:12:\"display_name\";s:7:\"Maltese\";}s:2:\"mn\";a:10:{s:4:\"code\";s:2:\"mn\";s:2:\"id\";s:2:\"35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:9:\"Mongolian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"mn_MN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"mn\";s:12:\"display_name\";s:9:\"Mongolian\";}s:2:\"ne\";a:10:{s:4:\"code\";s:2:\"ne\";s:2:\"id\";s:2:\"36\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:6:\"Nepali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"ne\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ne\";s:12:\"display_name\";s:6:\"Nepali\";}s:2:\"no\";a:10:{s:4:\"code\";s:2:\"no\";s:2:\"id\";s:2:\"38\";s:12:\"english_name\";s:17:\"Norwegian Bokmål\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"nb_NO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"no\";s:12:\"display_name\";s:17:\"Norwegian Bokmål\";}s:2:\"fa\";a:10:{s:4:\"code\";s:2:\"fa\";s:2:\"id\";s:2:\"17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"fa_IR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"fa\";s:12:\"display_name\";s:7:\"Persian\";}s:2:\"pl\";a:10:{s:4:\"code\";s:2:\"pl\";s:2:\"id\";s:2:\"40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"polski\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pl_PL\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pl\";s:12:\"display_name\";s:6:\"Polish\";}s:5:\"pt-br\";a:10:{s:4:\"code\";s:5:\"pt-br\";s:2:\"id\";s:2:\"42\";s:12:\"english_name\";s:18:\"Portuguese, Brazil\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_BR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-br\";s:12:\"display_name\";s:19:\"Portuguese (Brazil)\";}s:5:\"pt-pt\";a:10:{s:4:\"code\";s:5:\"pt-pt\";s:2:\"id\";s:2:\"41\";s:12:\"english_name\";s:20:\"Portuguese, Portugal\";s:11:\"native_name\";s:10:\"Português\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"pt_PT\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:5:\"pt-pt\";s:12:\"display_name\";s:21:\"Portuguese (Portugal)\";}s:2:\"pa\";a:10:{s:4:\"code\";s:2:\"pa\";s:2:\"id\";s:2:\"39\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:7:\"Punjabi\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"pa\";s:12:\"display_name\";s:7:\"Punjabi\";}s:2:\"qu\";a:10:{s:4:\"code\";s:2:\"qu\";s:2:\"id\";s:2:\"43\";s:12:\"english_name\";s:7:\"Quechua\";s:11:\"native_name\";s:7:\"Quechua\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:6:\"quz_PE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"qu\";s:12:\"display_name\";s:7:\"Quechua\";}s:2:\"ro\";a:10:{s:4:\"code\";s:2:\"ro\";s:2:\"id\";s:2:\"44\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ro_RO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ro\";s:12:\"display_name\";s:8:\"Romanian\";}s:2:\"ru\";a:10:{s:4:\"code\";s:2:\"ru\";s:2:\"id\";s:2:\"45\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ru_RU\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ru\";s:12:\"display_name\";s:7:\"Russian\";}s:2:\"sr\";a:10:{s:4:\"code\";s:2:\"sr\";s:2:\"id\";s:2:\"49\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:12:\"српски\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sr_RS\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sr\";s:12:\"display_name\";s:7:\"Serbian\";}s:2:\"sk\";a:10:{s:4:\"code\";s:2:\"sk\";s:2:\"id\";s:2:\"10\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sk_SK\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sk\";s:12:\"display_name\";s:6:\"Slovak\";}s:2:\"sl\";a:10:{s:4:\"code\";s:2:\"sl\";s:2:\"id\";s:2:\"46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sl_SI\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sl\";s:12:\"display_name\";s:9:\"Slovenian\";}s:2:\"so\";a:10:{s:4:\"code\";s:2:\"so\";s:2:\"id\";s:2:\"47\";s:12:\"english_name\";s:6:\"Somali\";s:11:\"native_name\";s:6:\"Somali\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"so_SO\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"so\";s:12:\"display_name\";s:6:\"Somali\";}s:2:\"es\";a:10:{s:4:\"code\";s:2:\"es\";s:2:\"id\";s:1:\"2\";s:12:\"english_name\";s:7:\"Spanish\";s:11:\"native_name\";s:8:\"Español\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"es_ES\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"es\";s:12:\"display_name\";s:7:\"Spanish\";}s:2:\"sv\";a:10:{s:4:\"code\";s:2:\"sv\";s:2:\"id\";s:2:\"50\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"sv_SE\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"sv\";s:12:\"display_name\";s:7:\"Swedish\";}s:2:\"ta\";a:10:{s:4:\"code\";s:2:\"ta\";s:2:\"id\";s:2:\"51\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:5:\"Tamil\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"ta_IN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ta\";s:12:\"display_name\";s:5:\"Tamil\";}s:2:\"th\";a:10:{s:4:\"code\";s:2:\"th\";s:2:\"id\";s:2:\"52\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"th\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"th\";s:12:\"display_name\";s:4:\"Thai\";}s:2:\"tr\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:7:\"Turkish\";}s:2:\"uk\";a:10:{s:4:\"code\";s:2:\"uk\";s:2:\"id\";s:2:\"54\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:9:\"Ukrainian\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:2:\"uk\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uk\";s:12:\"display_name\";s:9:\"Ukrainian\";}s:2:\"ur\";a:10:{s:4:\"code\";s:2:\"ur\";s:2:\"id\";s:2:\"55\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:9:\"اردو \";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"ur\";s:12:\"display_name\";s:4:\"Urdu\";}s:2:\"uz\";a:10:{s:4:\"code\";s:2:\"uz\";s:2:\"id\";s:2:\"56\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:5:\"Uzbek\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"uz_UZ\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"uz\";s:12:\"display_name\";s:5:\"Uzbek\";}s:2:\"vi\";a:10:{s:4:\"code\";s:2:\"vi\";s:2:\"id\";s:2:\"57\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"vi_VN\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"vi\";s:12:\"display_name\";s:10:\"Vietnamese\";}s:2:\"cy\";a:10:{s:4:\"code\";s:2:\"cy\";s:2:\"id\";s:2:\"11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:5:\"cy_GB\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"cy\";s:12:\"display_name\";s:5:\"Welsh\";}s:2:\"yi\";a:10:{s:4:\"code\";s:2:\"yi\";s:2:\"id\";s:2:\"58\";s:12:\"english_name\";s:7:\"Yiddish\";s:11:\"native_name\";s:7:\"Yiddish\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"yi\";s:12:\"display_name\";s:7:\"Yiddish\";}s:2:\"zu\";a:10:{s:4:\"code\";s:2:\"zu\";s:2:\"id\";s:2:\"60\";s:12:\"english_name\";s:4:\"Zulu\";s:11:\"native_name\";s:4:\"Zulu\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"0\";s:14:\"default_locale\";s:0:\"\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"zu\";s:12:\"display_name\";s:4:\"Zulu\";}}s:28:\"in_language_en__english_name\";a:2:{s:2:\"en\";a:10:{s:4:\"code\";s:2:\"en\";s:2:\"id\";s:1:\"1\";s:12:\"english_name\";s:7:\"English\";s:11:\"native_name\";s:7:\"English\";s:5:\"major\";s:1:\"1\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"en_US\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"en\";s:12:\"display_name\";s:7:\"English\";}s:2:\"tr\";a:10:{s:4:\"code\";s:2:\"tr\";s:2:\"id\";s:2:\"53\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:5:\"major\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:14:\"default_locale\";s:5:\"tr_TR\";s:10:\"encode_url\";s:1:\"0\";s:3:\"tag\";s:2:\"tr\";s:12:\"display_name\";s:7:\"Turkish\";}}s:4:\"tren\";s:7:\"Turkish\";}s:17:\"flags_cache_class\";a:2:{s:2:\"en\";O:8:\"stdClass\":2:{s:4:\"flag\";s:6:\"en.png\";s:13:\"from_template\";s:1:\"0\";}s:2:\"tr\";O:8:\"stdClass\":2:{s:4:\"flag\";s:6:\"tr.png\";s:13:\"from_template\";s:1:\"0\";}}}", "yes");
INSERT INTO `wp_options` VALUES("45395", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1671180530;s:7:\"checked\";a:6:{s:7:\"kallyas\";s:6:\"4.18.1\";s:14:\"twentynineteen\";s:3:\"2.0\";s:12:\"twentytwenty\";s:3:\"1.7\";s:15:\"twentytwentyone\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.0\";s:15:\"twentytwentytwo\";s:3:\"1.0\";}s:8:\"response\";a:4:{s:14:\"twentynineteen\";a:6:{s:5:\"theme\";s:14:\"twentynineteen\";s:11:\"new_version\";s:3:\"2.4\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentynineteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentynineteen.2.4.zip\";s:8:\"requires\";s:5:\"4.9.6\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:12:\"twentytwenty\";a:6:{s:5:\"theme\";s:12:\"twentytwenty\";s:11:\"new_version\";s:3:\"2.1\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwenty/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwenty.2.1.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.7\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.7.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.3.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:9:\"no_update\";a:1:{s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.0.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("45396", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1671222541;s:8:\"response\";a:12:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"5.0.2\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.5.0.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:3:\"5.2\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.7.1\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.1.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:67:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=2279696\";s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.0\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";b:0;}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:5:\"1.5.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/duplicator.1.5.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2605836\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2605835\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2085472\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:5:\"5.3.8\";}s:27:\"fluent-smtp/fluent-smtp.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:25:\"w.org/plugins/fluent-smtp\";s:4:\"slug\";s:11:\"fluent-smtp\";s:6:\"plugin\";s:27:\"fluent-smtp/fluent-smtp.php\";s:11:\"new_version\";s:5:\"2.2.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/fluent-smtp/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/fluent-smtp.2.2.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:56:\"https://ps.w.org/fluent-smtp/assets/icon.svg?rev=2458343\";s:3:\"svg\";s:56:\"https://ps.w.org/fluent-smtp/assets/icon.svg?rev=2458343\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/fluent-smtp/assets/banner-1544x500.png?rev=2606439\";s:2:\"1x\";s:66:\"https://ps.w.org/fluent-smtp/assets/banner-772x250.png?rev=2606439\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.5\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:3:\"7.1\";}s:31:\"creame-whatsapp-me/joinchat.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:32:\"w.org/plugins/creame-whatsapp-me\";s:4:\"slug\";s:18:\"creame-whatsapp-me\";s:6:\"plugin\";s:31:\"creame-whatsapp-me/joinchat.php\";s:11:\"new_version\";s:6:\"4.5.14\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/creame-whatsapp-me/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/creame-whatsapp-me.4.5.14.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/creame-whatsapp-me/assets/icon-256x256.gif?rev=2699533\";s:2:\"1x\";s:71:\"https://ps.w.org/creame-whatsapp-me/assets/icon-128x128.gif?rev=2699533\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/creame-whatsapp-me/assets/banner-1544x500.png?rev=2742423\";s:2:\"1x\";s:73:\"https://ps.w.org/creame-whatsapp-me/assets/banner-772x250.png?rev=2742423\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"4.4.0\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:3:\"5.5\";}s:35:\"litespeed-cache/litespeed-cache.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:29:\"w.org/plugins/litespeed-cache\";s:4:\"slug\";s:15:\"litespeed-cache\";s:6:\"plugin\";s:35:\"litespeed-cache/litespeed-cache.php\";s:11:\"new_version\";s:5:\"5.3.1\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/litespeed-cache/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/litespeed-cache.5.3.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/litespeed-cache/assets/icon-256x256.png?rev=2554181\";s:2:\"1x\";s:68:\"https://ps.w.org/litespeed-cache/assets/icon-128x128.png?rev=2554181\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/litespeed-cache/assets/banner-1544x500.png?rev=2554181\";s:2:\"1x\";s:70:\"https://ps.w.org/litespeed-cache/assets/banner-772x250.png?rev=2554181\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";b:0;}s:21:\"mailin/sendinblue.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:20:\"w.org/plugins/mailin\";s:4:\"slug\";s:6:\"mailin\";s:6:\"plugin\";s:21:\"mailin/sendinblue.php\";s:11:\"new_version\";s:6:\"3.1.54\";s:3:\"url\";s:37:\"https://wordpress.org/plugins/mailin/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/mailin.3.1.54.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/mailin/assets/icon-256x256.png?rev=2128831\";s:2:\"1x\";s:59:\"https://ps.w.org/mailin/assets/icon-128x128.png?rev=2128831\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/mailin/assets/banner-772x250.jpg?rev=2128832\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.4\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:6:\"6.0.12\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/really-simple-ssl.6.0.12.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2810060\";s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2810049\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=2810049\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=2810049\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.7\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:3:\"7.2\";}s:35:\"wp-fastest-cache/wpFastestCache.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:30:\"w.org/plugins/wp-fastest-cache\";s:4:\"slug\";s:16:\"wp-fastest-cache\";s:6:\"plugin\";s:35:\"wp-fastest-cache/wpFastestCache.php\";s:11:\"new_version\";s:5:\"1.0.9\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/wp-fastest-cache/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/wp-fastest-cache.1.0.9.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wp-fastest-cache/assets/icon-256x256.png?rev=2064586\";s:2:\"1x\";s:69:\"https://ps.w.org/wp-fastest-cache/assets/icon-128x128.png?rev=1068904\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/wp-fastest-cache/assets/banner-772x250.jpg?rev=1064099\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.3\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";b:0;}s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:33:\"w.org/plugins/wp-maintenance-mode\";s:4:\"slug\";s:19:\"wp-maintenance-mode\";s:6:\"plugin\";s:43:\"wp-maintenance-mode/wp-maintenance-mode.php\";s:11:\"new_version\";s:5:\"2.6.2\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/wp-maintenance-mode/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/wp-maintenance-mode.2.6.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:64:\"https://ps.w.org/wp-maintenance-mode/assets/icon.svg?rev=2809498\";s:3:\"svg\";s:64:\"https://ps.w.org/wp-maintenance-mode/assets/icon.svg?rev=2809498\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/wp-maintenance-mode/assets/banner-1544x500.png?rev=2809498\";s:2:\"1x\";s:74:\"https://ps.w.org/wp-maintenance-mode/assets/banner-772-250.png?rev=2809498\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.5\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:33:\"duplicate-post/duplicate-post.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:28:\"w.org/plugins/duplicate-post\";s:4:\"slug\";s:14:\"duplicate-post\";s:6:\"plugin\";s:33:\"duplicate-post/duplicate-post.php\";s:11:\"new_version\";s:3:\"4.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-post/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/duplicate-post.4.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-256x256.png?rev=2336666\";s:2:\"1x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-128x128.png?rev=2336666\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/duplicate-post/assets/banner-1544x500.png?rev=2336666\";s:2:\"1x\";s:69:\"https://ps.w.org/duplicate-post/assets/banner-772x250.png?rev=2336666\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:6:\"5.6.20\";}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:5:\"19.12\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.12.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.png?rev=2643727\";s:2:\"1x\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";s:3:\"svg\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=2363699\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=2643727\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=2643727\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=2643727\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=2643727\";}s:8:\"requires\";s:3:\"5.9\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:6:\"5.6.20\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:1:{s:9:\"hello.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582\";s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}}}", "no");
INSERT INTO `wp_options` VALUES("910", "wpseo_titles", "a:194:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:49:\"%%name%%, %%sitename%% sitesinin yazarı %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:69:\"%%searchphrase%% için arama yaptınız %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:38:\"Sayfa bulunamadı %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:71:\"%%POSTLINK%% yazısı ilk önce %%BLOGLINK%% üzerinde ortaya çıktı.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:27:\"Hata 404: Sayfa bulunamadı\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:6:\"Arşiv\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:8:\"Anasayfa\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"Şunu aradınız\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:15:\"title-zn_layout\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-zn_layout\";s:0:\"\";s:17:\"noindex-zn_layout\";b:0;s:28:\"display-metabox-pt-zn_layout\";b:1;s:28:\"post_types-zn_layout-maintax\";i:0;s:26:\"schema-page-type-zn_layout\";s:7:\"WebPage\";s:29:\"schema-article-type-zn_layout\";s:4:\"None\";s:22:\"social-title-zn_layout\";s:9:\"%%title%%\";s:28:\"social-description-zn_layout\";s:0:\"\";s:26:\"social-image-url-zn_layout\";s:0:\"\";s:25:\"social-image-id-zn_layout\";i:0;s:15:\"title-portfolio\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-portfolio\";s:0:\"\";s:17:\"noindex-portfolio\";b:0;s:28:\"display-metabox-pt-portfolio\";b:1;s:28:\"post_types-portfolio-maintax\";i:0;s:26:\"schema-page-type-portfolio\";s:7:\"WebPage\";s:29:\"schema-article-type-portfolio\";s:4:\"None\";s:22:\"social-title-portfolio\";s:9:\"%%title%%\";s:28:\"social-description-portfolio\";s:0:\"\";s:26:\"social-image-url-portfolio\";s:0:\"\";s:25:\"social-image-id-portfolio\";i:0;s:25:\"title-ptarchive-portfolio\";s:51:\"%%pt_plural%% arşivi %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-ptarchive-portfolio\";s:0:\"\";s:27:\"bctitle-ptarchive-portfolio\";s:0:\"\";s:27:\"noindex-ptarchive-portfolio\";b:0;s:32:\"social-title-ptarchive-portfolio\";s:21:\"%%pt_plural%% arşivi\";s:38:\"social-description-ptarchive-portfolio\";s:0:\"\";s:36:\"social-image-url-ptarchive-portfolio\";s:0:\"\";s:35:\"social-image-id-ptarchive-portfolio\";i:0;s:19:\"title-documentation\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-documentation\";s:0:\"\";s:21:\"noindex-documentation\";b:0;s:32:\"display-metabox-pt-documentation\";b:1;s:32:\"post_types-documentation-maintax\";i:0;s:30:\"schema-page-type-documentation\";s:7:\"WebPage\";s:33:\"schema-article-type-documentation\";s:4:\"None\";s:26:\"social-title-documentation\";s:9:\"%%title%%\";s:32:\"social-description-documentation\";s:0:\"\";s:30:\"social-image-url-documentation\";s:0:\"\";s:29:\"social-image-id-documentation\";i:0;s:29:\"title-ptarchive-documentation\";s:51:\"%%pt_plural%% arşivi %%page%% %%sep%% %%sitename%%\";s:32:\"metadesc-ptarchive-documentation\";s:0:\"\";s:31:\"bctitle-ptarchive-documentation\";s:0:\"\";s:31:\"noindex-ptarchive-documentation\";b:0;s:36:\"social-title-ptarchive-documentation\";s:21:\"%%pt_plural%% arşivi\";s:42:\"social-description-ptarchive-documentation\";s:0:\"\";s:40:\"social-image-url-ptarchive-documentation\";s:0:\"\";s:39:\"social-image-id-ptarchive-documentation\";i:0;s:24:\"title-znpb_template_mngr\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:27:\"metadesc-znpb_template_mngr\";s:0:\"\";s:26:\"noindex-znpb_template_mngr\";b:0;s:37:\"display-metabox-pt-znpb_template_mngr\";b:1;s:37:\"post_types-znpb_template_mngr-maintax\";i:0;s:35:\"schema-page-type-znpb_template_mngr\";s:7:\"WebPage\";s:38:\"schema-article-type-znpb_template_mngr\";s:4:\"None\";s:31:\"social-title-znpb_template_mngr\";s:9:\"%%title%%\";s:37:\"social-description-znpb_template_mngr\";s:0:\"\";s:35:\"social-image-url-znpb_template_mngr\";s:0:\"\";s:34:\"social-image-id-znpb_template_mngr\";i:0;s:18:\"title-tax-category\";s:55:\"%%term_title%% arşivleri %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:25:\"%%term_title%% arşivleri\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:18:\"title-tax-post_tag\";s:55:\"%%term_title%% arşivleri %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:25:\"%%term_title%% arşivleri\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:21:\"title-tax-post_format\";s:55:\"%%term_title%% arşivleri %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:25:\"%%term_title%% arşivleri\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:32:\"title-tax-documentation_category\";s:55:\"%%term_title%% arşivleri %%page%% %%sep%% %%sitename%%\";s:35:\"metadesc-tax-documentation_category\";s:0:\"\";s:42:\"display-metabox-tax-documentation_category\";b:1;s:34:\"noindex-tax-documentation_category\";b:0;s:39:\"social-title-tax-documentation_category\";s:25:\"%%term_title%% arşivleri\";s:45:\"social-description-tax-documentation_category\";s:0:\"\";s:43:\"social-image-url-tax-documentation_category\";s:0:\"\";s:42:\"social-image-id-tax-documentation_category\";i:0;s:40:\"taxonomy-documentation_category-ptparent\";i:0;s:26:\"title-tax-project_category\";s:55:\"%%term_title%% arşivleri %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-tax-project_category\";s:0:\"\";s:36:\"display-metabox-tax-project_category\";b:1;s:28:\"noindex-tax-project_category\";b:0;s:33:\"social-title-tax-project_category\";s:25:\"%%term_title%% arşivleri\";s:39:\"social-description-tax-project_category\";s:0:\"\";s:37:\"social-image-url-tax-project_category\";s:0:\"\";s:36:\"social-image-id-tax-project_category\";i:0;s:34:\"taxonomy-project_category-ptparent\";i:0;s:24:\"title-tax-portfolio_tags\";s:55:\"%%term_title%% arşivleri %%page%% %%sep%% %%sitename%%\";s:27:\"metadesc-tax-portfolio_tags\";s:0:\"\";s:34:\"display-metabox-tax-portfolio_tags\";b:1;s:26:\"noindex-tax-portfolio_tags\";b:0;s:31:\"social-title-tax-portfolio_tags\";s:25:\"%%term_title%% arşivleri\";s:37:\"social-description-tax-portfolio_tags\";s:0:\"\";s:35:\"social-image-url-tax-portfolio_tags\";s:0:\"\";s:34:\"social-image-id-tax-portfolio_tags\";i:0;s:32:\"taxonomy-portfolio_tags-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("1589", "duplicate_post_copystatus", "0", "yes");
INSERT INTO `wp_options` VALUES("1590", "duplicate_post_copyslug", "0", "yes");
INSERT INTO `wp_options` VALUES("42028", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/tr_TR/wordpress-6.1.1.zip\";s:6:\"locale\";s:5:\"tr_TR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/tr_TR/wordpress-6.1.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.1.1\";s:7:\"version\";s:5:\"6.1.1\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1671180528;s:15:\"version_checked\";s:5:\"6.1.1\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("45478", "_transient_timeout_feed_mod_868981a74fb045e2d866f14ee0dbf978", "1671265737", "no");
INSERT INTO `wp_options` VALUES("45479", "_transient_feed_mod_868981a74fb045e2d866f14ee0dbf978", "1671222537", "no");
INSERT INTO `wp_options` VALUES("45480", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1671265738", "no");
INSERT INTO `wp_options` VALUES("45481", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"BuddyPress: BuddyPress 11.0.0 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=327475\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://buddypress.org/2022/12/buddypress-11-0-0-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3223:\"<p>The first release candidate for BuddyPress 11.0.0 is now available!</p>\n\n\n\n<div class=\"is-horizontal is-content-justification-center is-layout-flex wp-container-1 wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-white-color has-text-color has-background wp-element-button\" href=\"https://downloads.wordpress.org/plugin/buddypress.11.0.0-RC1.zip\">Let&#8217;s test it!</a></div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p>&#8220;Release Candidate&#8221; means that we think the new version is ready for release, but with a bit less than 200,000 active installs, hundreds of BuddyPress plugins and Thousands of WordPress themes, it’s possible something was missed. BuddyPress 11.0.0 is slated for release&nbsp;on&nbsp;<strong>January 5, 2023</strong>, but&nbsp;<em>your</em>&nbsp;help is needed to get there — if you haven’t tried 11.0.0 yet,&nbsp;doing it now is a great idea!</p>\n\n\n\n<p>You can test the&nbsp;<a href=\"https://downloads.wordpress.org/plugin/buddypress.11.0.0-RC1.zip\">11.0.0-RC</a>&nbsp;pre-release in 4 ways :</p>\n\n\n\n<ul>\n<li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/bp-beta-tester/\">BP Beta Tester</a>&nbsp;plugin.</li>\n\n\n\n<li><a href=\"https://downloads.wordpress.org/plugin/buddypress.11.0.0-RC1.zip\">Download the release candidate here (zip file)</a>.</li>\n\n\n\n<li>Check out our SVN repository:&nbsp;<code>svn co https://buddypress.svn.wordpress.org/trunk/</code></li>\n\n\n\n<li>Clone our read-only Git repository:&nbsp;<code>git clone git://buddypress.git.wordpress.org/</code></li>\n</ul>\n\n\n\n<p>A detailed changelog will be part of our official release note, but&nbsp;you can get a quick overview by reading the post about the&nbsp;<a href=\"https://buddypress.org/2022/11/buddypress-11-0-0-beta1/\">11.0.0 Beta1</a>&nbsp;release.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against BuddyPress 11.0.0. If you find compatibility problems, please be sure to post to this specific&nbsp;<a href=\"https://buddypress.org/support/topic/buddypress-11-0-0-release-candidate/\">support topic</a>&nbsp;so we can figure those out before the final release. We strongly advise you to have a look at the&nbsp;<a href=\"https://bpdevel.wordpress.com/category/development-notes/11-0/\">11.0.0 developer notes</a>&nbsp;to figure out what to focus on during your testing.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2>How you can help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp-plugins/buddypress/\">Help us translate BuddyPress into as many languages as possible!</a>&nbsp;This release also marks the&nbsp;<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#string-freeze\">string freeze</a>&nbsp;point of the 11.0.0 release schedule.</p>\n\n\n\n<p><em><strong>If you think you’ve found a bug</strong>, you can share it with us replying to this <a href=\"https://buddypress.org/support/topic/buddypress-11-0-0-release-candidate/\">support topic</a> or if you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://buddypress.trac.wordpress.org/\">file one on BuddyPress Trac</a></em>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Dec 2022 05:51:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mathieu Viet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"WPTavern: State of the Word 2022: Matt Mullenweg Highlights Gutenberg’s Progress, Announces New Community Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=140361\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"https://wptavern.com/state-of-the-word-2022-matt-mullenweg-highlights-gutenbergs-progress-announces-new-community-tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6540:\"<p>State of the Word (SOTW) watch parties kicked off around the world this afternoon as Matt Mullenweg delivered his annual address to the WordPress community. A small group of people gathered live in New York City to participate while the majority of enthusiasts watched via the livestream. Mullenweg spent an hour reviewing and celebrating the work done across the project in 2022 before taking questions from the audience.</p>\n\n\n\n<p>At last year’s SOTW, Mullenweg spoke about how Gutenberg adoption is growing beyond WordPress and how he believed it could become &#8220;bigger than WordPress itself.&#8221; In addition to Gutenberg <a href=\"https://wptavern.com/the-block-editor-is-coming-to-wordpress-support-forums\">getting rolled out on the bbPress support forums</a> this week to modernize the WordPress support experience, the block editor has found its way into more apps in 2022. </p>\n\n\n\n<p>Mullenweg cited a few examples including <a href=\"https://engineawesome.com/\">Engine Awesome</a> (a Laravel-based SaaS application), the Pew Research Center&#8217;s Political Typology Quiz, the web version of Automattic&#8217;s Day One app, and the Tumblr post form. He noted that in Tumblr, 99% of the editor is hidden &#8211; there&#8217;s no sidebar, everything happens inline. Mullenweg said he is hoping Gutenberg can create an &#8220;open block standard that can be used anywhere,&#8221; where users learn it on one system and it can be applied in other apps.</p>\n\n\n\n<p>For those who had been missing WordCamps, one of the major highlights of 2022 was the return to in-person events. From 2021 to 2022, the number of meetup groups doubled. Only one WordCamp was held in 2021 but that jumped to 22 WordCamps in 2022. Mullenweg highlighted how WordCamps have historically been &#8220;the magical ingredient&#8221; for onboarding people to contribute and teaching them about WordPress culture. </p>\n\n\n\n<p>For being just one year back into in-person events, WordPress has done well in 2022 with 1,399 release contributors and 652 contributing for the first time. There were 204 people who contributed to all releases in 2022 and 424 who contributed in 2021 and returned in 2022. Some 322 contributors took a break in 2021 and returned in 2022.</p>\n\n\n\n<img />\n\n\n\n<p>People are also contributing to Openverse, which has indexed more than 22 million images, 1.1 million audio files, and has handled more than 59 million requests in the last 30 days.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Tools Coming to the Community: New Taxonomies for the Plugin and Theme Directories and Staging &#8220;Playground&#8221; that Runs WordPress in the Browser</h3>\n\n\n\n<p>It wouldn&#8217;t be the State of the Word without a few exciting announcements. Mullenweg unveiled a plan to add new taxonomies for the theme and plugin directories that will help users more quickly ascertain the purpose of the extensions they are considering. </p>\n\n\n\n<p>For example, there would be a tag for the type of plugins that a developer might create to solve a problem but may not be intended for wide public use and may not come with dedicated support. Another tag would be designated for &#8220;Community&#8221; plugins, which Mullenweg said is for software that &#8220;belongs to all of us&#8221; with the lead developers stewarding it for the next generation. This tag is for plugins that do not have any upsells and invite contributions. Some of these plugins will be <a href=\"https://wptavern.com/matt-mullenweg-renews-push-for-canonical-plugins\">canonical plugins</a>, those that are officially supported by core developers and receive attention from the security team. Gutenberg and the importer plugins are a few examples.</p>\n\n\n\n<p>Another tag would be designated for commercial plugins that have some sort of upsell and often include commercial support. Anything with a pro version will fall within this category. Mullenweg said he wants WordPress.org to create an environment where commercial and non-commercial plugins can exist together harmoniously.</p>\n\n\n\n<p>The new taxonomies will be launching in the directories this month and will also eventually make their way into the plugin and theme screens inside the WordPress admin. This will be a major improvement that will give users of all experience levels a better understanding of the extensions they are examining, making it easier to select the right type for their needs. </p>\n\n\n\n<p>Mullenweg also announced WordPress&#8217; official support for the <a href=\"https://wptavern.com/new-wordpress-sandbox-project-demos-test-drive-themes-and-plugins-in-the-browser\">WordPress Sandbox project</a>, which we featured earlier this month. He outlined a plan for what will officially be called &#8220;WordPress Playground.&#8221; The experimental project uses WebAssembly (WASM) to <a href=\"https://wptavern.com/new-prototype-runs-wordpress-in-the-browser-with-no-php-server\">run WordPress in the browser without a PHP server</a>, making it possible to spin up new playgrounds in just a couple of seconds. This will enable things like a guided, interactive WordPress landing experience where developers can edit code live and see the results right away. It will also make it possible for users to try plugins directly from the directory and may someday be used to allow people to contribute to WordPress core.</p>\n\n\n\n<p>A new website for WordPress Playground is located at <a href=\"https://developer.wordpress.org/playground/\">https://developer.wordpress.org/playground/</a> where anyone interested can check out the experimental project for running a WordPress instance entirely in your browser. There&#8217;s also a new #meta-playground Slack channel for those who want to join the conversation.</p>\n\n\n\n<img />\n\n\n\n<p>WordPress turns 20 next year. Mullenweg noted that not many software projects make it that long but WordPress is also growing faster than ever, currently powering 43% of websites according to W3Techs and 32% according to Builtwith. A new website at <a href=\"https://wp20.wordpress.net/\">wp20.wordpress.net</a> will be headquarters for the festivities, including swag, merchandise, and a new Milestones book for the most recent 10 years of WordPress&#8217; history. </p>\n\n\n\n<p>If you didn&#8217;t have the chance to catch the State of the Word this afternoon, check out the recording below to hear Mullenweg&#8217;s vision for the next phases of WordPress and see demos of all the progress made on block themes and full-site editing in 2022.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Dec 2022 01:42:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"Post Status: The WP Agency Journey with Krissie VandeNoord of North UX — Post Status Draft 134\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=145935\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://poststatus.com/the-wp-agency-journey-with-krissie-vandenoord-of-north-ux-post-status-draft-134/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:43644:\"<div class=\"is-layout-flow wp-block-group eplus-wrapper has-theme-palette-2-color has-theme-palette-8-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\"><a href=\"https://twitter.com/krissierae\">Krissie VandeNoord</a>, founder of <a href=\"https://www.northuxdesign.com/\">North UX</a>, talks with Cory Miller about their work in creating people-first solutions for the nuanced needs of ecommerce and membership site owners. Krissie shares her story from her early days as a designer and blogger to launching her own agency. Her work and energy will encourage you to think beyond what is to build the possibilities that make things work better. </p></div>\n\n\n<div class=\"wp-block-spacer eplus-wrapper\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">31</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n\n\n\n\n<p><a href=\"https://poststatus.com/planet/feed/#h-transcript\">Transcript</a> ↓</p>\n\n\n\n<p>Cory Miller is joined by North UX founder, Krissie VandeNoord to discuss her journey of agency ownership. Their work contributes to the businesses they serve, winning big and experiencing new levels of growth from the unique solutions they bring. From hearing about her background as a natural problem solver to her experiences engaging client needs with creative solutions, you will be inspired to break through limitations into the land of possibility.</p>\n\n\n\n<p>Top Takeaways:</p>\n\n\n\n<ul>\n<li><strong>Building for Nuance: </strong>North UX likes to hone in on what makes a business really unique and find solutions to highlight those things so they are experienced as an asset instead of a detractor.</li>\n\n\n\n<li><strong>Problem Solving Spiral:</strong> Poking around, asking questions, and figuring out ways to develop solutions spiraled Krissie from seeing and experiencing challenges to being a solution-building developer. Navigating and figuring things out is the work it takes to give you the experience to increase your confidence threshold. This can act as a springboard to making great connections and solving more complex problems.</li>\n\n\n\n<li><strong>Impact of Creating Efficiency: </strong>This isn’t just about creating solutions that get customers to take certain actions. It is also about saving hours or weeks of time spent on manual processes. As a small business owner, I know this makes a BIG difference, and that is exciting. Time can be invested in growth, making the impact exponential. Initial solutions fuel inspiration to shift from survival to ongoing enhancements.</li>\n\n\n\n<li><strong>Empowering DIY-ers:</strong> Rather than viewing self-build solutions as a threat or an indication of impending obsoletion, Krissie frames this as an opportunity to educate and become a trusted expert who will be there when more complex solutions are needed.</li>\n</ul>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<div class=\"is-layout-flex wp-container-4 wp-block-columns has-theme-palette-8-background-color has-background\" id=\"WP-Engine\">\n<div class=\"is-layout-flow wp-block-column\">\n<h3><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/pagely\">Pagely</a></h3>\n\n\n\n<p>Top-Tier Managed WordPress hosting solutions for Enterprise, the Public Sector, and Media companies. We invented Managed WordPress, and we never stopped raising the bar. <strong>Expect Extraordinary!</strong></p>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column is-vertically-aligned-center\"><div class=\"wp-block-image\">\n<a href=\"https://poststat.us/pagely/\"><img width=\"752\" height=\"752\" src=\"https://cdn.poststatus.com/wp-content/uploads/2016/02/Pagely-Mark-Black-752x752.png\" alt=\"Pagely\" class=\"wp-image-93218\" title=\"WP Engine\" /></a></div></div>\n</div>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul>\n<li><a href=\"https://www.northuxdesign.com/\">North UX</a></li>\n\n\n\n<li><a href=\"https://geovin.com/\">Geovin</a></li>\n</ul>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-you-can-follow-post-status-and-our-guests-on-twitter\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> You can follow Post Status and our guests on Twitter:</h3>\n\n\n\n<ul class=\"eplus-wrapper\">\n<li><a href=\"https://twitter.com/krissierae\">Krissie VandeNoord</a> (Team Lead, <a href=\"https://twitter.com/northuxdesign\">North UX</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/corymiller303\">Cory Miller</a> (CEO, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a> (Intern, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n</ul>\n\n\n\n<p class=\"eplus-wrapper has-background\">The <strong>Post Status Draft</strong> podcast is geared toward WordPress professionals, with interviews, news, and deep analysis. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4dd.png\" alt=\"📝\" class=\"wp-smiley\" /><br /><br /><a href=\"https://poststatus.com/category/post-status-podcasts/\" target=\"_blank\" rel=\"noreferrer noopener\">Browse our archives</a>, and don’t forget to subscribe via <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\" target=\"_blank\" rel=\"noreferrer noopener\">iTunes</a>, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\" target=\"_blank\" rel=\"noreferrer noopener\">Google Podcasts</a>, <a href=\"https://www.youtube.com/c/PostStatus\" target=\"_blank\" rel=\"noreferrer noopener\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\" target=\"_blank\" rel=\"noreferrer noopener\">Stitcher</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Simplecast</a>, or <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h2 class=\"eplus-wrapper\" id=\"h-transcript\">Transcript</h2>\n\n\n\n<p><strong>Cory Miller:</strong> [00:00:00] Hey everybody. Welcome back to Post Tes Draft. Um, this is another great story in our agency journey series. Uh, we\'ll be talking to Chrissy, one of our great agency owners. At post status about her journey today, and I got to a couple weeks ago, get to know Chrissy and more about her story, and I\'m really excited to, uh, be able to share her story with you.</p>\n\n\n\n<p>So Chrissy, thanks so much for being on the draft podcast, talking about your journey and what you\'re doing with WordPress.</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> Thank you so much for having me. I\'m super, super excited. Um, yeah, I couldn\'t be, I couldn\'t be more excited to just kind of be engaged in this community and seeing kind of.</p>\n\n\n\n<p>Communities, specifically around agencies kind of start to develop.</p>\n\n\n\n<p><strong>Cory Miller:</strong> It\'s really exciting. There\'s so many good people, members of post status doing great work, and I love when I get to talk to people like you and just see what cool things you\'re doing in the world. So could you tell us, uh, a little bit about [00:01:00] your agency and where you\'re at now and what you do for your clients in the world?</p>\n\n\n\n<p>Yeah,</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> absolutely. So, um, I own North. And, um, my last name is Van De nor, which actually means from the North and, um, which is where North UX came from. When I started, I knew I didn\'t, I wanted to be more than just me. Um, and so I didn\'t want to just like, use my name. And so that\'s, that\'s how we got to North ux.</p>\n\n\n\n<p>And ux obviously. That\'s just very much the center of what we try to do is we\'re really trying to deliver, um, a development experience that very much is considerative of um, how real people are going to engage with what we\'re, what we\'re doing and what we\'re creating, and. [00:02:00] Very, very much like a people first kind of</p>\n\n\n\n<p><strong>Cory Miller:</strong> approach.</p>\n\n\n\n<p>Yeah. I love that there\'s real humans that actually have to use the web, so it\'s kinda good to have that experience. I love, I love the, the basis for the name. Um, so what kind of work do you do at your agency? Yeah. Basis,</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> we typically, um, find, I would say, you know, right now, 99% of our work is, is WordPress in some regard, most of it is some kind of e-commerce, whether it\'s a membership type e-commerce, or whether it\'s actual like a product WooCommerce, um, setup and.</p>\n\n\n\n<p>I would say that we specialize in, uh, working with clients who need something that doesn\'t exist in an off-the-shelf plugin right now. Um, sometimes that\'s just a, a really custom user flow. Like they\'re, they\'re going to use WooCommerce, but they want to really walk their customers through in [00:03:00] a very set, set way.</p>\n\n\n\n<p>Um, sometimes it\'s custom functionality, um, like extending subscriptions or, um, We\'ve done a project with Restrict Content Pro where um, instead of renewing on, um, like a normal annual, like one year from when they signed up, we needed everybody to renew at the exact same time every year. Uh, little things like that that, um, really kind of, I think help businesses and set themselves apart in an industry to be able to just extend kind of like what\'s just out there and accessible to the general business population.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah. And so I, I\'m sorry, I was writing a note, but if, if I missed it. So a lot of your work is membership site projects,</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> um, either memberships or Woo</p>\n\n\n\n<p><strong>Cory Miller:</strong> commerce. Woo commerce. Okay. Yeah. Um, and, and particularly helping with the experiences and some of those custom things that don\'t happen out of the box that I know [00:04:00] from my experience, Christy, and you know, this way better than me building the e-Commerce Pro product back in the day.</p>\n\n\n\n<p>There are a thousand flavors of e-commerce times infinity because everyone has like you. I was trying to imagine when would somebody want to start the first day or whatever that could be, you know, probably a hundred different things, but like there\'s so much nuance in e-commerce and memberships that why organizations, agencies like yours exist because there\'s so many nuanced needs out there.</p>\n\n\n\n<p>Yeah,</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> I mean, it\'s impossible for a plug and developer to be able to truly like be all things to all people and you know, arguably, Trying to do that to a certain extent is going to like water down or bloat, um, what they\'re actually offering. And so we tend to work with plugins that are built in a way and intended to be easily extended by another developer.</p>\n\n\n\n<p>Um, because what we just found is like businesses, [00:05:00] even though, you know, it\'s interesting cuz I think businesses. There are, there are definitely, they\'re buckets. You can put businesses, you know, you\'re direct to consumer, you\'re selling a physical product, you\'re selling, um, you know, digital content. And, but at the same time, like they\'re so different and so nuanced and they have such unique needs, um, that it\'s just really fun to kind of like hone in on what makes businesses really unique and then like work to highlight that and, and make that be an asset instead of a detractor.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah, we would always have this example like, okay, you, you sell a t-shirt, but you want a membership with it. And oh, by the way, you want a 14 day trial, or you want them to pay a dollar for a 14 day trial. And, uh, I mean, you know, oh, and then you wanna be able to add consulting time or a coaching thing to it.</p>\n\n\n\n<p>And that\'s the day and age we we\'re, we\'re in right now is, The web enabling these businesses with [00:06:00] vast setups to be able to offer those things online where it was picking up the phone call and say, okay, well I\'ll take one of those, one of those, one of those. Well, this is technology doing that. So I love that you all are helping people with that, because I see that need so often with these vastly nuanced, uh, needs.</p>\n\n\n\n<p>Yeah,</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> and I feel like that level of nuance was really only available at enter. Like, I mean, even like five, 10 years ago, you know, you, if you were a small business like you, you just had to try to make do, um, because it just wasn\'t as accessible. And there are so many tools now that get you, you know, 70% of the way there, that that extra 30% you can bite that off and it\'s no big deal, um, to a small business.</p>\n\n\n\n<p>Whereas before it just wasn\'t even. , you know, something they were really considering as a possibility.</p>\n\n\n\n<p><strong>Cory Miller:</strong> And that\'s so great, like you said, with the enterprise, [00:07:00] um, you know, with huge budgets, Disney or some other big can code that probably for, to code that. Mainly now we have some tools and great agencies like yours now.</p>\n\n\n\n<p>So tell me a little bit about your team set up and how you work.</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> Yeah, so, um, I have. One official employee, um, and she\'s a project manager and she has been, oh my goodness, that was such a, I can\'t believe I waited so long to hire a project manager, . I should have done that a long time ago. Um, and then everyone else currently right now is a contractor.</p>\n\n\n\n<p>Um, they are either in Europe or in the us and I find that it works best for us to kind of just work on. Hourly model. That\'s how we structure our projects. Um, we give people estimated ranges and we bill hourly. And so I just do the same for, for my people. Um, and I, I just feel like that, [00:08:00] that for me, I\'ve found has been the best setup.</p>\n\n\n\n<p>I\'ve tried a few other things, but as far as like really like paying people for like the value that they\'re bringing, Really doing a true straight up hourly has been the best, best situation. And so right now we have got, um, A freelance designer and UX person, um, that contributes regularly. And then we\'ve got, um, a front end developer that contributes regularly.</p>\n\n\n\n<p>And, um, we have two backend developers beyond just myself. I\'m a full stack develop. I started as a designer and then quickly kind of moved into the development world cause I wanted to control what things looked like and, and now somehow a full stack developer. So, um, And, and just kind of wear all of the hats.</p>\n\n\n\n<p>But yeah, that\'s kind of the makeup of the team at the current moment. And we\'re honestly at the spot now where I\'m I. [00:09:00] Very much looking towards January and having meetings with clients and them saying, we wanna do this, we wanna do that. And I\'m like, okay, I need to figure out who I\'m hiring on , who I\'m gonna bring on</p>\n\n\n\n<p>Cause we\'re not gonna be able to cover</p>\n\n\n\n<p><strong>Cory Miller:</strong> all of this. That\'s a great reflection of doing good work, you know? Yeah.</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> I\'m a, it\'s a really, it\'s, it\'s an exciting place to be, but it\'s also, um, I feel like whenever I bring somebody new on, there\'s this trade off. Um, my productivity decreases because I\'m spending time training them and getting up them up to speed and they\'re not like immediately productive.</p>\n\n\n\n<p>And so there\'s this like dip of like, Okay, now we\'re</p>\n\n\n\n<p><strong>Cory Miller:</strong> great. . Yes. Yes. Well, um, okay, so that\'s how you work and you started getting in a little bit to your journey. So that\'s where you are now. Um, working with WordPress obviously, but also membership sites, WooCommerce, and how your team kind of set up and how you work with clients.[00:10:00]</p>\n\n\n\n<p>Tell us how you got here.</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> Yeah, so like I said, I started as a designer, um, and. It was just like early two thousands, mid two thousands, somewhere there, , where, you know, blogs were super popular and everybody had a blog and um, and so I. I had a blog, but I was a designer, so I wanted to make the blog look like I wanted it to look like, especially if it\'s like representing like myself.</p>\n\n\n\n<p>And so I just, it, it happened to be in WordPress and I just got in there and started like poking around and figuring things out. And that was really kind of like my first experience with code was kind of just. Poking things. And, you know, fast forward, you know, a few years I started with a very small agency.</p>\n\n\n\n<p>Um, and so we, we all wore a lot of hats. And when [00:11:00] I started it was, oh, you know, can, you know, doing a lot of design, but it was, oh, can you, you know, tweak this, you know, h t l newsletter or can you tweak this webpage or whatever. And after a few years, I would start to ask them questions and they\'d be like, you know, more than we do about development right now,</p>\n\n\n\n<p>And, and it just kind of spiraled into. Becoming the queen of web, um, and, and grew from there. I\'ve just always been a natural problem solver. And so that idea of, Hmm, can I do this? I wanna find out , like I wanna figure out how I can do that. Um, and so it, yeah, it just kind of spiraled from there. And then, um, I was with that small agency for I think about eight years, and it just was a real obvious, um, You know, they weren\'t bringing in the business to fill my plate.</p>\n\n\n\n<p>And, um, and so we parted ways, but, and at, at [00:12:00] first they were like, let\'s, you know, keep this relationship going. We\'ll use you as a contractor. But I was like, ah, I just really want a job . Um, I was at that point in time, um, when I started my business, I had a one, I, not even a one year old, he wasn\'t even one years old.</p>\n\n\n\n<p>my second kid. and my daughter was three at the time. So like, I had small children and I was just like, I just want something like nice and consistent and reliable. Um, but it, I did end up starting my business and it\'s been fantastic. Um, and I\'ve never looked back. Um, and it\'s been just, uh, like in some regards, my fear of it, lacking the stability I\'m feeling.</p>\n\n\n\n<p>I\'ve got these young kids, um, Has like the other side of that coin is it\'s offered me the flexibility to like be fully invested in work and at the same time feel like I can be present with my kids and my family. Um, [00:13:00]</p>\n\n\n\n<p><strong>Cory Miller:</strong> do good work and also live life, like Right. Live and manage life. Yeah, absolutely. Now what, what year was it when you started North ux?</p>\n\n\n\n<p>Uh, 2016. 2016. And then how, how did it evolve to, to get into where you\'re really focusing on a lot of commerce and membership projects? Um,</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> you know, it kind of just happened. Organically. One of my first clients was, um, I took over a project that was WooCommerce, um, from someone else. And that was the first time I think I\'d done anything with WooCommerce that really involved extending it in any way.</p>\n\n\n\n<p>Um, and so I just like dove right into the deep end. And, um, man, I, I learned a lot about Woo Conversa in that project cuz we were migrating them. From a whole other system and subscriptions. And so it was, it was just a beast of a [00:14:00] process, um, that took way longer than we thought it was going to. But, um, I gained so much from the experience that then it just was a springboard towards doing more and more along those lines.</p>\n\n\n\n<p>And I also made some really great connections and working on that project, kind of like. Space. Um, and so it just was kind of like a natural extension. And then I think also because I am such a, I just, I really love the problem to solve. Um, I think that e-commerce space just tends to offer the problem a lot.</p>\n\n\n\n<p>And so I naturally gravitate towards like, Ooh, that\'d be fun, .</p>\n\n\n\n<p><strong>Cory Miller:</strong> Um, you, you have to have that mindset and attitude, I think for that because I think of those subjects, I go, oh my gosh. Every possibility, every possible problem. But you have to be somebody that loves that rub. Rubrics cube, you know,</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> kinda problem solving.</p>\n\n\n\n<p>Oh yeah. Yeah. I used to say, um, and I don\'t think this is true anymore, but especially like when I was still working at that agency now as I transitioned into my own business, that when somebody [00:15:00] would come to me and say like, can this be done? I would do just enough research to feel like 60% confident that the answer was yes,</p>\n\n\n\n<p>And then I\'d be like, yeah, we can do it. And then I would just figure it out. Um, and I\'m also just a very much like a, I will finish it. Like it may take longer than I wanted it to. Um, but I\'m kind of like, I can\'t let it go until like I actually solved the problem. And so I don\'t think there\'s any, there\'s ever been something where I like was like 60% and then got into it and was like, oh, nope.</p>\n\n\n\n<p>Nevermind. Can\'t do it. . Um, and I would say anymore, like I. My confidence threshold is much higher just because from experience. Um, so I\'ve never, I think at that 60% mark, but that\'s definitely where I started</p>\n\n\n\n<p><strong>Cory Miller:</strong> that I think that\'s good though. And that\'s the beauty of everything we\'re doing with talented people like yourself is if you have that much confidence, confidence, at least, you know, the other part is part of [00:16:00] just navigating and figuring it out.</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> Exactly.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Exactly. Can you, can you share, um, and you don\'t have to say the name, of course. We want to, you know, I know sometimes we, we need to be careful sharing clients and names and stuff. We can, can you talk about a recent project you\'re really proud of, or you really appreciated what you did, uh, with, with some of your clients?</p>\n\n\n\n<p>Um,</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> stick out. Oh my goodness. Like so many of them. So many of them. And I don\'t think I have any, well, I\'ve got one that I\'m currently working on that I can\'t really talk about, but the rest are all out there for anybody to experience. Um, trying to think what\'s the best, like, I think the most recent one, um, that has just like a real kind of feel, good sense to it is, um, and I talked about it in, um, the woosh, um, presentation that I.</p>\n\n\n\n<p>Goodness. When was that? Beginning of October. Um, but it\'s this furniture company, Giovan, and we did [00:17:00] a implementation, well, we, they were on a very static site. Um, they sh they sold through dealers and so they, for a long time just didn\'t have the need for e-commerce because it, you know, dealers are pay, we\'re placing large orders, that sort of a thing.</p>\n\n\n\n<p>But we essentially moved them into, like, we moved them from like way old to like way new. And to watch them kind, kind of like step into this, um, digital world has been really fun. And, um, we created, you know, a 3D model that connects to the WooCommerce attribute so people can like customize their furniture pieces and like see it like in real time, um, which is really cool.</p>\n\n\n\n<p>But, Like, the part that I\'m loving about it is how much we are like equipping, like the people inside the company and like how it boosts [00:18:00] their excitement about what they\'re doing and then, um, like how that then trickles out to like their customers. And just like having all these like improved experiences and being able to do things so much more efficiently.</p>\n\n\n\n<p>I love it. We like, create efficiency for a business, like almost more so than, um, you know, when we design a great landing page and the, you know, we look at the analytics and we\'re like, oh, the users are doing exactly what we wanted them to do. That\'s, that\'s rewarding, but, I think that I get a little bit more of like a rewarding sense when I\'m like, I just saved you like 20 hours of work every month.</p>\n\n\n\n<p>Um, that to me, I\'m, I think just because I am a small business owner, I know how big of a difference that makes to a small business that I get really excited about this stuff.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Oh yeah. Anytime you can save time like that, I hope they value and understand that like you just took a big swath of our time out, that we can focus [00:19:00] on other things now.</p>\n\n\n\n<p>And particularly like a furniture company that might, that you know, more traditional sales thing and being able to have that ability now on the web I think is pretty, pretty amazing. Oh</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> yeah. And they do. I mean that\'s, um, I need to figure out how to better quantify those things when I get those calls cuz they\'re harder things to try to quantify is like when you\'re talking about like employees time.</p>\n\n\n\n<p>But we built one system that has um, an integration that tracks like continuing education credits. And this organization put on a conference every year and they\'ve got, their members are tracking their credits score. The way that they were trying to process that. It was literally like manual assignment sheets and then somebody was like data entering, like all of this stuff.</p>\n\n\n\n<p>And after we transitioned to this new digital system, and it\'s like the conference was over and like all of the credits were entered like in real time as people attended because it happened digitally. He was just like, I don\'t even know what to do with myself. I mean, I would\'ve spent six [00:20:00] weeks trying to process all of these c e credits.</p>\n\n\n\n<p>And I don\'t have to, like, it\'s done. I don\'t, like it was just mind blowing to him of like, oh my goodness, I don\'t have to do</p>\n\n\n\n<p><strong>Cory Miller:</strong> this. I\'ve got experience helping a mental health organization, um, offer CEUs. And, and they do have that same thing, so I need to refer them on to you to do something like that because, um, she was the point of content.</p>\n\n\n\n<p>Their marketing director would spend some, probably half a day on the back end after we did a C E U. Um, To like, you know, get all the paperwork and everything ready to go. Yeah. And</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> it\'s, it\'s always somebody like that. It\'s always like, why is the marketing director having to do this? Because like there isn\'t somebody that is, I, you know, there\'s nobody else to do it and just has to get done.</p>\n\n\n\n<p>And cuz you know, they do the website and so, you know, whatever, like it somehow falls in their lap. But those are the people that I think appreciate the most when you save them time too. Cuz they\'re like, I didn\'t wanna be doing this.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah. Yeah. Uh, it seems very much [00:21:00] too is like if you\'re an organization business that is trying to do more of those things online to reach more people and probably secondarily don\'t fully realize it efficiently, um, that\'s how you help people navigate that and then build the result they\'re trying to get.</p>\n\n\n\n<p>That helps save time and increase the, and grow the.</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> And honestly, I think that in some regards, when small businesses can see like that kind of a direct value, it\'s easier for them to bite off a more sizable project, like financially speaking, because they\'re like, oh shoot, I don\'t have to hire somebody.</p>\n\n\n\n<p>Well, that\'s a lot of money that I\'m. Saving, like sure, that\'s not a big deal if I am gonna pay you, you know, 30 or $40,000 to build this, you know, site for us. Um, cuz now I don\'t, I\'m not hiring another person. Um,</p>\n\n\n\n<p><strong>Cory Miller:</strong> and so it\'s a, it\'s a big win. We see that all the time at post status with our members trying to hire hiring\'s tough.</p>\n\n\n\n<p>Not even now. It\'s just tough in general because [00:22:00] mm-hmm. , um, there are some tech companies that can throw lots of money at someone. You, the person wants to stay engaged with interesting projects, and I think that\'s where our agencies like yourself, um, really have a great solution in that. Why hire a full-time person?</p>\n\n\n\n<p>That might not have the training excu, uh, skills experience that you all have access to and, and have, um, to do that. Where I, I hear a lot of our agencies, you know, they\'re the support, summer support for just, you know, basic website updates, but then someone like you all just to, you know, manage, I know from my own, our own business projects, You know, when I, when we add in an e-commerce option, I\'m like, who\'s gonna babysit it?</p>\n\n\n\n<p>Who\'s gonna be there when we need to do something more than the base software might do for us? Cuz we have those new odds setups and things like that. And then having someone like North UX where you can rely on them without having this, there\'s so much overhead. Like we talked just a minute ago of hire having [00:23:00] a full-time employee, but someone who knows WordPress and web stuff.</p>\n\n\n\n<p>That\'s even a higher bar, I think.</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> Oh yeah. Oh. Um,</p>\n\n\n\n<p><strong>Cory Miller:</strong> do you do ongoing, um, support retainers, things like that? Yes.</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> Yes, we do. And what I, what\'s interesting is I was, I was just actually just sharing the story the other day that about a client, um, that like when they came to us, and this is, this is the same client with the, uh, CU credits.</p>\n\n\n\n<p>Like when they came to us, um, they had it, they had a WordPress site, but Oh my word. It was so outdated and it was, There was, there was p h P in the content editor. Like, I mean, it was just like, and I\'m like, I dunno what, like it\'s, it was so like, Not great. And so it was very much like, and, and they were very kind of like, oh, trepidatious about, you know, spending money.</p>\n\n\n\n<p>And so like, we started them on this like super small monthly plan where we\'re [00:24:00] literally just like, we\'re just gonna duct tape things to kind of like keep this thing going. And then I, you know, gave them proposal for a new site. Really like pared it down to try to get it to this point where it, it was a digestible cost for them.</p>\n\n\n\n<p>Um, and so it was like a really limited scope. Um, and like, you know, that first plan they were on, I think was like $500 a month or something like that. And, um, now they\'ve turned into clients and like once we launched their site, they\'re like, we can automate that. And they, I mean, we probably. On a given month, do 30 to 50 hours worth of work for them because there\'s just something else that they\'re like, Ooh, let\'s make.</p>\n\n\n\n<p>New and shiny. Let\'s make that new and shiny. Let\'s do this. And you know, and they have really bought into like the value of what we\'re doing for them. And so it\'s not even so much like, uh, a support plan or a retainer from [00:25:00] just like a, keeping the site going. It\'s very much like an ongoing enhancements.</p>\n\n\n\n<p>And we find that a lot of our clients kind of, once we do like the first big project, they. Start to kind of move into this, like, oh, we just want to continue to iterate and add more features and functions and, um, and just make it bigger and better and, and whatnot. So it\'s, it\'s even beyond just the support of it.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Be that backstop, be that partner ally when let them do what they do best and you all do what you do best and that seems to work fantastically. Um, okay. So, you know, with all of your experience with, with e-commerce, Myriad of versions of this. I\'d love to get your thoughts on where it\'s going, what trends and things and themes you see.</p>\n\n\n\n<p>You know, during C O D. Um, I was just talking to an agency owner yesterday that, you know, they were working with, let\'s say yoga studio studio business owners, and [00:26:00] their, their business and business model got flipped on its head. So then they transitioned to use web, which I think is such a, if there\'s positives that come outta Covid, I would mm-hmm.</p>\n\n\n\n<p>or, or the pandemic. I would say it\'s this. Did you know the whole world exists out here for your. From an e-commerce and all these type of things, perspective, what are you seeing? What are you looking forward to, you know, out there as, as you know, particularly as you work daily with clients doing these, these cool projects for them to grow their businesses.</p>\n\n\n\n<p>What, what things are you seeing that stand out to you?</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> Um, yeah, so I think that there are a lot of people that are kind of like jumping into. Um, online business kind of a thing like for the first time. Um, and at the same time, like as so many companies have kind of come out with these, and even as work processes moved more towards like a, a, um, an actual usable like [00:27:00] page builder, like d i y kind of a website thing, um, I think that.</p>\n\n\n\n<p>You know, I think you could either look at that from, a couple of, you can look at it like, oh, it\'s almost like, well, we\'re just not needed anymore. People can just do it themselves. Um, but the reality is like, that\'s not true. But I think that the way that we are, um, engaging with the people that do want to do it themselves, um, I think there\'s opportunity there and I\'m kind of excited about some of the things cause I.</p>\n\n\n\n<p>As nor as an agency, we\'ve really served these very, um, like small businesses, but very established small businesses. Like they\'ve been around for a while. They have, you know, 10 to 20 employees. Um, you know, they\'ve got money to invest in a sizable project. Um, But I\'ve kind of always wanted to figure out, um, a better way to catch people, like catch businesses as they\'re [00:28:00] just starting because of what I\'ve, I mean, so many of our clients made poor tech decisions in the beginning and are with us because we are unraveling something.</p>\n\n\n\n<p>And so how can, how can with this new. Uh, you know, it\'s so easy to do, like no code or page builders or whatever, like how can I walk people through, like just when they\'re just starting to give them resources so they understand the decisions that they\'re making and are when they\'re comparing apples to apples or apples to oranges.</p>\n\n\n\n<p>Cuz sometimes they don\'t even know. And, um, they\'ve got a cucumber and they had no idea, um, , but it\'s technically a fruit. So, Um, but like give them the resources and the knowledge about technology in a way that they feel empowered to make some decisions and like also establish ourselves as, um, as experts in this area so that [00:29:00] then when they get to the point where they need the one little extra piece, like were there to help.</p>\n\n\n\n<p>Um, and so I think that there is definitely almost like that, um, moving towards like a. Partner with you around some of the stuff you can do for yourself, um, as opposed to just, we\'re gonna do it all for you.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah, I can see that. You know, we, we, we have a great friend who we helped start, get her off the ground and she was doing a physical product and, um, it was interesting trying to look at all the options out there.</p>\n\n\n\n<p>And I know a little bit more than most people, uh, when it comes to these. But what we found too was like there\'s a graduation point you may start selling here and it helps fill a need, but then you get into more complex, and if you\'re like me, I go, I don\'t do this all day, every day. I wanna find somebody, an expert to lead and guide me through these things.[00:30:00]</p>\n\n\n\n<p>I\'ve talked to a lot of our agency members like yourself and go, there\'s this shift from, it\'s not just Technic delivery. That\'s part of it for sure. But there\'s also this thing, I hope clients are more and more valuing that having a guide like yourself who has been there, done that do, does this every day to help you not make those big pitfalls.</p>\n\n\n\n<p>So when there\'s those steps, it seems like there might be a. , you know? Mm-hmm. , maybe we get on this thing, it\'s the software as a service software solution, and it gets \'em to a step, but then they\'re like, we\'re ready to graduate. We wanna do all these things. Then they can come to North UX and say, guide me, lead me, and deliver the project too.</p>\n\n\n\n<p>Yeah. Are, are you seeing that more and more to, it seems like that\'s what you\'re saying.</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> Yeah, exactly. And I think what I\'m, what I\'ve seen is I feel like, um, I\'ve encountered so many businesses that kind of, you know, they did the steps and then they got to a point where they were like, we wanna take the next step, but we can\'t figure out how to do it from where we\'re at.</p>\n\n\n\n<p>And [00:31:00] by the time that they\'re actually starting to engage with someone who knows this space, it\'s like, oh, well we actually need to go all the way back. Square one because you have reached the top of where these stairs were going. Yeah. Um, and so helping them to make the decisions along the way that are really paving the way for their future, even before they really know what their future holds, um, I think is just, it\'s huge.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Oh yeah. And there\'s so much complexity there and, and I say that\'s a byproduct of success. You\'ve gotten to this point that you need to come to Christy and other, other, our agency owners and help you guide them because you\'ve gotten to this complexity and hopefully that\'s called success. Well, you\'re ready.</p>\n\n\n\n<p>Yeah. You need, you need this. You\'re ready to take this new step and blow your business out the doors for the next stage. Yeah.</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> And we also, like, we\'ve even. Taken clients through to where they\'re, they\'ve now they\'ve grown enough that they\'ve hired an in-house developer and like we\'ve partnered with them to help them figure out like, how do we hire, should [00:32:00] we hire an in-house developer?</p>\n\n\n\n<p>Um, and how do we hire and then continue to have a collaborative relationship to like supplement. , you know, their developer and like also just helping business understand like, you know, it\'s unrealistic to think that you\'re gonna hire one person that\'s going to be able to truly do everything. Exactly.</p>\n\n\n\n<p>You know, and so helping them understand like what is the range of skills and where\'s like the 80% mark in a role that you could carve out? And where is this 20% like? Somebody that actually could do the 20% and then you\'re still stuck with , the 80% that they\'re not skilled for having to outsource, um, those kinds.</p>\n\n\n\n<p>Of things of like really just walking everybody through from the point of like DIYing your first website to your big enough business that you have an in-house developer and we\'ve held your hands the whole way</p>\n\n\n\n<p><strong>Cory Miller:</strong> through . It seems like that\'s a trend in a lot of business, not just in the technical side, but where you might have somebody, that person, and I\'m not [00:33:00] trying to devalue that person, but is a coordinator of these things that works with great groups and partners.</p>\n\n\n\n<p>I don\'t wanna say vendors, but partner. Yeah, that can come in and do those, and they\'re air traffic control. I need to get these things done. We talk about a lot with the marketing side of things, Matt. You might have some that coordinates all these other things, but if you, like you said, if you expect that person to do everything, you\'re wishing for a unicorn.</p>\n\n\n\n<p>Yeah. Yeah. All right. Well, Christy, this has been awesome. I want to ask finally, um, what you\'re excited. Coming up next year or so, um, with your work and your agency work in the world.</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> Yeah. Um, oh my goodness. I\'m like, what, what do I pick? . Yeah. Right. I\'m excited about a lot. Um, I think the thing that I\'m most excited, and I\'ve not said this like out loud publicly yet, I don\'t think, um, but kind of along these lines of [00:34:00] this, like to helping people start at the beginning is, um, I\'m getting ready to kind of launch like a pilot program of what I\'m calling like a e-commerce website in a day where, um, we have like some really specific.</p>\n\n\n\n<p>Steps that like we walk them through that they engage with like some forms and like, you need to gather this and you need to gather that and you need to do that. And where they kind of like walk them through prepping all the things that they need and making some of the preliminary decisions. And then, um, they literally schedule a day with us where we\'re just gonna crank out, um, you know, we\'re gonna start with our, our skeleton theme and just be able to get them.</p>\n\n\n\n<p>A site up and going because they\'ve done all of the preliminary work, will import their products, you know, all of that stuff, and it\'ll happen on that day, and then they\'ll have a website. Um, that\'s fantastic. I\'m really excited about it. I [00:35:00] did kind of a really, a trial project with someone last year and, um, she, she does pottery and so this is again, Our, we\'ve been with these really established small businesses, but starting to kind of find some people that are just getting started on their business.</p>\n\n\n\n<p>And after we launched her site, she was like, I just did a new product drop and I made $4,000 at a time of the year where I wouldn\'t have done an in-person event and would not have made any money. You know? And she\'s like, Like, I can\'t believe I waited this long to have my own website. Um, and so I\'m excited about like that kind of stuff.</p>\n\n\n\n<p>Um,</p>\n\n\n\n<p><strong>Cory Miller:</strong> that\'s so fun when you\'re able to, yeah. The work you\'re doing contributes to this big win where someone\'s in that setting able to like start and grow their business in a really tough time. Uh, and then like your furniture, uh, example is help them make processes more efficient and grow their [00:36:00] business.</p>\n\n\n\n<p>Yeah. Exciting work. Thank you, Christie, for sharing your story. And, um, tell us finally where they can find out about more about you and your, your work.</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> Yeah, so, um, north ux design.com is where you can certainly know all about North UX and what we\'re doing and, um, Whatnot. And then as far as me, best place is probably Twitter, which, um, my personal Twitter is Chrissy Ray, k r i s s i e r a e.</p>\n\n\n\n<p>Um, and I do have a North Uax design Twitter as well. Um, but it\'s not quite as, it\'s a little bit more, you know, polished professional. I don\'t engage with it quite as much, but those are great places to find me.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Well, thank you Christy, for this time and sharing your</p>\n\n\n\n<p><strong>Krissie VandeNoord:</strong> story. Yeah, thanks so much for having me.</p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Dec 2022 20:06:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olivia Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Matt: Fusion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=72681\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://ma.tt/2022/12/fusion/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:973:\"<p><a href=\"https://www.energy.gov/articles/doe-national-laboratory-makes-history-achieving-fusion-ignition\">This is a big deal</a>. There are a lot of <a href=\"https://chat.openai.com/\">big deals</a> happening right now, it&#8217;s honestly a very exciting time to be in tech. I feel like a sailor in a tumultuous sea, and they should have sent a poet. T. S. Eliot was actually the inspiration for WordPress&#8217; tagline &#8220;Code is Poetry&#8221; and I&#8217;m reminded of this from <a href=\"https://stuff.mit.edu/people/dpolicar/writing/poetry/poems/fareForward.html\">The Dry Salvages</a>:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>O voyagers, O seamen,<br />You who came to port, and you whose bodies<br />Will suffer the trial and judgement of the sea,<br />Or whatever event, this is your real destination.&#8221;<br />So Krishna, as when he admonished Arjuna<br />On the field of battle.<br />Not fare well,<br />But fare forward, voyagers.</p>\n</blockquote>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Dec 2022 06:19:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"Post Status: Annual Survey • State of the Word 2022 • Suggest Community Summit Topics • WordPress Playground (WASM)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=145943\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://poststatus.com/annual-survey-state-of-the-word-2022-suggest-community-summit-topics-wordpress-playground-wasm/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16110:\"<h2 id=\"h-this-week-at-wordpress-org-december-12-2022\">This Week at WordPress.org (December 12, 2022)</h2>\n\n\n<div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">Tune in Thursday for Matt\'s annual State of the Word address. Check out the WordPress Playground now. It brings key platform dependencies into the browser that you can embed in your own site today.  Your feedback into the annual WordPress survey helps shape the project, so fill it out as soon as possible. </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div id=\"kt-info-box_adc852-65\" class=\"wp-block-kadence-infobox\"><div class=\"kt-blocks-info-box-link-wrap kt-blocks-info-box-media-align-left kt-info-halign-left\"><div class=\"kt-blocks-info-box-media-container\"><div class=\"kt-blocks-info-box-media kt-info-media-animate-none\"><div class=\"kadence-info-box-icon-container kt-info-icon-animate-none\"><div class=\"kadence-info-box-icon-inner-container\"><span class=\"kt-info-svg-icon kt-info-svg-icon-ic_people\"></span></div></div></div></div><div class=\"kt-infobox-textcontent\"><h2 class=\"kt-blocks-info-box-title\">2022 Survey, SotW, Community Summit, and the WordPress Playground</h2><p class=\"kt-blocks-info-box-text\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4dd.png\" alt=\"📝\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/news/2022/12/2022-wordpress-survey/\">Share Your Experience: The 2022 WordPress Survey is Open</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word 2022</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f465.png\" alt=\"👥\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/community/2022/12/08/suggest-topics-for-the-2023-wordpress-community-summit/\">Suggest Topics for the 2023 WordPress Community Summit</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f6dd.png\" alt=\"🛝\" class=\"wp-smiley\" /> <a href=\"https://developer.wordpress.org/playground/\">WordPress Playground</a></p></div></div></div>\n\n\n\n<h2 id=\"h-news\">News<a href=\"https://wordpress.org/news/2022/10/wordpress-6-1-release-candidate-3/\"></a></h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2022/12/2022-wordpress-survey/\">Share Your Experience: The 2022 WordPress Survey is Open</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2022/12/08/suggest-topics-for-the-2023-wordpress-community-summit/\">Suggest Topics for the 2023 WordPress Community Summit</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/playground/\">WordPress Playground</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_121b9e-cb\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<div class=\"is-layout-flex wp-container-11 wp-block-columns\">\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-accessibility\"><a href=\"https://make.wordpress.org/accessibility\">Accessibility</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/accessibility/2022/12/08/accessibility-team-meeting-notes-december-2-2022/\">Accessibility Team Meeting Notes: December 2, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-community\">Community</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/community/2022/12/15/idea-creating-a-translation-events-kit-for-meetups/\">Idea: Creating a translation events kit for Meetups</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2022/12/15/recap-of-the-diverse-speaker-training-group-wpdiversity-amer-emea-on-december-14-2022/\">Recap of the Diverse Speaker Training group (#WPDiversity) AMER/EMEA on December 14, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2022/12/09/december-update-global-meetup-reactivation-project/\">December Update: Global Meetup Reactivation Project</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2022/12/08/suggest-topics-for-the-2023-wordpress-community-summit/\">Suggest Topics for the 2023 WordPress Community Summit</a></li>\n</ul>\n\n\n\n<h2 id=\"h-core\"><a href=\"https://make.wordpress.org/core\">Core</a> </h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/\">What’s new in Gutenberg 14.7? (7 December)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/12/09/enhancing-the-scripts-api-with-a-loading-strategy/\">Enhancing the Scripts API with a loading strategy</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/12/09/update-to-content-only-editing-filter-namespace/\">Update to content only editing filter namespace</a></li>\n</ul>\n\n\n\n<h3 id=\"h-meetings\">Meetings</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/12/14/dev-chat-summary-wednesday-december-14-2022/\">Dev Chat summary: Wednesday, December 14, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/12/13/editor-chat-agenda-december-14-2022/\">Editor Chat Agenda: December 14, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/12/08/editor-chat-summary-wednesday-december-7-2022/\">Editor chat summary: Wednesday, December 7, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/12/07/dev-chat-summary-wednesday-december-7-2022/\">Dev Chat summary: Wednesday, December 7, 2022</a></li>\n</ul>\n\n\n\n<h3 id=\"h-dev-blog\"><a href=\"https://developer.wordpress.org/news/\">Dev Blog</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/news/2022/12/13/application-state-managed-withdispatch-withselect-and-compose-101/\">Application state managed withDispatch, withSelect and compose 101</a></li>\n</ul>\n\n\n\n<h2 id=\"h-docs\"><a href=\"https://make.wordpress.org/docs\">Docs</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/updates/2022/12/12/documentation-team-update-december-12-2022/\">Documentation Team Update – December 12, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-hosting\"><a href=\"https://make.wordpress.org/hosting\">Hosting</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/hosting/2022/12/08/nominations-are-in-hosting-team-rep-2023/\">Nominations are in – Hosting Team Rep 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-marketing\"><a href=\"https://make.wordpress.org/marketing\">Marketing</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/marketing/2022/12/14/notes-global-marketing-team-meeting-november-30-2022/\">Notes: Global Marketing Team meeting, November 30, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/marketing/2022/12/14/notes-global-marketing-team-meeting-december-7-2022/\">Notes: Global Marketing Team meeting, December 7, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-meta\"><a href=\"https://make.wordpress.org/meta\">Meta</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/meta/2022/12/14/showcase-visual-refresh/\">Refreshing&nbsp;the WordPress Showcase</a></li>\n</ul>\n\n\n\n<h2 id=\"h-openverse\"><a href=\"https://make.wordpress.org/openverse\">Openverse</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/openverse/2022/12/13/community-meeting-recap-14-december-2022/\">Community Meeting Recap (13 December 2022)</a></li>\n</ul>\n\n\n\n<h2 id=\"h-performance\"><a href=\"https://make.wordpress.org/performance/\">Performance</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/12/13/performance-team-meeting-summary-13-december-2022/\">Performance Chat Summary: 13 December 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-polyglots\">Polyglots</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/polyglots/2022/12/13/agenda-weekly-polyglots-chat-dec-13-2022-700-utc/\">Agenda: Weekly Polyglots Chat – Dec. 13, 2022 (7:00 UTC)</a></li>\n</ul>\n\n\n\n<h2 id=\"h-plugins\">Plugins</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/updates/2022/12/12/plugin-review-team-12-december-22/\">Plugin Review Team: 12 December ’22</a></li>\n</ul>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-support\"><a href=\"https://make.wordpress.org/support\">Support</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/support/2022/12/introducing-the-block-editor-in-the-support-forums/\">Introducing the Block Editor in the Support Forums</a></li>\n</ul>\n\n\n\n<h2 id=\"h-test\"><a href=\"https://make.wordpress.org/test\">Test</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2022/12/08/hallway-hangout-lets-chat-about-the-future-of-custom-css-with-block-themes/\">Hallway Hangout: Let’s chat about the Future of Custom CSS with block themes</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2022/12/08/fse-program-site-editor-sneak-peek-summary/\">FSE Program Site Editor Sneak Peek Summary</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2022/12/07/fse-program-seeking-volunteers-to-use-replay-io-for-capturing-bugs/\">FSE Program: Seeking volunteers to use Replay.io for capturing bugs</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/12/13/test-team-update-12-december-2022/\">Test Team Update: 12 December 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-themes\"><a href=\"https://make.wordpress.org/themes\">Themes</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/themes/2022/12/14/themes-team-meeting-notes-december-13-2022/\">Themes Team Meeting Notes –&nbsp;December 13, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2022/12/13/themes-team-update-december-13-2022/\">Themes team update December 13, 2022</a></li>\n</ul>\n\n\n\n<h2 id=\"h-training\"><a href=\"https://make.wordpress.org/training\">Training</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/individual-learner-survey/\">How did you learn WordPress?</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/12/12/meeting-agenda-for-december-13-2022/\">Meeting Agenda for December 13, 2022</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2022/12/09/training-team-meeting-recap-for-december-6-2022/\">Training Team Meeting Recap for December 6, 2022</a></li>\n</ul>\n\n\n\n<h3 id=\"h-courses\"><a href=\"https://learn.wordpress.org/courses\">Courses</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/course/a-developers-guide-to-block-themes-part-2/\">A Developers Guide to Block Themes – Part 2</a></li>\n</ul>\n\n\n\n<h3 id=\"h-online-workshops\">Online Workshops</h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/?meeting=wordpress-development-live-stream-building-an-advanced-query-loop-plugin\">WordPress development live stream: Building an Advanced Query Loop plugin</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=getting-started-with-a-wordpress-org-account\">Getting Started with a WordPress.org Account</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=start-blogging-in-2023-part-2-planning-your-blogs-content\">Start Blogging in 2023 Part 2: Planning Your Blog’s Content</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=start-blogging-in-2023-part-1-planning-to-reach-your-audience\">Start Blogging in 2023 – Part 1: Planning To Reach Your Audience</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=ep3-wordpress-migration-local-live-to-local-live-bangla\">EP3: WordPress Migration (Local/Live to Local/Live) | Bangla</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=get-blogging-in-2023-set-up-your-blog-interactive-2\">Get Blogging in 2023: Set Up Your Blog (Interactive)</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=get-blogging-in-2023-set-up-your-blog-interactive\">Get Blogging in 2023: Set Up Your Blog (Interactive)</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=lets-code-developing-blocks-without-react-review\">Let’s code: Developing Blocks without React! – Review</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=ep2-wordpress-installation-on-local-and-live-cpanel-ftp-mysql-bangla\">EP2: WordPress Installation on Local and Live (cPanel, FTP & MySQL) | Bangla</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=ep1-wordpress-environment-setup-local-wp-laravel-valet-bangla\">EP1: WordPress Environment Setup (Local WP & Laravel Valet) | Bangla</a></li>\n</ul>\n\n\n\n<h3 id=\"h-tutorials\"><a href=\"https://learn.wordpress.org/tutorials\">Tutorials</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/manage-your-block-theme-fonts-with-create-block-theme/\">Manage your block theme fonts with Create Block&nbsp;Theme</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/the-key-to-locking-blocks/\">The Key to Locking Blocks</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/templates/\">Using Page Templates</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/streamline-your-block-theme-development-with-create-block-theme/\">Streamline your Block Theme development with Create Block&nbsp;Theme</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/trabalhando-com-estilos-globais/\">Trabalhando com estilos globais</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/padding-versus-margin/\">Padding Versus Margin</a></li>\n</ul>\n\n\n\n<h2 id=\"h-wptv\">WPTV</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.tv/category/year/2022/\">Latest WordPress TV videos</a></li>\n</ul>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 id=\"h-related-news\">Related News:</h2>\n\n\n\n<ul>\n<li><a href=\"https://phpconference.com/berlin-en/\">International PHP Conference Berlin 2023</a></li>\n</ul>\n\n\n\n<p class=\"has-theme-palette-7-background-color has-background\">Thanks for reading our WP dot .org roundup! Each week we are highlighting the news and discussions coming from the good folks making WordPress possible. If you or your company create products or services that use WordPress, you need to be engaged with them and their work. Be sure to share this resource with your product and project managers. <br /><br /><strong>Are you interested in giving back and contributing your time and skills to WordPress.org?</strong> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/support/article/contributing-to-wordpress/\">Start Here ›</a><br /><br /><strong>Get our weekly WordPress community news digest</strong> — Post Status\' <a href=\"https://poststatus.com/news/week-in-review/\">Week in Review</a> — covering the WP/Woo news plus significant writing and podcasts. It\'s also available in <a href=\"https://poststatus.com/newsletter\">our newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f48c.png\" alt=\"💌\" class=\"wp-smiley\" /></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><a href=\"https://poststatus.com/\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-85823 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\">You — and <a href=\"https://poststatus.com/#Agency\">your whole team</a> can <a href=\"https://poststatus.com/#choose-membership\">Join Post Status</a> too!</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> and <a href=\"https://www.linkedin.com/company/post-status-llc/\">LinkedIn</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4bc.png\" alt=\"💼\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Dec 2022 02:41:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"WPTavern: Performance Lab Plugin to Add New Experimental SQLite Integration Module in Upcoming 1.8.0 Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=140328\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"https://wptavern.com/performance-lab-plugin-to-add-new-experimental-sqlite-integration-module-in-upcoming-1-8-0-release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7434:\"<p>WordPress&#8217; Performance Team contributors have merged <a href=\"https://github.com/WordPress/performance/pull/547\">a new experimental SQLite integration module</a> that is on track to be included in the upcoming version 1.8.0 of the <a href=\"https://wordpress.org/plugins/performance-lab/\">Performance Lab</a> plugin. (This is the plugin that contains a collection of feature plugins with performance-related modules the team hopes to land in WordPress core.) The new module allows the adventurous to test the new SQLite implementation, with the understanding that the overall user experience will still be rough.</p>\n\n\n\n<p>In a proposal titled <a href=\"https://make.wordpress.org/core/2022/09/12/lets-make-wordpress-officially-support-sqlite/\">Let’s make WordPress officially support SQLite</a>, Yoast-sponsored core contributor Ari Stathopoulos contends that less complex sites (small to medium sites and blogs) don&#8217;t necessarily benefit from the requirement of using WordPress&#8217; standard MySQL database:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>On the lower end of the spectrum, there are small and simple sites. These are numerous and consist of all the blogs, company pages, and sites that don’t have thousands of users or thousands of posts, etc. These websites don’t always need the complexities of a MySQL/MariaDB database. The requirement of a dedicated MySQL server increases their hosting cost and the complexity of installation. On lower-end servers, it also decreases performance since the same “box” needs to cater to both a PHP and a MySQL/MariaDB server.</p>\n</blockquote>\n\n\n\n<p>In an ideal world, users could select their database type during installation. Stathopoulos said this would require WordPress to have a database abstraction layer, which other platforms like Drupal have had more 10+ years. </p>\n\n\n\n<p>&#8220;Building a database abstraction layer for WordPress would be a colossal task – though it might be one that, at some point in the future, we may have to undertake to ensure the project’s continued evolution and longevity,&#8221; he said.</p>\n\n\n\n<p>As an alternative, Stathopoulos sees SQLite as a &#8220;perfect fit&#8221; and cited the benefits of using it for smaller websites:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<ul>\n<li>It is the most widely used database worldwide</li>\n\n\n\n<li>It is cross-platform and can run on any device</li>\n\n\n\n<li>It is included by default on all PHP installations (unless explicitly disabled)</li>\n\n\n\n<li>WordPress’s minimum requirements would be a simple PHP server, without the need for a separate database server.&nbsp;</li>\n\n\n\n<li>SQLite support enables lower hosting costs, decreases energy consumption, and lowers performance costs on lower-end servers.</li>\n</ul>\n</blockquote>\n\n\n\n<p>This new SQLite integration module is based on the <a rel=\"noreferrer noopener\" href=\"https://github.com/aaemnnosttv/wp-sqlite-db\" target=\"_blank\">wp-db-sqlite</a> plugin, a SQLite database driver drop-in that is also <a href=\"https://wptavern.com/new-wordpress-sandbox-project-demos-test-drive-themes-and-plugins-in-the-browser\">used by the WordPress Sandbox project</a>, as WASM doesn&#8217;t support MySQL. The wp-db-sqlite plugin was based on the original work of Kojima Toshiyasu in his eight-year-old <a href=\"https://wordpress.org/plugins/sqlite-integration/\">SQLite Integration plugin</a>, which is no longer available for download on WordPress.org. Stathopoulos said these solutions have evolved over the years, have been thoroughly tested, and proven to work seamlessly, although they are not well known among users.     </p>\n\n\n\n<p>Matt Mullenweg <a href=\"https://make.wordpress.org/core/2022/09/12/lets-make-wordpress-officially-support-sqlite/#comment-43729\">commented</a> in support of the proposal so the implementation moving into the Performance Lab plugin may have a decent shot at landing in core someday in the future. Most participants in the discussion on the proposal were supportive of the idea but also discussed a few of the potential drawbacks. These include poorer support for things like multi-author editing and search. </p>\n\n\n\n<p>&#8220;MySQL is and should continue to be the default because if you have aspirations to be the next big thing, then MySQL can scale better,&#8221; Stathopoulos said.&#8221; If on the other hand you just want a blog, a company site with your about page and a contact form to have an online presence, or any type of small site (which is arguably the majority of sites on WordPress) then SQLite is all you’ll ever need and it will perform a lot better.&#8221;</p>\n\n\n\n<p>A few participants in the discussion also bristled at the controversial, religious <a href=\"https://sqlite.org/codeofethics.html\">code of ethics</a> SQLite holds for its contributors. Stathopoulos sees it as a non-issue because the project is open source and the technology is widely used.</p>\n\n\n\n<p>&#8220;Its popularity speaks volumes regarding what it can do and where it can be used,&#8221; he said in response to criticism of the idea of tying WordPress to a project with an objectionable code of ethics.</p>\n\n\n\n<p>If you have used WordPress from the early days, you have witnessed it become more complicated over the years. Discussions around the idea of a &#8220;<a href=\"https://chriscoyier.net/2022/11/01/wordpress-lite/\">WordPress Lite</a>&#8221; have popped up every few years, but the platform&#8217;s specific selection of features seems to have been a major factor in WordPress powering 43% of the web (according to <a href=\"https://w3techs.com/technologies/details/cm-wordpress\">W3Techs</a>). NerdPress founder Andrew Wilder suggested that a SQLite implementation might benefit from being branded as &#8220;WordPress Lite.&#8221;</p>\n\n\n\n<p>&#8220;Reading the comments and potential issues above, if this does move forward, perhaps the way to implement this in a way that makes sense to users would be to brand it simultaneously as &#8216;WordPress Lite,\'&#8221; Wilder said. &#8220;So if a site is using SQLite, there could be features that are simply no longer available (such as multiple authors, or perhaps plugins that have certain database requirements can’t be installed).&#8221;</p>\n\n\n\n<p>Those who are interested in testing the new SQLite integration module should be able to test drive it next week. Google-sponsored Performance Team contributor Felix Arntz gave a few notes on testing in yesterday&#8217;s team meeting:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>For the SQLite implementation, other than the SQLite DB working correctly by itself, another crucial aspect to test is the user experience on module activation. You&#8217;ll get an entirely new database, but we&#8217;ve added some logic to make the transition as seamless as possible: On a typical WordPress setup, you should not need to reinstall WordPress yourself when you enable the module, and you shouldn&#8217;t even be needed to log in again.</p>\n\n\n\n<p>Basically the PR has logic to install WordPress automatically in the new database, using the same basic setup data that is present in the regular database.</p>\n\n\n\n<p>Just keep in mind that it is by no means a migration. It&#8217;s only the install you&#8217;ll get; no content will be migrated.</p>\n</blockquote>\n\n\n\n<p>The 1.8.0 release of the Performance Lab plugin is expected on Monday, December 19, and is set to include the new module.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Dec 2022 02:29:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Post Status: Interview With Product Lead Jessica Frick At Pressable— Post Status Draft 133\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=145743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://poststatus.com/interview-with-product-lead-jessica-frick-at-pressable-post-status-draft-133/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39939:\"<div class=\"is-layout-flow wp-block-group eplus-wrapper has-theme-palette-2-color has-theme-palette-8-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\"><a href=\"https://twitter.com/renewabelle\">Jessica Frick</a> is a huge WordPress advocate and has been a contributing community member since 2008. She is the Director of Operations at <a href=\"https://pressable.com/\">Pressable</a>, one of our Post Status sponsors. Jess joins Cory Miller to share about the amazing WordPress hosting experience Pressable offers, in addition to her own experience and expertise as a long-time member of the WordPress community. </p></div>\n\n\n<div class=\"wp-block-spacer eplus-wrapper\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">31</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n\n\n\n\n<p><a href=\"https://poststatus.com/planet/feed/#h-transcript\">Transcript</a> ↓</p>\n\n\n\n<p>In this episode, <a href=\"https://twitter.com/renewabelle\">Jess Frick</a>, Pressable’s Director of Operations, discusses what differentiates the hosting performance and support <a href=\"https://pressable.com/\">Pressable</a> offers WordPress users. They are a “small but mighty” hosting provider from the Automattic family powered by the agility to continuously evolve to better serve customers with diverse needs. Her enthusiasm, generosity, and honesty inspire us to use the power of WordPress for good. As a WordPress lover, Jess shares her thoughts on the benefits of being people-powered.</p>\n\n\n\n<p>Top Takeaways:</p>\n\n\n\n<ul>\n<li><strong>Differentiated by Support:</strong> When facing an issue with your site, Pressable understands you don’t have time to wait for answers or be redirected to articles and links that don’t deliver real-time solutions. Pressable support is led by a team of WordPress experts with a proven record of responding in less than 3 minutes and solving issues in under 10 minutes on average.</li>\n\n\n\n<li><strong>Technical, User-Friendly Interface:</strong> Pressable’s single dashboard offers simple site management with a clear view of site performance and metrics. More technical users can manage multiple sites from one platform, build API applications, test site versions, and more.</li>\n\n\n\n<li><strong>Power of Decentralization:</strong> As we are seeing the real-time impacts of power being held singularly in other organizations, it highlights the power of the open-source community we have within WordPress. Jess shares her thoughts on how this insulates WordPress from experiencing toxic growth and protects the evolution of future technology powered by WP.</li>\n</ul>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<div class=\"is-layout-flex wp-container-18 wp-block-columns Pressable has-theme-palette-8-background-color has-background\" id=\"Pressable\">\n<div class=\"is-layout-flow wp-block-column\">\n<h3><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/pressable\">Pressable</a></h3>\n\n\n\n<p>Founded in 2010, <strong>Pressable</strong> is a world-class managed WordPress hosting provider built on the same data network as <strong>WordPress.com</strong> and <strong>WordPress VIP</strong>. With industry-leading performance, 24/7 expert support, a 100% uptime guarantee, and seamless integrations with <strong>WooCommerce</strong> and <strong>Jetpack</strong>, Pressable provides the tools you need to manage your WordPress websites and grow your business all in one place. <a href=\"https://poststat.us/pressable\">TRY PRESSABLE→</a></p>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column is-vertically-aligned-center\">\n<a href=\"https://poststat.us/pressable\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2022/01/pressable-icon-primary.svg\" alt=\"Pressable\" class=\"wp-image-121339\" width=\"150\" title=\"Pressable\" /></a>Pressable\n</div>\n</div>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul>\n<li><a href=\"https://pressable.com/\">Pressable</a></li>\n\n\n\n<li><a href=\"https://automattic.com/\">Automattic</a></li>\n\n\n\n<li><a href=\"https://www.liquidweb.com/\">Liquid Web</a></li>\n\n\n\n<li><a href=\"https://twitter.com/chrislema\">Chris Lema</a></li>\n\n\n\n<li><a href=\"https://copyblogger.com/\">Copy Blogger Media</a></li>\n\n\n\n<li><a href=\"https://www.studiopress.com/\">Studio Press</a></li>\n\n\n\n<li><a href=\"https://wphostingbenchmarks.com/\">WordPress Hosting Benchmarks by Review Signal</a></li>\n\n\n\n<li><a href=\"https://twitter.com/kevinohashi\">Kevin Ohashi</a></li>\n\n\n\n<li><a href=\"https://titan.email/\">Titan Mail</a></li>\n</ul>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-you-can-follow-post-status-and-our-guests-on-twitter\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> You can follow Post Status and our guests on Twitter:</h3>\n\n\n\n<ul class=\"eplus-wrapper\">\n<li><a href=\"https://twitter.com/renewabelle\">Jessica Frick</a> (Director of Operations, <a href=\"https://twitter.com/Pressable\">Pressable</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/corymiller303\">Cory Miller</a> (CEO, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a> (Intern, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n</ul>\n\n\n\n<p class=\"eplus-wrapper has-background\">The <strong>Post Status Draft</strong> podcast is geared toward WordPress professionals, with interviews, news, and deep analysis. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4dd.png\" alt=\"📝\" class=\"wp-smiley\" /><br /><br /><a href=\"https://poststatus.com/category/post-status-podcasts/\" target=\"_blank\" rel=\"noreferrer noopener\">Browse our archives</a>, and don’t forget to subscribe via <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\" target=\"_blank\" rel=\"noreferrer noopener\">iTunes</a>, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\" target=\"_blank\" rel=\"noreferrer noopener\">Google Podcasts</a>, <a href=\"https://www.youtube.com/c/PostStatus\" target=\"_blank\" rel=\"noreferrer noopener\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\" target=\"_blank\" rel=\"noreferrer noopener\">Stitcher</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Simplecast</a>, or <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h2 class=\"eplus-wrapper\" id=\"h-transcript\">Transcript</h2>\n\n\n\n<p>Interview With Product Lead Jessica Frick At Pressable</p>\n\n\n\n<h1>Interview With Product Lead Jessica Frick At Pressable</h1>\n\n\n\n<p><strong>Cory Miller:</strong> [00:00:00] Hey everybody. Welcome back to Post Edits Draft. This is another interview in our series of product people. Um, and the intention behind this is there\'s all these great products out there in WordPress. And I wanna hear from the humans that lead these products for their customers and the clients. And today I\'ve got a dear friend, Jess Frick, who is over at a great hosting company called Pressable.</p>\n\n\n\n<p>Also an awesome sponsor and supporter post status. And I\'m excited for this. Uh, all these are so much fun to me, but I\'ve known Jess a long time. I\'m really excited to let you hear. What I get to hear, uh, about her passion, her vision, her values for what she does, and how she leads her team, um, and really around the product that she, she runs.</p>\n\n\n\n<p>So Jess, welcome to post status draft.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> Thanks for having me, Corey. As you know, we are huge supporters of post status. We love the community and I\'ve been a [00:01:00] member since before I\'ve been with Pressable cuz I just love everybody in the community.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Also, before Corey and Lindsay, uh, were part of the ownership.</p>\n\n\n\n<p>So That\'s true.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> That\'s true. But you know what? Post status has been giving back to the community for a really long time and so you\'re, you\'re always honoring us and I wanna take a minute to honor you too. So. Thanks for all you do.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Thanks my friend. If you don\'t know Jess, you need to get to know her. By the way.</p>\n\n\n\n<p>She\'s an incredible human being and you\'re getting ready to hear some of her experience and expertise too. Jess, could you start and tell us what your role is at Principal?</p>\n\n\n\n<p><strong>Jessica Frick:</strong> Uh, Well, we\'re not really big on titles around here, but I do have one. It\'s Director of Operations and what that ultimately entails is I lead our product ops and marketing here at Principal.</p>\n\n\n\n<p>People think we\'re a lot bigger than we are. We are a small but mighty team over here. Um, little, little known secret. Pressable has less than 20 full-time employee. We [00:02:00] are just killing it and everybody\'s just wearing a bunch of hats. .</p>\n\n\n\n<p><strong>Cory Miller:</strong> I I really love that, even that as a part of automatic, um, to see us. Uh, I like your description, small and mighty team.</p>\n\n\n\n<p>Uh, and we\'ll talk a little bit about that too. Cause I\'ve experienced that, not just because of our friendship, but as, uh, a friend of mine is a customer and I get to go in and help and experience. What you\'ve done and your team does. Um, Jess, you have a vast experience in WordPress, and I know this, but I want other people to do.</p>\n\n\n\n<p>Could you tell us what you\'re doing, what you\'ve done in WordPress, uh, before Princip?</p>\n\n\n\n<p><strong>Jessica Frick:</strong> Well, my first time using WordPress would\'ve been in 2008. Um, my first job in WordPress, uh, was with Copy Blogger Media, the parent company of Studio Press. Um, and so if you ever got any swag back in the day with hashtag genesis WP that came from my house, , um, , [00:03:00] we, we grew this awesome brand and.</p>\n\n\n\n<p>Honestly, I did not build with any other themes. I\'m so sorry, Corey for like 10 years because it was just awesome to watch the genesis of the product. Um, and from there I got to work with the team over at Liquid Web. I was on Chris LEMAs team. We launched the first re commerce product. Um, and then about a year ago I got to join the team here at Pressable and I absolutely love it.</p>\n\n\n\n<p><strong>Cory Miller:</strong> That\'s awesome. Now, one of the angles for the</p>\n\n\n\n<p>part of that is product and um, so can you tell me a little bit about the principle WordPress product?</p>\n\n\n\n<p><strong>Jessica Frick:</strong> Yes, I can and I would love to. Um, some things you should know about the Pressable WordPress product is we really differentiate on support. That\'s our number one thing. I know everybody says that their support is great.[00:04:00]</p>\n\n\n\n<p>Um, if you\'re familiar with. Automatic. You know that sometimes they\'ll have support teams that kind of go across different brands. But at Pressable we have the same core group of people. Most of them are developers, all of them are WordPress experts, and you\'re gonna get the same people every time. So, you know, the product that we serve is hosting, it\'s great hosting, it\'s powerful performance hosting, but what we really sell is the experience.</p>\n\n\n\n<p>And that means you\'re gonna have friends here that can help you no matter what your word. Website problem may be, um, within reason, obviously, but, uh, cuz people can do some weird stuff to word breasts. Okay. Um, but uh, the other stuff that we sell is that, uh, performance, um, A lot of people don\'t realize this, but Principle was originally known as Zippy Kid.</p>\n\n\n\n<p>We were one of the original three managed WordPress hosting companies in the world. And obviously that a lot\'s changed since 2010 when it was founded. Um, [00:05:00] it\'s. Been rebranded as pressable, and today we\'re owned by Automatic something a lot of other people don\'t know. Um, so the platform that we have that\'s super performant is actually the same one that powers wordpress.com and to some extent, WordPress, v i p.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah, I know a lot of hosts can say performance and support. Uh, on the support side, I know the culture at Automatic is prolific with support. I, I, I recall several years ago that every team member that\'s hired goes through basically their first onboarding experiences, actually doing support. And I thought to myself, that\'s, that\'s a company that does value support, but I\'ve also experienced.</p>\n\n\n\n<p>Yeah, like I said, my friend, uh, has, has a site on principal and I ran into something because, you know, I\'m barely technical and, um, I can\'t remember his name off the hand, top of my head, but I think it was Michael. But, um, I went to support, asked a question, thought I\'ll get direction and [00:06:00] pointing. The next thing I know it\'s like, Kind of really helped me try to get the, the site going and get past one of the issues that I was having though.</p>\n\n\n\n<p>I was like, I\'m gonna spend a couple hours googling this or have to go to post outta Slack and ask somebody and beg somebody for help. And, uh, I really did get that experience. And that to me, Jess is pretty rare in hosting. Because in the early days you remember this, you talked about 2008. I remember you go to some of these shared hosting companies and I could get incredible admin type work, like support from people.</p>\n\n\n\n<p>Those days are pretty much gone until you get up to these high tiers of like hosting. So to have that kinda support is incredible. And then to your point, you just told me like support and performance. At first I go, most hosts probably brag about. Two things, but you\'re backing up the performance side too, like you said, but this backbone, which is legendary wordpress.com and b i.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> It\'s true. Um, if you look at this year\'s WP [00:07:00] Hosting Benchmarks studies, um, and if you\'re not familiar with WP Hosting Benchmark, um, review Signal runs these every year, hosts have to pay to participate. Because there is no favoritism, there is no way you can kind of grease the wheels. And if anybody does anything that looks untoward, he blasts you and tells everybody what you did.</p>\n\n\n\n<p>Um, but he legitimately, Kevin from Rude View Signal will do these tests and you enter in a variety of categories. and in this year\'s test, pressable aced every single level we were in. We got top awards in every single category we entered. Um, and that\'s a reflection of our environment. Um, we don\'t need to rely only on caching, but our caching is awesome.</p>\n\n\n\n<p>Um, we have, you know, industry leading PHP resources, and I would say that our CPUs can probably best, most other host.</p>\n\n\n\n<p><strong>Cory Miller:</strong> I, I tell you, you\'re not kidding when you talk about Kevin, I get to meet him, um, this [00:08:00] summer in Porto like you did too, I\'m sure. And, um, Kevin is a purist. He\'s extremely passionate about what he does, and I know he\'s been doing the benchmarks for a long time and to, to pass.</p>\n\n\n\n<p>It\'s this pretty, pretty incredible, um, I, I, I would say it\'s not for the faint of heart. Go through Kevin\'s benchmarks and things, so that\'s great. Backing it up from an external source like Kevin, and he\'s in the process community and pretty active. So yeah, we\'re proud. Awesome. Okay, so we talked a little bit about the product manage WordPress hosting support performance Two highlights.</p>\n\n\n\n<p>Um, what, uh, tell me about the types of customers. If you\'re a customer looking at principle or looking at managed Word Press hosting, who are you, who, who, who did you build the product for, essentially?</p>\n\n\n\n<p><strong>Jessica Frick:</strong> That\'s a really good question. Um, and honestly, [00:09:00] there are two main audiences that we work with and it, it sounds overly simplified to say it this way.</p>\n\n\n\n<p>Um, The, the more simple user that just needs powerful hosting with great support. And then the more advanced user, um, which might be a developer or an agency, um, you know, an agency, like there\'s so many different kinds of agencies. You might have an agency that\'s. Super technical and some that are not. Um, I would say that we are ideal for agencies that are operating multiple websites for their clients because we make it super easy to manage multiple sites in one place.</p>\n\n\n\n<p>Um, I would also say that we\'re good for agencies that have their own special workflows. We have get integration tools. Um, we are able to help you with custom API applications, um, SSH and WP CLI and all. Stuff. And then of course, um, for the business owner who just has an e-commerce store [00:10:00] that gets crazy waves of traffic every single time her story gets picked up on TikTok and it happens, you know, a couple times a month.</p>\n\n\n\n<p>We\'ve got her back. because our hosting out of the box can handle huge amounts of traffic at any given moment. And so most of the time, you know, she doesn\'t even have to pay attention to her website, but when she does, she needs help and she needs it now. And that\'s where we come in. One of the things I didn\'t get to mention is our support has some pretty incredible statistics.</p>\n\n\n\n<p>So our average first response time is under three. So when that business owner needs our help, she\'s not waiting for like 20 minutes for somebody to respond to her chat. We\'re there our average resolution time, Corey is under 10 minutes. So it\'s not like you write us and then you\'ve gotta wait for us to ask four other people.</p>\n\n\n\n<p>We\'re there and we\'re helping you and we fix it. Um, so I would say, you know, even more simplified than all of [00:11:00] that, we\'re probably not gonna be your first host. We\'re gonna be the host that you graduate to when you\'ve experienced support at some other places, or when you\'ve outgrown what their resources can offer you.</p>\n\n\n\n<p>Um, you know, maybe your sites are slow, maybe you\'re experiencing downtime. Um, we have a 100% uptime guarantee, and we\'re able to offer that because we have automatic failover included for free. And because we know that your sites aren\'t gonna go down here, So .</p>\n\n\n\n<p><strong>Cory Miller:</strong> Okay. Tell, tell me more about that. So, a hundred percent guarantee.</p>\n\n\n\n<p>I, I know I\'ve been to hundreds of, you know, hosting sites since like 99.9, and I go, okay, cool. Why does it, why does it, ma, I mean, and, and I\'m not running an e-commerce store that if I, if I\'m down for a minute, I probably lost a thousand dollars, right? Mm-hmm. , tell me why that matters. A hundred percent. And what that means.</p>\n\n\n\n<p>A hundred percent uptime and the automatic.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> You can fit a lot of excuses in 0.1%. Corey[00:12:00]</p>\n\n\n\n<p><strong>Cory Miller:</strong> That\'s good.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> You know, there are a lot of things you can say. Oh, that\'s the 0.1. No, we we\'re a hundred percent up time. We got you. Um, I was just talking with one of our agencies yesterday who\'s been with us for, since 2017, and they\'ve never had a site go down, ever. And they host hundreds of sites with us.</p>\n\n\n\n<p><strong>Cory Miller:</strong> And that matters. You know, you got the 99.999 or whatever, and then a hundred percent. Um, for sure, like I at, at Ithe, I knew when our site went down, we lost money. Now we didn\'t lose thousands of dollars, but we were losing opportunity cost. I mean, there\'s a big value to that. Yeah. Um, tell me, because I just don\'t even know what is automatic, fell over.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> Automatic failover means if for some reason there\'s a problem with the mechanics and the systems, we will automatically redirect your traffic to your exact [00:13:00] site on a different server elsewhere. So it\'s kind of like that high availability experience where if it goes wrong here, we got you over here.</p>\n\n\n\n<p>When you\'re using our name servers, we\'ve got you everywhere.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Okay. Hat tip. Make sure your name servers are at the host and particularly with Pressable cuz you wanna take advantage of that, that\'s outstanding. Um, okay. Tell me, um, do you wanna show me a little bit of the dashboard and the product itself?</p>\n\n\n\n<p><strong>Jessica Frick:</strong> I do, yeah.</p>\n\n\n\n<p>So you asked like who we\'re for, and you know, one of the things that I\'m super proud of when it comes to Pressable is it is an extremely technical interface, but it can be done. Um, and it can be used in such a way that. Someone who\'s not super technical will also appreciate it. I\'m so sorry. Like myself.</p>\n\n\n\n<p>Yeah. Well you, but also, you know, you are technical. [00:14:00] Um, I would say that there are also some people that just sort of see this, and I\'m so sorry, I\'m having some technical issues. We\'re gonna have to edit this.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Yep. We\'ll edit it. Yeah. Lemme start with.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> One of the things that I absolutely love about our interface is that it\'s great for technical people, but it\'s easy to use for people who maybe aren\'t quite as technical. So when you log into your account, this is what you\'re gonna see. Obviously not these sites, this is our demo account. Um, but you know, right off the bat you can see your sites, you know where they all are.</p>\n\n\n\n<p>Um, and you\'ve, we\'ve got a new feature here called collaborators. I\'ll get to that in a. Um, but let\'s dig into a site right now. Demoable . Mm-hmm. . It\'s not a real site, don\'t go to it. Um, but when you get in here, you can immediately get a nice overview. You can see what PHP version you\'re running, what WordPress version you\'re running.</p>\n\n\n\n<p>Um, by the way, we will allow you to be on the [00:15:00] previous release, the current stable, or you can go on beta. Um, that is something that we offer here and we\'re very proud to do that, especially because we know that sometimes you might need a little more time for testing. So, um, we offer you the opportunity to leave notes for your team.</p>\n\n\n\n<p>Let\'s say you\'re working in here with multiple others and you\'re gonna need to just kind of have those admin. Pieces of information that\'s right there within the dashboard. Here\'s where you\'re gonna have your domain information. Um, obviously our name servers, um, and we can also give you IP addresses. Uh, then we have performance.</p>\n\n\n\n<p>Um, if this was a live site, you would see more data here and it\'s just gonna kinda give you that pulse check on what your site\'s doing this month. Um, I could probably spend a long time on this, but I won\'t cause we only have a couple minutes. But you\'re gonna have all of your users for this particular site here, we offer backups 30 days.</p>\n\n\n\n<p>Oh, by the way, our backup storage is complimentary. That does not go [00:16:00] against your total storage that you have for your plan, and then of course, that get integration. What I wanted to show you also was collaborators. So collaborators is gonna give you a way to have multiple people in your account, but not everybody can do everything.</p>\n\n\n\n<p>Um, I know at some other host when you add somebody, you basically get to be an admin or just, you know, a viewer. Uh, here, if you want somebody to be able to get that WordPress access, maybe you\'d never wanna give them the ability to delete or disable. But they\'re also gonna need to be able to get that SFTP access.</p>\n\n\n\n<p>You can fine tune the experience for that one particular person right here. Um, something else that\'s coming up that\'s gonna be super exciting. Uh, we\'re introducing something called the One Press Login. One thing that we\'ve heard from our customers is it\'s kind of annoying to have to enter your credentials every single time you wanna go into your WP admin.</p>\n\n\n\n<p>And [00:17:00] so here on your site details, we\'re going to give you that one press login button, and it\'s going to basically work like a one time password. Automatically and securely log you into your dashboard. No passwords needed. We also offer email through Titan Mail. This is an upsell. Um, we have usage data for you here.</p>\n\n\n\n<p>It\'s really nothing super exciting or sexy. Um, billing is no nothing to write home about . make billing sexy. Um, but you know, we also have site performance reports. We have collaborator reports. If you\'ve got a bunch of collaborators on your site and you\'re. Who all is on this and what do they do? Um, you\'ve got different site usage reports, all of these, you click the report and it\'s gonna send you an email.</p>\n\n\n\n<p>Um, please don\'t spam us there, but basically, we\'re trying to make it easy to manage a whole bunch of sites and [00:18:00] just to keep your finger on the pulse of what all of them are doing.</p>\n\n\n\n<p><strong>Cory Miller:</strong> I can see that collaborator report, especially if you have a team and different hands in the, in the kitchen. Yeah. Um, for sure.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> Yeah. And then of course, you know, if you wanna build your own API application, you can come here and create your api. And we have all of our documentation published here. Um, this is not behind a paywall, so if you ever wanna see if you could do that here, chances are you can.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Fantastic. I love that. Yeah.</p>\n\n\n\n<p>Well, thanks for that quick overview. Uh, I like to see the pro, you know, the dashboard. Um, I, I\'m sure unlike many people listening that I go to, uh, Page or sales page one day, and then it\'s months, maybe even years before I go back when I have a need. And so I like showing the product because I want people to see the experience.</p>\n\n\n\n<p>And one thing that stuck out just was like, how fast that even the admin side oh, uh, was rocking.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> Yeah, it\'s super, super fast and it\'s [00:19:00] super fast. Even if you have hundreds of websites as opposed to just one. Um, that\'s something that, you know, obviously I do a lot of testing at our competitors. That\'s not something you get every.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Yep. Well, okay, thanks. Now, we talked about the product. We\'ve talked a little bit about what you\'re looking forward to, but I really want to ask that question. What things are you doing? What things are you excited about at Principal?</p>\n\n\n\n<p><strong>Jessica Frick:</strong> I know a lot of people aren\'t comfortable talking about this, but I love talking about what\'s coming soon.</p>\n\n\n\n<p>Um, we have some really fun features coming soon. One of the things is going to include the ability to have kind of a template of your site. Um, Right now, our competitors would call them, you know, templates or, uh, maybe even stencils. It\'s gonna give you a way to just clone your site, but with all of the different settings and plugins attached to it, um, that\'s coming soon.</p>\n\n\n\n<p>Obviously, the One Press login that I mentioned, we are also looking to bring [00:20:00] forward smart plugin updates, so you\'ll be able to update plugins for one site or multiple. Easily in a safe way. And then we also are looking to improve the sinking between staging and live. This is something that honestly, I have not seen anyone do.</p>\n\n\n\n<p>Beautifully. Like there\'s problems everywhere when you\'re trying to do this. Um, one of the things that we are trying to keep an eye on though, is the changes that are happening with full site editing. Um, you know, a lot of other hosts might have an easy button. I shouldn\'t say a lot, but a couple of other hosts have an easy button.</p>\n\n\n\n<p>And basically what that\'s gonna do is just exclude your databases from syncing your staging environment to your production environment. And that would be fine because you obviously don\'t wanna overwrite your W commerce data, comments, all the other dynamic stuff that happens. But with full sight editing, a lot of that data is being stored in those same places that you\'re currently excluding.</p>\n\n\n\n<p>So we\'re trying to [00:21:00] like fine tune. So that you get what you want to have from staging moved over. Um, and just to make it fast and easy too. Ultimately, the, the things that we\'re trying to develop are things that people have directly asked us for. Um, we love hearing from our customers and we love hearing from people who would be customers, but perhaps they\'re held from, you know, for one reason or another.</p>\n\n\n\n<p>Um, One of the cool things about us being small and mighty is we actually act on those. Mm-hmm. . And so if somebody\'s watching this and you\'re not a customer because this or that, please tell me cuz we\'ll build it</p>\n\n\n\n<p><strong>Cory Miller:</strong> And by the way, Jess is in post set of slacks. She can even DM her. Yeah. So I wanna go back to something you talked about the syncing, and there\'s a nuance there that I hadn\'t thought about, which is all the databases. So could you gimme some examples of that? Uh, particular instance? I know you said, uh, full side [00:22:00] editing.</p>\n\n\n\n<p>Uh, But I, I\'m, I\'m, I\'ll just confess to you, I\'m a newbie to staging. I have used, uh, principle staging mm-hmm. to, um, we\'re, we\'re working on a rebrand of, uh, post status.com and I was like, I just want to get a site that I can go do. And I\'ve been using the staging for that, but could you tell me what a little bit more details about, or examples of how that might be really critical for store owners, agencies and developers?</p>\n\n\n\n<p>I\'m sure they know these answers, but I want to.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> So, having worked in hosting for a long time, I can tell you it is shocking how few people actually use staging environments. So high five to you, my friend, for doing an staging environment first. Um, one of the problems is you get your staging site exactly how you want it, and then you need to be able to push it live.</p>\n\n\n\n<p>And for the, the old way to do it was just to completely overwrite your site. The thing is, and like picking on post status, I know you guys have. [00:23:00] I know you even have a store, but I can\'t remember if your store is actually on the, the site or not, or if it\'s external. Um, but you know, if you have that kind of data coming in on the regular, there are a few ways you can go about it.</p>\n\n\n\n<p>Um, the first would be like a two stage migration where you would migrate it. At a single point in time, and then like, kind of do your stuff and then you would bring to date the Delta. Um, so for example, blog vault can actually do that for you. They do a great job with that. Um, and so they\'ll bring over the, the data, but you\'re still gonna have that tiny window where you might miss a pro, a purchase or you know, somebody might be doing something on a membership site and you\'re gonna lose that activity in that moment.</p>\n\n\n\n<p>Um, one way to counter that is to put up a, like. Under maintenance. Interstitial or something that basically lets people know that whatever you\'re doing right now, not gonna count, or you just can\'t do it right now. Um, but the other [00:24:00] option is to create a nuanced tool that does not include that data when they overwrite it.</p>\n\n\n\n<p>Um, because whatever is happening on staging is not going to include all of that purchase data. Something people haven\'t considered a lot of times is when you bring an entire production site over to your staging, you might actually have all of that e-commerce stuff in place. And so heaven forbid you\'ve got a membership site.</p>\n\n\n\n<p>It could be charging subscriptions on. You gotta be real careful of that. And so one of the things that we\'re also working to do is to make sure that that kind of stuff doesn\'t happen in staging. Just a blanket rule that you can\'t be charging for things and you know, running, running different processes that could negatively impact you cuz you didn\'t mean to do that there.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah, I can see how you just eliminated how critical that is for a w uh, like a W Commerce site, um, with some of those things because you do have this continuum amount of data and storages or staging as a best practice, [00:25:00] and this is a nuance to make sure you\'re capturing those educations. I think that really stands out, particularly in e-commerce, but I think you showed some other ways where I don\'t want that thing.</p>\n\n\n\n<p>To be missed or I don\'t want that thing to be updated. And some of my experience with backups, I kind of, I, I\'m aware of some of those type of nuances and that\'s, I, I ask for my own edification, but also I think it highlights that the person leading the team I knows, knows their stuff. And I love, I love talking with you because you always give me something new to think about.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> Well, thank you. That\'s a very nice thing to say.</p>\n\n\n\n<p><strong>Cory Miller:</strong> You bet. Well,</p>\n\n\n\n<p><strong>Jessica Frick:</strong> fortunately I work with some people that are smarter than me too. So , I think I\'m great. You should meet the team.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Well, my next and close to my last question is I, I just wanna get your thoughts about tech WordPress in general. We talked a lot about hosting nuances, the things that you\'re working on, you\'re already doing, have done, [00:26:00] um, performance and support being some big highlights backed up, but some really good reasons.</p>\n\n\n\n<p>Um, To be able to say we do performance and support extremely well. But I really wanna turn the page and ask you your thoughts about tech and WordPress and what you see coming up and what you\'re excited about with WordPress and then tech overall.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> You know, it\'s, um, This is a really interesting question because we\'re at a strange time right now.</p>\n\n\n\n<p>You know, for a minute, every time you turned around, another WordPress company was getting acquired and I feel like we\'re kind of in a lull for a little bit. That\'s not to say that somebody\'s not gonna get acquired while we\'re on this call, but it could have , but for a minute, there was like every single day.</p>\n\n\n\n<p>Um, but what\'s also interesting is we\'re seeing, you know, different companies tightening up. Um, Be it the market conditions or some other, you know, variable. We\'re, we\'re seeing a lot of companies, you know, really getting into conserve [00:27:00] mode and it\'s been interesting to watch how they\'re doing that. Um, thankfully we\'ve not seen a lot of companies just laying off a whole bunch of people.</p>\n\n\n\n<p>Um, it\'s happened, but it\'s not happening like you\'re seeing with other big tech. And I think part of the reason that WordPress is probably a little more insulated is because I think by and large the WordPress community has perhaps been more stable to grow in the first place. Um, I think it\'s gonna be interesting to see what happens in the hosting world, but also, you know, in the future of plugins, um, and certainly themes, especially with, you know, blocks becoming what they are.</p>\n\n\n\n<p>Um, I\'m really interested to see how that plays out for the community because at the heart of it, I mean core, you know me, I love WordPress. Like I love WordPress, but part of, one of the, part of the reason that I love WordPress so much is because I [00:28:00] love the community. You know, we have a lot of really great, genuine, smart, helpful people.</p>\n\n\n\n<p>You know, if we\'re being honest, yeah, there\'s some jerks, but that\'s. A small percentage. Mm-hmm. , most people would stop what they\'re doing to help you if you needed it. And I think that that\'s also part of why we\'ve become kind of insulated, um, from that toxic growth. I guess if you\'ll let me get kind of spicy.</p>\n\n\n\n<p>Yeah. Um, , I think we know who is Awesome. Generally speaking, and we all kind of look out for each other, and I really, really love that about. Yeah. Um, what I\'m thinking about tech right now, we\'re, we\'re seeing a situation where one of the biggest social networks has been bought by a single individual and love them, hate \'em, or don\'t even care about \'em.</p>\n\n\n\n<p>[00:29:00] It\'s making some pretty big changes to the product itself and the audience that uses it. And one of the things that I love about WordPress is that it\'s open. And you know, a lot of people want to blame one specific person for things. And yeah, of course he\'s influential, but he doesn\'t control the whole project.</p>\n\n\n\n<p>And so I think it\'s made me more grateful, um, seeing how it can go wrong when you have just that one super rich guy that can make all the shots. And then you have WordPress where it really is, you know, power to the people</p>\n\n\n\n<p><strong>Cory Miller:</strong> and you can fork it. I don\'t think you can fork Twitter, but you can\'t fork WordPress and it has been forked.</p>\n\n\n\n<p>It has. So even if there are powerful structures, you can still take the code and and go elsewhere. Yeah. Decentralization is definitely something that I\'ve heard a lot from members and in these interviews because it\'s uh, really key in part of the power [00:30:00] WordPress is that, um, it can power everything from my little blog on my stage inside principle, uh, to you.</p>\n\n\n\n<p>Uh, very big house in Washington DC that happens to be white. Yeah. And so like, it\'s, it\'s crazy. All the applications. I, uh, as I\'ve talked to agency owners and, and technical people, what WordPress is being used for, but at the core, that open source philosophy really resonates and. Powerful. And I think we\'re seeing that, like from what you\'re saying too, is like we\'re seeing that the power that WordPress is and continues to be, it\'s not owned necessarily by one person.</p>\n\n\n\n<p>It can be used, the freedom that we have</p>\n\n\n\n<p><strong>Jessica Frick:</strong> and people are building cool things to go with it. You know, things on top of it. You know, before we started recording, we were talking about the world of podcasting and the things that are built to, you know, work alongside it, you know, pocket casts and various others.</p>\n\n\n\n<p>Um, we were talking about custom applications that people are building. I think WordPress itself is going to [00:31:00] continue as a building block for a lot of other cool technology in the future. And, So excited to see it happen and honestly I hope one of the ideas is mine cuz I feel like you and I would be really good, rich people.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Yes, totally. I think we would very generous . Just Rick, thank you so much. Can you tell people, uh, where to find more about you in principal?</p>\n\n\n\n<p><strong>Jessica Frick:</strong> Yes. Come visit us at pressable.com and if you wanna find me, I am in the post status slack. Um, if you\'re not in post status, let\'s fix that problem first. Uh, but you can also find me at renewable.com if you want.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Awesome. Thanks so much. Yes, for the time today, and I hope you\'ll go check out our principal dot com\'s offerings and see what we\'re talking about.</p>\n\n\n\n<p><strong>Jessica Frick:</strong> Thanks, Cory.</p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Dec 2022 21:37:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olivia Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WPTavern: #55 – Dennis Dornon on How Partnerships Have Helped Grow His WordPress Plugin Business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=140323\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"https://wptavern.com/podcast/55-dennis-dornon-on-how-partnerships-have-helped-grow-his-wordpress-plugin-business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47001:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast, which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, how finding partners might boost your WordPress business?</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m very keen to hear from you and hopefully get you or your idea, featured on the show. Head to WPTavern.com forward slash contact forward slash jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Dennis Dormon. Dennis is the founder of MainWP. A WordPress plugin which enables you to manage multiple WordPress websites from a single dashboard. As you&#8217;ll hear, the business has changed over the years, as Dennis has learned more about the plugins&#8217; target audience.</p>\n\n\n\n<p>If you&#8217;re a solo developer, or a working for a small team, bringing your WordPress product into the market can be very rewarding, but it can also be hard. Given the scale of the market, it&#8217;s likely that your product has got an audience. But with the time and resources being limited, it might be hard to break through and be widely discovered.</p>\n\n\n\n<p>Dennis talks today about how, in the recent past, he&#8217;s been trying out working with partners as an effective way to increase the plugins reach. As you&#8217;ll hear, it&#8217;s a strategy that he&#8217;s enamored with, given the right partner.</p>\n\n\n\n<p>We start off by talking about why Dennis built MainWP, and who the plugin was originally aimed at. And it&#8217;s not what you might expect.</p>\n\n\n\n<p>We then get into how Dennis is working out his partnerships as he goes. What is it he&#8217;s looking for in a partner? Not all companies in the WordPress space are going to be a good fit. And so he explains how it&#8217;s important that all partners have some skin in the game, and know what part of the deal they have to uphold. What are the things that need to be considered before the partnership begins? And how do you make sure that all the parties are keeping up their end of the bargain?</p>\n\n\n\n<p>It turns out that MainWP is a business which is in just about the perfect spot for bringing on partners. But if you&#8217;re a developer and have not considered this type of approach with your business, this podcast is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more you can find all of the links in the show notes by heading to WPTavern.com forward slash podcast. Where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so, without further delay, I bring you Dennis Dormon.</p>\n\n\n\n<p>I am joined on the podcast today by Dennis Dornon. Hello, Dennis.</p>\n\n\n\n<p>[00:03:40] <strong>Dennis Dornon:</strong> Hey, Nathan. How are you?</p>\n\n\n\n<p>[00:03:42] <strong>Nathan Wrigley:</strong> Very, very well. Dennis and I have had a little bit of a chat before the podcast began, and it&#8217;s been a pleasure getting to know him. You&#8217;re going to get to know him over the next few minutes. Dennis, we always ask our guests right at the beginning, there&#8217;s some kind of orientation question, just trying to figure out who you are and where you come from.</p>\n\n\n\n<p>I&#8217;m wondering if you&#8217;d spend a few moments just telling us what it is that you do in the WordPress space and how you&#8217;ve become part of the WordPress community. You can take that in any which way you like and go back as far or as near as you wish.</p>\n\n\n\n<p>[00:04:14] <strong>Dennis Dornon:</strong> Hello everyone. I&#8217;m Dennis Dornon with MainWP, WordPress manager plugin that allows you to maintain multiple WordPress sites from one central dashboard. The MainWP plugin allows you to perform most of your daily WordPress maintenance tasks, such as updating your plugins, backups, uptime monitoring things like that.</p>\n\n\n\n<p>And since MainWP is a self hosted WordPress plugin, it allows you to do all that while remaining privacy focused and not relying on any third party solutions like many other WordPress managers.</p>\n\n\n\n<p>[00:04:40] <strong>Nathan Wrigley:</strong> So when did you discover WordPress? How far do we go back?</p>\n\n\n\n<p>[00:04:44] <strong>Dennis Dornon:</strong> I would say probably about 10 years ago is when I really started getting into it. About 10 to 12 years ago I was full-time affiliate marketing and had a few hundred websites, mostly focused on the automotive industry. And at that time I just did real cookie cutter sites that just did PHP changes from a flat file where, like I would change the city name, make model, and just put those out.</p>\n\n\n\n<p>But then Google started changing their algorithm, so you couldn&#8217;t really have the cookie cutter sites anymore if you wanted to continue to rank. That&#8217;s when I started exploring WordPress. Slowly moved those few hundred sites over into WordPress. And then I quickly realized once you have a few hundred sites, I think in my case it was close to 500 sites, that maintaining those could be quite a pain in the neck.</p>\n\n\n\n<p>And that&#8217;s when we started looking to different solutions that were already out there. But none of them gave us the privacy we were really looking for. Both me and the co-founder came from an affiliate background, so we wanted everything to stay completely private and no one to have any of our information.</p>\n\n\n\n<p>Started developing our own solution for WordPress and we actually went with using WordPress as the backbone since we didn&#8217;t have to worry about login, security and making all those things for ourselves and just built it as a plugin itself.</p>\n\n\n\n<p>[00:05:54] <strong>Nathan Wrigley:</strong> That&#8217;s really fascinating. Kind of interesting that it was a scratch your own itch type of product. We&#8217;re here today, we&#8217;re going to talk about a slightly different subject because a little while ago I put out a tweet and I was asking for people to suggest topics that maybe of interest to listeners of this podcast. And Dennis reached out and so we got connected and we&#8217;d settled on the topic of, the idea of partnerships within the WordPress space. So, I&#8217;m just going to map out in broad outline what I think we&#8217;re going to talk about, and then we&#8217;ll see if the conversation goes in that direction or not.</p>\n\n\n\n<p>So, Dennis has a history, or at least I should say MainWP, whether it&#8217;s Dennis or other people, I&#8217;m not entirely sure, has a history of connecting with other WordPress companies to mix up what they&#8217;re doing. So MainWP with partner A and MainWP with partner B. And try to figure out if there&#8217;s ways that they can rub each other&#8217;s backs, and help each other along the journey to growing and what have you.</p>\n\n\n\n<p>So you have a product and you have lots of partnerships. I guess the easiest way to begin this subject is, can you just lay out some examples of people that you have partnered with in the past and how those partnerships have developed. Just to give us a little bit of a picture of how this all works.</p>\n\n\n\n<p>[00:07:14] <strong>Dennis Dornon:</strong> Sure we really just got into partnerships. We have a lot of extensions that work with other plugins, but I wouldn&#8217;t really call those partnerships. Those were more along the lines of what you were saying earlier of kind of scratching our own itch. So we put out our first kind of partnership way back in 2015 with our first third party extensions. So, about a year into our existence, we actually started going out and working with other plugins.</p>\n\n\n\n<p>The problem at that time is we didn&#8217;t tell them we were actually working with them, so we would just go out and build these extensions and then be like, hey, we got an extension for you. And they&#8217;d be like, thank you. That&#8217;d pretty much be the end of the partnership. But it helped our users, especially with our first ones, which was a backup extension, Updraft Plus. And then we, I believe one of our first extensions was also a Yoast extension.</p>\n\n\n\n<p>But these weren&#8217;t true partnerships. It wasn&#8217;t until probably the last year or two that we actually started to get into real partnerships, where we talked to the other company, before we built an extension for them so that we could, uh, grow out from there.</p>\n\n\n\n<p>Some of the current ones that we have out are of course, SEOPress, which we just launched earlier this month. Atarim a couple months ago. Before that WPvivid Backups made their own extension and WP White Hat Security made an activity log extension. Those were more true partnerships where we work together to find a common solution.</p>\n\n\n\n<p>But most of these were just a, I would call them code development partnerships. So we were both kind of working in the development of it. Where I failed at would be the co-marketing portion of it. So even though we had grown and had actually started working with the other companies on building these extensions, instead of just building them ourselves, we still weren&#8217;t getting the word out appropriately that we now had official partnerships with these different companies. So we&#8217;d launch the partnership, announce it for a day or two, and then kind of let it die.</p>\n\n\n\n<p>Die might be the wrong word. We didn&#8217;t do too much with it, we just kind of hoped they would grow on their own if you follow what I&#8217;m saying there. We didn&#8217;t really learn until the, well, I didn&#8217;t learn until the Atarim partnership, how to correctly co-market. And that has really jumped up our actual partnerships. People coming in for partnerships. Partnership requests have all gone up.</p>\n\n\n\n<p>Really from what Vito Peleg showed us with our partnership with Atarim, and how to not only do the co-development, but the co-marketing, and co-marketing is what you generally see from, when you see a partnership in WordPress that&#8217;s, you know, where you&#8217;re on each other&#8217;s mailing list, social, things like that. And you do it for a short amount of time.</p>\n\n\n\n<p>So now we have that perfect combination for a partnership of both co-development and co-marketing. Why co-development helps is it gets the other person to have skin in the game with you. So you both, you both have something to lose if the co-marketing doesn&#8217;t go well.</p>\n\n\n\n<p>[00:09:58] <strong>Nathan Wrigley:</strong> So towards the beginning of your endeavors, you mentioned 2013 or something like that.</p>\n\n\n\n<p>[00:10:03] <strong>Dennis Dornon:</strong> 2015.</p>\n\n\n\n<p>[00:10:03] <strong>Nathan Wrigley:</strong> 2015, Sorry, yeah. You mentioned that the business was growing and, I guess at that point you didn&#8217;t really know that partnerships could be a thing, and so you just looked out into the WordPress ecosystem and thought what would be a good thing for us to build? And how can we help our customer base that exists already? And so you just built it yourself, shipped it, and maybe had some kind of email interaction with the originators of that plugin? Maybe not. It just went out there. But the point was it was all within your silo.</p>\n\n\n\n<p>And more recently, in the last year, as you&#8217;ve described, you figured out that there&#8217;s this model where you get in touch beforehand and potentially you do the work or they do the work, or you partner together and do the work together, I don&#8217;t know what the model there is exactly, but the principle being that it&#8217;s much more of a symbiotic relationship. You&#8217;re in conversation about it. You both are sending out promotional materials once the thing has finally shipped, so it&#8217;s much more of a collaboration. It&#8217;s not as if you&#8217;re merging together. Your business is separate, their business is separate, but there&#8217;s definitely an overlap where you can help each other out.</p>\n\n\n\n<p>[00:11:16] <strong>Dennis Dornon:</strong> Correct, yeah. Everything stays completely separate. It&#8217;s not a partnership in terms of a, you know, giving up any portion of your business. It&#8217;s more of a partnership of helping each other grow from your own base of customers. So if we go back to Atarim. Atarim promotes to their base of customers along with an actual, like I was saying, the code developed.</p>\n\n\n\n<p>So they have something to hand them that they can come back and, MainWP, this is how it works with it, because we&#8217;ve actually built something together. I&#8217;m just not sending you an email blast telling you to go use MainWP. Here&#8217;s an email, here&#8217;s social, here&#8217;s how we&#8217;re working together to make your life easier. And that&#8217;s what we&#8217;re focused on going forward. Both co-development, co-marketing to work nice and smooth.</p>\n\n\n\n<p>[00:11:52] <strong>Nathan Wrigley:</strong> So in the last year, in this time where you&#8217;ve found several companies that you&#8217;ve decided to partner with as opposed to building it yourself. Just describe some of the benefits that you&#8217;ve discovered. You&#8217;ve mentioned things like marketing and what have you, but are there any other unexpected things?</p>\n\n\n\n<p>It might be just that, you know, it saved you a bunch of time. You ended up being friendly with people that you otherwise wouldn&#8217;t have encountered. Whichever way you want to take that.</p>\n\n\n\n<p>[00:12:17] <strong>Dennis Dornon:</strong> I&#8217;ve really learned, we&#8217;ve been doing this, MainWP itself for nine years, and I am just really started talking to people in the last year. And I think a lot of that comes from being in the partnerships and realizing that, when you get out there and you talk to people that they are friendly, most people are friendly.</p>\n\n\n\n<p>Most people just want to work with you. They want to help. You gotta find who you want to work with, if they fit into what you want to do, if they fit into how you want to grow. But really we haven&#8217;t run into too much of people who didn&#8217;t align with what we are looking to do so far. But we are working on documents that we can put on our MainWP.dev site that allow people to see what&#8217;s expected from them, what&#8217;s expected from us in a partnership, so they know before they even contact us, hey, if we want to do a partnership, okay, we need to meet these things, do these things. So it&#8217;s all laid out for everybody.</p>\n\n\n\n<p>[00:13:06] <strong>Nathan Wrigley:</strong> Yeah. That&#8217;s really interesting because, obviously a couple of years ago you didn&#8217;t really have anything to lean back on to say, this is how a partnership may work, and now that you&#8217;ve done it a couple of times, you&#8217;ve taken the step to even create documentation around that so that you can isolate yourself, I guess, from people coming to you and saying, we&#8217;d like to partner with you, and it&#8217;s simply not being a particularly good fit. There&#8217;s bound to be a whole raft of companies, there&#8217;s just really not enough overlap to work with.</p>\n\n\n\n<p>Yeah, I was wondering about that really. Are there any constraints that you&#8217;ve placed upon yourself to say, okay, if it&#8217;s out of this boundary, we probably won&#8217;t be able to work with you, or if it&#8217;s inside this boundary, we will.</p>\n\n\n\n<p>[00:13:47] <strong>Dennis Dornon:</strong> It&#8217;s a hard one cause I haven&#8217;t come across anybody reaching out directly to me that I would be like, oh, I just can&#8217;t, just couldn&#8217;t work with you. There have been some things, where I know if somebody reached out that I didn&#8217;t feel comfortable putting in front of our user base, we&#8217;d be able to say no to. Something that wasn&#8217;t, um, don&#8217;t want to say privacy focused, but something that is completely against the way we feel about privacy.</p>\n\n\n\n<p>Of course, we wouldn&#8217;t work with them. It&#8217;s a hard question to answer because it&#8217;s, until I&#8217;m actually presented with the situation, I&#8217;m not sure who I&#8217;d say no to, who I&#8217;d say yes to. I think everybody&#8217;s gotta be evaluated on their own individual basis.</p>\n\n\n\n<p>[00:14:20] <strong>Nathan Wrigley:</strong> You obviously, when you are creating partnerships like this, you are staking quite a lot. You&#8217;re putting your flag in the sand that we would like to work with this company. Our business aligns with them, and if you start to email your list with logos from other companies and what have you, you are firmly saying, we align, we are trusted partners with each other.</p>\n\n\n\n<p>And so the word that I used there was trust. Now I imagine that we won&#8217;t get into the conversation of any times that trust may have been broken, but I do wonder what that level of trust means. How have you approached that whole subject of, can I trust this company?</p>\n\n\n\n<p>You know, many people rely on their instinctive sense. Maybe there&#8217;s companies that you think if they approach me because I&#8217;ve seen what they do in the past, that isn&#8217;t a good fit for us. How do you establish trust and what does that trust actually mean?</p>\n\n\n\n<p>[00:15:14] <strong>Dennis Dornon:</strong> Well, I can say this year we did have a partnership that I would not do again. Not naming any names. We had terms in and then they, uh, changed the terms once things had been launched, and that was kind of upsetting and I&#8217;m not sure what you can actually do for that.</p>\n\n\n\n<p>So you really do have to put some trust into it. And I think that&#8217;s where combining the co-development along with the co-marketing really makes a difference. This particular partner, we did all the work for the extension for, and they provided the service and then they changed the service after the extension was made.</p>\n\n\n\n<p>So we&#8217;ve kind of moved away from doing where we do all the work in those situations. So we really go for the more of the co-development. Where the other person has the skin in the game, we know they&#8217;re also working for the same end goal we are. And then go into the co-marketing. And usually if you can get that skin in the game from the co-development, they&#8217;re not as, a person isn&#8217;t going to be as easy to do something, to break up that partnership or, make that partnership not profitable for both.</p>\n\n\n\n<p>[00:16:09] <strong>Nathan Wrigley:</strong> When you say co-development, are you talking about, literally you&#8217;ll put people in the same room or on the same Zoom call or whatever. So in other words, MainWP developers are working with company A developers, and together you are building out the solution which bolts into MainWP. Or is it more, you are collaborating on ideas and then somebody goes off and builds this part and MainWP take care of their part? Just give us an idea of what that co-working looks like.</p>\n\n\n\n<p>[00:16:37] <strong>Dennis Dornon:</strong> Yeah. and not to keep going back to Atarim, it&#8217;s just such a good example. In their case, they needed to develop a special API that we could connect to, and we needed to develop a way to connect to their API. So we were both working on APIs, to work with each other&#8217;s system. So we knew they were putting in the same amount of time or almost the same amount of time as we were into the extension. So we knew they were going to be just as dedicated to making sure that the product grew and got better.</p>\n\n\n\n<p>[00:17:02] <strong>Nathan Wrigley:</strong> So it&#8217;s very much a case of, you work out which ways you can scratch each other&#8217;s back, and share out the work accordingly. The hope being that the balance is equal, and it may be that at the beginning, if you&#8217;ve got the skill set to do the coding of a particular thing, then maybe that&#8217;s something that you would do, and maybe they don&#8217;t have the heavy lifting there. But they might have something else that they can contribute later in the journey. You know, marketing clout and so on and so forth.</p>\n\n\n\n<p>[00:17:28] <strong>Dennis Dornon:</strong> One of the things I have noticed, actually Jonathan Wold in one of his blog posts mentions it, and it&#8217;s something I&#8217;ve noticed too, is when you&#8217;re the smaller partner, you usually end up doing most of the work. And for most of this time we have been the smaller partner. So that&#8217;s just one of the things. If you&#8217;re the new guy or you&#8217;re the smaller partner, just be prepared to have to do more than the other partner.</p>\n\n\n\n<p>[00:17:47] <strong>Nathan Wrigley:</strong> Do you go through this in a very formal way? In other words, you mentioned the Atarim example, obviously one you&#8217;re very happy talking about. There&#8217;s a lot of work to be done. There&#8217;s lots of hours to commit to writing the code. There must have been some sort of procedure that was gone through saying, okay, exactly what is the scope of the partnership that we&#8217;re doing here? Exactly what is the scope of what we&#8217;re trying to build on top of MainWP, which will interact with Atarim? Do you spend a long time hammering all that out and deciding, we can&#8217;t do this particular feature, but we&#8217;ll come to that later.</p>\n\n\n\n<p>Because it&#8217;s not like you are selling a particular product at the end here where if the Atarim and MainWP partnership works out, it&#8217;s not like you can count the amount of units that you&#8217;ve sold of that partnership. It really isn&#8217;t like that, it&#8217;s just that you&#8217;ve made customers more happy. So there&#8217;s not revenue to be shared, but there is some benefit.</p>\n\n\n\n<p>[00:18:37] <strong>Dennis Dornon:</strong> Yeah, I think if you boil everything down to profit, what fun is it going to be to actually run the business? So if it helps the user, the end user, then that&#8217;s really what we&#8217;re going to do. I think that&#8217;s shown throughout everything we do as a company, that we just really care about helping the end user.</p>\n\n\n\n<p>Atarim&#8217;s a, just a good example. And the reason I keep coming back to that is because it is the one that taught me, if we go back to your earlier question to kind of calm down, and look at how to actually build the partnership. I keep saying I gotta give Vito credit for that, for, uh, teaching me that.</p>\n\n\n\n<p>Because before I would just get an email and if it looked like it worked from a standpoint of our users where I thought our users could really use something like this. I was all in I&#8217;d jump, we would go from there. It&#8217;d be a very quick process. I&#8217;m talking couple week turnaround time, from something that sounded really cool to actually getting it done, without any plan in place.</p>\n\n\n\n<p>We were running headlong into the fire, because that&#8217;s all I knew at the time. I just wanted to get this new product out. Make sure it works for everybody, make sure our users are happy, and that was my end goal. When it comes to partnerships, I&#8217;m not really too much worried about how many dollars this particular partnership&#8217;s going to bring into me. More of how happy will this make our users and will it get our brand in front of other users to also make them happy. So as long as our markets somehow can be combined, I think that&#8217;s the best way to look at it.</p>\n\n\n\n<p>[00:19:52] <strong>Nathan Wrigley:</strong> It feels like this is a train you in your business could at least get onto. You found a couple of partners, you&#8217;ve worked very happily with them, and you might move on to the next partner and the next partner, and the next partner and so on. I&#8217;m just wondering if that is now the intention for MainWP, you&#8217;ve enjoyed this experience. Is the plan to find new partners and see if there&#8217;s interesting ways that you can swell what your product does by partnering with other people? Or do you intend to have just a few close partners?</p>\n\n\n\n<p>Because that can be a nice model to work through as well. You&#8217;ve got five or six people that you work with very closely. You don&#8217;t have to dilute the work that you&#8217;ve got and try to maintain 50, 60, a hundred different extensions to MainWP, which may lead to, well, difficulty keeping them up to date as things change within their businesses and your business.</p>\n\n\n\n<p>[00:20:39] <strong>Dennis Dornon:</strong> Yeah, we actually are working on a dual model, if you will, of that. We have our extensions that we will build out, such as Atarim, which works through APIs. But we&#8217;re kind of moving away from building plugin based extensions like we had before, and we&#8217;re moving those more to also third parties.</p>\n\n\n\n<p>For example, the SEOPress extension, that was built completely by the SEOPress team. We did help with any development that they needed, but we didn&#8217;t get our hands too dirty in that. And then we worked with promoting them out. And same with the WPvivid backup people. They made their own extensions using our API and our code base, and they&#8217;re just putting those out themselves.</p>\n\n\n\n<p>We&#8217;re real happy with those. And we actually started doing more to help out those third party .org, I would call them, partnerships that kind of came across naturally. Like the WPvivid, I don&#8217;t believe they had much discussion with us at all. They kind of did the partnership the way we used to, where we launched the product and then sent over an email saying that, hey, we got a extension here, we made for you.</p>\n\n\n\n<p>[00:21:38] <strong>Nathan Wrigley:</strong> So do you wish to reach out and find new audiences? Different plugins and different, well, whatever it may be, different services that are out there. Is that the intention in the next one, two years, to find other partners to work with? Or is it very much case by case basis? We&#8217;ll do one at a time. We&#8217;ll take it nice and easy and slow. Or are you racing to get as many as you can?</p>\n\n\n\n<p>[00:22:00] <strong>Dennis Dornon:</strong> We&#8217;re a small team of only seven people. So we can only do, so many and we have to maintain our own. That&#8217;s what I was saying earlier, we&#8217;re really becoming more API focused when it comes to our internal extensions, because they&#8217;re easier for us to maintain as we&#8217;re crossing over into the 40 extensions that we have ourselves.</p>\n\n\n\n<p>Which is why we&#8217;re having the plugin users, or the plugin extensions are starting to be made by the actual plugin company, because they&#8217;re better at keeping those updated on their own, and it kind of takes a little bit off our plate. And then we&#8217;re able to still help co-market them. We&#8217;ve started adding into our actual plugin to make it easier for you to find these new .org partnerships that are coming around.</p>\n\n\n\n<p>But really what I&#8217;m striving for is, like you said, a platform base, similar to WooCommerce. We actually just kind of got lucky in this, because when we started back in 2015 with that first backup extension, it wasn&#8217;t to get along the path of WooCommerce and try and build a platform. It was, we&#8217;re a small, bootstrap company. I think we only had, uh, three people, or four people at the time. And backups were just killing our support and development time. We couldn&#8217;t come up with, didn&#8217;t have time to do anything new and exciting. We were just stuck on backup, month after month after month.</p>\n\n\n\n<p>And that&#8217;s when we decided start making these backup extensions that work with the plugins that were built by people who knew backups. So, we were able to offload that work to people who actually knew how to do it, just by connecting their plugin with our plugin.</p>\n\n\n\n<p>[00:23:27] <strong>Nathan Wrigley:</strong> It feels like you have a business which is really, really wide open to partnerships. And what I mean by that, and it may be difficult for me to describe. You have essentially a platform. You have an architecture, which means that things can be built right on top, so that they can update their own website.</p>\n\n\n\n<p>So, you could help SEO companies. You could help image compression companies. You could help form companies. They&#8217;re all part of the WordPress website ecosystem. So, there&#8217;ll be a lot of companies out there who maybe are thinking, well, yeah, but we&#8217;ve got this one plugin in it just does this one thing. I can&#8217;t see of a way to be partnering with other people. Have you got any advice to give to those people?</p>\n\n\n\n<p>[00:24:10] <strong>Dennis Dornon:</strong> Looking at it from my point of view, as the potential platform that you would build on. If you have a plugin, say a form plugin, something that can be used in multiple places. So you can have your setting set. If you&#8217;re usually like the same settings all the time, you can do that from a dashboard such as ours. Or if you want to get all your forms returned from one place, so you have 50 sites, but you want to see all the forms in one place. You could think of it like that.</p>\n\n\n\n<p>[00:24:37] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s more that you have a platform which enables you to partner with more or less anybody it feels like in the WordPress space. So that&#8217;s a good bit of serendipity. You&#8217;ve got this system which you&#8217;ve built over years. But a lot of people will be thinking, I can&#8217;t partner with other people, I&#8217;ve got this one plugin, which just does one thing. And it may be that partnerships are out of scope for them, and I guess that is just a reality.</p>\n\n\n\n<p>[00:24:58] <strong>Dennis Dornon:</strong> In that case, you probably would just be stuck with the co-marketing form, and then you would have to find somebody whose market aligns with yours that is willing to actually do a mailing for you. So yeah, that might be a tough one if it&#8217;s just a very basic plugin.</p>\n\n\n\n<p>[00:25:11] <strong>Nathan Wrigley:</strong> Yeah. The other thing about partnerships, I suppose, is that you are very much aligning yourself with a particular company. So let&#8217;s imagine that in the WordPress space there are four companies, company A, B, C, and D, and they basically do the same thing. We can imagine who these companies might be and how they are competitive rivals in the marketplace.</p>\n\n\n\n<p>There&#8217;s something there isn&#8217;t there. And what I mean by that is if you decide to partner with one of those and send out emails and you are lording how fabulous product B is. Do you have any fears that you have then cut yourself off from A, C and D? And that they won&#8217;t wish to speak to you because now, well, you know, it&#8217;s pretty clear from the stuff that they&#8217;re marketing over the last year that they&#8217;ve made their decision and we are not a part of that. Is that something that concerns you?</p>\n\n\n\n<p>[00:26:02] <strong>Dennis Dornon:</strong> I wouldn&#8217;t say. So if we just take a look at our backup extension situation. As I mentioned, WPvivid put out their own. And then of course we have some built in house and one of the ones we built in house actually comes from one of our competitors who also put up a backup solution.</p>\n\n\n\n<p>And we just deploy gratitude. Work with them and do your best. The fact they came to us, a competitor comes to us and asks for help with their promoting their backup extension. That just makes me feel good. I don&#8217;t think of it as a competitive atmosphere in that way.</p>\n\n\n\n<p>Just more of, hey, even though they&#8217;re a competitor, they&#8217;re not a competitor with this particular product, and this product will help our users. So yeah, that sounds like a, sounds like a good partnership to us.</p>\n\n\n\n<p>[00:26:41] <strong>Nathan Wrigley:</strong> Do you have any interesting input? We&#8217;re in the middle of November and this is 2022. This podcast episode will air within several weeks of this being recorded. And so with that caveat in mind, is there anything exciting that you have in the pipeline for MainWP users? It may be that the answer to that is no, Nathan, I don&#8217;t. But it may be that the answer is actually, we&#8217;ve got a couple of interesting things that we&#8217;re working on at the moment.</p>\n\n\n\n<p>[00:27:08] <strong>Dennis Dornon:</strong> We have a few interesting things. Um, I&#8217;m not sure which ones I can really talk about depending on when this comes out, so I&#8217;m going to have to keep pretty quiet on that. But, we got an interesting partnership coming up that I&#8217;m very excited about that should be out hopefully by January as long as everything goes smooth and determined by their marketing schedule. And then we also have some core updates, which are going to be pretty exciting.</p>\n\n\n\n<p>[00:27:32] <strong>Nathan Wrigley:</strong> So this is a product that you&#8217;re working on. You are actively working on it. Is this the only thing that you are doing, or do you, Dennis have other fingers in other WordPress pies?</p>\n\n\n\n<p>[00:27:43] <strong>Dennis Dornon:</strong> I strictly focus on MainWP. I like to stay with what I know. Remember we built this for our own use, and it&#8217;s grown from there. This is really kind of my baby. I&#8217;ve looked at other things, but just nothing&#8217;s ever really, you know, really caught my eye. When I wake up in the morning this is, I want to see how we can make MainWP better. I want to see what&#8217;s going on? I still check almost every support ticket, so I have a finger on the pulse of what&#8217;s happening. I may not be the one replying, but I&#8217;m still reviewing almost every support ticket, every forum post every Facebook post, just to really keep my finger on what&#8217;s happening in MainWP. And I figure if I, if I&#8217;m doing three or four other plugins, nothing&#8217;s going to be focused on for the end user.</p>\n\n\n\n<p>[00:28:29] <strong>Nathan Wrigley:</strong> It sounds from what you&#8217;ve said, and I could be misrepresenting this, it sounds like when you began, you were very much walking in the dark. You didn&#8217;t really know how the plugin would develop, how the business would develop. And it feels like you&#8217;ve really found your feet in the last few years, you&#8217;ve had some success.</p>\n\n\n\n<p>Obviously the plugin is selling to the point where you can swell the team to seven as opposed to whatever it was, one, two, or three in the olden days. And it&#8217;s a general question, but I, I do like these questions, the warm and fuzzy question. Are you still happy in the WordPress space. Is this a community that you enjoy being a part of? Are you still enjoying doing the work that you do?</p>\n\n\n\n<p>[00:29:07] <strong>Dennis Dornon:</strong> I would say I enjoy it more now than I did before. I am a private person. So I don&#8217;t like talking. I don&#8217;t like doing podcasts that much, or videos. But I&#8217;m trying to get better at it. And as I&#8217;m doing it, actually enjoying being in the WordPress community more and more. Just being out there instead of, we&#8217;re going on nine years in February, so for eight years, I basically hid behind this computer screen and didn&#8217;t talk to anybody except through email and chat, to actually be out talking to people and, interacting with people in a more personable way has really just made it much more fun for me than it was even in the beginning. And it just grows every day. I wake up wanting to come in. I go to bed wanting to come in. It doesn&#8217;t feel like work any day that I&#8217;m here.</p>\n\n\n\n<p>[00:29:53] <strong>Nathan Wrigley:</strong> Has WordPress itself changed in any way, which has affected your business strategy? Because a lot of companies, you know, if you&#8217;re a theme company at the moment, there must be a lot of introspection. Okay, where&#8217;s WordPress going with all of this? If you were a plugin which is now being overlapped by blocks, that must be an awful lot of anxiety about, okay, where do we need to go with this? We&#8217;re not quite sure how this is going to all settle down.</p>\n\n\n\n<p>It feels like your business inside of WordPress was really insulated from the changes that we&#8217;ve had since WordPress, well let&#8217;s say WordPress five with Gutenberg and everything. Or has there been a lot that you&#8217;ve had to refactor in the background to continue to make it working?</p>\n\n\n\n<p>[00:30:29] <strong>Dennis Dornon:</strong> We&#8217;ve definitely made a shift from where we originally were. If you look at MainWP, in the beginning we were really affiliate focused. I mean, that&#8217;s what we came from. Everything was set for affiliates and to grow affiliates and to make sure, you know, you could be a profitable affiliate. As years have gone by, I would say now we&#8217;re much more agency or creator focused than we are affiliate focused.</p>\n\n\n\n<p>Not that affiliates can&#8217;t find a way to use MainWP. It&#8217;s still going to work great for them, but it&#8217;s not our focus. As you see new extensions come out, they&#8217;re not something doing like a spinner syntax or something like you might have done 9, 10 years ago. Now it&#8217;s focused on different APIs, Atarim, SEOPress, things like that.</p>\n\n\n\n<p>[00:31:08] <strong>Nathan Wrigley:</strong> So, Dennis, you are sticking around in the WordPress space. If we come back in five or six or seven years time, we fully expect to have MainWP still available for us?</p>\n\n\n\n<p>[00:31:19] <strong>Dennis Dornon:</strong> Yeah. And that, that&#8217;s one of the, the great things too about being open source. I&#8217;ve said this from the beginning. If something happens to us, you still have everything. If MainWP as a company goes away, you still have MainWP. Your service is still going to work. It&#8217;s a plugin that doesn&#8217;t need MainWP the website to keep going.</p>\n\n\n\n<p>It&#8217;s going to keep going for you. So you don&#8217;t have to worry about us disappearing because the code is live, out there, anybody can pick it up if something did happen and we disappeared. Which of course, I hope we don&#8217;t, but it&#8217;s there available to people.</p>\n\n\n\n<p>[00:31:51] <strong>Nathan Wrigley:</strong> Is there a sweet spot that you feel, MainWP is now worth it? And what I mean by that is, obviously if you have one WordPress website, I can imagine the argument for getting into the MainWP platform is probably not that strong. You know, it&#8217;s fairly easy to log into your website and do all of the things that you need to do. But once you&#8217;ve got two or three, or four, or five or fifty or a hundred, the numbers begin to swell.</p>\n\n\n\n<p>And I just wonder if you had any thoughts on that. You&#8217;ve obviously got a target market. I know that you don&#8217;t gather much data about them, so maybe you don&#8217;t have a great deal to say in terms of the metrics there.</p>\n\n\n\n<p>[00:32:27] <strong>Dennis Dornon:</strong> it&#8217;s hard to say on who has what. I know we have different users. I would say probably four or five is where it starts to get a little time consuming, and at least the free core, which gives you most of what you&#8217;re going to need for that level would be a great place to start. Our average user based on the.org statistics, show that we average about 60 child sites per dashboards. So, dot org is saying we have 10,000 active dashboards out there with 600,000 active child sites. So I would say the jumping endpoint should be much closer to five than 60, but the average user has 60.</p>\n\n\n\n<p>[00:33:02] <strong>Nathan Wrigley:</strong> Always surprises me how there&#8217;s a tool for just about everything in the WordPress space, and much of it is open source. There&#8217;s a lot of SaaS platforms which do what you do, but it is nice to have an option that you can put on your own dedicated website.</p>\n\n\n\n<p>Do give us a little bit of intel, because I imagine quite a few people in the audience are interested in the privacy part. You spoke to me just before we hit record about the lack of data that you can bring to bear. And on the one hand, that might be frustrating for you, but on the other hand, it might be incredibly nice for listeners to the podcast to know how much data you collect, or quite the opposite, how much data you don&#8217;t collect.</p>\n\n\n\n<p>[00:33:40] <strong>Dennis Dornon:</strong> We really don&#8217;t collect anything. If you look on MainWP.com, if I can send people there, and you&#8217;ll notice at very top of the page we&#8217;re one of the only plugins that I know of that has their own private plugin policy. And that was actually a written by Donata Stroink-Skillrud of Agency Attorneys. And that&#8217;s a privacy policy for your plugins telling you exactly what information we&#8217;re gathering or in our case not gathering. We really don&#8217;t record anything of any personal nature.</p>\n\n\n\n<p>[00:34:10] <strong>Nathan Wrigley:</strong> And in terms of the support that you offer, a platform like this will become quickly part of the backbone of your business. You know, it may be that you log in once a day and update sites and you want to know that that&#8217;s possible and you want to know that should there be any problems, you can reach out to MainWP and get those problems fixed quickly. How do you handle support? Is it email? Have you got chats? Are you 24 7? Are you throughout the globe? How does that work?</p>\n\n\n\n<p>[00:34:36] <strong>Dennis Dornon:</strong> We have multiple people throughout the globe. We&#8217;re not 24 7. We are basically eastern standard time, 7:00 AM to about 4:00 PM. We have support both in a support forum at managers dot MainWP, and people can send in tickets. One of the things I&#8217;m proud of, we don&#8217;t charge for support. So if you&#8217;re a free user, or a pro-level user, we&#8217;re providing the same support for both levels.</p>\n\n\n\n<p>So nobody&#8217;s ostracized to just forum support or just this or just that. Somebody can send in a ticket or they can go to the forum or they can post on wordpress.org. We&#8217;re going to answer you however we can in any way we can. And support has been very strong from the beginning for us. We want to make sure everybody can get the answers that they need when they need it. Always keeping an updated knowledge base for users so they don&#8217;t have to ask because you know, who really wants to put in a ticket when you can just look at the knowledge base to find the answer. So we try and keep that as up to date as possible.</p>\n\n\n\n<p>[00:35:31] <strong>Nathan Wrigley:</strong> You mentioned before that you are just getting into the idea of making public appearances, so podcasts and videos that you&#8217;re making and so on. So this question may fall on deaf ears for you. But ,do you encourage people to reach out to you? Do you have any social platforms? Do you have an email address that you&#8217;d like to share? The answer to that can be no. But, uh, if do and you do like chatting to people on email and giving them into some intel into what it is that you&#8217;ve been working on, will be working on, you could share that now.</p>\n\n\n\n<p>[00:36:01] <strong>Dennis Dornon:</strong> Really, if you want to reach out to me, just go to dennisdornon.com. That&#8217;s my full name dot com. And it has a calendar on there. And I, I just put this site really updated last month with a calendar on there. Just got my calendly. Started have to actually uh, mark things on a calendar because they&#8217;re happening so fast lately.</p>\n\n\n\n<p>You can hop in over there and I&#8217;ll be glad to chat over Zoom with whoever wants to chat with over Zoom. Going to actually try and start to do a little more AMAs. It sounds like people in the community want to do that too. So you&#8217;ll have chances to reach out to me live on different ask me anything type videos.</p>\n\n\n\n<p>[00:36:31] <strong>Nathan Wrigley:</strong> Dennis Dornon and thank you for chatting to me on the podcast today. I really appreciate it.</p>\n\n\n\n<p>[00:36:36] <strong>Dennis Dornon:</strong> Glad to be here. Thank you very much.</p>\n</div>\n\n\n\n<p>On the podcast today, we have <a href=\"https://twitter.com/dennisdornon\">Dennis Dornon</a>.</p>\n\n\n\n<p>Dennis is the founder of <a href=\"https://mainwp.com/\">MainWP.</a> A WordPress plugin which enables you to manage multiple WordPress websites from a single dashboard. As you&#8217;ll hear, the business has changed over the years, as Dennis has learned more about the plugins&#8217; target audience.</p>\n\n\n\n<p>If you&#8217;re a solo developer, or a working for a small team, bringing your WordPress product into the market can be very rewarding, but it can also be hard. Given the scale of the market, it&#8217;s likely that your product has got an audience, but with the time and resources being limited, it might be hard to break through and be widely discovered.</p>\n\n\n\n<p>Dennis talks today about how, in the recent past, he&#8217;s been trying out working with partners as an effective way to increase the plugins reach. As you&#8217;ll hear, it&#8217;s a strategy that he&#8217;s enamored with, given the right partner.</p>\n\n\n\n<p>We start off by talking about why Dennis built MainWP, and who the plugin was originally aimed at. And it&#8217;s not what you might expect.</p>\n\n\n\n<p>We then get into how Dennis is working out his partnerships as he goes. What is it he&#8217;s looking for in a partner? Not all companies in the WordPress space are going to be a good fit. And so he explains how it&#8217;s important that all partners have some skin in the game, and know what part of the deal they have to uphold. What are the things that need to be considered before the partnership begins? And how do you make sure that all the parties are keeping up their end of the bargain?</p>\n\n\n\n<p>It turns out that MainWP is a business which is in just about the perfect spot for bringing on partners. But if you&#8217;re a developer and have not considered this type of approach with your business, this podcast is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links.</h2>\n\n\n\n<p><a href=\"https://mainwp.com/\">MainWP website</a></p>\n\n\n\n<p><a href=\"https://jonathanwold.com/partnerships-in-portugal/\">Partnerships in Portugal</a> by Jonathan Wold</p>\n\n\n\n<p><a href=\"https://mainwp.com/seopress-partnership/\">Introducing “SEOPress for MainWP” Extension</a></p>\n\n\n\n<p><a href=\"https://mainwp.com/atarim-partnership/\">Introducing Atarim Inside MainWP &amp; Vice Versa</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Dec 2022 15:20:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Do The Woo Community: Acquisitions Are Not a Goal of Building a Product\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=73869\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://dothewoo.io/acquisitions-not-a-goal-of-building-a-product/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:414:\"<p>There are paths to choose from and other considerations when preparing your WooCommerce product business for acquisition. </p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/acquisitions-not-a-goal-of-building-a-product/\">Acquisitions Are Not a Goal of Building a Product</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Dec 2022 12:30:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"Do The Woo Community: Building an Agency Team and Culture for Success with Marius Vetrici\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=74026\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/building-an-agency-team-and-culture-for-success/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:431:\"<p>Marius Vetrici from WPRiders shares his insights into running an agency and building a WooCommerce subscription plugin.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/building-an-agency-team-and-culture-for-success/\">Building an Agency Team and Culture for Success with Marius Vetrici</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Dec 2022 10:49:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Mailchimp for WordPress Plugin for Sale in the Ballpark of €1.6M\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=140295\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/mailchimp-for-wordpress-plugin-for-sale-in-the-ballpark-of-e1-6m\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3896:\"<p><a href=\"https://www.dannyvankooten.com/\">Danny van Kooten</a>, creator of the <a href=\"https://wordpress.org/plugins/mailchimp-for-wp/\">Mailchimp for WordPress</a> plugin, has indicated that he is interested in selling his plugin for somewhere in the ballpark of €1.6M. It is the most popular Mailchimp solution for WordPress, although it is &#8220;unofficial&#8221; in that it is not developed by or affiliated with Mailchimp in any way. It has more than 2 million active installs and has been downloaded more than 42 million times.</p>\n\n\n\n<p>In a <a href=\"https://news.ycombinator.com/item?id=33931627\">comment</a> on a popular Hacker News post that asks, &#8220;<a href=\"https://news.ycombinator.com/item?id=33923137\">What is the best income stream you have created till date?</a>&#8221; van Kooten dropped the hint that he is willing to sell the nearly ten-year-old plugin: </p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>It’s definitely not my passion but in 2013 I built a WordPress plugin around the API of a popular newsletter service and it’s been paying my bills ever since.</p>\n\n\n\n<p>Still going strong at €36K per month excluding VAT.</p>\n\n\n\n<p>There was (and still is) a huge market where non-technical people are looking for a GUI around something a programmer would find very simple (and usually too boring to work on). More so if the tech surrounding it is not particularly sexy, as is the case for WordPress and PHP.</p>\n\n\n\n<p>Ps. In case anyone is reading this, I am open to selling. I spent about 4 hours a week on it and the rest is handled by 2 freelance people costing about €1K / month each. Contact me for details if interested and willing to pay in the ballpark of €1.6M.</p>\n</blockquote>\n\n\n\n<p>van Kooten developed Mailchimp for WordPress when he was hospitalized in Vietnam due to acute appendicitis with extra time on his hands during his recovery. He identifies himself as an &#8220;accidental entrepreneur&#8221; in his Hacker News bio. In 2021, he was <a href=\"https://www.wired.com/story/sustainable-software-design-climate-change/\">featured in Wired</a> for his efforts in reducing his carbon output as a plugin developer. He refactored the plugin to send 20kb less data, and, due to its large user base, he estimates these changes reduced  the world&#8217;s monthly CO<sub>2</sub> output by 59,000 kilograms, which Wired estimated is &#8220;roughly the equivalent to flying from New York to Amsterdam and back 85 times.&#8221;</p>\n\n\n\n<p>Mailchimp for WordPress has commercial upgrades ranging from $59 &#8211;  $149 per year, and 1% of the plugin&#8217;s revenue goes towards environmental projects.</p>\n\n\n\n<p>Although Mailchimp recommends WordPress.com&#8217;s &#8220;<a href=\"https://mailchimp.com/integrations/wordpress/\">Mailchimp block</a>&#8221; as the official WordPress integration (also available in Jetpack 7.1+), van Kooten&#8217;s plugin is far more flexible. Mailchimp for WordPress integrates with other popular plugins like WooCommerce, Contact Form 7, Gravity Forms, Ninja Forms 3, BuddyPress, MemberPress, and Events Manager, allowing visitors to subscribe via the checkout or comments form.</p>\n\n\n\n<p>Several commenters on van Kooten&#8217;s Hacker News response indicated interest in his offer for sale. His comment offers a a rare, transparent look into a popular plugin&#8217;s revenue and potential sale price, as most companies that acquire WordPress plugins are almost never willing to reveal how much they paid for them. As Substack moves to <a href=\"https://twitter.com/cjgbest/status/1602370307884318720\">add compatibility for Ghost themes</a> and other third-parties, and newsletters become even more critical with people leaving Twitter, it will be interesting to see more movement in the newsletter support space. van Kooten may be setting out at just the right time to find a buyer for Mailchimp for WordPress.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Dec 2022 04:30:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"WPTavern: Gutenberg 14.7 Introduces Color Coding for Template Parts and Reusable Blocks, Adds Media Tab to Inserter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=140270\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://wptavern.com/gutenberg-14-7-introduces-color-coding-for-template-parts-and-reusable-blocks-adds-media-tab-to-inserter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2734:\"<p>Sometimes Gutenberg introduces features that you never knew you needed. Such is the case with the new color coding system in the Site Editor. The latest <a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/\">14.7 release</a> adds color to template parts and reusable blocks in the list view, block toolbar, and block selection outlines. The colorization is intended to help users differentiate between the different block types as they edit their designs.</p>\n\n\n\nvideo source: <a href=\"https://github.com/WordPress/gutenberg/issues/32163\">Gutenberg PR #32163</a>\n\n\n\n<p>Another UI enhancement in version 14.7 is a new, experimental split control for block settings. It splits the block inspector sidebar to separate the settings controls from the appearance controls, giving the appearance side the same half-moon icon used for styles in the Site Editor. The intention is to make it easier to manage blocks with many controls, such as Group or Navigation blocks, that would end up having the settings scrolling down the page. </p>\n\n\n\n<img />image source: <a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/\">Gutenberg 14.7 release post</a>\n\n\n\n<p>The split control enhancement isn&#8217;t set in stone yet, as it must be enabled as an experimental feature in the Gutenberg > Experiments admin menu. It seems helpful but could prove to be more confusing for users, so further testing is needed before it moves out of experiments. </p>\n\n\n\n<img />\n\n\n\n<p>The inserter is getting a major change in 14.7 with the addition of a Media tab, making it faster to add images, video, and audio. Users can select the new tab and select a media type to see the ten most recent items. There&#8217;s also an &#8220;Open Media Library&#8221; button at the bottom of the panel.</p>\n\n\n\n<img />\n\n\n\n<p>Other notable updates in 14.7 include the following: </p>\n\n\n\n<ul>\n<li>Page List block can now expand inside the List View to see the hierarchy of pages (<a href=\"https://github.com/WordPress/gutenberg/pull/45776\">45776</a>)</li>\n\n\n\n<li>Layout controls added to children of flex layout blocks (width for row and height for stack are now available for child Row and Stack blocks) (<a href=\"https://github.com/WordPress/gutenberg/pull/45364\">45364</a>)</li>\n\n\n\n<li>Significant load time performance improvements from caching the results of querying settings from theme.json. (<a href=\"https://github.com/WordPress/gutenberg/pull/45372\">45372</a>)</li>\n</ul>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/\">changelog</a> to get a more detailed look at the dozens of improvements and bug fixes included in 14.7.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Dec 2022 03:17:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Gutenberg Times: Gutenberg Changelog #77 – Gutenberg 14.7, what’s new for Block Themes, an upcoming Live Q&amp;A in January\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=22971\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-77-gutenberg-14-7-whats-new-for-block-themes-an-upcoming-live-qa-in-january/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:45870:\"<p>Daisy Olsen and Birgit Pauli-Haack discuss Gutenberg 14.7, what’s new for Block Themes, an upcoming Live Q&amp;A in January and much more.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#transcript\">Transcript</a></p>\n\n\n\n<ul>\n<li>Music:&nbsp;<a href=\"https://soundcloud.com/xirclebox\">Homer Gaines</a></li>\n\n\n\n<li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h3>Announcements</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/support/2022/12/introducing-the-block-editor-in-the-support-forums/\">Introducing the Block Editor in the Support Forums</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2022/12/07/leveraging-theme-json-and-per-block-styles-for-more-performant-themes/\">Leveraging theme.json and per-block styles for more performant themes</a> by Justin Tadlock</li>\n\n\n\n<li><a href=\"https://wordpress.org/themes/oaknut/\">Oaknut</a> by Anders Noren</li>\n\n\n\n<li><a href=\"https://wptavern.com/anders-noren-releases-oaknut-a-new-profile-block-theme-with-23-style-variations\">Anders Norén Releases Oaknut, a New Profile Block Theme with 23 Style Variations</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2022/11/29/a-php-developers-guide-to-getting-started-with-block-development/\">A PHP developer’s guide to getting started with block development</a> by Michael Burridge</li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/course/a-developers-guide-to-block-themes-part-1/\">Developers Guide to Block Themes (Part 1)</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/course/a-developers-guide-to-block-themes-part-2/\">Developers Guide to Block Themes (Part 2)</a></li>\n</ul>\n\n\n\n<h3>Community Contributions</h3>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/plugins/lang-attribute/\">Lang Attribute for the Block Editor</a>  </li>\n\n\n\n<li><a href=\"https://wordpress.org/plugins/abbreviation-button-for-the-block-editor/\">Abbreviation Button for the Block Editor</a></li>\n</ul>\n\n\n\n<h3>What&#8217;s released</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/\">What’s new in Gutenberg 14.7? (7 December)</a></li>\n\n\n\n<li><a href=\"https://wordpress.github.io/gutenberg/?path=/docs/docs-introduction--page\">Storybook</a></li>\n</ul>\n\n\n\n<h3>What&#8217;s worked on</h3>\n\n\n\n<ul>\n<li><a href=\"https://github.com/wordpress/gutenberg/issues/45371\">Global Styles: Allow saving, importing, exporting, copying from another theme without switching to it</a></li>\n\n\n\n<li><a href=\"https://github.com/wordpress/gutenberg/issues/29577\">FSE: Create more robust autosaving including UI&nbsp;</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/design/2022/12/05/design-share-nov-21-dec-2/\">Design Share: Nov 21–Dec 2</a></li>\n</ul>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<ul>\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on Twitter or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcrip</strong>t</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Hello </p>\n\n\n\n<p>and welcome to our 77th episode of the Gutenberg Changelog Podcast. In today&#8217;s episode, we will talk about Gutenberg 14.7, what&#8217;s next for Block Themes and an upcoming Live Q&amp;A in January and so much more. My name is Birgit Pauli-Haack, curator at the Gutenberg Times and WordPress developer advocate and core contributor on the WordPress Open-Source Project. Today we are recording the last show of 2022, and we are all in for a special treat. I&#8217;m thrilled to welcome Daisy Olsen to the show, a master educator on Block Themes, fellow developer advocate, and first-time release lead of the latest Gutenberg plugin release 14.7. Good morning, Daisy. Thank you for making the time and join me on the show. How are you?</p>\n\n\n\n<p><em>Daisy Olsen</em>: I&#8217;m doing really well. Thanks so much for having me today.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: You&#8217;re so welcome. It&#8217;s a special pleasure for me. So, for the last year, you have been working on various educational material around the Block Themes. Your workshop at Word Camp Europe was standing room only. And then you gave an updated version three months later on Word Camp US. You also worked with a training team on online workshops. If someone knows about Block Theme, it&#8217;s you. So, what are some of the most asked questions you hear from participants about Block Themes, or what are they&#8217;re most struggling with when building Block Themes?</p>\n\n\n\n<p><em>Daisy Olsen</em>: So, I think that people come from a lot of different places in their development career or path. I&#8217;m not sure if I have any specific most asked questions at the top of my mind. But I do think that the move to more low-code or even no-code options for creating themes is a paradigm shift and it&#8217;s going to take some time for everyone to get used to it. Given how quickly the number of block themes has increased, I heard like 250 or more potentially in the theme directory there&#8217;s certainly some energy building. I would say that one thing that I&#8217;ve heard in general is that there&#8217;s sometimes some worry around how existing theme functionality will work as we move towards a block theme first ideal. And the short answer is that the old waste will still work. We&#8217;re not replacing the PHP-based theme engine. We&#8217;re expanding on it and making it much easier for developers, and users alike to participate in the theme creation process. But change can be hard, and this is a process that will happen over time.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, thank you for that. What I see that it&#8217;s also what the last bit, that it&#8217;s actually not a replacement, it&#8217;s actually an expansion of the existing theme hierarchy framework is a little hard to hear overall. This is the new things doing things what happens with the old and I think that&#8217;s part of the problem that we have, and we are all working on it. And I know that Matias also said that, there&#8217;s nothing&#8217;s going to go away or get obsolete. It&#8217;s just that the user no code, creating a theme with the site editor is actually kind of expanding the user base of it and not shrinking it. And if the pie gets bigger, I think we all really profit from that.</p>\n\n\n\n<p><em>Daisy Olsen</em>: I would just add that as we think about the way that WordPress themes are created as an expansion. It will open up the opportunity for people to come in with a different skill set that maybe would not have been able to create theming in the WordPress, they mentioned the way that it has existed. And one of my very favorite things about WordPress theming is that you can take a theme created for version 1.2 and install it today and it&#8217;ll still work. You can&#8217;t go the other direction because new features have been at a new functionality. But you can take something as old as so many years ago and still basically use it today. I don&#8217;t know that anybody is going to do that necessarily. But the fact that backwards compatibility is such a big part of the culture of WordPress is a huge comfort if you&#8217;re thinking about the future.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Totally and that&#8217;s also what made WordPress so big is almost a 20-year backwards compatibility. And I&#8217;m really amazed, and every release party that I participate on beta releases or release candidate releases when we upgrade 4.0 something themes to the new theme, the upgrade is just seamless. Everybody who worked on the core releases has made sure that older versions upgrade to the new versions and the same happens with the classic themes that the workers will always work for classic themes. It&#8217;s not, sometimes things change, but it&#8217;s also, there&#8217;s a lot of effort also in the developer. Good work developer could not develop, a community where the effort is to make part of the block theme features available for classic themes. An example was that all the block-based template parts that can be used for classic themes, and they had that came with 6.1. Do you have seen a lot of adoption of those or what people are doing with them?</p>\n\n\n\n<p><em>Daisy Olsen</em>: We have more to do to encourage people to adopt those gradual adoption pathways, but the fact that they exist is really a great thing that we&#8217;re not expecting. The project is not expecting people to go in headfirst and change everything that they know and all of their workflows and everything. But there are ways that you can take legacy code because the truth is that not every client is going to be ready for a full redesign and some never are. But the pathways that we have to take legacy code and expand it to adopt some of these new features is really powerful.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It&#8217;s not a really good business case to make to say, &#8220;Okay, now I start using the new thing for new client project.&#8221; Unless when you have a tested and proven workflow to get new clients online very easily for the last six or seven years, you are not going to change your workflow as the same available or agency freelancer to change that from today, from tomorrow. So, it definitely takes some time to adjust to that. We have seen this with other new features in WordPress they take about two to three years. All right. But I digress or we digress a little bit, but I think we always kind of need to talk out about a few things.&nbsp;</p>\n\n\n\n<h3><strong>Announcements</strong></h3>\n\n\n\n<p>But we are ready for our announcements. And as I mentioned in the intro, we have a great good work time live Q&amp;A planned. It&#8217;s in preparation for working with Asia. The title is layouts, layouts, layouts, and Layouts of fundamental part of how Block Themes work. And it allows you to define the width of your post content, arrange the blocks horizontally, as well as vertically. And left or right aligned and inside container blocks. And in terms of block styling, layout is a complex feature because it affects not only the container but also the child blocks in ways that go beyond the cascading style sheets inheritance.</p>\n\n\n\n<p>In the show, we will have Isabel Bryson, Andrew Serong, Justin Tadlock, and we will discuss the opportunities and challenges for this layout feature and for site builders. Both or all three of them, and I&#8217;m two but only minimally available for your questions to answer them. And Isabel Bryson will also give us a little demo of the various layout scenarios, which is kind of flex and fluid and constrained. And there&#8217;s certainly some more development being done in the few, in the couple of weeks that are until we have that, it&#8217;s going to happen on January 11 at 5:00 p.m. Eastern. That&#8217;s 10:00 UTC, 2200 UTC. And it&#8217;s a little bit of a different timeframe than other because Isabel and Andrew are in Australia. So, we have a little Pacific, an Asia Pacific kind of timeframe there. And Isabel is also a speaker at Word Camp Asia, so it&#8217;s going to be a great show.&nbsp;</p>\n\n\n\n<p><em>Daisy Olsen</em>: All right. Sounds great. Another thing that has come up recently is that the WordPress support forums are now including, rather than the WYSIWYG formatter or text format block. We have the embedded block editor. So, we&#8217;re going to see the ability to add blocks and support forms. So, it&#8217;s going to be interesting to see how that is received for by the user base and if it helps to move the support questions forward in a way. But anytime we see the Gutenberg project, the block editor as we know it outside of WordPress. Outside of the WordPress administrative area, it&#8217;s really neat because it shows how the power of this contained thing that can be dropped into another environment and used in a different way, so&#8230;</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: We have in the show notes where we have the post from Alvaro Gameiro, I&#8217;m just checking the name, Alvaro Gomez. I had all letters write, and right now it&#8217;s in testing, but it won&#8217;t be in testing for long, so if you follow the post, there&#8217;s also a link for the test site, so you can try it out and see how you feel about it and also share your feedback on the make blog support post in the comments. We also have new posts on the new developer block. So, for five years I have now the trouble that is block and blog with the pronunciation so that the new developer blog is two new articles: One is Leveraging theme.json and the Per-Block Styles for More Performance Themes by Justin Tadlock.</p>\n\n\n\n<p>And he outlines how using the theme.json two style, all your elements, the blocks, the individual blocks, as well as some of the elements centrally through the theme.Json file saves you quite a bit on CSS file length. And also code I&#8217;m a fan of Anders Noren themes and he has done some great work on the block themes and he just released his theme Oaknut, which gives you a kind of link tree way to create your page and has, he says a really small CSS file, and it comes in less than 150 lines and 120 of those are lines for the custom block styles that he includes in the theme.</p>\n\n\n\n<p>So, he does not style the main thing and all the other styles that come with WordPress theme classic theme. So, I think that&#8217;s also another reason to maybe use the theme.json funnel for classic themes, which is possible. Any comments on that, Daisy?</p>\n\n\n\n<p><em>Daisy Olsen</em>: Just that it&#8217;s exciting to see that our CSS starts to get smaller and by moving things into theme.json we are paving the pathway to make more performant sites because we&#8217;ll be able to build up more tooling to only use the CSS in line when we need it. And that hasn&#8217;t always been the case. So, trying to keep things small and concise where possible is going to take things a long way. So, I think we&#8217;ll see a lot more improvement. And it&#8217;s great to see people trying to push the boundaries of small, can you make your custom CSS and still get a really beautiful design out there? That can be distributed out to a lot of people. Anders puts his themes out to the community through the theme directory quite often, and I think that he&#8217;s right on the front edge of where things will be in a couple of years.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And as Anders also opened up his GitHub repost for the theme, so you can actually learn from his coding and kind of inspect them a little bit closer if you want to. So, the second post on the developer blog is a PHP developer&#8217;s guide to getting started with Block Development by Michael Burridge, and he practically gives you a roadmap of what you need to learn or what you need as tooling and also some shortcuts and tips. If you are new to modern JavaScript development, it&#8217;s all in one place so you don&#8217;t have to chase other sources. You might need to read up a few things, but also have some great links for you to study more.</p>\n\n\n\n<p><em>Daisy Olsen</em>: I love the approach of moving into trying to help PHP developers because so many of us are coming from that side of things as WordPress-focused developers. And sometimes the JavaScript is especially modern. JavaScript is, it&#8217;s kind of daunting.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: If you start researching yourself if you don&#8217;t know where to focus. So having a curated guide is really valuable and cuts down a lot of the time that you would need to do your own research. Still and he says it in his post as well. There are some hurdles or learning curves to overcome, especially with react. But there&#8217;s also some great abstraction in Gutenberg that you can get quite a long way adopting the blocks without actually touching JavaScript. What comes to mind is block styles, block patterns with new locking features. I can see that a few agencies might say, &#8220;Okay, we are not creating new blocks because now with the block patterns.&#8221; We can style them and we can lock them down for our users to use, and we don&#8217;t have to create new JavaScript for that. That&#8217;s also a great approach is to kind of think about when do I actually have to start developing for my own custom blocks.</p>\n\n\n\n<p>A while ago, must have been maybe a year and a half ago, Victor Ramirez and I, we had a little live Q&amp;A on that approach to kind of see what an agency approach could be in a gradual adopting, here&#8217;s the word again, gradual adopting the new things. When do you really need a developer where designers and content creators actually can go a long way. So, I&#8217;ll put the link to that video and all the resources there into the show notes, so you can look up about it as well. So, the training team published two-part courses talking about block themes. It&#8217;s the developers Guide to block themes, part one and part two. So that is definitely a great resource if you want to go from Zero to Hero and get all the latest features in there. And of course, the links are in the show notes developer&#8217;s guide to. But they&#8217;re all published on learn.wordpress.org. That&#8217;s a fabulous site. And I know that some of your events that you did on online education Daisy are also available through the site.</p>\n\n\n\n<p><em>Daisy Olsen</em>: I have some workshops published there, and also, I will occasionally run online workshops through the Learn WordPress Meetup group, which is also part of the training team&#8217;s efforts.</p>\n\n\n\n<h3><strong>Community Contributions</strong></h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Awesome. Awesome. All right. We&#8217;re coming to Community Contributions and then we are for the release. I just wanted to give a shout-out to Jean-Baptist Audras address from the Whodunit Agency and is also outgoing team rep of the WordPress court team. And he tweeted that his agency released two new plug-ins mini micro plugins with creating accessible content. One is called Lang Attribute for the Block Editor. When you change in your writing the language that you can add a Lang attribute to your paragraph tag or whatever block that is, which makes you then also compact or compliant with accessibility standards for language of parts.&nbsp;</p>\n\n\n\n<p>And then, the second plugin is the abbreviation button for the block editor. Which helps you provide definitions for abbreviations using the tag the HTML tag, &lt;abbr&gt; element. And it&#8217;s quite neat because then you get a little, if there is an abbreviation, you get a little on the front end, a little squiggly line or something like that where you can point to it with your mouse and then get the long content for the abbreviation, which is actually quite neat.</p>\n\n\n\n<p>He also tweeted that worth noting that indicating language changes in content is mandatory for the WCAG or CWE compliance. And there is currently no way to do this in the block editor except for adding the code manually, editing the code manually. And this features, he says, continues this feature should be implemented natively into Gutenberg. And I just did a little digging and there has been an open issue and it&#8217;s actually goes back to the accessibility audit and there has been some movement, but not we need some developer to kind of get it on it and fix it or put it into a core. All right.</p>\n\n\n\n<h3><strong>What’s Released &#8211; Gutenberg 14.7</strong></h3>\n\n\n\n<p><em>Daisy Olsen</em>: So, let&#8217;s move on to the Changelog for Gutenberg 14.7. Gutenberg 14.7 was released this week with 165 merch PRs by 48 contributors, nine of which were first timers. And it&#8217;s packed with quite a few features, some of which are pretty experimental. And you would need to enable them through the experiment settings. And namely, that is a tabbed sidebar that splits out your block control settings between appearance, tools, styles, and other settings. Hopefully the hope there is to make it a little easier to navigate big improvements to the navigation block media selection from the inserter and more controls for the inner blocks of flex layout blocks. Other core blocks receive some small refinements that make the overall experience more consistent. There are also 19 bug fixes for accessibility improvements and quite a few documentation and code quality updates.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And congratulations, Daisy, for your first Gutenberg plug-in release. How was that experience?</p>\n\n\n\n<p><em>Daisy Olsen</em>: It was exciting and I learned a lot about how the release post comes together quite a bit that goes into it and I hope that I have another opportunity to go through this process again.&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I found it when I did. So, mine was actually 13.7 yours were 14.7 so it&#8217;s kind of a bookend kind of there. And I really learned quite a bit how the whole thing comes together and about PRs and about all the processes that there are quite a few automations happening and how to handle between release candidate and stable, how to handle updates that need to get into the release. Everybody who wants to be should start reading about the release process and see if you want to volunteer for that. That definitely needs some technology background on that. That&#8217;s not something for a fly-by contributor of course, but you get help from others.&nbsp;</p>\n\n\n\n<h3><strong>Enhancements</strong></h3>\n\n\n\n<p>All right let&#8217;s dive into the changelog as mentioned, the block library, some standard core blocks got some refinements. The first one is that the heading block now has a class name of WP/block/heading, which means that you can target any heading with your CSS, and now that that&#8217;s in place. And it&#8217;s kind of a prototype of getting other blocks, also having a specific class name so you can target again, that was some in and out from the team that it was in there at the beginning and then they were moved around a bit and now they&#8217;re coming back.&nbsp;</p>\n\n\n\n<p>I see how that&#8217;s kind of going to work out the navigation block, I think we&#8217;re going to talk about the navigation a little later in quite some detail because it has a revamp and it&#8217;s in the experiment. We&#8217;re going to talk about that a little later. The template part block has now you now see in the site editor the colorized template parts, what is ahead of, or what&#8217;s a reusable block when you go down the list view on the left-hand side, you see some color coding there. Your eyes and your brain can better disseminate the different pieces of your page.</p>\n\n\n\n<p><em>Daisy Olsen</em>: I really like that. I find visual cues to be very helpful. Things like if I were on a staging site, I might change the theme on it to be some obnoxious color on the admin side. I know that I&#8217;m in staging, but this is a small improvement just to give you a visual cue of what is a bigger piece of your list view rather than the individual blocks that are within the content.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And your reusable block, I don&#8217;t know if you said it, but the reusable blocks also have this colorized outline. The page list block hasn&#8217;t been touched for a while, but it gets on refinements that it actually expands in the list view, and you can change the starting page. If you are on a page that&#8217;s kind of the beginning of a set of other pages here, like a hierarchy, you can add links to the subpages in the page list block that you can add to the side of your page. So, you can outline the subpages as well. That was still missing. It was available in the other editor, in the menus, but the list block now has that, too. And the table block now, there are a lot of things that can be done to improve the table block. But now, it supports the colspan attribute so you can merge cells from the same column into one place in the table HTML and you have some listed tables if you want to. But that was definitely important when you copy-paste tables from another page or another text editor into the block editor that you keep the colspan attribute aligned so the columns and rows align correctly.</p>\n\n\n\n<p><em>Daisy Olsen</em>: I&#8217;d say that, just in general, anytime we improve the ability to paste content in from another place is a good thing. Because the truth is that we don&#8217;t always start our writing within WordPress or we&#8217;re using something that was collaborated on some other location. So, trying to keep things aligned with how they might exist in other places is super helpful.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Really. Well, really, we use Google Docs quite a bit, or I use Google Docs quite a bit. And from the beginning of the block editor, I was so amazed how seamless the copy and paste works from Google Docs to block editor, if you are sparse with your design on Google Docs. The layout you have to do on the other side, but it brought over the headings, the list, the indented list, and all that. It&#8217;s a really good place. But now, we can also do the tables, yes.</p>\n\n\n\n<p><em>Daisy Olsen</em>: Another thing that I use is to pull in markdown, and I love that it just magically turns into HTML.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. There are actually markdown shortcuts that you can use on the block editor, yeah. That&#8217;s really cool. I need to do more markdown. When you paste markdown into GitHub, it kind of ceases that code and you cannot&#8230; It was weird. But post it into WordPress, and you can all read it. So, there was quite a few changes to the components, mostly adding a new opt-in for background color and for opt-in props. So, you can actually use that component.</p>\n\n\n\n<p>The global styles component got a new on-change action. So, when the color to the color palette, so when you click on the color palette on the&#8230; So, on the right-hand side, you see the color palettes and you see, every time you change the color, the little circle next to the property takes on the color. But when you click on it, it always went back to the default setting of the color palette.</p>\n\n\n\n<p>Now, when you click on it, you see the color that was in there before also in that little window in the color palette. So, if you just want to change the view of a color, then you don&#8217;t have to navigate to the color again and then change the views. You really see, okay, this was before and this is&#8230; So, it&#8217;s a really good improvement for changing colors. And yeah, I really love it. That&#8217;s why I pointed it out.</p>\n\n\n\n<p>The others are more like code quality improvements there. And then, now, the block editor gets the insert of the block editor. It gets a new media tap. So, now, you will be able to add pictures right from the inserter instead of going to go to the media library selected, come back to the editor. It&#8217;s now very seamless, which means that there are additional tabs. There&#8217;s one additional tab. And it gets a little crowded. So, you have the blocks, then you have the patterns, then the media tab. And your reusable block are still there, but they are replaced by an icon. And that&#8217;s the icon that you see on other reusable block references. So, I really like it. You get also some preview to the pictures. And so, it&#8217;s tested out. It&#8217;s quite amazing.</p>\n\n\n\n<p><em>Daisy Olsen</em>: And then at the bottom of the area, you still get an option to load up the old media library modal overlay. So, if you prefer that, it&#8217;s still there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, good point. Because the media library view gives you a lot more pictures to look at to select from. Because the other pictures in that view, you see one at a time in a little preview and you have to scroll through them. But if it&#8217;s just an image that you uploaded the last week or the last two weeks, depending on how much content you provide, it&#8217;s a really neat shortcut.</p>\n\n\n\n<p><em>Daisy Olsen</em>: So, the layouts control has been added to flex layout blocks, notably the row and the stack, so that you can fit. What is it? Fit, flex, and contain. Basically, those are not the right words. I wish I have to cover.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Fluid.</p>\n\n\n\n<p><em>Daisy Olsen</em>: Yes. So, it gives you more control over how those two group block types will display the blocks or how the inner blocks or child blocks will be structured.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: You also get now a minimum height block support under dimensions for the container block. Container block is like a group block or the cover block. Because it&#8217;s hard to fill something when it&#8217;s in it, it doesn&#8217;t have a maximum height thing or minimum height to put an image that fills up the whole block. So, that&#8217;s also something in there. And you can also resize the children or inner blocks. Resizing children is really hard. That&#8217;s why I try to find a different. Because the parent-child relationship, that&#8217;s more like a developer thing. It&#8217;s not for, yeah&#8230; But, yeah, that&#8217;s a great addition to that. Scrolling down to the experiments. And then, there&#8217;s a whole lot of things for the navigation block.</p>\n\n\n\n<h3><strong>Experiments</strong></h3>\n\n\n\n<p><em>Daisy Olsen</em>: So, there&#8217;s a new experiment flag that you can enable or opt into by going to Gutenberg experiments and checking the box. And what this is going to add is, in the sidebar controls for your blocks, where you would normally set your appearance settings or any other settings that are part of that block, it&#8217;s going to split out the appearance items from everything else. So, there will be a new tab interface in that sidebar, so that you can minimize the amount of scrolling that you need to do. So, it&#8217;s an experiment. And feedback, obviously, welcome. I don&#8217;t know how much it&#8217;ll change, but it&#8217;s a cool idea. I like anything that we can do to make the interface less overwhelming will be beneficial. But that is a new experiment. And I look forward to seeing how it evolves.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: The navigation block also uses that space in the sidebar to actually have an off-canvas editor. That&#8217;s how it&#8217;s used now that, in the sidebar, so you get a list of your pages or the menu items that are in the navigation block. So, you have a little bit more space to edit them and rearrange them and, also, add new pages to it, because the little place that you had in the navigation block, if it&#8217;s in the header, you have overlapping issues with links and setting block tube settings. And it was a total chaos, I would say. Yeah, if you really wanted to get in there.</p>\n\n\n\n<p>And it was hard to actually add sub menus. And this feature makes it really, really easy to create sub menus. And it&#8217;s almost like a mini-version of the old menu navigator from the WP admin, the old menu settings there. And you can add and remove pages or links quite easily now, in addition to the being able to add other blocks to the navigation bar, like a search block or a site logo block like that. So, yeah, test out the new navigation block, because it&#8217;s a test that has gotten quite a few revamps from the original features, and if you like it better.</p>\n\n\n\n<p>So, the experimental settings that you see now in that menu item, one is the zoomed-out view where you can see all your template ports and all your themes all in one place in thumbnails. And then, the off-canvas navigation editor. And then, there&#8217;s also a&#8230; I haven&#8217;t tried it yet, but I heard about it yesterday on the hallway hangout for the FSE project. There is a global styles color randomizer. So, if you are not very good in color combinations, you can select one color, or the randomizer gives you a full palette for your styles. It&#8217;s a really interesting thing. It&#8217;s more a gimmick, but it&#8217;s like the dual tone or the gradient.</p>\n\n\n\n<p>But the people who want to work with colors, it&#8217;s definitely an improvement. And then, the fourth one is the block inspector tabs would be with the settings and the appearance controls changed. So, for experience, it&#8217;s been a while that we had four experiments happening in the block editor. I think it was the early days of full-site editing, had quite a few experiments. But that was back in 2020, early 2020. And now, two years later, almost three years later, we have new experiments, also.</p>\n\n\n\n<p><em>Daisy Olsen</em>: I think that&#8217;s a great thing because it shows we&#8217;re feeling confident with what&#8217;s not experimental anymore enough to go out into new territory again.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Sometimes, it&#8217;s also hard to isolate a feature into a separate place that it&#8217;s turned on and off. But yeah, it definitely has&#8230; But you need testers. So, if you are in the get the new version, check it out and let your feedback be known. It&#8217;s really important that those things are tested very early and feedback comes in, even if it&#8217;s not testing or if you don&#8217;t find a bug, but you say something is quirky or, &#8220;I don&#8217;t understand things, yet,&#8221; it&#8217;s very, very helpful when you let the team know. The document there were&#8230; Do you have anything else that you wanted to add to that?</p>\n\n\n\n<p><em>Daisy Olsen</em>: No, all good.</p>\n\n\n\n<h3><strong>Documentation</strong></h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: There are a few documentation edits happening there. And I only want to point out that the storybook site that&#8217;s online or that you also can get locally with the Gutenberg thing has now a link to the component folder on GitHub. When you look at a component with all the isolated, with all the features or features, attributes, on and off switches, different color scheme, you can test it on the storybook site. But when you want to check out the component, you get a direct link to the place in the Gutenberg report for the source code, so you can really double-check certain things. So, it&#8217;s a really good tool when you get down to the component level on whatever you want to build and use the storyboard to test your code.</p>\n\n\n\n<h3><strong>What is Active Development or Discussed</strong></h3>\n\n\n\n<p>So, this was the Gutenberg 14.7 change log. Well, thank you for going over it with me, Daisy. We are now in the section what&#8217;s in active development. And I have a few things there. One of them is that the team is working on making style variations theme-agnostic. What I understood with that is that you can use theme style variations that you selected even with a different theme.</p>\n\n\n\n<p><em>Daisy Olsen</em>: There are a few parts of it, the way that I&#8217;ve seen it in the design panels. And one is the other installed themes that may not be active on your site. The variations will be available, also, to be able to edit them.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Cool.</p>\n\n\n\n<p><em>Daisy Olsen</em>: Which is very cool. And then, to be able to import and export style variations from other places is another piece of it. So, I think that just a general expansion of the way that we can work with style variations is going to be really interesting. But, yes, theme agnostic is a great way to put it, because really, with the right base for how those style variations are created, particularly in terms of how things are named for color palettes and such, you should be able to take a style variation and put it onto any site that&#8217;s using a theme.JSON. So, I think that it&#8217;s been a really great thing with the way that 2023 default theme was created. And it spearheaded this idea that we should be able to use these in more than one way. But this is one piece of making it easier to switch themes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And even if that&#8217;s not a one-on-one good fit, you definitely get 80% there when you switch a theme to use the same styles that you had and then adopt what is missing. Because, you mentioned in the sentences, if the color scheme is not standardized from one style variation to the other, it might be a little bit wonky at first, but you can certainly adjust it. And I also can see one feature that could be used someplace else or in some other way is to just import style variations from other places. Like, if a theme developer has a website where have additional style variations that he doesn&#8217;t want to package with his or her theme, it certainly would make it available, just download it and add it to it. I can also see the 2023 theme as a community-wide effort. And there were 38 style variations that were submitted to be included, and 10 of those were selected. But now, there might come a way where you can actually add some of the others into your site, at least.</p>\n\n\n\n<p>All right. So, Joen Asmussen, he&#8217;s on the design team and one of the early design leads on Gutenberg, has started quite a while ago, every two weeks, posting on the design team&#8217;s make blog his design shares. And the one from last week had a few things in there that I want to point out. So, wordpress.org is in a huge site overhaul. And in the post, you see the markups of the dev hub, which is the developer site, and the job site. And there&#8217;s some great visuals. Sorry, I can&#8217;t show them to you in the podcast. But, of course, I share the link in the show notes. But you see the updates of the dev hub pages as well as the jobs pages on the org, on how they are designed and worked on right now by the meta team. Have you seen those designs?</p>\n\n\n\n<p><em>Daisy Olsen</em>: Some of them. I haven&#8217;t seen the post, but I saw some of the designs other places, the meta team.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: The design process is quite a long one. There&#8217;s a second round of feedback now through the docs team because they are the owner of the sites. So, maybe I should find that as well and put it in the show notes. Another one is that the design team created the designs for a future style block. No, style book, not a block, style book. The name is still not final, but what it is, is actually a neat feature where you can see on a screen for each block how it&#8217;ll appear on your site. That&#8217;s not new. You had this with any of the themes that you got a page where you can look through how my heading&#8217;s going to be looking at. But now it&#8217;s for every block. And you can now, also, on the right-hand side, see when you check a different style variation, see how the blocks change with that.</p>\n\n\n\n<p>And that is a fabulous feature. It really makes that coming up with new things or checking out new things like a new style variation, or so. It comes really handy. There is no surprise. There is no, &#8220;Oh, Don, we didn&#8217;t look at it beforehand, but there are two things wrong with the table block,&#8221; or something like that. You see it before you do it. And then, you can do some fixes, if you want to. But you see how the site really works, not only on the front page but with every block that you put in there.</p>\n\n\n\n<p>And when I tested it, what I also saw is that it also includes the third-party blocks. So, if you have from JetBag or from Jost or from Coblocks, all those blocks will also show up in that and you see how they will change with a change of the style variations, which is, I find that particularly important because many of those block suites came out in the early days of the block editor, and some of them have not been updated. And you will see it there, too, and see which ones are actually a little bit that needs some more TLC there.</p>\n\n\n\n<p><em>Daisy Olsen</em>: I think of this as like a unit testing feature. But rolled in, instead of having to be imported, it&#8217;s available. Once it gets in, it would be available all the time. So, you can always double-check how things are looking without importing content or some of the other ways that we&#8217;ve had to do this kind of unit testing in the past.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: The feature is merged into the code base. And it&#8217;ll be released in the 14.8 release. But it&#8217;s also available, it&#8217;s already available in the Gutenberg Nightly version, if you want to download that and get an early look at it. I really loved it. And then the last one from that post is the&#8230; Is it in any post? There is a video in the design post on the reorganization of the editor.</p>\n\n\n\n<p>It&#8217;s also coming or slated for 14.8, is that the editor screens receive some reorganization that it&#8217;s better positioned for the future enhancements like the browse mode. And the poster design post has a short video for the new way of things. So, it&#8217;s more like an organized version. Right now, when you click on the appearance editor link in the WP admin, where you get your right into the editor of your homepage, which is a little bit confusing, now, when you click on it, you get the menu on the left-hand side.</p>\n\n\n\n<p>And what you see in the canvas is actually just a view. There&#8217;s an edit button where you can start the editing, but you are not going to edit by accident. Or, you can then navigate to the other template parts much easier instead of getting out of the canvas. There are all these little things where little annoying things are taken care of. And I&#8217;m looking forward to that. Some of the UI experiments, new UI is already in the experiments, but that gives them a new home, so to speak. Any comments on that?</p>\n\n\n\n<p><em>Daisy Olsen</em>: No, I look forward to seeing more about what&#8217;s coming.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It&#8217;s really cool. I think there&#8217;s so much more coming. And I&#8217;m looking forward to 6.2 because some of it is definitely slated. We don&#8217;t have any plans yet on the 6.2 release cycle. That&#8217;s a very shortening&#8230; It&#8217;s a nice shortening of things. Instead of release cycle, you say recycle. Well, the state of the word is coming up. And I&#8217;m sure we hear a little bit about what&#8217;s coming in 2023, a review of 2022. It&#8217;s on December 15th at 1:00 p.m. Eastern 1800 DTC. I always need to check my calculations on the time zones. That&#8217;s just a shout-out for don&#8217;t miss it. It will be recorded, of course, for anybody who has no time at 1:00 p.m. or in the evening. So, Daisy, is there anything? How can people reach you if they wanted to connect with you? And what is in store on the online meetup?</p>\n\n\n\n<p><em>Daisy Olsen</em>: Let&#8217;s see. So, nothing scheduled for online meetup, as we&#8217;re coming into the holiday season. If you&#8217;d like to get in touch with me, I am Daisy O, the letter &#8220;O,&#8221; on mixed Slack. And also, that&#8217;s my WordPress profile. Most other places, Twitter, Facebook, LinkedIn, I&#8217;m DaisyOlsen, all one word.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: All right. So, so we&#8217;re coming to the end of the show, and I will thank you very much for spending the time with me here and going through the change log. Good work on all the good educational pieces that you do. And if you have any questions, still listening about block themes, you can contact me. But I will point you to Daisy, in shortcut, unless we find, of course, already material online. She also has one post in the developer blog. What is that about?</p>\n\n\n\n<p><em>Daisy Olsen</em>: It was about the various ways you can use the home template and post template options and theming.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Excellent. As always, the show notes will be published on the gutenbergtimes.com/podcast. This is episode 77. And if you have questions and suggestions or news that you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. That&#8217;s <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. Yes, that&#8217;s an email address. No slack, no Twitter. Well, of course, you can always follow us on @gutenbergtimes on Twitter. We also have pinned on the profile page our place on Mastodon. If you have left Twitter, just go there. It&#8217;s a public page. You can still see it and link it. Thank you all for listening. Thank you, Daisy. Wishing everyone wonderful holidays and a happy new year. And I&#8217;ll see you on the other side until 2023. Goodbye.</p>\n\n\n\n<p><em>Daisy Olsen</em>: Thanks so much for having me, Birgit. And happy holidays to everyone.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 12 Dec 2022 02:40:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Gutenberg Changelog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"Gutenberg Times: State of the Word, Gutenberg 14.7, Box Shadow and more – Weekend Edition 238\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=22914\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://gutenbergtimes.com/state-of-the-word-gutenberg-14-7-box-shadow-and-more-weekend-edition-238/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:24884:\"<p>Howdy,</p>\n\n\n\n<p>Going through the latest Gutenberg release, and seeing what is in store for the next one, I feel, fantastic progress has been made on Phase 2 of the block editor. WordPress will be in great shape to start the next phase: collaborative editing.  If you are keen to learn more, I suggest you watch <a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">next week&#8217;s State of the Word</a>.  As always, it will be recorded, and you can watch it at your leisure. </p>\n\n\n\n<a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\"><img /></a>\n\n\n\n<p>I&#8217;d be interested in your take of the keynote as well as the Q &amp; A that will be held afterwards. I hope you write with your thoughts.</p>\n\n\n\n<p>Until next week, be well! </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n<h2 id=\"0-strong-a-href-https-us-02-web-zoom-us-webinar-register-7616700808432-wn-ig-f-xjz-c-qym-tk-62-c-v-9-ocw-layout-layout-layout-a-strong\">Layout. Layout. Layout</h2>\n\n\n\n<p><strong><a href=\"https://us02web.zoom.us/webinar/register/7616700808432/WN_IG_fXjzCQymTk62cV9_ocw\">Reserve your seats!</a></strong> The next <strong>Gutenberg Live Q &amp; A</strong> will take place on January 11th, 2023 at 5pm ET / 22:00 UTC . </p>\n\n\n\n<p>Layouts are a fundamental part of how block themes work: Layout allows us to define the width of our post content, and arrange blocks horizontally or vertically, right or left aligned, inside container blocks. In terms of block styling, Layout is a complex feature because it affects child blocks in ways that go beyond CSS inheritance.</p>\n\n\n\n<p>In this show, <strong>Isabel Brison</strong>, <strong>Andrew Serong</strong> and <strong>Justin Tadlock</strong> will discuss the opportunities and challenges of the Layout features for site builders, and they will be available to answer your questions. Isabel Brison will also give us a demo of various layout scenarios. <strong><a href=\"https://us02web.zoom.us/webinar/register/7616700808432/WN_IG_fXjzCQymTk62cV9_ocw\">Join us! </a></strong></p>\n\n\n\n<p><em>This is also a preview on <a href=\"https://asia.wordcamp.org/2023/session/layout-layout-layout/\">Isabel Brison&#8217;s talk at WordCamp Asia</a></em> i<em>n February 2023</em></p>\n\n\n\n<a href=\"https://us02web.zoom.us/webinar/register/7616700808432/WN_IG_fXjzCQymTk62cV9_ocw\"><img /></a>\n\n\n\n\n\n<p><strong>Lana Miro</strong> collected <a href=\"https://crocoblock.com/blog/best-wordpress-podcasts-to-listen/\"><strong>16 Best WordPress Podcasts to Listen To (Top Selection)</strong></a>. She wrote about the Gutenberg Changelog: &#8220;This podcast is not just about WordPress in general but specifically about the Gutenberg block editor. In each episode, host Birgit Pauli-Haack and a guest discuss the latest version of Gutenberg and any related issues. They do all the hard work of curating news of Gutenberg’s development and then present it with infectious enthusiasm.&#8221; Thank you, Lana &nbsp;💞</p>\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-strong-a-href-https-us-02-web-zoom-us-webinar-register-7616700808432-wn-ig-f-xjz-c-qym-tk-62-c-v-9-ocw-layout-layout-layout-a-strong\">Layout. Layout. Layout</a></li><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-release-information\">Developing Gutenberg and WordPress</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#2-gutenberg-14-7-released\">Gutenberg 14.7 release</a></li></ul></li><li><a href=\"https://gutenbergtimes.com/feed/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li><li><a href=\"https://gutenbergtimes.com/feed/#6-new-videos\"> New videos </a><ul><li><a href=\"https://gutenbergtimes.com/feed/#7-word-press-tv\">WordPressTV</a></li></ul></li><li><a href=\"https://gutenbergtimes.com/feed/#5-s\">Upcoming WordPress events</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#1-l\">Learn WordPress Online Meetups</a></li></ul></li></ul></div>\n</div></div>\n\n\n\n\n<h2 id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<h3 id=\"2-gutenberg-14-7-released\">Gutenberg 14.7 release</h3>\n\n\n\n<p><strong>Gutenberg 14.7 </strong>was released this week, with 165 merged PRs by 48 Contributors, 9 were first timers! And it’s packed with quite a few features, some of them still experimental. You see big improvements to the navigation block, a media selection from the inserter and more controls for the inner blocks of flex layout blocks. Other core blocks received some small refinements that make the overall experience more consistent.</p>\n\n\n\n<p><strong>Daisy Olsen</strong>, lead for Gutenberg 14.7 plugin release, wrote in the post. <a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/\"><strong>What’s new in Gutenberg 14.7? (7 December)</strong></a>,  &#8220;It introduces a new experimental tabbed&nbsp;sidebar, colors to help identify some&nbsp;block&nbsp;types in list view, and improvements to the Page List block to make it easier to manage page links in your content.&#8221; </p>\n\n\n\n<p>Olsen highlighted the following features:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/#improved-organization-of-block-settings-with-split-control\">Improved organization of block settings with split control</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/#quickly-identify-template-parts-and-reusable-blocks-by-color\">Quickly identify Template Parts and Reusable Blocks by color</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/#add-media-to-your-content-directly-from-the-inserter\">Add media to your content directly from the inserter</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/#see-all-pages-in-list-view-for-the-page-list-block\">See all pages in List View for the Page List block&nbsp;</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/#layout-controls-added-to-children-of-flex-layout-blocks\">Layout controls added to children of flex layout blocks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/#improved-load-times-by-caching-the-results-of-querying-settings-from-theme-json\">Improved load times by caching the results of querying settings from theme.json</a></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Yesterday, <strong>Daisy Olsen</strong> and I recorded the 77th Episode of the Gutenberg Changelog. It was such a great pleasure to discuss the release and what&#8217;s coming next for the block editor. The episode will arrive at your favorite podcast app over the weekend. </p>\n\n\n\n<a href=\"https://gutenbergtimes.com/podcast/\"><img /></a>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p><strong>🎙️ </strong> New episode:  <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-77-gutenberg-14-7-whats-new-for-block-themes-an-upcoming-live-qa-in-january/\">Gutenberg Changelog #77 – Gutenberg 14.7, what’s new for Block Themes, an upcoming Live Q&amp;A in January</a> with special guest, Daisy Olsen and host Birgit Pauli-Haack. </p>\n</div></div>\n\n\n\n<p><strong>Anne McCarthy</strong>, who runs the FSE Outreach program held this week&#8217;s <a href=\"https://make.wordpress.org/test/2022/12/08/hallway-hangout-lets-chat-about-the-future-of-custom-css-with-block-themes/\"><strong>Hallway Hangout: Let’s chat about the Future of Custom CSS with block themes</strong></a> and posted the recording and a summary. </p>\n\n\n\n<p>In another update from the FSE Program, Anne McCarthy is<a href=\"https://make.wordpress.org/test/2022/12/07/fse-program-seeking-volunteers-to-use-replay-io-for-capturing-bugs/\"><strong> seeking volunteers to use Replay.io for capturing bugs</strong></a> . After using Instant WP for spinning up test site for call for testings, Anne McCarthy will expand the program to pilot using Replay.io. Volunteers will  &#8220;help determine how it can be used to better WordPress’ bug finding and fixing feedback&nbsp;loop.&#8221;</p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-constrained\"><div class=\"wp-block-group__inner-container\">\n<p>The <strong><a href=\"https://developer.wordpress.org/news/\">WordPress Developer Blog</a></strong> is still in beta. The editorial group is working on getting more posts published. If you want to write a blog post that would help WordPress developer be successful building themes or plugins or bespoke site for client, browse through the <a href=\"https://github.com/WordPress/developer-blog-content/discussions/categories/topic-ideas\">topic Ideas, that have already been submitted</a>.  </p>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/news/how-to-contribute/\">How to contribute</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/tips-and-guidelines-for-writers/\">Tips and guidelines for writers</a></li>\n</ul>\n</div></div>\n\n\n\n<p><strong>Alvaro Gómez</strong> posted about <a href=\"https://make.wordpress.org/support/2022/12/introducing-the-block-editor-in-the-support-forums/\"><strong>Introducing the Block Editor in the Support Forums</strong></a>; only a few core-block will be allowed. &#8220;Users will be able to easily insert links, share code or embed screenshots. Using Blocks will also enable new possibilities, such as using patterns for common responses to allow for faster answers.&nbsp;&#8221; he wrote.  If I read it right and the current editor in use &#8220;predates TinyMCE&#8221;, then this might be the first update to the forums editor since the start of the website in 2003. </p>\n\n\n\n<p>For now, it&#8217;s available via a test site, and you are invited to try it and share your feedback on the <a href=\"https://meta.trac.wordpress.org/ticket/6608\">meta trac ticket. </a></p>\n\n\n\n<p><strong>Sarah Gooding</strong> also reported on this update: <a href=\"https://wptavern.com/the-block-editor-is-coming-to-wordpress-support-forums\"><strong>The Block Editor Is Coming to WordPress’ Support Forums</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>In her article <strong><a href=\"https://wptavern.com/woocommerce-blocks-9-1-0-introduces-products-block-in-beta\">WooCommerce Blocks 9.1.0 Introduces Products Block in Beta</a> Sarah Gooding</strong> reports on the latest release of WooCommerce Blocks. &#8220;The plugin serves as a place to iterate and test new blocks, and this release introduces the new Product Query-powered Products block in beta. (&#8230;) The new Products block is based on the core Query Loop block. WooCommerce Blocks contributors are aiming to replace all the plugin’s current product-displaying blocks with this one.&#8221;</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Rich Tabor</strong>, theme and plugin developer, was <a href=\"https://richtabor.com/wordpress-design-tool/\"><strong>exploring WordPress as a design tool</strong></a>. It&#8217;s the story of how he challenged himself to take one pattern, from one theme, and morph it multiple times — only using the design controls of the block editor.  &#8220;Every font family/size, color, border, radius, image, video, and spacing value were all added in-editor.&#8221; And he also challenges you to give this a try: </p>\n\n\n\n<ul>\n<li><em>Use only the&nbsp;<a href=\"https://wordpress.org/themes/twenty-twenty-three\">Twenty Twenty-Three&nbsp;</a><a href=\"https://wordpress.org/themes/twentytwentythree\">theme</a>.&nbsp;</em></li>\n\n\n\n<li>Design a section of a page, then </li>\n\n\n\n<li>morph it a couple of times using only the design tooling within the editor.&nbsp;</li>\n</ul>\n\n\n\n<a href=\"https://richtabor.com/wordpress-design-tool/\"><img /></a>\n\n\n\n<p><strong>Automattic&#8217;s Sensei LMS</strong> has <a href=\"https://senseilms.com/meet-course-a-new-free-block-theme-by-sensei/\"><strong>released a new free block theme called &#8220;Course.&#8221;</strong></a> It is designed for creators and is built to work perfectly with all Sensei LMS features, including course lists, sales pages, and learning mode course templates. It is also open-source and <a href=\"https://wordpress.org/themes/course/\">available on WordPress.org</a>, making it ideal for course creators, bloggers, coaches, small businesses, and even those using competitor LMS WordPress plugins. The theme is mobile-optimized and allows for customization to match your brand.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://jetpack.com/blog/jetpack-11-6-update-to-the-form-block-and-more/\">Jetpack 11.6 release</a></strong> added new features to its forms and SEO capabilities. It now has block pattern support for forms, making it easier to create them, and new SEO features allowing users to specify that certain posts or pages should not be indexed by search engines, and to set custom SEO titles for individual posts and pages.</p>\n\n\n\n<a href=\"https://jetpack.com/blog/jetpack-11-6-update-to-the-form-block-and-more/\"><img /></a>\n\n\n\n<p><a href=\"https://wptavern.com/podcast/54-steve-burge-on-where-were-at-with-multi-author-collaboration-in-wordpress\" target=\"_blank\" rel=\"noreferrer noopener\">#54 – </a><strong><a href=\"https://wptavern.com/podcast/54-steve-burge-on-where-were-at-with-multi-author-collaboration-in-wordpress\" target=\"_blank\" rel=\"noreferrer noopener\">Steve Burge on Where We’re at With Multi-Author Collaboration in WordPress</a> </strong>with Nathan Wrigley. On this episode of the Jukebox podcast from WP Tavern, the topic is multi-author collaboration in WordPress. Steve Burge discusses the current state of collaboration in WordPress, the challenges that come with it, and what the future holds for the platform. Burge also elaborates on the site editing phase of the Gutenberg project and how it relates to collaboration.</p>\n\n\n\n<h2 id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Justin Tadlock</strong> just published a new post on the WordPress Developer Blog:  <a href=\"https://developer.wordpress.org/news/2022/12/07/leveraging-theme-json-and-per-block-styles-for-more-performant-themes/\"><strong>Leveraging theme.json and per-block styles for more performant themes</strong></a>. I<a href=\"https://twitter.com/justintadlock/status/1600623143558828034\">n a tweet</a> he wrote: &#8220;This post dives into how to primarily lean into theme.json when styling your theme, taking advantage of the built-in performance enhancements that WordPress offers out of the box, such as only outputting CSS when it&#8217;s needed. All theme authors know that theme.json isn&#8217;t quite enough for every project. However, you can benefit from those same enhancements by loading per-block stylesheets. This is also great for integrating with third-party blocks without bulking up your CSS.&#8221; </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<p>In his article on the CSS Tricks, <a href=\"https://css-tricks.com/adding-box-shadows-to-wordpress-blocks-and-elements/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Adding Box Shadows to WordPress Blocks and Elements</strong></a>, <strong>Ganesh Dahal</strong> provides you with a tutorial and an example of how to add a `box-shadow` to the hover state of a button in `theme.json`. ICYMI: As of WordPress 6.1, it is possible to add styles to elements and blocks using `theme.json`, including pseudo-classes such as `:hover`. Ben Dwyer wrote the corresponding Dev Note: <a href=\"https://make.wordpress.org/core/2022/10/10/styling-elements-in-block-themes/\">Styling elements in block themes</a></p>\n\n\n\n<h2 id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p>In his post, <a href=\"https://fluffyandflakey.blog/2022/12/06/access-all-block-attributes-structurally-with-the-gutenberg-block-editor/\"><strong>Access all block attributes structurally with the Gutenberg block editor</strong></a>, <strong>Dennis Snell</strong> wrote &#8220;about a small experiment to eliminate sourced attributes in Gutenberg posts. If you want to build a custom block editor, and you wish to avoid parsing HTML to get the full set of attributes, then it’s strikingly easy to do so: all it takes is disabling a few properties of each block’s attribute definitions.&#8221; Let him tell you more! </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<h2 id=\"6-new-videos\"> New videos </h2>\n\n\n\n<p><a href=\"https://torquemag.io/2022/12/torque-social-hour-learning-to-use-the-site-editor/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Torque Social Hour: Learning to use the Site Editor</strong></a> with <strong>Brian Gardner.</strong> On this week’s episode, Brian Gardner teaches Doc the fundamentals of editing a block-based WordPress theme with the new Site Editor. Brian designed one of the Style Variations that came in the new Twenty Twenty Three theme.</p>\n\n\n\n<h3 id=\"7-word-press-tv\">WordPressTV</h3>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.tv/2022/12/09/builder-basics-demystifying-theme-json-and-global-styles/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Builder Basics: Demystifying theme.json and Global Styles</strong></a> (Learn WordPress)</li>\n\n\n\n<li><a href=\"https://wordpress.tv/2022/12/09/manage-your-block-theme-fonts-with-create-block-theme/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Manage your block theme fonts with Create Block Theme</strong></a> (Learn WordPress)</li>\n\n\n\n<li><strong><a href=\"https://wordpress.tv/2022/12/08/the-key-to-locking-blocks/\" target=\"_blank\" rel=\"noreferrer noopener\">The key to locking blocks</a> </strong>(Learn WordPress)</li>\n\n\n\n<li><strong><a href=\"https://wordpress.tv/2022/12/08/content-creators-are-users-too-the-crucial-importance-of-carefully-crafted-editorial-experiences/\" target=\"_blank\" rel=\"noreferrer noopener\">Content creators are users too: the crucial Importance of carefully crafted editorial experiences</a> </strong>(WCUs)</li>\n\n\n\n<li><strong><a href=\"https://wordpress.tv/2022/12/07/using-the-navigation-block-2/\" target=\"_blank\" rel=\"noreferrer noopener\">Using the navigation block</a> </strong>(Learn WordPress)</li>\n\n\n\n<li><a href=\"https://wordpress.tv/2022/12/02/hallway-hangout-future-of-css-in-block-themes/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Hallway Hangout: the future of CSS in block themes</strong></a> (Learn WordPress)</li>\n\n\n\n<li><strong><a href=\"https://wordpress.tv/2022/12/02/builder-basics-building-with-columns-groups-rows-and-stacks/\" target=\"_blank\" rel=\"noreferrer noopener\">Builder basics: building with columns, groups, rows and stacks</a> </strong>(Learn WordPress)</li>\n\n\n\n<li><a href=\"https://wordpress.tv/2022/12/02/lets-code-developing-blocks-without-react-controls/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Let’s code: developing blocks without React! – Controls</strong></a> (Learn WordPress)</li>\n\n\n\n<li><a href=\"https://wordpress.tv/2022/11/30/using-page-templates/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>Using page templates</strong></a> (Learn WordPress)</li>\n</ul>\n\n\n\n<h2 id=\"5-s\">Upcoming WordPress events</h2>\n\n\n\n<p><strong>December 12, 2022 &#8211; 10 am &#8211; 1:30 pm ET / 15:00 &#8211; 18:30 UTC </strong><br /><a href=\"https://bluehostawards.com/\"><strong>WP CreatorCon</strong>  </a>&#8211;  a virtual event curated by Bluehost to bring together all WordPress creators of the world. It&#8217;s an event that will culminate the Bluehost Creators Awards. </p>\n\n\n\n<p><strong>December 15, 2022 – 1 pm ET / 18:00 UTC</strong><br /><strong><a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word 2022</a></strong>&nbsp;– Matt Mullenweg’s annual keynote.</p>\n\n\n\n<p><strong>January 11, 2023 &#8211; 5 pm ET / 22:00 UTC</strong><br /><strong><a href=\"https://us02web.zoom.us/webinar/register/7616700808432/WN_IG_fXjzCQymTk62cV9_ocw\">Gutenberg Times Live Q &amp; A: Layout, layout, layout</a></strong><br />Panel discussion with Isabel Brison, Andrew Serong, Justing Tadlock and Birgit Pauli-Haack</p>\n\n\n\n<p><strong>February 17 – 19, 2023</strong><br /><a href=\"https://asia.wordcamp.org/2023/\"><strong>WordCamp Asia 2023</strong></a>&nbsp;</p>\n\n\n\n<h3 id=\"1-l\">Learn WordPress Online Meetups</h3>\n\n\n\n<p>December 12, 2022 – 3 pm ET / 22:00 UTC<br /><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/289957641/\"><strong>Creating a Call To Action with the Block Editor</strong></a></p>\n\n\n\n<p>December 14, 2022 &#8211; 7 pm ET / 24:00 UTC<br /><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/290170169/\"><strong>Exploring Category Templates and the Query Loop Block Session 1</strong></a></p>\n\n\n\n<p>December 15, 2022 &#8211;  9 am ET / 14:00 UTC<br /><strong><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/290237910/\">Let&#8217;s code: Developing Blocks without React! &#8211; Review</a></strong></p>\n\n\n\n<p>December 21, 2022 &#8211;  7 pm ET / 24:00 UTC<br /><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/290170454/\"><strong>Creating a Theme with the Create Block Theme Plugin Session 1</strong></a></p>\n\n\n\n<p>December 21, 2022 &#8211; 3 am ET / 8 am UTC<br /><strong><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/290170469/\">Creating a Theme with the Create Block Theme Plugin Session 2</a></strong></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p>Featured Image: &#8220;Galleria Vittorio Emanuele II&#8221; in Milan by Dennis Hipp via <a href=\"https://wordpress.org/photos/photo/6136384d1b/\">WordPress Photos</a> </p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 10 Dec 2022 13:57:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: WooCommerce Blocks 9.1.0 Introduces Products Block in Beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=140245\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/woocommerce-blocks-9-1-0-introduces-products-block-in-beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2447:\"<p>WooCommerce Blocks<a href=\"https://developer.woocommerce.com/2022/12/09/woocommerce-blocks-9-1-0-release-notes/\"> version 9.10</a> was released today, hitting a major milestone for the development of its new Products Block. The plugin serves as a place to iterate and test new blocks, and this release introduces the new Product Query-powered Products block in beta.</p>\n\n\n\n<p>In this first iteration, users can arrange products by popular presets and control the layout in the list/grid. </p>\n\n\n\n<img />\n\n\n\n<p>The new Products block is based on the core Query Loop block. WooCommerce Blocks contributors are aiming to replace all of the plugin&#8217;s current product-displaying blocks with this one. </p>\n\n\n\n<p>&#8220;This new block should be flexible enough to reproduce all of the use-cases currently covered by existing blocks (e.g. showing all products, showing only new products, or products on sale, etc.), while also being filterable via dedicated filter blocks and compatible with FSE templates (i.e. it should replace the placeholders we currently use in archive templates),&#8221; Automattic-sponsored WooCommerce contributor Marco Lucio Giannotta said in the <a href=\"https://github.com/woocommerce/woocommerce-blocks/issues/6793\">ticket</a> proposing the new Products block.</p>\n\n\n\n<p>The first iteration still requires some polishing but it&#8217;s meeting the basic objectives for allowing users to display and customize products using the new query-based block.</p>\n\n\n\n<p>Version 9.1.0 also unveils three new &#8220;product-adjacent&#8221; patterns. These are patterns that don&#8217;t use WooCommerce store data but rather focus on presentation. They include the following patterns:</p>\n\n\n\n<ul>\n<li>&#8220;WooCommerce Alternating Image and Text” block pattern. (<a href=\"https://github.com/woocommerce/woocommerce-blocks/pull/7827\">7827</a>)</li>\n\n\n\n<li>&#8220;WooCommerce Product Hero 2 Column 2 Row” block pattern. (<a href=\"https://github.com/woocommerce/woocommerce-blocks/pull/7814\">7814</a>)</li>\n\n\n\n<li>“Just Arrived Full Hero”  block pattern (<a href=\"https://github.com/woocommerce/woocommerce-blocks/pull/7812\">7812</a>)</li>\n</ul>\n\n\n\n<p>WooCommerce Blocks contributors are also working on patterns that connect to store data and will be releasing new patterns soon. Other notable additions in this release include support for the alignment setting in the Add to Cart Button and Product Rating elements.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Dec 2022 22:21:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Post Status: More WordPress People Doing Good Things\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=145785\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://poststatus.com/more-wordpress-people-doing-good-things/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4077:\"<h2 id=\"h-wordpress-gives-a-hand\">WordPress Gives a Hand</h2>\n\n\n\n<p>For the third year in a row, a bunch of WordPress community members will join together at the holiday time for the charity campaign “<a href=\"http://wpgivesahand.com/\">WordPress Gives A Hand</a>” <a href=\"https://twitter.com/search?q=%23wpgivesahand&src=typed_query\">#wpgivesahand</a>.</p>\n\n\n\n<p>During the holiday season, instead of giving out discounts to customers, participating WordPress community members will donate a percentage of their revenue to supporting people in need. Each company chooses whichever charity they would like to donate to.</p>\n\n\n\n<p>This great initiative raises awareness across the global WordPress community. Last year, participating companies included Cloudways, TranslatePress, Visual Composer, wpDataTables, Amelia, and others. This year WordPress Gives a Hand is asking for your help to show the world that WordPress is a place for everyone!</p>\n\n\n\n<p>To learn more or to get involved visit <a href=\"http://wpgivesahand.com/\">wpgivesahand.com</a>.</p>\n\n\n\n<h2 id=\"h-the-wp-community-collective\">The WP Community Collective</h2>\n\n\n\n<p>The WP Community Collective aims to address some of these ongoing challenges by creating community-funded <a href=\"https://www.thewpcommunitycollective.com/fellowships/\">Fellowships</a> to financially support individual contributions to the WordPress project and community.</p>\n\n\n\n<p>“We hope that the WP Community Collective can help bridge the gap between the passion people feel for WordPress, and the very real and practical limits of volunteer contribution,” said founding co-director Sé Reed.&nbsp;&nbsp;</p>\n\n\n\n<p>The WPCC’s first initiative is the <a href=\"https://opencollective.com/thewpcc/contribute/accessibility-fellowship-46812\">WPCC Accessibility Fellowship</a>. They are currently in discussion with an existing unsponsored core contributor to hold the inaugural role of Accessibility Fellow, and have launched the fundraising efforts to fund this Fellowship: <a href=\"https://opencollective.com/thewpcc/contribute/accessibility-fellowship-46812\">https://opencollective.com/thewpcc/contribute/accessibility-fellowship-46812</a></p>\n\n\n\n<p>To learn more or to get involved visit <a href=\"https://www.thewpcommunitycollective.com/\">thewpcommunitycollective.com</a></p>\n\n\n\n<h2 id=\"h-post-status-membership-deal\">Post Status Membership Deal</h2>\n\n\n\n<p>In the spirit of Black Friday/Cyber Monday, Post Status is offering $100 off any annual membership through December 31. Why? Because we love you! Membership gets you into our Slack community, too!</p>\n\n\n\n<p>Use discount code BFCM for your best Post Status membership deal ever!</p>\n\n\n\n<h2 id=\"h-in-the-spotlight\">In the Spotlight</h2>\n\n\n\n<p>Post Status professional member, <a href=\"https://poststatus.com/member-spotlight-jamie-madden/\">Jamie Madden</a>. Jamie is the founder and lead developer of WC Vendors Marketplace, the first free multivendor marketplace plugin for WordPress and WooCommerce, launched back in 2014.</p>\n\n\n\n<h2 id=\"h-weekly-member-huddles\">Weekly Member Huddles</h2>\n\n\n\n<ul>\n<li>Wednesdays <a href=\"https://us02web.zoom.us/meeting/register/tZYuf-GrpjksH91MJiGiaIwzpHWzhWSgOrKL\">Sign Up</a></li>\n\n\n\n<li>Fridays <a href=\"https://us02web.zoom.us/meeting/register/tZcuf-uprT0oGdx2Pg91t1eADl5JOow2YwLR\">Sign Up</a></li>\n</ul>\n\n\n\n<h2 id=\"h-upcoming-events\">Upcoming Events:</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word</a> December 15, 2022</li>\n\n\n\n<li><a href=\"https://kolkata.wordcamp.org/2022/\">WordCamp Kolkata</a> December 17-18, 2022</li>\n\n\n\n<li><a href=\"https://asia.wordcamp.org/2023/\">WordCamp Asia</a> February 17-19, 2023</li>\n\n\n\n<li>Calls for Speakers and Sponsors are open at <a href=\"https://www.wpwealthbuilder.com/\">WP Wealthbuilder Summit</a> May 12, 2023</li>\n\n\n\n<li>WordCamps are back. <a href=\"https://central.wordcamp.org/schedule/\">Check the schedule online</a>!</li>\n</ul>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Dec 2022 20:10:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Michelle Frechette\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"Post Status: The WP Agency Journey with D’nelle Dowis of Berry Interesting Productions— Post Status Draft 132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=145319\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://poststatus.com/the-wp-agency-journey-with-dnelle-dowis-of-berry-interesting-productions-post-status-draft-132/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:43796:\"<div class=\"is-layout-flow wp-block-group eplus-wrapper has-theme-palette-2-color has-theme-palette-8-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">D\'nelle Dowis has been a part of WordPress for more than a decade. Her passion for genuine, sustained relationships informs how she leads her agency, <a href=\"https://berry-interesting.com/\">Berry Interesting Productions</a>. D\'nelle talks about her experiences meeting clients where they are and helping them leverage technology to solve the challenges of today while making room for future opportunities. She shares why she values support, her thoughts on DIY, and how she makes room for her clients to ask the weird questions.   </p></div>\n\n\n<div class=\"wp-block-spacer eplus-wrapper\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">31</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n\n\n\n\n<p><a href=\"https://poststatus.com/planet/feed/#h-transcript\">Transcript</a> ↓</p>\n\n\n\n<p>In this episode of <strong>Post Status Draft</strong>, Cory is joined by <strong>D\'nelle Dowis</strong>, CEO of <strong><a href=\"https://berry-interesting.com/\">Berry Interesting Productions</a></strong>. She and her husband have worked in WordPress for over a decade and run a small, consultative agency. D\'nelle shares truly helpful insights about centering relationships in work and life. From being invested in clients for the long haul to being intentionally curious about knowing others and how they spend their days, D\'nelle invites us to let connection be the fuel that informs and inspires who we are and how we work.  </p>\n\n\n\n<p>Top Takeaways:</p>\n\n\n\n<ul>\n<li><strong>Build Long-Term Client Relationships: </strong>Building long-term relationships enables you to advise clients from a big-picture perspective, as opposed to just building technical solutions. \n<ul>\n<li></li>\n</ul>\n</li>\n\n\n\n<li><strong>Support is Serious Business: </strong>Doing what we do best should give our client\'s peace of mind that their sites will perform as needed when needed. </li>\n\n\n\n<li>Look Beyond a Client\'s Ask to Unseen Opportunities: As clearly reflected in D\'nelle\'s experience share about her yoga studio client, leaning into hard seasons with clients to bring unique solutions with technology can transform the future trajectory of their business.</li>\n</ul>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<div class=\"is-layout-flex wp-container-26 wp-block-columns Pressable has-theme-palette-8-background-color has-background\" id=\"Pressable\">\n<div class=\"is-layout-flow wp-block-column\">\n<h3><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/pressable\">Pressable</a></h3>\n\n\n\n<p>Founded in 2010, <strong>Pressable</strong> is a world-class managed WordPress hosting provider built on the same data network as <strong>WordPress.com</strong> and <strong>WordPress VIP</strong>. With industry-leading performance, 24/7 expert support, a 100% uptime guarantee, and seamless integrations with <strong>WooCommerce</strong> and <strong>Jetpack</strong>, Pressable provides the tools you need to manage your WordPress websites and grow your business all in one place. <a href=\"https://poststat.us/pressable\">TRY PRESSABLE→</a></p>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column is-vertically-aligned-center\">\n<a href=\"https://poststat.us/pressable\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2022/01/pressable-icon-primary.svg\" alt=\"Pressable\" class=\"wp-image-121339\" width=\"150\" title=\"Pressable\" /></a>Pressable\n</div>\n</div>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul>\n<li><a href=\"https://troydean.com.au/\">Troy Dean</a></li>\n\n\n\n<li><a href=\"https://www.thecaverns.com/\">The Caverns in Tennessee</a> </li>\n\n\n\n<li><a href=\"https://www.novofitnessstudio.com/\">Novo Fitness Studio</a> </li>\n\n\n\n<li><a href=\"https://www.elegantthemes.com/gallery/divi/\">Divi</a> </li>\n</ul>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-you-can-follow-post-status-and-our-guests-on-twitter\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> You can follow Post Status and our guests on Twitter:</h3>\n\n\n\n<ul class=\"eplus-wrapper\">\n<li><a href=\"https://twitter.com/d_nelle\">D\'nelle Dowis</a> (Owner, <a href=\"https://twitter.com/berryinterestin\">Berry Interesting Productions</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/corymiller303\">Cory Miller</a> (CEO, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a> (Intern, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n</ul>\n\n\n\n<p class=\"eplus-wrapper has-background\">The <strong>Post Status Draft</strong> podcast is geared toward WordPress professionals, with interviews, news, and deep analysis. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4dd.png\" alt=\"📝\" class=\"wp-smiley\" /><br /><br /><a href=\"https://poststatus.com/category/post-status-podcasts/\" target=\"_blank\" rel=\"noreferrer noopener\">Browse our archives</a>, and don’t forget to subscribe via <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\" target=\"_blank\" rel=\"noreferrer noopener\">iTunes</a>, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\" target=\"_blank\" rel=\"noreferrer noopener\">Google Podcasts</a>, <a href=\"https://www.youtube.com/c/PostStatus\" target=\"_blank\" rel=\"noreferrer noopener\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\" target=\"_blank\" rel=\"noreferrer noopener\">Stitcher</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Simplecast</a>, or <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h2 class=\"eplus-wrapper\" id=\"h-transcript\">Transcript</h2>\n\n\n\n<p>Cory Miller: [00:00:00] Hey everybody. Welcome back to Post Status Draft. This is another interview in our agency journey series where we\'re talking to agency owners and getting their backstory and their story, and sharing a little bit about their passions and the work and the world of WordPress. So today I have someone I\'ve known for a very long time, D\'nelle and I\'m gonna let her introduce herself in a second.</p>\n\n\n\n<p>But, um, we\'ve been, I\'ve known D\'nelle for, let\'s see. Gosh, 10 years. I\'m trying to think at least. Oh yeah. Yeah. And um, so we\'ve got to meet a couple times and I was just hearing a little bit about her story and I\'m excited for you to hear that too. So, D\'nelle, would you mind in, uh, introducing yourself and sharing, uh, what your agency is?</p>\n\n\n\n<p>D’nelle Dowis: Yeah. Um, so my name is D\'nelle Dallas. I own an agency named Berry interesting productions. We\'re very small. Um, it\'s owned by me and my husband. Um, and then we have a developer who we rely on heavily, but she is still contract with us. We primarily provide WordPress support. That\'s what we get really excited about.</p>\n\n\n\n<p>Um, but we also build WordPress [00:01:00] websites. And depending on what the client\'s needs are, we will either say, Hey, maybe you should be on Squarespace, or, Hey, maybe you need a bigger agency. So a lot of. Is very, take a very consultative approach. And, um, yeah, so been in WordPress since 2010 now. Um, it\'s, it\'s been a, a hot minute since all of that started.</p>\n\n\n\n<p>Um, and yeah, we\'ve seen a lot happen. It\'s, there\'s a lot has happened over the last 15, 17 years.</p>\n\n\n\n<p>Cory Miller: No kidding. Tell me a little bit about, okay, so that\'s where you are now, and we\'re going to dive into parts of the in a minute, but tell us how you got there. So you started with WordPress in 2010?</p>\n\n\n\n<p>D’nelle Dowis: Yeah, so I started writing HTML websites.</p>\n\n\n\n<p>I mean, I don\'t go quite far enough back to have written, um, themes for MySpace. But that is, that\'s the kind of era that we\'re talking about is write your own HTML website era. Um, and I, so I, I came from a print background, um, [00:02:00] primarily in journalism. I thought that I was gonna go and like lay out. Uh, newspapers for a living.</p>\n\n\n\n<p>So I had a lot of experience with type setting, a lot of experience with, um, graphic design in the sense of like user experience design. Like I kind of, um, during Covid, I, I dabbled a little bit in UX and it very much lined up with the ba like, like career background of having worked in print journalism and um, print design.</p>\n\n\n\n<p>Um, and then, um, in 2000 and. 10, 2011. Um, I went through career change where I was let go after a reorg and I was like, I really don\'t know what I\'m gonna do. Um, and was hired as a webmaster just because I happened to be tech savvy, was hired as a webmaster at a little company in Nashville and that company was building themselves a website.</p>\n\n\n\n<p>And so I was tasked with. Basically liaising with the agency that was building this site so that I knew as much about it as possible so that I could be a good [00:03:00] webmaster for ongoing upkeep. Um, and that\'s really where I started to see the power of WordPress and what it can do for you and the ways that it can be used to do all kinds of different things.</p>\n\n\n\n<p>Um, and it was. After encountering WordPress that it really made sense for me to move into doing it, um, as a like long term business. Um, in 2012, I quit doing anything for anybody else and started doing this full time. Um, I\'ve definitely like kind of dabbled in other agents. Um, that was really like from a, a like supplement my own income as I built my business kind of thing.</p>\n\n\n\n<p>I would do project management and like low level development for other agencies, um, which really has formed the way that I run. Very interesting today because you, you see that man behind the curtain, you see where. Those cracks are in the fascia and you wanna, I mean, at least I wanna fix it. Um, I didn\'t want it to be like that for the people who are working at agencies, and I don\'t want it to be like that for clients.</p>\n\n\n\n<p>Um, so that\'s kind of how we ended up here with the [00:04:00] goal of making sure that we have clients that we are in long-term relationships with, that we can advise from a big picture perspective as opposed to just building. That\'s not what we want. Do we wanna be in the long term relationship business? Um, and so kind of as a result, we are in the website development business.</p>\n\n\n\n<p>Um, but it really is all about the support, all about the kind of holistic business advice from a, I was writing a blog the other day about, um, tech stacks and really like tech stacks come from the world of application building where you think about all of the languages and tools that you\'re using to build an application.</p>\n\n\n\n<p>I really like to think about that from a business perspective. There\'s a lot of like tech stack advice that I will give to clients. Like, you shouldn\'t be, you know, uh, registering your domain over here, or maybe we should think about different hosting, or you might wanna think about a different calendar booking tool that integrates with your website.</p>\n\n\n\n<p>Those kinds of things that aren\'t just about web development, but are more about the overall business operations. [00:05:00] Those are the kind of relationships that I wanna have with our clients, and that is what I wanna establish with our agency, which is a space where people are not just like coming to you saying, Hey, could you build this website for me?</p>\n\n\n\n<p>But they might come to you with weird questions. I wanna have the kind of relationship with our clients where we can answer those weird questions and if we can\'t answer them, we can help them find somebody that they, we know that they can trust.</p>\n\n\n\n<p>Cory Miller: Tell me a little bit about support. You mentioned like, okay, there\'s building this side, but there\'s this ongoing thing, and I think that\'s one of the beauties of WordPress that can do so much more for businesses.</p>\n\n\n\n<p>But could you talk about from that angle, um, the support, what it, what you\'re intending to do and what you see from some of the types of clients that you have that you do for?</p>\n\n\n\n<p>D’nelle Dowis: Um, so at the very basis of it, um, I mean I\'m kind of coming from the, uh, space where I\'m influenced by like Troy Dean and also like, let\'s not forget to mention Nathan Ingram, who is like an absolute genius in this space.</p>\n\n\n\n<p>Um, talking about like Nathan\'s scope document where he [00:06:00] talks about how you talk to clients when you are meeting them for the first time and evaluating what their needs are. Inevitably, people think they are coming to you because they wanna buy something from you. They wanna buy a product, they wanna buy this website.</p>\n\n\n\n<p>What they don\'t understand about buying that website. And I find myself in a situation where I\'m often kind of like educating people about what it\'s like to own and use a website is that it\'s not something where you can just set it and forget it. You\'re not going to buy a car. You\'re thinking about the ongoing mainten.</p>\n\n\n\n<p>That is going to have to happen. So I mean, we, we take a little bit of a kitchy approach with it. Very interesting productions like we are, we have this kind of like garden, like tending your garden sort of theme. That\'s really where that support comes from, is that, You can\'t just go out there and throw some seeds in the ground and then expect that you\'re gonna get the harvest that you want.</p>\n\n\n\n<p>You really need to be paying attention to your site long term. That being said, there\'s so many things about website maintenance that really should not be on [00:07:00] mind of a business owner. Like it\'s I, I\'m kind of in a weird position because we build websites and we provide website support. So I think about this for our own website as well.</p>\n\n\n\n<p>But, you know, we serve a lot of yoga studios, a lot of wellness businesses, a lot of, um, like, you know, independent musicians. And I don\'t want, you know, the musician to be laying awake at night thinking about, is my website gonna break? Um, are, are people gonna be able to access those tour dates? Is the thing that we have set up for people to enter this raffle so that they could potentially win?</p>\n\n\n\n<p>Like VIP experience, is that gonna work after we put out the marketing for it? Those kinds of things. Those worries of, is this gonna work for me? Am I gonna be able to use this tool in the way that I need it when I need to? They shouldn\'t be having to think about those things. Um, you know, last year we bought a house, um, out here in Denver, Colorado.</p>\n\n\n\n<p>Um, it was the second house that we purchased, but this really is like our forever home and. Thinking about the like long term [00:08:00] things that you need to do to keep this house healthy, to keep it safe, to keep everything working properly. Like I kind of wish that I had the budget to hire somebody who would come out here and do a property walk once a month to see if my gutters are sagging or to see if there\'s something that\'s gone wrong on the roof.</p>\n\n\n\n<p>Those are the kinds of things that I don\'t have the knowledge of in my own head because I\'m not spending the time thinking about it every day. So from a support perspective, We want to be that resource that is the expert on this particular niche so that you can trust us to handle it for you. And you could be thinking about, okay, what am I gonna create next?</p>\n\n\n\n<p>Like, what is my next tour gonna look like? Um, what do does the, you know, brick and mortar expansion to a second location of our yoga studio look like? It really is a situation where I want to be the trusted space that they can outsource those sorts of things so that they\'re not having to worry about them so that they\'re not spooked when somebody goes on their website and, you know, puts in a, I notice that your site\'s SEO is terrible.</p>\n\n\n\n<p>You should contact us, you know, like through your [00:09:00] contact forum. Like I don\'t want people to be spooked by that. I want them to know that if they\'re gonna, they have a question about anything, they got a phishing email that they can call. And we\'re gonna give them that the advice that they need so that they don\'t have to like, learn a whole new set of domain knowledge.</p>\n\n\n\n<p>And so that if they don\'t wanna deal with it that day, they can out, they can just offload it to us. That\'s, that\'s really what needs to happen. You don\'t wanna worry about looking into this like you have copyright infringement images on your site. I got that for you. I will let you know whether or not you need to pay attention to this.</p>\n\n\n\n<p>And meanwhile, we\'re gonna make sure that your site has not actually been. So, um, it really is more about being that, that support source of support for clients, almost from an emotional perspective, more than a practical perspective. We have done the property walks around your site. We know everything is working fine.</p>\n\n\n\n<p>This one really important page that is tied to your marketing is working. There\'s nothing broken on it. You can confidently move forward with your marketing without worrying about whether or not your [00:10:00] site is gonna, you know, crack under the.</p>\n\n\n\n<p>Cory Miller: And when you go to these types of experts, you want them worrying about their craft, what they do best.</p>\n\n\n\n<p>Like the musicians for instance, like Right. You know, hey, if you\'re a fan of a big band, I want them thinking about their next song. Not necessarily worrying about, okay, what is this fishing like you said to that fishing email part. And I think that\'s the beauty of WordPress too. You can do so much with it, but as these businesses, organizations grow, they need more complexity that WordPress gives \'em.</p>\n\n\n\n<p>And that\'s where I, I see you all coming in to say, we\'re gonna take this load off you so that you can focus on what you do best.</p>\n\n\n\n<p>D’nelle Dowis: That\'s exactly right because I am so passionate just about artists in general. I mean, when I was in college, like one of my majors was creative writing. Like I definitely come from a creative space, but what I came away from college with and what has has happened during my career over the intervening years is that I find myself time and time again wanting to.</p>\n\n\n\n<p>People to [00:11:00] do the thing that they are really passionate about, and there are plenty of times that I have just, you know, sat head in hand being like, I do not wanna think about whether or not I should buy this new garage door or have it fixed. I don\'t wanna think about like why my water bill is so high. I just wanna hire somebody to come out here and make sure that it\'s okay.</p>\n\n\n\n<p>With their expertise. I don\'t wanna have to develop that expertise myself, and I don\'t want my clients to have to develop that expertise cuz I want \'em to spend that time creating new and amazing things that they\'re excited about. Like it\'s really hard to get excited about dns. Like really hard, like I have a hard time getting excited about dns.</p>\n\n\n\n<p>I don\'t want \'em to have to worry about it. If there\'s a term that they don\'t know, they don\'t know, that they don\'t understand, I want \'em to be able to come to me and me to be able to be trusted enough to give them the answer. That doesn\'t seem like I\'m coming from a place of trying to get \'em to.</p>\n\n\n\n<p>Spend more money or come from a place of trying to, you know, change the nature of our relationship in some way. Like my whole thing has always been like, I don\'t wanna hold people hostage. And I [00:12:00] really, really don\'t want artists to feel held hostage by this need to engage in something that really, like, they don\'t wanna spend their time thinking about.</p>\n\n\n\n<p>Like, there\'s plenty of people who are like, oh, I\'ll just DIY that website myself. Awesome. I wanna support you in DIYing it, but first let\'s have a conversation about the complexity of it so that you can make an informed decision about what you wanna learn in DIY versus what it really makes sense for you to outsource.</p>\n\n\n\n<p>So that. You can spend the time thinking about the things that you\'re really excited about, whether that is the book that you wrote or the next tour that\'s coming up, or you know, the expansion of your studio. So it, it really is like, I mean it\'s, it\'s very much like comes from a mothering instinct in me.</p>\n\n\n\n<p>I think. Like I\'ve got dogs, but we don\'t have kids really, like my clients and the business really take up a lot of that energy of me thinking about how can we best take care of our clients so that they are enabled to do the thing that they\'re really excited about.</p>\n\n\n\n<p>Cory Miller: Well, you mentioned artists and I wanna talk about that part of your business.</p>\n\n\n\n<p>Um, I [00:13:00] think it\'s so interesting working with, with artists and musicians and things like that, but, uh, that, and also the yoga and the wellness industry you talked about too, seemed like, um, we, we were talking before we started this interview, you\'re mentioning like during Covid helping some of these people that didn\'t have a lot of support infrastructure that I, I think about as like, uh, analog almost in the sense of they\'re meeting.</p>\n\n\n\n<p>People, um, in person and, uh, you know, whether it\'s a band playing a venue or it\'s a yoga instructor, and I\'d love to you to share a little bit about that, that work with those types that I think Covid, uh, helped, uh, open an opportunity, I think for a lot of businesses like. To kind of go, okay, now we can use leverage web and online to build and grow our business.</p>\n\n\n\n<p>D’nelle Dowis: Well, I mean, for a lot of people it really was a smack in the face. I mean, if you think about yoga studios, that is a very in person [00:14:00] thing. I mean, we definitely have like online classes that we can take, but I mean, if you\'re anything like me, like it is not the same. And it\'s, it\'s the same for like, um, for musician.</p>\n\n\n\n<p>Um, my, my favorite story that I like to tell about Vibe is that in October of 2020, uh, we went to a show in South Central Tennessee. It\'s a place called The Caverns in Pelham, Tennessee. And they normally have bluegrass underground in their caverns, but because everything was, we can only do outdoor. Um, they set up a stage above their caverns.</p>\n\n\n\n<p>They like brought in a stage and we, our favorite artist was playing a show on this stage. And we were like, partially it was a personal thing, like, we have got to get out of this house and, and do something, or we\'re gonna absolutely drive each other mad. And the other part of it, especially for me, was a deep curiosity about how they were gonna pull this off, because it really was, I mean, you know, to use a very tired word, it was unprecedented for all of.</p>\n\n\n\n<p>[00:15:00] So what is this gonna look like with all of these new restrictions and all of these unknowns? And so we went down to the caverns and I was incredibly impressed with the operations of how they had turned this thing that they normally have, like in a, in a enclosed space. Into doing this outdoors. Um, which I think that they\'ve continued to do.</p>\n\n\n\n<p>They definitely had more shows outdoors after this first one. But the notable thing about this show was that we are sitting in like our little six foot square and they have, they\'re using an app that you can order, um, concessions off of that\'ll be delivered. And it was all very interesting. And then the show started and the vibe of everyone in.</p>\n\n\n\n<p>In that audience was so subdued, it was unnerving to watch the way that we had all clearly been affected by being in our houses for six, seven months at that point. And I think about that a lot in terms of these in person things. That in person is incredibly important and we\'re never, [00:16:00] I don\'t think we are ever really going to be able to replicate that in an online, in a virtual environment, but a lot of us were forced.</p>\n\n\n\n<p>And one of the people that was forced to do that was a, um, client of ours, um, named no Novo Fitness studio. They\'re out of Midland, Georgia. We absolutely adore them. They are like, they\'re just our favorite to work with. Like they really get our vibe. We really get their vibe. And we\'re in a position where the yoga studio owners, it\'s a two sisters, they don\'t have to think.</p>\n\n\n\n<p>Their website because they know that they can come to us and be like, Hey, we wanna do this, can you make it happen? And we can give them good advice about whether or not they should make it happen. And so with them, what we did is, this was very early on, I think this like started in April of 2020. They are like, we are absolutely bleeding money.</p>\n\n\n\n<p>We are paying. Rent on a brick and mortar that we can\'t use. Like the sisters would go in there and like do yoga in the studio themselves, but you can\'t have other people coming in, right? [00:17:00] Like it\'s, this is, we\'re all in lockdown. What do we do to maintain the, the vibe of the community that we have built.</p>\n\n\n\n<p>Now, whether that is. A music, like a touring musician or whether that is, uh, a yoga studio or an acupuncturist or any kind of like wellness. Any, any of the people who are kind of in the, the verticals that we tend to work in. Um, how can we retain the magic that is that in person stuff while we are all stuck inside?</p>\n\n\n\n<p>And so with Novo, what we did is we built them like a little OnDemand, uh, video portal. So it\'s got gated content. The content is served up through Vimeo, but you can only access it if you\'re logged into their website. It was a relatively simple thing. We hadn\'t built anything like that before, but we had used all of these tools before the, um, the content gate tools.</p>\n\n\n\n<p>We\'d used Vimeo before. Um, and really like we were all stuck inside. Nobody really knew what to do, so we built this really quickly. I mean, it definitely, I think there\'s a case study out on. About the, [00:18:00] the process of it. It was definitely daunting because this was completely new for them and they weren\'t really sure how they wanted to use it.</p>\n\n\n\n<p>What they ended up with is a thing that\'s gonna do two things for them. First, it helped them keep a revenue stream going. Which was really, really important. But that, like during Covid, but that turned into an additional revenue stream now that we are all back in person and they are, you know, having their five, six classes a day in their brick and mortar.</p>\n\n\n\n<p>Um, so having that additional kind of passive revenue stream, really, you upload one video and it\'s. Going to serve up, you know, infinite number of times for infinite number of people. Um, you know, I think about that a lot with my business. What is recurring revenue? Like, how does that help us to be able to make long-term decisions?</p>\n\n\n\n<p>They now have a line item in their budget that is recurring revenue in a way that is almost passive, that\'s not dependent upon being present in the real world. But the thing is, is I don\'t think that that really is the end of it. I think that now we\'ve got this on demand. [00:19:00] Tool that they can use as a revenue booster, but it is helping them to maintain that those in person relationships, like they\'ve got one person who, um, right prior to c she and her, she had moved to Italy because of her partner\'s job.</p>\n\n\n\n<p>And so she wasn\'t able to come into these yoga classes anymore. And when she found out that Novo was offering on demand video, she was like, please, can you figure out a way that I can. Um, get to these videos because I miss attending these classes. I miss these instructors. I miss the community of the people that I was with.</p>\n\n\n\n<p>And at this point, that\'s what I wanna see out of virtual. I wanna see virtual providing this kind of like steam release valve. Like there is no telling what\'s gonna come our way, is another pandemic gonna come our way? Like, who knows what\'s happening? Like right now with like, I think I read something the other day about like avian flu making things like really.</p>\n\n\n\n<p>Like difficult for, uh, the, the poultry industry. Like there\'s just all of these variables that we don\'t know what\'s gonna come at us, but if we [00:20:00] have a really strong virtual presence that\'s supporting our in-person presence, it\'s gonna make us more resilient all around. If you know one of the artists that we\'re working with right now, Has the flu and if she were not feeling as bad as she is, the conversation that we would be having right now is, okay, well I can\'t go do this show this weekend, but I still want to connect with the people who are gonna be there.</p>\n\n\n\n<p>I still wanna make sure that they\'re gonna have an amazing. Friday night. What does that look like from a digital perspective? Do we have the infrastructure on our site to have this membership portal set up so that we can gate this content and make sure that we\'re still capturing that revenue so that we can keep doing what we\'re doing?</p>\n\n\n\n<p>Right? Like that really is what I want. I want our yoga studios. I want our artists to be able to keep doing the work that they\'re really, really passionate about, and if they have a digital infrastructure, Stable. They\'re gonna be able to rely on that to be able to create a, a more holistic approach to, well, I, I can\'t go out this weekend for whatever reason.</p>\n\n\n\n<p>I\'m tested positive for Covid, but I feel [00:21:00] fine. I\'d love to do something this weekend. Okay, well we can move into digital for that. But primarily we are still invested in being in the real world. Um, which is honestly, like Covid taught me that, like, I don\'t think I really appreciated the value of those real world connections and being in the same room as people until you weren\'t allowed to be.</p>\n\n\n\n<p>Cory Miller: Well, I, I think you\'ve really illustrated great, uh, case study too, which is having a backup when you\'re in person, whatever that is, and you just can\'t happen. But also I think you\'re showcasing too, where they can use that, not just in those bad times, but good times to continue to grow and support their businesses.</p>\n\n\n\n<p>Like when you talked about the Exactly. The yoga fitness studio, um, it\'s an extension. They record those videos once. And then they get to share that with whoever they want in their, uh, in their business. Uh, and it\'s up there. That\'s the beauty of the web. That\'s 24 7, 365, especially if they\'re supported by [00:22:00] very interesting productions.</p>\n\n\n\n<p>But like, you know, to extend the service and things that you do. Websites, web\'s always been, I love this because you can do so much more with little.</p>\n\n\n\n<p>D’nelle Dowis: Exactly, exactly like these, the, the yoga studio like Nova, uh, fitness is not focused on their website, and I don\'t want them to be focused on their website.</p>\n\n\n\n<p>I want them to focus on the real world, brick and mortar, making the vibe in that yoga studio exactly what their community needs. I don\'t want them to be thinking about like, oh, well, I need to go do this on my website now. No, no, no. You\'ve got somebody who\'s gonna handle that for you. They\'re gonna take care of it, and they\'re gonna provide you with the advice that you need about whether you should be doing it or not.</p>\n\n\n\n<p>Like there\'s a lot of people who I\'m like, no, I, I really don\'t think you wanna like, Spend part of your budget on that. Um, we have that conversation when it comes to design a lot that the, the level of client that we work with doesn\'t necessarily need custom design. What they need is [00:23:00] graphic design support.</p>\n\n\n\n<p>And use existing design templates or, you know, like we, we really love to work with Divvy a lot, and Divvy has a really great library of, um, page templates and like kind of starter designs that really serve our clients. But I don\'t want them to be spending their time and their money on something that they could otherwise have turned to really growing their business and cultivating the, the, what they\'re really passionate about.</p>\n\n\n\n<p>Which, you know, for Novo it\'s really about being in person and. You know, cultivating that community that they have built up. I mean, that was the scary part of Covid, is you think I have spent all of this time building up this community of people who are willing to get out of their houses to come see me every day.</p>\n\n\n\n<p>And what is going to happen now? Everybody\'s gonna be out of the habit of it. And are people gonna also forget about me? Um, I don\'t want, I, I. To be able to create the kind of stability that like helps businesses thrive. And so having this in an [00:24:00] emergency is great, but also having it as a part of the overall plan for growing your business is really huge.</p>\n\n\n\n<p>Because I mean, if they had already had on demanded place, they could have spent their time in their money marketing that on demand to people who are not. Already their students. Um, so I, I want our clients to be able to make really smart decisions and decisions that are gonna keep their business as stable as possible, even in the face of something like Covid.</p>\n\n\n\n<p>Cory Miller: Well, you, you very much, you know what I\'ve heard resonates with me because you\'ve talked about a web presence can be a chore. Or the two words you used were, uh, cultivating community. So using it as a channel to reach your customers, reach your prospective customers, and build and cultivate that community.</p>\n\n\n\n<p>Like the musician we were talking about is like, right, she can\'t be there Friday night, but her website can be there in some shape, manner, or form to help cultivate that interest in community. Right. [00:25:00] Um, Okay. So the last question I want to ask, uh, is tips for people starting out as an agency wanting to do, uh, use WordPress as a, as a tool to build, uh, and, and, uh, client websites and things like that.</p>\n\n\n\n<p>What, what advice would you give looking back as you\'ve shared your story? I</p>\n\n\n\n<p>D’nelle Dowis: I wish that I had listened harder and more intently to the things that Nathan Ingram was saying from the very beginning. Um, you know, it took me a really long time to build up, um, not necessarily automated processes, but processes that I\'m really comfortable with.</p>\n\n\n\n<p>Um, you know, whether that is the task management system that we are using or the way that we onboard clients, what those discovery calls look like, what our road mappings look like, kind of vetting those clients to see what the relationship between us and that client is like. I wish that I had, I could like just magically go back in time and tell [00:26:00] myself.</p>\n\n\n\n<p>Focus on those relationships with your clients because that\'s what\'s gonna feel the best for you. So anybody that\'s starting out, I mean, first of all, like just meet as many people as you possibly can. I feel like Covid has kind of done that for like the kids that are graduating college right now. I\'ve had some really cool conversations with kids that are like, I am graduating.</p>\n\n\n\n<p>I don\'t know how to get into this industry. What do I do? My answer is always meet and talk to as many people as you possibly can who are already doing the kind of thing that you wanna do or that you think you wanna do. Like you may think that you wanna build websites, but you get five years down the road and you realize what your talent actually is, is project management.</p>\n\n\n\n<p>I mean, I\'m calling myself out on that. Like I am first and foremost a project or a production manager. I am super good at that. It, my brain works that way. I really should not have my hands deeply in code because it takes me longer to do that than it would somebody who is really focused on that. So the more people that you can meet [00:27:00] to find out what it is that they do, what is their day like?</p>\n\n\n\n<p>Like what do they get really excited about when it comes to the work that they do is gonna help you identify the best. For you and I mean if it, if you are, are like already hell bent on starting your own agency. The advice there is, is kind of the same, get to know people as much as possible. I mean, I, there was a a point in 2015 where I made a, well 2016, where I made a huge mistake.</p>\n\n\n\n<p>I hired a couple people who I thought that I had a good relationship with. And it went very south very quickly. I think it ended up costing me a little under $20,000 when it all came down to it. I mean, I was really lucky that I had the ability to be financially resilient in that way and we\'re still here.</p>\n\n\n\n<p>Um, but. The relationships that you\'re gonna build with clients and the relationships that you\'re gonna build with other people in the community are what are going to support you and help you be resilient. I could not be as resilient I as I am if it [00:28:00] weren\'t for the people at Ithe who are providing part of the engine to run my business.</p>\n\n\n\n<p>The people in the post status community who, if I need a specific type of developer, I can go out there and it\'s like shooting fish in a barrel. You can. Five people who are gonna be the exact person that you need to do this work for your client. The relationships that we have are above all the thing that are sustaining us and helping us be resilient, and I did not.</p>\n\n\n\n<p>I couldn\'t really wrap my head around that until probably five years into doing my, into doing my business. I mean, I grew up in a situation where it was very much like, shut your work is the proof of the actual, like work product is the proof of whether you\'re good or not, and. As I moved through kind of owning my own thing, it became obvious that there\'s a lot of people out there who are doing really, really quality work.</p>\n\n\n\n<p>It is more about how you resonate with the people who you are working with and, and the maintenance. And the cultivation of those [00:29:00] relationships that is going to provide you with the stability you need to build whatever it is you\'re wanting to build. Whether that is a web development agency or a a, you know, content marketing business, or, you know, if you wanna start a yoga studio, think about the people who you have in your network who are gonna be able to support you in that, and how much do you trust them.</p>\n\n\n\n<p>And it takes time to build up trust. It takes experimentation. It. You know, a lot of, um, hit a lot of, you know, mishits really, you know, just like the people that I hired in 2016 who it didn\'t work out. I mean, there are definitely like plenty of situations I found myself in where I didn\'t do all of the work I needed to do to really establish that Right.</p>\n\n\n\n<p>Kind of trust. I mean, and I take responsibility for that too. Like I really dove into that relationship in a very naive way. Um, whereas I think that if it happened to me now, I don\'t think I would\'ve ended up in a situation that was as scary as that was for me, a sort of. Gigantic fail that it took me a couple months to recover from emotionally.</p>\n\n\n\n<p>Um, just because I went into it thinking [00:30:00] more about the work than I was about the relationships, which is why I focus so hard on relationships now because that really is where the best stuff is.</p>\n\n\n\n<p>Cory Miller: I love your energy and your approach. It really resonates with me relationship. So key. When you really get that aligned, you\'re, you\'re doing your best work, you\'re helping someone else, getting rewarded for it, and um, it makes everything better, doesn\'t it?</p>\n\n\n\n<p>D’nelle Dowis: It really, really does. I mean, that is why I\'m focused on support instead of website development. Like it\'s almost like you go anywhere and get anybody to build a website for you. Like you can hop out on Upwork or you can outsource it to a team in India. But the long relationship provides so many dividends over the years of knowing that person\'s business of understanding really where they are.</p>\n\n\n\n<p>Like we have one client right now. Her mother just passed away. She needs some time. That changes the project. The, like, the, the arc of our project build. It [00:31:00] changes, you know, the, when I\'m gonna need to bring in a, um, a developer for something versus when I\'m gonna need to bring in the SEO specialist. It changes a lot.</p>\n\n\n\n<p>But having known this client now since 2012, I know what I\'m gonna be able to expect from her, what she\'s gonna be capable of. And she knows that in a situation where she\'s kind of like in a personal crisis, she knows that she can offload and delegate more work to us that is gonna make it possible for her to do what she needs to do for herself personally.</p>\n\n\n\n<p>And those are the kind of relationships that I want to. I wanna be in a situation where somebody knows that they can call me up and say, Hey, I\'m gonna need more help this month. In the same fashion that they can call me up and be like, Hey, I\'ve gotta go with this other agency for X, Y, Z. Can you help me offboard myself from you?</p>\n\n\n\n<p>I don\'t ever want people to felt, feel like they\'re held hostage. I want people to feel like if they need a hand, they\'re handheld, that we are right here to grab.</p>\n\n\n\n<p>Cory Miller: Hostage to an ally you want.</p>\n\n\n\n<p>D’nelle Dowis: Exactly.</p>\n\n\n\n<p>Cory Miller: Pardon me.</p>\n\n\n\n<p>D’nelle Dowis: Exactly. Yes.</p>\n\n\n\n<p>Cory Miller: Well, Daniel, thank you so [00:32:00] much for sharing your story and also your passion and what you\'re doing in WordPress for your clients and making a difference in the world.</p>\n\n\n\n<p>Um, tell us where we can find more about you and, and your work.</p>\n\n\n\n<p>D’nelle Dowis: Um, so if you are interested in primarily the digital side of our business, we do have some in-person stuff that we do with live events, um, that we are, uh, kind of weaving in and out. But um, for the website support, go to web dot berry interesting.com.</p>\n\n\n\n<p>Um, I did the other day just get the domain that doesn\'t have the hyphen in it, and I\'m all excited, but, Switched over yet. Um, so yeah, web dot barry interesting.com and all of the information is out there. Um, we also have kind of upped our presence on social media. Um, I\'m doing a lot more on LinkedIn than I used to do, um, and we\'re pushing a bunch more content out to our business, LinkedIn as well.</p>\n\n\n\n<p>Um, but all of those links are out on our website. And, um, if you wanna find me anywhere on social media, um, I\'m primarily on Instagram. D underscore, n e l l e. [00:33:00] Um, I post a lot of dog photos and, uh, and stuff from when I am actually traveling. So it\'s that, that is not really, uh, professionally focused, but it\'s fun.</p>\n\n\n\n<p>Um, and I, I really appreciate it. Thank you so much for taking the time to talk to me today. It was a wonderful way to come back from the Thanksgiving holiday.</p>\n\n\n\n<p>Cory Miller: You bet. Thanks D\'nelle.</p>\n\n\n\n<p>D’nelle Dowis: Awesome. Thanks.</p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Dec 2022 13:03:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Olivia Bisset\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Do The Woo Community: WP Community Collective, CertifyWP and WordPress Enterprise\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=74009\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://dothewoo.io/wp-community-collective-certifywp-and-wordpress-enterprise/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:438:\"<p>Supporting and funding contributions and initiatives, credentialing process for WordPress and enterprise in the ecosystem. </p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/wp-community-collective-certifywp-and-wordpress-enterprise/\">WP Community Collective, CertifyWP and WordPress Enterprise</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Dec 2022 10:44:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"BuddyPress: BuddyPress 11.0.0-beta3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=327432\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://buddypress.org/2022/12/buddypress-11-0-0-beta3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3767:\"<p>Hello BuddyPress contributors!</p>\n\n\n\n<p>If you haven’t tested our two first&nbsp;11.0.0 beta releases, here’s a last opportunity to help us give the final touches to our next major release so that we make sure it will fit perfectly into your WordPress / BuddyPress specific configuration. Beta testing is very important and we need you all, whether you’re a regular or advanced user, a theme designer or a plugin author: <strong>please contribute</strong>!</p>\n\n\n\n<div class=\"is-content-justification-center is-layout-flex wp-container-2 wp-block-buttons\">\n<div class=\"wp-block-button aligncenter has-custom-font-size has-medium-font-size\"><a class=\"wp-block-button__link has-white-color has-text-color has-background wp-element-button\" href=\"https://downloads.wordpress.org/plugin/buddypress.11.0.0-beta3.zip\">Download &amp; Test BuddyPress 11.0.0-beta3</a></div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p>Please note the plugin is&nbsp;<strong>still in development</strong>, so we recommend running this beta release on a&nbsp;<strong>testing site</strong>.</p>\n\n\n\n<p>You can test&nbsp;<a href=\"https://downloads.wordpress.org/plugin/buddypress.11.0.0-beta3.zip\">BuddyPress 11.0.0-beta3</a>&nbsp;in 4 ways :</p>\n\n\n\n<ul>\n<li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/bp-beta-tester/\">BP Beta Tester</a>&nbsp;plugin.</li>\n\n\n\n<li><a href=\"https://downloads.wordpress.org/plugin/buddypress.11.0.0-beta3.zip\">Download the beta here (zip file)</a>.</li>\n\n\n\n<li>Check out our SVN repository:&nbsp;<code>svn co https://buddypress.svn.wordpress.org/trunk/</code></li>\n\n\n\n<li>Clone our read-only Git repository:&nbsp;<code>git clone git://buddypress.git.wordpress.org/</code></li>\n</ul>\n\n\n\n<p>We&#8217;ve <a href=\"https://bpdevel.wordpress.com/2022/12/07/bp-dev-chat-summary-december-7-2022/\">lately decided to postpone</a> the final release date to <strong>January 5, 2023</strong> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f448.png\" alt=\"👈\" class=\"wp-smiley\" />. We would greatly appreciate your help making sure this next major version of your community engine is as good as it can be.</p>\n\n\n\n<p>Since beta2, we&#8217;ve fixed <a href=\"https://buddypress.trac.wordpress.org/query?changetime=11%2F26%2F2022..12%2F09%2F2022&resolution=fixed&milestone=11.0.0&or&changetime=11%2F26%2F2022..12%2F09%2F2022&resolution=fixed&milestone=10.7.0&group=status&col=id&col=summary&col=owner&col=type&col=priority&col=component&col=version&order=priority\">7 tickets</a> and documented two changes BP developers should love:</p>\n\n\n\n<ul>\n<li><a href=\"https://bpdevel.wordpress.com/2022/12/01/bp-11-fetch-activities-for-or-excluding-a-group-of-users/\">Fetch Activities for or Excluding a Group of&nbsp;Users</a></li>\n\n\n\n<li><a href=\"https://bpdevel.wordpress.com/2022/12/06/bp-11-bp_has_profile-now-accepts-an-array-of-profile-group-ids/\">bp_has_profile() Now Accepts an Array of Profile Group&nbsp;IDs</a></li>\n</ul>\n\n\n\n<p><strong>beta3 particularly targets installs where the BP Default theme is active. If you are using this theme, we&#8217;d be very happy if you could make sure everything is fine for you. If you are not using this theme and wish to give us a hand, add the following line to your <a href=\"https://codex.buddypress.org/themes/bp-custom-php/\">bp-custom.php</a> file so that you bring it back into your available themes and activate it:</strong></p>\n\n\n\n<p><code>add_filter( \'bp_do_register_theme_directory\', \'__return_true\' );</code></p>\n\n\n\n<p>If you find something weird testing this beta, please report it on&nbsp;<a href=\"https://buddypress.trac.wordpress.org/newticket\">BuddyPress Trac</a>&nbsp;or post a reply to&nbsp;<a href=\"https://buddypress.org/support/topic/buddypress-11-0-0-beta3/\">this support topic</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Dec 2022 07:58:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mathieu Viet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"Post Status: Interview with Product Lead Robert Jacobi at Cloudways Managed WordPress Hosting— Post Status Draft 131\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=145014\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"https://poststatus.com/interview-with-product-lead-robert-jacobi-at-cloudways-managed-wordpress-hosting-post-status-draft-131/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:52746:\"<div class=\"is-layout-flow wp-block-group eplus-wrapper has-theme-palette-2-color has-theme-palette-8-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">Director of WordPress at <a href=\"http://cloudways.com/\">Cloudways</a>, Robert Jacobi, talks about WordPress and their WordPress hosting products in this interview with Post Status Publisher Cory Miller. </p></div>\n\n\n<div class=\"wp-block-spacer eplus-wrapper\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">31</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n\n\n\n\n<p><a href=\"https://poststatus.com/planet/feed/#h-transcript\">Transcript</a> ↓</p>\n\n\n\n<p>Robert Jacobi shares his work as the Director of WordPress at <a href=\"http://cloudways.com/\">Cloudways</a>, or to put it simply-strategy, partnerships, and product marketing. After working for years as an agency owner, Robert joined the WordPress community. His experience enables him to foster the relationship between business and open-source projects and vice-versa. Robert shares how the products and services offered by Cloudways enable businesses of all sizes to accomplish their vision of “moving dreams forward”.</p>\n\n\n\n<p>Top Takeaways:</p>\n\n\n\n<ul>\n<li><strong>Cloudways Offers One-Click Easy: </strong>Staging in one click. Migration in one click. Scalability without the complexity.&nbsp;</li>\n\n\n\n<li><strong>Open-Source Ecosystems Thrive:</strong> Communities are driving satisfaction. There are so many opportunities to take in feedback and make improvements. They are driving new niches for flexibility, freedom, and scalability.&nbsp;</li>\n\n\n\n<li><strong>Find the Right Fit:</strong> Are you getting the value of what you are paying for? Are you getting less than you need? Are you taking advantage of all of the functionality you are paying for? Little things make a big difference for your site performance and user experience.</li>\n\n\n\n<li><strong>WordPress is Comforting: </strong>WordPress has risk, but the history, knowledge repository, documentation, and training resources offer a level of security from the enterprise on down.</li>\n</ul>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<div class=\"is-layout-flex wp-container-34 wp-block-columns sponsor has-theme-palette-8-background-color has-background\" id=\"Cloudways\">\n<div class=\"is-layout-flow wp-block-column\">\n<h3 id=\"sponsor-wpengine\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> Sponsor: <a href=\"https://poststat.us/cloudways\">Cloudways</a><a href=\"https://poststat.us/wpengine\"></a></h3>\n\n\n\n<p><strong><strong>Cloudways</strong> </strong>is proud to sponsor Post Status. Our <a href=\"https://poststat.us/cloudways\">managed hosting for WordPress and WooCommerce</a> takes away the cloud server-related learning curve with a seamless and scalable web hosting experience. Trusted by over 250,000 WordPress users, Cloudways gives you the freedom to choose from any of the top IaaS (infrastructure as a service) providers for ultimate performance.</p>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column is-vertically-aligned-center\"><div class=\"wp-block-image cloudways-logo\">\n<a href=\"https://poststat.us/cloudways\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2022/02/Stacked-Logo-300x176.png\" alt=\"Cloudways: Created for Exceptional Experiences\" class=\"wp-image-93196\" width=\"200\" height=\"117\" title=\"Cloudways Logo\" /></a>Managed Cloud Hosting Simplified</div></div>\n</div>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul>\n<li><a href=\"https://www.cloudways.com/en/\">Cloudways</a></li>\n\n\n\n<li><a href=\"https://www.joomla.org/\">Joomla</a></li>\n\n\n\n<li><a href=\"https://www.drupal.org/\">Drupal</a></li>\n\n\n\n<li><a href=\"https://www.digitalocean.com/\">Digital Ocean</a></li>\n\n\n\n<li><a href=\"https://www.cloudflare.com/\">Cloudfare</a></li>\n\n\n\n<li><a href=\"https://woocommerce.com/\">WooCommerce</a></li>\n\n\n\n<li><a href=\"https://www.linode.com/\">Linode</a></li>\n\n\n\n<li><a href=\"https://www.vultr.com/\">Vultr</a></li>\n\n\n\n<li><a href=\"https://aws.amazon.com/\">AWS</a></li>\n</ul>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-you-can-follow-post-status-and-our-guests-on-twitter\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> You can follow Post Status and our guests on Twitter:</h3>\n\n\n\n<ul class=\"eplus-wrapper\">\n<li><a href=\"https://twitter.com/RobertJacobi\">Robert Jacobi</a> (Director of WordPress, <a href=\"https://twitter.com/Cloudways\">Cloudways</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/corymiller303\">Cory Miller</a> (CEO, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a> (Intern, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n</ul>\n\n\n\n<p class=\"eplus-wrapper has-background\">The <strong>Post Status Draft</strong> podcast is geared toward WordPress professionals, with interviews, news, and deep analysis. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4dd.png\" alt=\"📝\" class=\"wp-smiley\" /><br /><br /><a href=\"https://poststatus.com/category/post-status-podcasts/\" target=\"_blank\" rel=\"noreferrer noopener\">Browse our archives</a>, and don’t forget to subscribe via <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\" target=\"_blank\" rel=\"noreferrer noopener\">iTunes</a>, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\" target=\"_blank\" rel=\"noreferrer noopener\">Google Podcasts</a>, <a href=\"https://www.youtube.com/c/PostStatus\" target=\"_blank\" rel=\"noreferrer noopener\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\" target=\"_blank\" rel=\"noreferrer noopener\">Stitcher</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Simplecast</a>, or <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h2 class=\"eplus-wrapper\" id=\"h-transcript\">Transcript</h2>\n\n\n\n<p><strong>Cory Miller:</strong> [00:00:00] Welcome back to Post Status draft. Um, we\'re doing a new series called The Product People, basically where we\'re talking to the people actually driving the product at all these great companies. And one of our first to do this is Robert, my friend Robert Jacobi. Who leads WordPress endeavors over there, and I\'ll let him actually share in just a second what he actually does in his actual title or Robert.</p>\n\n\n\n<p>But I\'ve known Robert for a couple years now and hearing some of his backstory, I\'m excited for this because. I mean, he\'s had a wealth of experience, not just in WordPress, but before that other communities and agency work. And so, um, today, the purpose of this, the intention of these interviews is really to say there\'s all these cool products out there in the WordPress space.</p>\n\n\n\n<p>But let\'s talk to the people driving the vision, um, the roadmaps, the work that gets done for the people buying those products. So I wanna give, like, I, I personally, Robert, like [00:01:00] the human angle. I don\'t like to just buy from a button. I wanna buy from a human, ultimately know there\'s people out there. I give the example a lot of like Tom bin bags.</p>\n\n\n\n<p>And now Tom has actually exited that business. But I was like, you get to hear the story. You get to hear him, his background and talk about how you designed this particular backpack. But, uh, anyway, Robert, thanks for coming on to the draft podcast, talking about, uh, the product and what you\'re doing at Cloud Ways.</p>\n\n\n\n<p>But would you give us a set, uh, little background about yourself, how you got into it, what you, well, let\'s say, let\'s start with what you actually do at Cloud Ways, what you\'re responsible for, and then I\'ll ask how you got there.</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> Okay. So we\'ll, we\'ll, we\'ll, Teased it out backwards. Fantastic. Yeah. Thanks so much for, for having me here.</p>\n\n\n\n<p>Corey, I, you know, I, I love post status, love you and your family. Uh, really thrilled to be here. Uh, so I, my title, which titles don\'t mean Anything, but, uh, as director of WordPress at Cloud Ways, uh, it\'s a fancy way of saying [00:02:00] strategy partnerships, product marketing, c. So all the above. All the above. And probably things I\'m missing, and those</p>\n\n\n\n<p><strong>Cory Miller:</strong> that know you well, know that it\'s very fitting.</p>\n\n\n\n<p>All the things were in one hat and director of WordPress. I love it. .</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> But, uh, yeah, it\'s, I, I guess I could say it\'s been like a 20 year journey to get here. I\'ve been at, uh, cloud Ways for about a year and a half actually just. But started, uh, in open source decades ago. Boy, that makes it sound so long. . Years ago.</p>\n\n\n\n<p>Just, just years ago. And, uh, uh, built an agency around initially Java, but then actually jula, uh, the content management system and focused on that aspect of implementing backend work with Jum. Open source, connecting up to all that fun open source [00:03:00] stuff, which actually led me to being a leader of the project, uh, for a little bit in the late 20 teen.</p>\n\n\n\n<p><strong>Cory Miller:</strong> That\'s the part that I, I really appreciate. One of the many things about your story is like you were in, in this very big community called Joomla. And I, I\'ve told you my story, it was in 2006 when we were retailing our organization\'s website. I was working at, at the time, and one of the developers, uh, mentioned Joomla and Joomla, still around.</p>\n\n\n\n<p>Jim was still. And I think still with the open web conversation serves a vital interest, but you really were like in that inner circle of community helping lead and drive that project for a long time. And I know I bounce things off you over time because now we have this WordPress thing, and I know Drupla was even set up differently too from a governance standpoint and getting your feedback and the pros and cons and strengths and weaknesses of those.</p>\n\n\n\n<p>With all that say, I, I still am a cheerleader for Jula cuz I think it works in a lot of, [00:04:00] for a lot of people in a lot of settings. But I think there\'s lessons that you have from that experience that, that I know. I\'ve appreciated hearing your thoughts on WordPress specifically.</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> Oh my gosh. Well, we don\'t have 17 hours to go over that, but</p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah, exactly that.</p>\n\n\n\n<p>We\'ll say that one for another one. Yeah. But three</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> very differently run organizations. Each successful in the way they wanna be successful. So that\'s what actually makes it interesting that the way you run an organization can define, helps you define what success is and then you can actually focus on it more.</p>\n\n\n\n<p>Yeah. And</p>\n\n\n\n<p><strong>Cory Miller:</strong> the other part of the background for you too is running your own agency. So like you, when you\'re building product there, I love highlighting this because you\'re, you were, The user for a lot of companies, including cloudy product stuff that I think is really, uh, helps you build a more intuitive product too.</p>\n\n\n\n<p>But I know from years running your own agency, like you come in from the gr, you know, from the people doing the work out there, that always [00:05:00] don\'t get showcased as well. And WordPress and Post has specifically, but I think that\'s another angle is like you\'ve been there, you\'ve earned your straps as an</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> agency owner.</p>\n\n\n\n<p>Thank you. And I just, whenever I think that far back, I think of when we had our servers in a closet, you know, hosting customers, you know, way back then. Yeah. Oh wow.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Now you\'re, now you\'re dating yourself .</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> No, I don\'t miss that .</p>\n\n\n\n<p><strong>Cory Miller:</strong> So, uh, then fast forward, okay, so there was this time where I know you stepped into the WordPress community.</p>\n\n\n\n<p>This was before cloud. Can you share a little bit about that and why you chose to step into the WordPress</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> community? Sure. After I kind of, uh, rolled out of the agency, I started looking for just something new to do, for lack of a better term or phrase, and, uh, uh, joined the executive team at Perfect Dashboard, which is, uh, which was a company that built a automatic [00:06:00] update.</p>\n\n\n\n<p>Tool for WordPress, uh, that was acquired by WP Engine at the beginning of 2019. And then I just focused on, uh, in a lot of ways helping the open source community understand what businesses needed, but even more importantly, for businesses to let them know how open source communi. Work and, and it\'s not just about, you can throw, you know, millions of dollars at something and everyone\'s gonna love you there.</p>\n\n\n\n<p>There\'s a lot of, you know, get to know the people, get engaged, uh, be a part of everything from a word camp, you know, to a jula day, to, you know, whatever the open source project is. But you know, you, you need to have skin in the game to be taken seriously by a lot of people who have spent hundreds, thousands, tens of thousands of hours within those open source.</p>\n\n\n\n<p>Well, I\'m</p>\n\n\n\n<p><strong>Cory Miller:</strong> thankful you, you took the step into the WordPress community and then so fast forward, you got the [00:07:00] gig at Cloud Ways. You all have had a lot of, um, new things coming out from a product standpoint and then also new news coming out from a company standpoint and that you were acquired by Digital Ocean or, um, let\'s see, August, September, I</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> wanna say, uh, the beginning of September was, uh, yep.</p>\n\n\n\n<p>When we closed there. It\'s been, uh, 2022. Uh, so it\'s technically our 10 year anniversary. And, uh, I unfortunately we\'ve had like no time to celebrate it. It\'s been busy as can be. You know, the, the, the opening up of the world post, you know, post covid, uh, you know, depending how you look at it. So, lots of travel, lots of events, a lot of, you know, Meeting folks.</p>\n\n\n\n<p>Uh, uh, partnership with CloudFlare. We announced, uh, safe updates. Uh, so, and then of course the digital ocean acquisition. So we\'ve been, it\'s this, this one year\'s we feel like we\'ve done, uh, 10 years of work in one year for our 10th anniversary.</p>\n\n\n\n<p><strong>Cory Miller:</strong> That\'s how it goes. That was similar. Similar to mine with iThemes.</p>\n\n\n\n<p>We had just celebrated our [00:08:00] 10th anniversary and we were required. Um, okay. So let\'s talk about WordPress as it relates to cloud ways. So this is what you lead that particular product. Tell us about the product at Cloud Way specific to</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> WordPress. So, uh, we actually have a number of WordPress products, I guess to put it that way.</p>\n\n\n\n<p>The goal of Cloud Ways is to just, it\'s a managed cloud, you know, hosting solution and, you know, we can all blah, blah, blah about manage hosting. Um, and I will, don\'t worry. But, uh, you know, one of the things we, we focused on was just making it, you know, One click easy. So we, we really want to, uh, enable folks, you know, who have one 10, you know, hundred sites to just be able to get on there.</p>\n\n\n\n<p>Uh, either start from scratch with, you know, sort of a, a more, you know, cloud ways, uh, adapted version. WordPress. It\'s totally WordPress. We just make sure that, you know, caching and things are turned on the way you might want it. [00:09:00] Um, or, you know, or just sort of. Naked WordPress. So nothing\'s tweaked at all.</p>\n\n\n\n<p>Uh, WooCommerce of course. And then, you know, we, we have some bundles around, uh, other packages and products. Just make it, again, one click easy. Uh, lots of folks can do one click easy. WordPress, what, you know, we focused on the whole time is how do you get that WordPress Cloud site cloud enabled? And, uh, you know, yes, you can go to a shared hosting site and say, I want a WordPress install.</p>\n\n\n\n<p>But there\'s a lot more work behind the scenes. You know, we want our users to feel like, yes, it\'s just the same thing, but behind the scenes you\'re on a very scalable, uh, high performance, secure infrastructure. So when</p>\n\n\n\n<p><strong>Cory Miller:</strong> someone\'s looking at their building, building a website or launching a project, and they go, Hey, I want the scale of cloud.</p>\n\n\n\n<p>With the easiness, not having to kind of go through and tinker with settings and things like that from a, and you know me, I\'m not very technical, but [00:10:00] from the cloud is awesome in this dream, in that you can scale and do all these kinds of things, but there\'s work in between that needs to happen to help get it.</p>\n\n\n\n<p>WordPress ready. Is that where kind of cloud waste kind of comes in?</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> Without a doubt. I mean, if you go to any of \'em, so obviously we\'re now owned by digital lotion, but you know, digital lotion, aws, gcp, so that\'s Google Cloud, uhlin, node, vulture, you know, all these platforms are much more tech focused. So you can do a lot of really cool stuff on any of these platforms.</p>\n\n\n\n<p>Like really dive data, dive, uh, Deep in, uh, you get root, you can do, you know, all kinds of crazy tech voodoo and you have fantastic platforms and applications out there on that. But boy, if you just want to get WordPress going, that is a pain in the rear. Uh mm-hmm. , you know, we used to work with AWS and Azure back in the agency days, and [00:11:00] Oh man, just to get stuff going.</p>\n\n\n\n<p>You know, you need that certification or, or you\'re going to misconfigure something or even worse, you\'re gonna misbuild the Jesus outta yourself and what you thought was gonna be a, you know, a $50, you know, bill for the month. All of a sudden it\'s like 500 or a thousand dollars because you left something on that you weren\'t supposed to, and you didn\'t know that it was gonna be metered and build out in such and such a way, or some database process went crazier, haywire.</p>\n\n\n\n<p>So, We try to get rid of that risk at Cloud ways and just mitigate that so you can be like, oh, I am on Digital Ocean and I don\'t need to worry about any of this stuff. I\'m paying a monthly fee. I\'m not gonna get surprised with anything. Uh, really just kind of making it what, you know, a lot of shared hosting used to be back in the day, but without all the performance bottlenecks.</p>\n\n\n\n<p>Mm-hmm. now.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Okay. You mentioned cloud. Is 10 years old and so I like been around for a long time. And I know this predates you [00:12:00] at the company, but like when did the WordPress specific offering start to come into the cloud? Ways history and product climate.</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> We started out as actually a Magento shop. That was our first big offering, uh, that was sort of cloud enabled.</p>\n\n\n\n<p>As we, uh, look at it, I think with the n memory serves, About three years, two to three years, we, uh, had on, you know, put together our WordPress packages to be able to deploy across, uh, cloud providers.</p>\n\n\n\n<p><strong>Cory Miller:</strong> Okay. So when you think about the product, um, that we, we talked about this big problem, you know, and I love your phrase there, cloud enabled.</p>\n\n\n\n<p>Um, so who do you find in your customer community that you know just goes, okay, this. This is exactly what we need for what we\'re doing. Are there some common kind of avatars and customer journeys you see most often?</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> Uh, first and foremost, our best customers are agencies, uh, because it\'s really easy to manage, [00:13:00] uh, you know, the costs of having a ton of clients on your infrastructure.</p>\n\n\n\n<p>I mean, the flexibility is yes, I can have a digital ocean droplet. A hundred sites, if they\'re all, you know, small, simple brochure sites and you know, that\'s costing you $10 a month, plus or minus, I can\'t remember the exact, maybe it\'s 10 99 . Mm-hmm. , you know, a. To host as many, you know, as many sites as that droplet can handle, or you can scale that heck out of it and have, you know, a super e-commerce site that\'s, you know, got 300 plus concurrent users and chugging away, uh, on its own droplets.</p>\n\n\n\n<p>You, you can mix and match, you know, across the platform. Uh, not even just with one cloud provider, but across multiple providers. Cause some folks do have that. AWS expert in a house or as a contractor, and they do wanna tweak some things, uh, to the best of their ability. Again, it\'s managed so we don\'t let them blow up everything.</p>\n\n\n\n<p>But, [00:14:00] uh, we, we have, uh, use cases where, you know, there\'s front end stuff that\'s, you know, quickly being handled by, uh, digital ocean. And then there\'s like some crazy backend batch processing that\'s happening on a, you know, super high performant, you know, aws, uh, EC two. So like diversity</p>\n\n\n\n<p><strong>Cory Miller:</strong> of the projects within an agency, like you said, brochure wear all the way to something that skills bigger in one place where you can kind of manage all those.</p>\n\n\n\n<p>Um, that\'s pretty</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> compelling. Uh, I wish I would\'ve had that 20 years ago. , right, right. Building up a staging and deployment server and a production server and yeah. All that fun. And managing</p>\n\n\n\n<p><strong>Cory Miller:</strong> all that cloud complexity too. Uh, for sure. So what are some of the, um, examples, like you mentioned eCommerce, um, and I know WooCommerce is something that a lot of your customers do and use the platform for.</p>\n\n\n\n<p>Um, can you give us some more like, niche down examples too, of, it doesn\'t have to be by name [00:15:00] of course, but like what you\'re seeing in the community at cloud ways, you know, you\'ve got is WooCommerce, something that comes up quite a bit is obviously WordPress too, but what are some of. Uh, niche down, you know, journeys that you see</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> in the community too.</p>\n\n\n\n<p>Well, it\'s e-commerce across the board. So, uh, just jump back slightly on the sort of the audiences we have at, at Cloud Wastes. Yeah. Uh, we focus on SMBs. I mean, that, that, that is, you know, the crux of our mission, the crux of our joy. Uh, our, our model\'s always been moving dreams forward, but it\'s also, you know, how do we accelerate?</p>\n\n\n\n<p>Opportunity for our customers. And it, it, it\'s almost easiest to see in the SMB space cause you can do a few little things and, uh, performance increases, uh, trust increases. Uh, our customers, customers are happy. And that, that kind of is a, a flywheel of, of, I wanna say a flywheel of joy. Patent pending, um, , [00:16:00] uh, but that, but a lot of it\'s on the e-commerce side.</p>\n\n\n\n<p>So, Pretty much every site on the web these days has some kind of e-commerce component, however you wanna monetize it, whether that\'s through ad traffic or actually running a store. Uh, we focus a lot on WooCommerce because it\'s a, uh, a great platform. It\'s an open source e-commerce platform. Um, it\'s hard to name many of those.</p>\n\n\n\n<p>And, uh, it, it, it, there\'s a lot of flexibility with what you can do with it. And so, People wanna spin up a shop. Uh, no, we\'re not Shopify, you\'re not gonna be able to just start dragging, dropping. But when you\'re looking at, you know, do I wanna be locked into, uh, a system where, you know, I don\'t have all the control that I need?</p>\n\n\n\n<p>For my site that I, you know, I might be locked in on data. I might not be able to, uh, move or migrate or all that kind of stuff. We, you know, we certainly believe that W Commerce is the way to go. Uh, we [00:17:00] just, uh, had a, you know, w Commerce speed challenge. Uh, you know, we like to engage with the W Commerce community, with other users of Glu commerce.</p>\n\n\n\n<p>Uh, you know, it. I\'ve always loved open source. It\'s, it\'s the, the communities, uh, drive satisfaction, which makes it exciting to, uh, evolve with customers. And because it\'s open source, you can do a lot of stuff to, you know, quickly, uh, take in that feedback. So</p>\n\n\n\n<p><strong>Cory Miller:</strong> drilling down to the products, the offerings that you have too, what are some.</p>\n\n\n\n<p>You know, we, we could just say it as what are the kind of features, the core parts of the products that you\'re really most proud of, and that you see people really like maxing out to the, uh, to the, to the furthest they can with, with the actual products.</p>\n\n\n\n<p><strong>Robert Jacobi:</strong> I love having staging that\'s always there and one click read